/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.proxy.AEProxy;
import com.aelitis.azureus.core.proxy.AEProxyException;
import com.aelitis.azureus.core.proxy.AEProxyHandler;
import com.aelitis.azureus.core.proxy.impl.AEProxyConnectionImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEProxyImpl
implements AEProxy,
VirtualChannelSelector.VirtualSelectorListener {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final int DEBUG_PERIOD = 60000;
    private long last_debug;
    private int port;
    private long connect_timeout;
    private long read_timeout;
    private AEProxyHandler proxy_handler;
    private VirtualChannelSelector read_selector = new VirtualChannelSelector(1, false);
    private VirtualChannelSelector connect_selector = new VirtualChannelSelector(8, true);
    private VirtualChannelSelector write_selector = new VirtualChannelSelector(4, true);
    private List processors = new ArrayList();
    private final HashMap write_select_regs = new HashMap();
    private AEMonitor this_mon = new AEMonitor("AEProxyImpl");

    public AEProxyImpl(int _port, long _connect_timeout, long _read_timeout, AEProxyHandler _proxy_handler) throws AEProxyException {
        this.port = _port;
        this.connect_timeout = _connect_timeout;
        this.read_timeout = _read_timeout;
        this.proxy_handler = _proxy_handler;
        try {
            final ServerSocketChannel ssc = ServerSocketChannel.open();
            ServerSocket ss = ssc.socket();
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.port), 128);
            if (this.port == 0) {
                this.port = ss.getLocalPort();
            }
            AEThread connect_thread = new AEThread("AEProxy:connect.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.connect_selector);
                }
            };
            connect_thread.setDaemon(true);
            connect_thread.start();
            AEThread read_thread = new AEThread("AEProxy:read.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.read_selector);
                }
            };
            read_thread.setDaemon(true);
            read_thread.start();
            AEThread write_thread = new AEThread("AEProxy:write.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.write_selector);
                }
            };
            write_thread.setDaemon(true);
            write_thread.start();
            AEThread accept_thread = new AEThread("AEProxy:accept.loop"){

                public void runSupport() {
                    AEProxyImpl.this.acceptLoop(ssc);
                }
            };
            accept_thread.setDaemon(true);
            accept_thread.start();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "AEProxy: listener established on port " + this.port));
            }
        }
        catch (Throwable e) {
            Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.port});
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "AEProxy: listener failed on port " + this.port, e));
            }
            throw new AEProxyException("AEProxy: accept fails: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptLoop(ServerSocketChannel ssc) {
        long successfull_accepts = 0L;
        long failed_accepts = 0L;
        while (true) {
            try {
                while (true) {
                    SocketChannel socket_channel = ssc.accept();
                    ++successfull_accepts;
                    if (!socket_channel.socket().getInetAddress().isLoopbackAddress()) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "AEProxy: incoming connection from '" + socket_channel.socket().getInetAddress() + "' - closed as not local"));
                        }
                        socket_channel.close();
                    }
                    socket_channel.configureBlocking(false);
                    AEProxyConnectionImpl processor = new AEProxyConnectionImpl(this, socket_channel, this.proxy_handler);
                    if (processor.isClosed()) continue;
                    try {
                        this.this_mon.enter();
                        this.processors.add(processor);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "AEProxy: active processors = " + this.processors.size()));
                        }
                    }
                    finally {
                        this.this_mon.exit();
                    }
                    this.read_selector.register(socket_channel, this, (Object)processor);
                }
            }
            catch (Throwable e) {
                ++failed_accepts;
                if (!Logger.isEnabled()) continue;
                Logger.log(new LogEvent(LOGID, "AEProxy: listener failed on port " + this.port, e));
                if (failed_accepts <= 100L || successfull_accepts != 0L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.port, "TCP"});
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(AEProxyConnectionImpl processor) {
        try {
            this.this_mon.enter();
            this.processors.remove(processor);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void selectLoop(VirtualChannelSelector selector) {
        long last_time = 0L;
        while (true) {
            try {
                while (true) {
                    selector.select(100L);
                    if (selector != this.read_selector) continue;
                    long now = SystemTime.getCurrentTime();
                    if (now < last_time) {
                        last_time = now;
                        continue;
                    }
                    if (now - last_time < 5000L) continue;
                    last_time = now;
                    this.checkTimeouts();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        long now = SystemTime.getCurrentTime();
        if (now - this.last_debug > 60000L) {
            this.last_debug = now;
            try {
                this.this_mon.enter();
                for (AEProxyConnectionImpl processor : this.processors) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent(LOGID, "AEProxy: active processor: " + processor.getStateString()));
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        if (this.connect_timeout <= 0L && this.read_timeout <= 0L) {
            return;
        }
        ArrayList<AEProxyConnectionImpl> closes = new ArrayList<AEProxyConnectionImpl>();
        try {
            this.this_mon.enter();
            for (AEProxyConnectionImpl processor : this.processors) {
                long diff = now - processor.getTimeStamp();
                if (this.connect_timeout > 0L && diff >= this.connect_timeout && !processor.isConnected()) {
                    closes.add(processor);
                    continue;
                }
                if (this.read_timeout <= 0L || diff < this.read_timeout || !processor.isConnected()) continue;
                closes.add(processor);
            }
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < closes.size(); ++i) {
            ((AEProxyConnectionImpl)closes.get(i)).failed(new Throwable("timeout"));
        }
    }

    protected void requestWriteSelect(AEProxyConnectionImpl processor, SocketChannel sc) {
        if (this.write_select_regs.containsKey(sc)) {
            this.write_selector.resumeSelects(sc);
        } else {
            this.write_select_regs.put(sc, null);
            this.write_selector.register(sc, this, (Object)processor);
        }
    }

    protected void cancelWriteSelect(SocketChannel sc) {
        this.write_select_regs.remove(sc);
        this.write_selector.cancel(sc);
    }

    protected void requestReadSelect(AEProxyConnectionImpl processor, SocketChannel sc) {
        this.read_selector.register(sc, this, (Object)processor);
    }

    protected void cancelReadSelect(SocketChannel sc) {
        this.read_selector.cancel(sc);
    }

    protected void requestConnectSelect(AEProxyConnectionImpl processor, SocketChannel sc) {
        this.connect_selector.register(sc, this, (Object)processor);
    }

    protected void cancelConnectSelect(SocketChannel sc) {
        this.connect_selector.cancel(sc);
    }

    public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
        AEProxyConnectionImpl processor = (AEProxyConnectionImpl)attachment;
        if (selector == this.read_selector) {
            return processor.read(sc);
        }
        if (selector == this.write_selector) {
            return processor.write(sc);
        }
        return processor.connect(sc);
    }

    public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
        AEProxyConnectionImpl processor = (AEProxyConnectionImpl)attachment;
        processor.failed(msg);
    }

    public int getPort() {
        return this.port;
    }
}

