/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.LightweightTCPTransport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ProtocolEndpointTCP
implements ProtocolEndpoint {
    private ConnectionEndpoint ce;
    private InetSocketAddress address;

    public ProtocolEndpointTCP(ConnectionEndpoint _ce, InetSocketAddress _address) {
        this.ce = _ce;
        this.address = _address;
        this.ce.addProtocol(this);
    }

    public ProtocolEndpointTCP(InetSocketAddress _address) {
        this.ce = new ConnectionEndpoint(_address);
        this.address = _address;
        this.ce.addProtocol(this);
    }

    public void setConnectionEndpoint(ConnectionEndpoint _ce) {
        this.ce = _ce;
        this.ce.addProtocol(this);
    }

    public int getType() {
        return 1;
    }

    public ConnectionEndpoint getConnectionEndpoint() {
        return this.ce;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public Transport connectOutbound(boolean connect_with_crypto, boolean allow_fallback, byte[] shared_secret, ByteBuffer initial_data, Transport.ConnectListener listener) {
        TCPTransportImpl t = new TCPTransportImpl(this, connect_with_crypto, allow_fallback, shared_secret);
        t.connectOutbound(initial_data, listener);
        return t;
    }

    public Transport connectLightWeight(SocketChannel sc) {
        return new LightweightTCPTransport(this, TCPTransportHelperFilterFactory.createTransparentFilter(sc));
    }

    public String getDescription() {
        return this.address.toString();
    }
}

