/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProvider;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProviderInstance;
import java.io.DataInputStream;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class DHTNetworkPositionManager {
    private static DHTNetworkPositionProvider[] providers = new DHTNetworkPositionProvider[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTNetworkPositionProviderInstance registerProvider(final DHTNetworkPositionProvider provider) {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        synchronized (providers) {
            DHTNetworkPositionProvider[] p = new DHTNetworkPositionProvider[providers.length + 1];
            System.arraycopy(providers, 0, p, 0, providers.length);
            p[DHTNetworkPositionManager.providers.length] = provider;
            providers = p;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new DHTNetworkPositionProviderInstance(){

                public void log(String log) {
                    DHTLog.log("NetPos " + provider.getPositionType() + ": " + log);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTNetworkPositionProvider getProvider(byte type) {
        DHTNetworkPositionProvider[] dHTNetworkPositionProviderArray = providers;
        synchronized (providers) {
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i].getPositionType() != type) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return providers[i];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public static DHTNetworkPosition[] createPositions(byte[] ID, boolean is_local) {
        DHTNetworkPositionProvider[] prov = providers;
        DHTNetworkPosition[] res = new DHTNetworkPosition[prov.length];
        int skipped = 0;
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = prov[i].create(ID, is_local);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                ++skipped;
            }
        }
        if (skipped > 0) {
            DHTNetworkPosition[] x = new DHTNetworkPosition[res.length - skipped];
            int pos = 0;
            for (int i = 0; i < res.length; ++i) {
                if (res[i] == null) continue;
                x[pos++] = res[i];
            }
            res = x;
            if (res.length == 0) {
                Debug.out("hmm");
            }
        }
        return res;
    }

    public static float estimateRTT(DHTNetworkPosition[] p1s, DHTNetworkPosition[] p2s) {
        byte best_provider = 0;
        float best_result = Float.NaN;
        block2: for (int i = 0; i < p1s.length; ++i) {
            DHTNetworkPosition p1 = p1s[i];
            byte p1_type = p1.getPositionType();
            for (int j = 0; j < p2s.length; ++j) {
                DHTNetworkPosition p2 = p2s[j];
                if (p1_type != p2.getPositionType()) continue;
                try {
                    float f = p1.estimateRTT(p2);
                    if (Float.isNaN(f) || p1_type <= best_provider) continue block2;
                    best_result = f;
                    best_provider = p1_type;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                continue block2;
            }
        }
        return best_result;
    }

    public static void update(DHTNetworkPosition[] local_positions, byte[] remote_id, DHTNetworkPosition[] remote_positions, float rtt) {
        block2: for (int i = 0; i < local_positions.length; ++i) {
            DHTNetworkPosition p1 = local_positions[i];
            for (int j = 0; j < remote_positions.length; ++j) {
                DHTNetworkPosition p2 = remote_positions[j];
                if (p1.getPositionType() != p2.getPositionType()) continue;
                try {
                    p1.update(remote_id, p2, rtt);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                continue block2;
            }
        }
    }

    public static DHTNetworkPosition deserialise(byte position_type, DataInputStream is) throws IOException {
        DHTNetworkPositionProvider[] prov = providers;
        is.mark(512);
        for (int i = 0; i < prov.length; ++i) {
            if (prov[i].getPositionType() != position_type) continue;
            DHTNetworkPositionProvider provider = prov[i];
            try {
                DHTNetworkPosition np = provider.deserialisePosition(is);
                return np;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                is.reset();
                break;
            }
        }
        return null;
    }
}

