/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerCellUtils;

public class TrackerStatusItem
extends CoreTableColumn
implements TableCellAddedListener,
TableCellToolTipListener {
    public TrackerStatusItem(String sTableID) {
        super("tracker", -2, 90, sTableID);
        this.setRefreshInterval(10);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        cell.setToolTip(TrackerCellUtils.getTooltipText(cell, dm));
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    private class Cell
    extends AbstractTrackerCell {
        public Cell(TableCell cell) {
            super(cell);
        }

        public void refresh(TableCell cell) {
            super.refresh(cell);
            String status = this.dm == null ? "" : this.dm.getTrackerStatus();
            int nl_pos = status.indexOf(10);
            if (nl_pos >= 0) {
                status = status.substring(0, nl_pos);
            }
            if (cell.setText(status) || !cell.isValid()) {
                TrackerCellUtils.updateColor(cell, this.dm);
            }
        }

        public void scrapeResult(TRTrackerScraperResponse response) {
            this.checkScrapeResult(response);
        }

        public void announceResult(TRTrackerAnnouncerResponse response) {
            this.cell.invalidate();
        }
    }
}

