/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class SeedToPeerRatioItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public SeedToPeerRatioItem(String sTableID) {
        super("seed_to_peer_ratio", 2, -1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        float ratio = -1.0f;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            int peers;
            int seeds;
            TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
            if (response != null && response.isValid()) {
                seeds = Math.max(dm.getNbSeeds(), response.getSeeds());
                peers = Math.max(dm.getNbPeers(), response.getPeers());
            } else {
                seeds = dm.getNbSeeds();
                peers = dm.getNbPeers();
            }
            ratio = (float)seeds / (float)peers;
        }
        if (!cell.setSortValue(ratio) && cell.isValid()) {
            return;
        }
        if (ratio == -1.0f) {
            cell.setText("");
        } else {
            String value = Float.toString(ratio);
            if (value.equalsIgnoreCase("NaN")) {
                value = Float.toString(0.0f);
            }
            int dot_index = value.indexOf(46);
            if (value.length() > dot_index + 3) {
                value = value.substring(0, dot_index + 4);
            } else {
                while (value.length() < dot_index + 4) {
                    value = value + "0";
                }
            }
            cell.setText(value);
        }
    }
}

