/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.ITableStructureModificationListener;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.impl.TableRowComparator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableRowImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnEditorWindow;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;
import org.gudy.azureus2.ui.swt.views.table.utils.TableStructureEventDispatcher;
import org.gudy.azureus2.ui.swt.views.utils.VerticalAligner;

public class TableView
extends AbstractIView
implements ParameterListener,
ITableStructureModificationListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final boolean DEBUGADDREMOVE = false;
    private static final boolean DISABLEVIRTUAL = SWT.getVersion() < 3138;
    private static final boolean COLUMN_CLICK_DELAY = Constants.isOSX && SWT.getVersion() >= 3221 && SWT.getVersion() <= 3222;
    private static final boolean DEBUG_SORTER = false;
    private static final ConfigurationManager configMan = ConfigurationManager.getInstance();
    private static final String CFG_SORTDIRECTION = "config.style.table.defaultSortOrder";
    protected String sTableID;
    protected String sPropertiesPrefix;
    protected String sDefaultSortOn;
    private boolean bSkipFirstColumn;
    private Point ptIconSize = null;
    private TableColumnCore[] basicItems;
    private TableColumnCore[] tableColumns;
    private Composite mainComposite;
    private Composite tableComposite;
    private Table table;
    protected int iTableStyle;
    private boolean bTableVirtual;
    private Menu menu;
    private Menu menuThisColumn;
    private Map dataSourceToRow;
    private AEMonitor dataSourceToRow_mon = new AEMonitor("TableView:OTSI");
    private List sortedRows;
    private AEMonitor sortedRows_mon = new AEMonitor("TableView:sR");
    private AEMonitor sortColumn_mon = new AEMonitor("TableView:sC");
    protected TableRowComparator rowSorter;
    private int iMouseX = -1;
    protected int loopFactor;
    protected int graphicsUpdate = configMan.getIntParameter("Graphics Update");
    protected int reOrderDelay = configMan.getIntParameter("ReOrder Delay");
    private int checkColumnWidthsEvery = Constants.isOSX && SWT.getVersion() < 3054 ? 10000 / configMan.getIntParameter("GUI Refresh") : 0;
    private TableColumnCore[] columnsOrdered;
    private ColumnMoveListener columnMoveListener = new ColumnMoveListener();
    private List dataSourcesToAdd = null;
    private List dataSourcesToRemove = null;
    public boolean bEnableTabViews = false;
    private CTabFolder tabFolder;
    private ArrayList tabViews = new ArrayList();
    private int lastTopIndex = 0;
    private int lastBottomIndex = -1;
    protected IView[] coreTabViews = null;
    private long lCancelSelectionTriggeredOn = -1L;
    private long lLastColumnResizeOn = -1L;
    long count = 0L;

    public TableView(String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn, int _iTableStyle) {
        this.sTableID = _sTableID;
        this.basicItems = _basicItems;
        this.sPropertiesPrefix = _sPropertiesPrefix;
        this.sDefaultSortOn = _sDefaultSortOn;
        this.iTableStyle = _iTableStyle | 0x200;
        if (DISABLEVIRTUAL) {
            this.iTableStyle &= 0xEFFFFFFF;
        }
        this.bTableVirtual = (this.iTableStyle & 0x10000000) != 0;
        this.dataSourceToRow = new HashMap();
        this.sortedRows = new ArrayList();
    }

    public TableView(String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn) {
        this(_sTableID, _sPropertiesPrefix, _basicItems, _sDefaultSortOn, 0x10010004);
    }

    private void initializeColumnDefs() {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        for (int i = 0; i < this.basicItems.length; ++i) {
            tcManager.addColumn(this.basicItems[i]);
        }
        tcManager.ensureIntegrety(this.sTableID);
        this.tableColumns = tcManager.getAllTableColumnCoreAsArray(this.sTableID);
    }

    public void initialize(Composite composite) {
        this.mainComposite = this.createSashForm(composite);
        this.menu = this.createMenu();
        this.table = this.createTable(this.tableComposite);
        this.initializeTable(this.table);
        configMan.addParameterListener("Graphics Update", this);
        configMan.addParameterListener("ReOrder Delay", this);
        Colors.getInstance().addColorsChangedListener(this);
        TableStructureEventDispatcher.getInstance(this.sTableID).addListener(this);
    }

    private Composite createSashForm(Composite composite) {
        double pct;
        if (!this.bEnableTabViews) {
            this.tableComposite = this.createMainPanel(composite);
            return this.tableComposite;
        }
        int iNumViews = this.coreTabViews == null ? 0 : this.coreTabViews.length;
        UISWTInstanceImpl pluginUI = MainWindow.getWindow().getUISWTInstanceImpl();
        Map pluginViews = pluginUI.getViewListeners(this.sTableID);
        if (pluginViews != null) {
            iNumViews += pluginViews.size();
        }
        if (iNumViews == 0) {
            this.tableComposite = this.createMainPanel(composite);
            return this.tableComposite;
        }
        final Composite form = new Composite(composite, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        form.setLayoutData((Object)gridData);
        int TABHEIGHT = 20;
        this.tabFolder = new CTabFolder(form, 2176);
        this.tabFolder.setMinimizeVisible(true);
        this.tabFolder.setTabHeight(20);
        final int iFolderHeightAdj = this.tabFolder.computeSize((int)-1, (int)0).y;
        final Sash sash = new Sash(form, 256);
        this.tableComposite = this.createMainPanel(form);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.tableComposite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        int iSplitAt = configMan.getIntParameter(this.sPropertiesPrefix + ".SplitAt", 3000);
        if (iSplitAt < 100) {
            iSplitAt *= 100;
        }
        if ((pct = (double)iSplitAt / 10000.0) < 0.03) {
            pct = 0.03;
        } else if (pct > 0.97) {
            pct = 0.97;
        }
        sash.setData("PCT", (Object)new Double(pct));
        this.tabFolder.setLayoutData((Object)formData);
        final FormData tabFolderData = formData;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)this.tabFolder);
        formData.height = 5;
        sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)sash);
        this.tableComposite.setLayoutData((Object)formData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                if (TableView.this.tabFolder.getMinimized()) {
                    TableView.this.tabFolder.setMinimized(false);
                    TableView.this.refreshSelectedSubView();
                    configMan.setParameter(TableView.this.sPropertiesPrefix + ".subViews.minimized", false);
                }
                Rectangle area = form.getClientArea();
                tabFolderData.height = area.height - e.y - e.height - iFolderHeightAdj;
                form.layout();
                Double l = new Double((double)((TableView)TableView.this).tabFolder.getBounds().height / (double)form.getBounds().height);
                sash.setData("PCT", (Object)l);
                if (e.detail != 1) {
                    configMan.setParameter(TableView.this.sPropertiesPrefix + ".SplitAt", (int)(l * 10000.0));
                }
            }
        });
        final CTabFolder2Adapter folderListener = new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event) {
                TableView.this.tabFolder.setMinimized(true);
                tabFolderData.height = iFolderHeightAdj;
                form.layout();
                configMan.setParameter(TableView.this.sPropertiesPrefix + ".subViews.minimized", true);
            }

            public void restore(CTabFolderEvent event) {
                TableView.this.tabFolder.setMinimized(false);
                form.notifyListeners(11, null);
                TableView.this.refreshSelectedSubView();
                configMan.setParameter(TableView.this.sPropertiesPrefix + ".subViews.minimized", false);
            }
        };
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)folderListener);
        this.tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TableView.this.tabFolder.getMinimized()) {
                    folderListener.restore(null);
                    e.button = 0;
                    TableView.this.tabFolder.notifyListeners(7, null);
                }
            }
        });
        form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (TableView.this.tabFolder.getMinimized()) {
                    return;
                }
                Double l = (Double)sash.getData("PCT");
                if (l != null) {
                    tabFolderData.height = (int)((double)form.getBounds().height * l) - iFolderHeightAdj;
                    form.layout();
                }
            }
        });
        if (this.coreTabViews != null) {
            for (int i = 0; i < this.coreTabViews.length; ++i) {
                this.addTabView(this.coreTabViews[i]);
            }
        }
        if (pluginViews != null) {
            String[] sNames = pluginViews.keySet().toArray(new String[0]);
            for (int i = 0; i < sNames.length; ++i) {
                UISWTViewEventListener l = (UISWTViewEventListener)pluginViews.get(sNames[i]);
                if (l == null) continue;
                try {
                    UISWTViewImpl view = new UISWTViewImpl(this.sTableID, sNames[i], l);
                    this.addTabView(view);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (configMan.getBooleanParameter(this.sPropertiesPrefix + ".subViews.minimized", false)) {
            this.tabFolder.setMinimized(true);
            tabFolderData.height = iFolderHeightAdj;
        } else {
            this.tabFolder.setMinimized(false);
        }
        this.tabFolder.setSelection(0);
        return form;
    }

    public Composite createMainPanel(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        return panel;
    }

    public Table createTable(Composite panel) {
        this.table = new Table(panel, this.iTableStyle);
        this.table.setLayoutData((Object)new GridData(1808));
        return this.table;
    }

    public void initializeTable(final Table table) {
        this.initializeColumnDefs();
        this.iTableStyle = table.getStyle();
        this.bTableVirtual = (this.iTableStyle & 0x10000000) != 0;
        table.setLinesVisible(Constants.isLinux || Constants.isSolaris);
        table.setMenu(this.menu);
        table.setData("Name", (Object)this.sTableID);
        table.setData("TableView", (Object)this);
        table.addPaintListener(new PaintListener(){
            boolean first = true;

            public void paintControl(PaintEvent event) {
                if (this.first) {
                    TableView.this.changeColumnIndicator();
                    this.first = false;
                }
                if (event.width == 0 || event.height == 0) {
                    return;
                }
                TableView.this.doPaint(event.gc);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            private TableCellMouseEvent createMouseEvent(TableCellCore cell, MouseEvent e, int type) {
                TableCellMouseEvent event = new TableCellMouseEvent();
                event.cell = cell;
                event.eventType = type;
                event.button = e.button;
                event.keyboardState = e.stateMask;
                event.skipCoreFunctionality = false;
                Rectangle r = cell.getBounds();
                event.x = e.x - r.x + VerticalAligner.getTableAdjustHorizontallyBy(table);
                event.y = e.y - r.y + VerticalAligner.getTableAdjustVerticalBy(table);
                return event;
            }

            public void mouseDoubleClick(MouseEvent e) {
                TableColumnCore tc = TableView.this.getTableColumnByOffset(e.x);
                TableCellCore cell = TableView.this.getTableCell(e.x, e.y);
                if (cell != null && tc != null) {
                    TableCellMouseEvent event = this.createMouseEvent(cell, e, TableCellMouseEvent.EVENT_MOUSEDOUBLECLICK);
                    tc.invokeCellMouseListeners(event);
                    cell.invokeMouseListeners(event);
                    if (event.skipCoreFunctionality) {
                        TableView.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
                TableColumnCore tc = TableView.this.getTableColumnByOffset(e.x);
                TableCellCore cell = TableView.this.getTableCell(e.x, e.y);
                if (cell != null && tc != null) {
                    TableCellMouseEvent event = this.createMouseEvent(cell, e, TableCellMouseEvent.EVENT_MOUSEUP);
                    tc.invokeCellMouseListeners(event);
                    cell.invokeMouseListeners(event);
                    if (event.skipCoreFunctionality) {
                        TableView.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                TableColumnCore tc = TableView.this.getTableColumnByOffset(e.x);
                TableCellCore cell = TableView.this.getTableCell(e.x, e.y);
                if (cell != null && tc != null) {
                    TableCellMouseEvent event = this.createMouseEvent(cell, e, TableCellMouseEvent.EVENT_MOUSEDOWN);
                    tc.invokeCellMouseListeners(event);
                    cell.invokeMouseListeners(event);
                    if (event.skipCoreFunctionality) {
                        TableView.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
                TableView.this.iMouseX = e.x;
                try {
                    Point pMousePosition;
                    if (table.getItemCount() <= 0) {
                        return;
                    }
                    Rectangle rTableArea = table.getClientArea();
                    if (rTableArea.contains(pMousePosition = new Point(e.x, e.y))) {
                        TableItem ti = table.getItem(table.getItemCount() - 1);
                        Rectangle cellBounds = ti.getBounds(table.getColumnCount() - 1);
                        if (cellBounds.width <= 0 || cellBounds.height <= 0) {
                            return;
                        }
                        if (e.x > cellBounds.x + cellBounds.width || e.y > cellBounds.y + cellBounds.height) {
                            table.deselectAll();
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println("MouseDownError");
                    Debug.printStackTrace(ex);
                }
            }
        });
        table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TableView.this.iMouseX = e.x;
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableView.this.visibleRowsChanged();
                if (TableView.this.tabViews == null && TableView.this.tabViews.size() == 0) {
                    return;
                }
                Object[] dataSourcesCore = TableView.this.getSelectedDataSources(true);
                Object[] dataSourcesPlugin = null;
                for (int i = 0; i < TableView.this.tabViews.size(); ++i) {
                    IView view = (IView)TableView.this.tabViews.get(i);
                    if (view == null) continue;
                    if (view instanceof UISWTViewImpl) {
                        if (dataSourcesPlugin == null) {
                            dataSourcesPlugin = TableView.this.getSelectedDataSources(false);
                        }
                        ((UISWTViewImpl)view).dataSourceChanged(dataSourcesPlugin.length == 0 ? null : dataSourcesPlugin);
                        continue;
                    }
                    view.dataSourceChanged(dataSourcesCore.length == 0 ? null : dataSourcesCore);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (TableView.this.lCancelSelectionTriggeredOn > 0L && System.currentTimeMillis() - TableView.this.lCancelSelectionTriggeredOn < 200L) {
                    e.doit = false;
                    TableView.this.lCancelSelectionTriggeredOn = -1L;
                } else {
                    TableView.this.runDefaultAction();
                }
            }
        });
        table.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                TableView.this.visibleRowsChanged();
            }
        });
        if (this.bTableVirtual) {
            table.addListener(36, new Listener(){

                public void handleEvent(Event e) {
                    TableItem item = (TableItem)e.item;
                    try {
                        item.setData("SD", (Object)"1");
                    }
                    catch (NullPointerException badSWT) {
                        return;
                    }
                    int tableIndex = table.indexOf(item);
                    if (tableIndex < 0) {
                        System.out.println("XXX TI < 0!!");
                        return;
                    }
                    TableRowCore row = (TableRowCore)item.getData("TableRow");
                    if (row == null || row.getIndex() != tableIndex) {
                        TableView.this.fillRowGaps(false);
                        row = (TableRowCore)item.getData("TableRow");
                        if (row == null || row.getIndex() != tableIndex) {
                            return;
                        }
                    } else {
                        row.invalidate();
                    }
                    if (row.setIconSize(TableView.this.ptIconSize)) {
                        TableView.this.visibleRowsChanged();
                    } else {
                        row.refresh(true);
                    }
                    if (!Constants.isLinux) {
                        Utils.alternateRowBackground(item);
                        Rectangle r = item.getBounds(0);
                        table.redraw(0, r.y, table.getClientArea().width, r.height, false);
                    }
                }
            });
        }
        new TableTooltips(table);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    if ((event.stateMask & 0x20000) > 0) {
                        TableView.this.runForSelectedRows(new GroupTableRowRunner(this){
                            private final /* synthetic */ 11 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run(TableRowCore row) {
                                row.invalidate();
                                row.refresh(true);
                            }
                        });
                    } else {
                        TableView.this.sortColumn(true);
                    }
                    event.doit = false;
                }
            }

            static /* synthetic */ TableView access$1300(11 x0) {
                return x0.TableView.this;
            }
        });
        ScrollBar bar = table.getVerticalBar();
        if (bar != null) {
            bar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableView.this.visibleRowsChanged();
                }
            });
        }
        table.setHeaderVisible(true);
        this.initializeTableColumns(table);
    }

    public void runDefaultAction() {
    }

    protected void initializeTableColumns(final Table table) {
        int i;
        TableColumn[] oldColumns = table.getColumns();
        if (SWT.getVersion() >= 3100) {
            for (i = 0; i < oldColumns.length; ++i) {
                oldColumns[i].removeListener(10, (Listener)this.columnMoveListener);
            }
        }
        for (i = oldColumns.length - 1; i >= 0; --i) {
            oldColumns[i].dispose();
        }
        ControlAdapter resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableColumn column = (TableColumn)e.widget;
                if (column == null || column.isDisposed()) {
                    return;
                }
                TableColumnCore tc = (TableColumnCore)column.getData("TableColumnCore");
                if (tc != null) {
                    tc.setWidth(column.getWidth());
                }
                int columnNumber = table.indexOf(column);
                TableView.this.locationChanged(columnNumber);
            }
        };
        boolean bl = this.bSkipFirstColumn = this.bSkipFirstColumn && !Constants.isOSX;
        if (this.bSkipFirstColumn) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setWidth(0);
            tc.setResizable(false);
        }
        TableColumnCore[] tmpColumnsOrdered = new TableColumnCore[this.tableColumns.length];
        for (int i2 = 0; i2 < this.tableColumns.length; ++i2) {
            int position = this.tableColumns[i2].getPosition();
            if (position == -1) continue;
            new TableColumn(table, 0);
            tmpColumnsOrdered[position] = this.tableColumns[i2];
        }
        int iNewLength = table.getColumnCount() - (this.bSkipFirstColumn ? 1 : 0);
        this.columnsOrdered = new TableColumnCore[iNewLength];
        System.arraycopy(tmpColumnsOrdered, 0, this.columnsOrdered, 0, iNewLength);
        ColumnSelectionListener columnSelectionListener = new ColumnSelectionListener();
        for (int i3 = 0; i3 < this.tableColumns.length; ++i3) {
            int position = this.tableColumns[i3].getPosition();
            if (position == -1) continue;
            String sName = this.tableColumns[i3].getName();
            int adjusted_position = position + (this.bSkipFirstColumn ? 1 : 0);
            if (adjusted_position >= table.getColumnCount()) {
                Debug.out("Incorrect table column setup, skipping column '" + sName + "'");
                continue;
            }
            TableColumn column = table.getColumn(adjusted_position);
            try {
                column.setMoveable(true);
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            Messages.setLanguageText((Widget)column, this.tableColumns[i3].getTitleLanguageKey());
            column.setAlignment(this.tableColumns[i3].getSWTAlign());
            column.setWidth(this.tableColumns[i3].getWidth());
            column.setData("TableColumnCore", (Object)this.tableColumns[i3]);
            column.setData("configName", (Object)("Table." + this.sTableID + "." + sName));
            column.setData("Name", (Object)sName);
            column.addControlListener((ControlListener)resizeListener);
            column.addListener(13, (Listener)columnSelectionListener);
        }
        String sSortColumn = configMan.getStringParameter(this.sTableID + ".sortColumn", this.sDefaultSortOn);
        int iSortDirection = configMan.getIntParameter(CFG_SORTDIRECTION);
        boolean bSortAscending = configMan.getBooleanParameter(this.sTableID + ".sortAsc", iSortDirection != 1);
        this.rowSorter = new TableRowComparator(sSortColumn, bSortAscending);
        this.changeColumnIndicator();
        if (SWT.getVersion() >= 3100) {
            Listener columnResizeListener = !COLUMN_CLICK_DELAY ? null : new Listener(){

                public void handleEvent(Event event) {
                    TableView.this.lLastColumnResizeOn = System.currentTimeMillis();
                }
            };
            for (int i4 = 0; i4 < this.tableColumns.length; ++i4) {
                int adjusted_position;
                int position = this.tableColumns[i4].getPosition();
                if (position == -1 || (adjusted_position = position + (this.bSkipFirstColumn ? 1 : 0)) >= table.getColumnCount()) continue;
                TableColumn column = table.getColumn(adjusted_position);
                column.addListener(10, (Listener)this.columnMoveListener);
                if (!COLUMN_CLICK_DELAY) continue;
                column.addListener(11, columnResizeListener);
            }
        }
    }

    public Menu createMenu() {
        final Menu menu = new Menu((Decorations)this.tableComposite.getShell(), 8);
        menu.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                e.widget.getDisplay().asyncExec((Runnable)new AERunnable(this){
                    private final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        if (this.this$1.bShown) {
                            return;
                        }
                        MenuItem[] items = 16.access$1800(this.this$1).getItems();
                        for (int i = 0; i < items.length; ++i) {
                            items[i].dispose();
                        }
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                this.bShown = true;
                TableView.this.fillMenu(menu);
                TableView.this.addThisColumnSubMenu(TableView.this.getColumnNo(TableView.this.iMouseX));
            }

            static /* synthetic */ Menu access$1800(16 x0) {
                return x0.menu;
            }
        });
        return menu;
    }

    public void fillMenu(Menu menu) {
        this.menuThisColumn = new Menu((Decorations)this.tableComposite.getShell(), 4);
        MenuItem itemThisColumn = new MenuItem(menu, 64);
        itemThisColumn.setMenu(this.menuThisColumn);
        MenuItem itemChangeTable = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemChangeTable, "MyTorrentsView.menu.editTableColumns");
        Utils.setMenuItemImage(itemChangeTable, "columns");
        itemChangeTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                new TableColumnEditorWindow(TableView.this.table.getShell(), TableView.this.tableColumns, TableStructureEventDispatcher.getInstance(TableView.this.sTableID));
            }
        });
        boolean enable_items = this.table != null && this.table.getSelection().length > 0;
        TableContextMenuItem[] items = TableContextMenuManager.getInstance().getAllAsArray(this.sTableID);
        if (items.length > 0) {
            new MenuItem(menu, 2);
            boolean prev_was_separator = true;
            for (int i = 0; i < items.length; ++i) {
                Graphic g;
                int swt_style;
                final TableContextMenuItemImpl contextMenuItem = (TableContextMenuItemImpl)items[i];
                int style = contextMenuItem.getStyle();
                boolean this_is_separator = false;
                if (style == 1) {
                    swt_style = 8;
                } else if (style == 2) {
                    swt_style = 32;
                } else if (style == 3) {
                    swt_style = 16;
                } else if (style == 4) {
                    this_is_separator = true;
                    swt_style = 2;
                } else {
                    swt_style = 8;
                }
                if (prev_was_separator && this_is_separator || this_is_separator && i == items.length - 1) continue;
                prev_was_separator = this_is_separator;
                final MenuItem menuItem = new MenuItem(menu, swt_style);
                if (swt_style == 2) continue;
                Messages.setLanguageText((Widget)menuItem, contextMenuItem.getResourceKey());
                menuItem.addListener(13, (Listener)new SelectedTableRowsListener(){

                    public void run(TableRowCore row) {
                        if (swt_style == 32 || swt_style == 16) {
                            contextMenuItem.setData(new Boolean(menuItem.getSelection()));
                        }
                        contextMenuItem.invokeListeners(row);
                    }
                });
                if (enable_items) {
                    contextMenuItem.invokeMenuWillBeShownListeners(this.getSelectedRows());
                    if (style == 2 || style == 3) {
                        menuItem.setSelection(((Boolean)contextMenuItem.getData()).booleanValue());
                    }
                }
                if ((g = contextMenuItem.getGraphic()) instanceof UISWTGraphic) {
                    Utils.setMenuItemImage(menuItem, ((UISWTGraphic)g).getImage());
                }
                menuItem.setEnabled(enable_items && contextMenuItem.isEnabled());
            }
        }
    }

    private void addThisColumnSubMenu(int iColumn) {
        if (this.menuThisColumn == null || this.menuThisColumn.isDisposed()) {
            return;
        }
        MenuItem[] oldItems = this.menuThisColumn.getItems();
        for (int i = 0; i < oldItems.length; ++i) {
            oldItems[i].dispose();
        }
        MenuItem item = this.menuThisColumn.getParentItem();
        if (iColumn == -1) {
            item.setEnabled(false);
            item.setText(MessageText.getString("GenericText.column"));
            return;
        }
        item.setEnabled(true);
        this.menu.setData("ColumnNo", (Object)new Long(iColumn));
        TableColumn tcColumn = this.table.getColumn(iColumn);
        item.setText("'" + tcColumn.getText() + "' " + MessageText.getString("GenericText.column"));
        String sColumnName = (String)tcColumn.getData("Name");
        if (sColumnName != null) {
            this.addThisColumnSubMenu(sColumnName, this.menuThisColumn);
        }
        if (this.menuThisColumn.getItemCount() > 0) {
            new MenuItem(this.menuThisColumn, 2);
        }
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.sort");
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int iColumn = ((Long)TableView.this.menu.getData("ColumnNo")).intValue();
                TableView.this.table.getColumn(iColumn).notifyListeners(13, new Event());
            }
        });
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.remove");
        item.setEnabled(false);
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.toClipboard");
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String sToClipboard = "";
                int iColumn = ((Long)TableView.this.menu.getData("ColumnNo")).intValue();
                TableItem[] tis = TableView.this.table.getSelection();
                for (int i = 0; i < tis.length; ++i) {
                    if (i != 0) {
                        sToClipboard = sToClipboard + "\n";
                    }
                    sToClipboard = sToClipboard + tis[i].getText(iColumn);
                }
                new Clipboard(TableView.this.mainComposite.getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        TableColumnCore tc = (TableColumnCore)tcColumn.getData("TableColumnCore");
        TableContextMenuItem[] items = tc.getContextMenuItems();
        if (items.length > 0) {
            new MenuItem(this.menuThisColumn, 2);
            for (int i = 0; i < items.length; ++i) {
                final TableContextMenuItemImpl contextMenuItem = (TableContextMenuItemImpl)items[i];
                MenuItem menuItem = new MenuItem(this.menuThisColumn, 8);
                Messages.setLanguageText((Widget)menuItem, contextMenuItem.getResourceKey());
                menuItem.addListener(13, (Listener)new SelectedTableRowsListener(){

                    public void run(TableRowCore row) {
                        contextMenuItem.invokeListeners(row);
                    }
                });
            }
        }
    }

    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    public Composite getComposite() {
        return this.mainComposite;
    }

    public Composite getTableComposite() {
        return this.tableComposite;
    }

    public final void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean bForceSort) {
        if (this.table == null) {
            return;
        }
        this.refreshTable(bForceSort);
        if (this.bEnableTabViews && this.tabFolder != null && !this.tabFolder.isDisposed() && !this.tabFolder.getMinimized()) {
            this.refreshSelectedSubView();
        }
    }

    public void refreshSelectedSubView() {
        IView view;
        if (!this.bEnableTabViews || this.tabFolder == null || this.tabFolder.isDisposed() || this.tabFolder.getMinimized()) {
            return;
        }
        CTabItem item = this.tabFolder.getSelection();
        if (item != null && (view = (IView)item.getData("IView")) != null) {
            view.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTable(boolean bForceSort) {
        if (this.table == null) {
            return;
        }
        try {
            boolean bWillSort;
            this.this_mon.enter();
            if (this.getComposite() == null || this.getComposite().isDisposed()) {
                return;
            }
            this.processDataSourceQueue();
            if (this.checkColumnWidthsEvery != 0 && this.loopFactor % this.checkColumnWidthsEvery == 0) {
                TableColumn[] tableColumnsSWT = this.table.getColumns();
                for (int i = 0; i < tableColumnsSWT.length; ++i) {
                    TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                    if (tc == null || tc.getWidth() == tableColumnsSWT[i].getWidth()) continue;
                    tc.setWidth(tableColumnsSWT[i].getWidth());
                    int columnNumber = this.table.indexOf(tableColumnsSWT[i]);
                    this.locationChanged(columnNumber);
                }
            }
            long lTimeStart = System.currentTimeMillis();
            this.count = 0L;
            final boolean bDoGraphics = this.loopFactor % this.graphicsUpdate == 0;
            boolean bl = bWillSort = bForceSort || this.reOrderDelay != 0 && this.loopFactor % this.reOrderDelay == 0;
            if (bWillSort) {
                this.sortColumn(true);
            }
            lTimeStart = System.currentTimeMillis();
            this.runForAllRows(new GroupTableRowRunner(){

                public void run(TableRowCore row) {
                    row.refresh(bDoGraphics);
                }
            });
            ++this.loopFactor;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataSourceQueue() {
        Object[] dataSourcesAdd = null;
        Object[] dataSourcesRemove = null;
        try {
            this.dataSourceToRow_mon.enter();
            if (this.dataSourcesToAdd != null) {
                dataSourcesAdd = this.dataSourcesToAdd.toArray();
                this.dataSourcesToAdd.clear();
                if (this.dataSourcesToRemove != null && this.dataSourcesToRemove.size() > 0) {
                    for (int i = 0; i < dataSourcesAdd.length; ++i) {
                        if (!this.dataSourcesToRemove.contains(dataSourcesAdd[i])) continue;
                        this.dataSourcesToRemove.remove(dataSourcesAdd[i]);
                        dataSourcesAdd[i] = null;
                    }
                }
            }
            if (this.dataSourcesToRemove != null && this.dataSourcesToRemove.size() > 0) {
                dataSourcesRemove = this.dataSourcesToRemove.toArray();
                this.dataSourcesToRemove.clear();
            }
        }
        finally {
            this.dataSourceToRow_mon.exit();
        }
        if (dataSourcesAdd != null) {
            this.addDataSources(dataSourcesAdd, true);
        }
        if (dataSourcesRemove != null) {
            this.removeDataSources(dataSourcesRemove, true);
        }
    }

    private void locationChanged(final int iStartColumn) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                row.locationChanged(iStartColumn);
            }
        });
    }

    private void doPaint(final GC gc) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.runForVisibleRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                row.doPaint(gc);
            }
        });
    }

    public void delete() {
        int i;
        if (this.tabViews != null && this.tabViews.size() > 0) {
            for (i = 0; i < this.tabViews.size(); ++i) {
                IView view = (IView)this.tabViews.get(i);
                if (view == null) continue;
                view.delete();
            }
        }
        TableStructureEventDispatcher.getInstance(this.sTableID).removeListener(this);
        if (this.tableColumns != null) {
            for (i = 0; i < this.tableColumns.length; ++i) {
                this.tableColumns[i].saveSettings();
            }
        }
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        this.removeAllTableRows();
        configMan.removeParameterListener("ReOrder Delay", this);
        configMan.removeParameterListener("Graphics Update", this);
        Colors.getInstance().removeColorsChangedListener(this);
        super.delete();
    }

    public String getData() {
        return this.sPropertiesPrefix + ".title.short";
    }

    public String getFullTitle() {
        return MessageText.getString(this.sPropertiesPrefix + ".title.full");
    }

    public void updateLanguage() {
        super.updateLanguage();
        if (this.tabViews != null && this.tabViews.size() > 0) {
            for (int i = 0; i < this.tabViews.size(); ++i) {
                IView view = (IView)this.tabViews.get(i);
                if (view == null) continue;
                view.updateLanguage();
            }
        }
    }

    public void addDataSource(Object dataSource, boolean bImmediate) {
        this.addDataSources(new Object[]{dataSource}, bImmediate);
    }

    public void addDataSource(Object dataSource) {
        this.addDataSources(new Object[]{dataSource}, false);
    }

    public void addDataSources(Object[] dataSources) {
        this.addDataSources(dataSources, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSources(final Object[] dataSources, boolean bImmediate) {
        if (dataSources == null) {
            return;
        }
        if (!bImmediate) {
            try {
                this.dataSourceToRow_mon.enter();
                if (this.dataSourcesToAdd == null) {
                    this.dataSourcesToAdd = new ArrayList(4);
                }
                for (int i = 0; i < dataSources.length; ++i) {
                    this.dataSourcesToAdd.add(dataSources[i]);
                }
                return;
            }
            finally {
                this.dataSourceToRow_mon.exit();
            }
        }
        if (this.mainComposite == null || this.table == null || this.mainComposite.isDisposed() || this.table.isDisposed()) {
            return;
        }
        try {
            this.dataSourceToRow_mon.enter();
            for (int i = 0; i < dataSources.length; ++i) {
                if (dataSources[i] == null) continue;
                if (this.dataSourceToRow.containsKey(dataSources[i])) {
                    dataSources[i] = null;
                    continue;
                }
                TableRowImpl row = new TableRowImpl(this.table, this.sTableID, this.columnsOrdered, dataSources[i], this.bSkipFirstColumn);
                this.dataSourceToRow.put(dataSources[i], row);
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error while added row to Table " + this.sTableID, e));
        }
        finally {
            this.dataSourceToRow_mon.exit();
        }
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (TableView.this.table == null || TableView.this.table.isDisposed()) {
                    return;
                }
                try {
                    TableView.this.dataSourceToRow_mon.enter();
                    for (int i = 0; i < dataSources.length; ++i) {
                        TableRowImpl row;
                        Object dataSource = dataSources[i];
                        if (dataSource == null || (row = (TableRowImpl)TableView.this.dataSourceToRow.get(dataSource)) == null) continue;
                        TableCellCore cell = row.getTableCellCore(TableView.this.rowSorter.sColumnName);
                        if (cell != null) {
                            try {
                                cell.invalidate();
                                cell.refresh(true);
                            }
                            catch (Exception e) {
                                Logger.log(new LogEvent(LOGID, "Minor error adding a row to table " + TableView.this.sTableID, e));
                            }
                        }
                        try {
                            TableView.this.sortedRows_mon.enter();
                            if (TableView.this.sortedRows.size() > 0) {
                                TableRowCore lastRow = (TableRowCore)TableView.this.sortedRows.get(TableView.this.sortedRows.size() - 1);
                                if (TableView.this.rowSorter.compare(row, lastRow) >= 0) {
                                    TableView.this.sortedRows.add(row);
                                } else {
                                    int index = Collections.binarySearch(TableView.this.sortedRows, row, TableView.this.rowSorter);
                                    if (index < 0) {
                                        index = -1 * index - 1;
                                    }
                                    if (index > TableView.this.sortedRows.size()) {
                                        index = TableView.this.sortedRows.size();
                                    }
                                    TableView.this.sortedRows.add(index, row);
                                }
                            } else {
                                TableView.this.sortedRows.add(row);
                            }
                            if (TableView.this.bTableVirtual) continue;
                            row.createSWTRow();
                            row.setIconSize(TableView.this.ptIconSize);
                            continue;
                        }
                        catch (Exception e) {
                            Logger.log(new LogEvent(LOGID, "Error adding a row to table " + TableView.this.sTableID, e));
                            try {
                                if (TableView.this.sortedRows.contains(row)) continue;
                                TableView.this.sortedRows.add(row);
                            }
                            catch (Exception e2) {
                                Debug.out(e2);
                            }
                            continue;
                        }
                        finally {
                            TableView.this.sortedRows_mon.exit();
                        }
                    }
                    if (TableView.this.bTableVirtual) {
                        TableView.this.table.setItemCount(TableView.this.dataSourceToRow.size());
                    }
                }
                finally {
                    TableView.this.dataSourceToRow_mon.exit();
                }
                TableView.this.fillRowGaps(false);
            }
        });
    }

    public void removeDataSource(Object dataSource) {
        this.removeDataSource(dataSource, false);
    }

    public void removeDataSource(Object dataSource, boolean bImmediate) {
        this.removeDataSources(new Object[]{dataSource}, bImmediate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSources(final Object[] dataSources, boolean bImmediate) {
        if (!bImmediate) {
            try {
                this.dataSourceToRow_mon.enter();
                if (this.dataSourcesToRemove == null) {
                    this.dataSourcesToRemove = new ArrayList(4);
                }
                for (int i = 0; i < dataSources.length; ++i) {
                    this.dataSourcesToRemove.add(dataSources[i]);
                }
            }
            finally {
                this.dataSourceToRow_mon.exit();
            }
            if (this.dataSourcesToRemove.size() >= 20) {
                this.processDataSourceQueue();
            }
            return;
        }
        boolean ok = Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableRowCore item;
                ArrayList<TableRowCore> itemsToRemove = new ArrayList<TableRowCore>();
                for (int i = 0; i < dataSources.length; ++i) {
                    if (dataSources[i] == null || (item = (TableRowCore)TableView.this.dataSourceToRow.remove(dataSources[i])) == null) continue;
                    itemsToRemove.add(item);
                    TableView.this.sortedRows.remove(item);
                }
                if (!TableView.this.bTableVirtual || !TableView.this.table.isDisposed()) {
                    // empty if block
                }
                Iterator iter = itemsToRemove.iterator();
                while (iter.hasNext()) {
                    item = (TableRowCore)iter.next();
                    item.delete();
                }
            }
        });
        if (!ok) {
            for (int i = 0; i < dataSources.length; ++i) {
                if (dataSources[i] == null) continue;
                TableRowCore item = (TableRowCore)this.dataSourceToRow.get(dataSources[i]);
                this.dataSourceToRow.remove(dataSources[i]);
                if (item == null) continue;
                this.sortedRows.remove(item);
                item.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTableRows() {
        long lTimeStart = System.currentTimeMillis();
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableView.this.table != null && !TableView.this.table.isDisposed()) {
                    TableView.this.table.removeAll();
                }
                TableRowCore[] rows = TableView.this.getRows();
                for (int i = 0; i < rows.length; ++i) {
                    rows[i].delete();
                }
            }
        });
        try {
            this.dataSourceToRow_mon.enter();
            this.sortedRows_mon.enter();
            this.dataSourceToRow.clear();
            this.sortedRows.clear();
            if (this.dataSourcesToAdd != null) {
                this.dataSourcesToAdd.clear();
            }
            if (this.dataSourcesToRemove != null) {
                this.dataSourcesToRemove.clear();
            }
        }
        finally {
            this.sortedRows_mon.exit();
            this.dataSourceToRow_mon.exit();
        }
    }

    public Table getTable() {
        return this.table;
    }

    public String getTableID() {
        return this.sTableID;
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Graphics Update")) {
            this.graphicsUpdate = configMan.getIntParameter("Graphics Update");
            return;
        }
        if (parameterName.equals("ReOrder Delay")) {
            this.reOrderDelay = configMan.getIntParameter("ReOrder Delay");
            return;
        }
        if (parameterName.startsWith("Color")) {
            this.tableInvalidate();
        }
    }

    public void tableStructureChanged() {
        this.removeAllTableRows();
        this.initializeTableColumns(this.table);
        this.refreshTable(false);
    }

    public void columnOrderChanged(int[] positions) {
        try {
            this.table.setColumnOrder(positions);
        }
        catch (NoSuchMethodError e) {
            this.tableStructureChanged();
        }
    }

    public void columnSizeChanged(TableColumnCore tableColumn) {
        int newWidth = tableColumn.getWidth();
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableColumn column = null;
        TableColumn[] tableColumnsSWT = this.table.getColumns();
        for (int i = 0; i < tableColumnsSWT.length; ++i) {
            if (tableColumnsSWT[i].getData("TableColumnCore") != tableColumn) continue;
            column = tableColumnsSWT[i];
            break;
        }
        if (column == null || column.isDisposed() || column.getWidth() == newWidth) {
            return;
        }
        column.setWidth(newWidth);
    }

    public void columnInvalidate(TableColumnCore tableColumn) {
        this.columnInvalidate(tableColumn, true);
    }

    public void columnRefresh(TableColumnCore tableColumn) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null) {
                    cell.refresh();
                }
            }
        });
    }

    public void tableInvalidate() {
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                row.invalidate();
                row.refresh(true);
            }
        });
    }

    public void columnInvalidate(String sColumnName) {
        TableColumnCore tc = TableColumnManager.getInstance().getTableColumnCore(this.sTableID, sColumnName);
        if (tc != null) {
            this.columnInvalidate(tc, tc.getType() == 3);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new GroupTableRowRunner(){

            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCellCore[] getColumnCells(String sColumnName) {
        TableCellCore[] cells = new TableCellCore[this.sortedRows.size()];
        try {
            this.sortedRows_mon.enter();
            int i = 0;
            Iterator iter = this.sortedRows.iterator();
            while (iter.hasNext()) {
                TableRowCore row = (TableRowCore)iter.next();
                cells[i++] = row.getTableCellCore(sColumnName);
            }
        }
        finally {
            this.sortedRows_mon.exit();
        }
        return cells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRowCore[] getRows() {
        try {
            this.sortedRows_mon.enter();
            TableRowCore[] tableRowCoreArray = this.sortedRows.toArray(new TableRowCore[0]);
            return tableRowCoreArray;
        }
        finally {
            this.sortedRows_mon.exit();
        }
    }

    public TableRowCore getRow(Object dataSource) {
        return (TableRowCore)this.dataSourceToRow.get(dataSource);
    }

    public int getRowCount() {
        return this.dataSourceToRow.size();
    }

    public List getSelectedDataSourcesList() {
        return this.getSelectedDataSourcesList(true);
    }

    public List getSelectedDataSourcesList(boolean bCoreDataSource) {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.table != null && !this.table.isDisposed()) {
            TableItem[] tis = this.table.getSelection();
            for (int i = 0; i < tis.length; ++i) {
                TableRowCore row = (TableRowCore)tis[i].getData("TableRow");
                if (row == null) {
                    this.fillRowGaps(false);
                    row = (TableRowCore)tis[i].getData("TableRow");
                    if (row == null) {
                        System.out.println("XXX Boo, row still null");
                    }
                }
                if (row == null || row.getDataSource(true) == null) continue;
                l.add(row.getDataSource(bCoreDataSource));
            }
        }
        return l;
    }

    public Object[] getSelectedDataSources(Object[] a) {
        return this.getSelectedDataSourcesList().toArray(a);
    }

    public Object[] getSelectedDataSources() {
        return this.getSelectedDataSourcesList().toArray();
    }

    public Object[] getSelectedDataSources(boolean bCoreDataSource) {
        return this.getSelectedDataSourcesList(bCoreDataSource).toArray();
    }

    public TableRowCore[] getSelectedRows() {
        return this.getSelectedRowsList().toArray(new TableRowCore[0]);
    }

    public List getSelectedRowsList() {
        ArrayList<TableRowCore> l = new ArrayList<TableRowCore>();
        if (this.table != null && !this.table.isDisposed()) {
            TableItem[] tis = this.table.getSelection();
            for (int i = 0; i < tis.length; ++i) {
                TableRowCore row = (TableRowCore)tis[i].getData("TableRow");
                if (row == null || row.getDataSource(true) == null) continue;
                l.add(row);
            }
        }
        return l;
    }

    public Object getFirstSelectedDataSource() {
        return this.getFirstSelectedDataSource(true);
    }

    public TableRowCore[] getVisibleRows() {
        if (this.table == null || this.table.isDisposed()) {
            return new TableRowCore[0];
        }
        int iTopIndex = this.table.getTopIndex();
        int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
        TableRowCore[] rows = new TableRowCore[iBottomIndex - iTopIndex + 1];
        int pos = 0;
        for (int i = iTopIndex; i <= iBottomIndex; ++i) {
            TableRowCore row = (TableRowCore)this.table.getItem(i).getData("TableRow");
            if (row == null) continue;
            rows[pos++] = row;
        }
        if (pos <= rows.length) {
            TableRowCore[] temp = new TableRowCore[pos];
            System.arraycopy(rows, 0, temp, 0, pos);
            return temp;
        }
        return rows;
    }

    public Object getFirstSelectedDataSource(boolean bCoreObject) {
        if (this.table == null || this.table.isDisposed() || this.table.getSelectionCount() == 0) {
            return null;
        }
        TableRowCore row = (TableRowCore)this.table.getSelection()[0].getData("TableRow");
        if (row == null) {
            return null;
        }
        return row.getDataSource(bCoreObject);
    }

    public void runForSelectedRows(GroupTableRowRunner runner) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableItem[] tis = this.table.getSelection();
        for (int i = 0; i < tis.length; ++i) {
            TableRowCore row = (TableRowCore)tis[i].getData("TableRow");
            if (row == null) continue;
            runner.run(row);
        }
    }

    public void runForVisibleRows(GroupTableRowRunner runner) {
        TableRowCore[] rows = this.getVisibleRows();
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i]);
        }
    }

    public void runForAllRows(GroupTableRowRunner runner) {
        TableRowCore[] rows = this.getRows();
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i]);
        }
    }

    public void runForTableItems(List items, GroupTableRowRunner runner) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            TableRowCore row;
            TableItem tableItem = (TableItem)iter.next();
            if (tableItem.isDisposed() || (row = (TableRowCore)tableItem.getData("TableRow")) == null) continue;
            runner.run(row);
        }
    }

    public void clipboardSelected() {
        String sToClipboard = "";
        for (int j = 0; j < this.getTable().getColumnCount(); ++j) {
            if (j != 0) {
                sToClipboard = sToClipboard + "\t";
            }
            sToClipboard = sToClipboard + this.getTable().getColumn(j).getText();
        }
        TableItem[] tis = this.getTable().getSelection();
        for (int i = 0; i < tis.length; ++i) {
            sToClipboard = sToClipboard + "\n";
            for (int j = 0; j < this.getTable().getColumnCount(); ++j) {
                if (j != 0) {
                    sToClipboard = sToClipboard + "\t";
                }
                sToClipboard = sToClipboard + tis[i].getText(j);
            }
        }
        new Clipboard(this.getComposite().getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
    }

    private int getColumnNo(int iMouseX) {
        int iColumn = -1;
        if (this.table.getItemCount() > 0) {
            int i;
            TableItem ti = this.table.getItem(this.table.getTopIndex());
            int n = i = this.bSkipFirstColumn ? 1 : 0;
            while (i < this.table.getColumnCount()) {
                Rectangle cellBounds = ti.getBounds(i);
                if (iMouseX >= cellBounds.x && iMouseX < cellBounds.x + cellBounds.width && cellBounds.width > 0) {
                    iColumn = i;
                    break;
                }
                ++i;
            }
        }
        return iColumn;
    }

    private TableCellCore getTableCell(int x, int y) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableItem item = this.table.getItem(new Point(2, y));
        if (item == null) {
            return null;
        }
        TableRowCore row = (TableRowCore)item.getData("TableRow");
        TableColumn tcColumn = this.table.getColumn(iColumn);
        String sCellName = (String)tcColumn.getData("Name");
        if (sCellName == null) {
            return null;
        }
        return row.getTableCellCore(sCellName);
    }

    private TableColumnCore getTableColumnByOffset(int x) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableColumn column = this.table.getColumn(iColumn);
        return (TableColumnCore)column.getData("TableColumnCore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDiagnostics(IndentWriter writer) {
        super.generateDiagnostics(writer);
        try {
            this.dataSourceToRow_mon.enter();
            writer.println("TableView: " + this.dataSourceToRow.size() + " datasources");
            writer.println("DataSources scheduled to Add: " + (this.dataSourcesToAdd == null ? 0 : this.dataSourcesToAdd.size()));
            writer.println("DataSources scheduled to Remove: " + (this.dataSourcesToRemove == null ? 0 : this.dataSourcesToRemove.size()));
            Iterator it = this.dataSourceToRow.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                writer.println("  " + key + " -> " + this.dataSourceToRow.get(key));
            }
            writer.println("# of SubViews: " + this.tabViews.size());
            writer.indent();
            try {
                Iterator iter = this.tabViews.iterator();
                while (iter.hasNext()) {
                    IView view = (IView)iter.next();
                    view.generateDiagnostics(writer);
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            this.dataSourceToRow_mon.exit();
        }
    }

    public boolean getSkipFirstColumn() {
        return this.bSkipFirstColumn;
    }

    public void setRowDefaultHeight(int iHeight) {
        if (this.ptIconSize == null) {
            this.ptIconSize = new Point(1, iHeight);
        } else {
            this.ptIconSize.y = iHeight;
        }
        this.bSkipFirstColumn = true;
    }

    public int getRowDefaultHeight() {
        if (this.ptIconSize == null) {
            return 0;
        }
        return this.ptIconSize.y;
    }

    public void setRowDefaultIconSize(Point size) {
        this.ptIconSize = size;
        this.bSkipFirstColumn = true;
    }

    public void addTabView(IView view) {
        if (view == null || this.tabFolder == null) {
            return;
        }
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setData("IView", (Object)view);
        Messages.setLanguageText((Widget)item, view.getData());
        view.initialize((Composite)this.tabFolder);
        item.setControl((Control)view.getComposite());
        this.tabViews.add(view);
    }

    private void fillRowGaps(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, true);
    }

    private void sortColumn(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sortColumn(boolean bForceDataRefresh, boolean bFillGapsOnly) {
        try {
            this.sortColumn_mon.enter();
            int iNumMoves = 0;
            int iFocusIndex = this.table.getSelectionIndex();
            TableRowCore focusedRow = iFocusIndex == -1 ? null : (TableRowCore)this.table.getItem(iFocusIndex).getData("TableRow");
            int[] selectedRowIndices = this.table.getSelectionIndices();
            TableRowCore[] selectedRows = new TableRowCore[selectedRowIndices.length];
            for (int i = 0; i < selectedRowIndices.length; ++i) {
                selectedRows[i] = (TableRowCore)this.table.getItem(selectedRowIndices[i]).getData("TableRow");
            }
            try {
                int i;
                TableRowCore row;
                this.sortedRows_mon.enter();
                if (bForceDataRefresh) {
                    Iterator iter = this.sortedRows.iterator();
                    while (iter.hasNext()) {
                        row = (TableRowCore)iter.next();
                        TableCellCore cell = row.getTableCellCore(this.rowSorter.sColumnName);
                        if (cell == null) continue;
                        cell.refresh();
                    }
                }
                if (!bFillGapsOnly) {
                    Collections.sort(this.sortedRows, this.rowSorter);
                }
                if (this.bTableVirtual) {
                    for (i = 0; i < this.sortedRows.size(); ++i) {
                        row = (TableRowCore)this.sortedRows.get(i);
                        if (!row.setTableItem(i)) continue;
                        ++iNumMoves;
                    }
                } else {
                    for (i = 0; i < this.sortedRows.size(); ++i) {
                        row = (TableRowCore)this.sortedRows.get(i);
                        if (!row.setTableItem(i)) continue;
                        ++iNumMoves;
                        row.refresh(true);
                    }
                }
            }
            finally {
                this.sortedRows_mon.exit();
            }
            if (focusedRow != null) {
                int pos = 1;
                int numSame = 0;
                int[] newSelectedRowIndices = new int[selectedRows.length];
                Arrays.sort(selectedRowIndices);
                for (int i = 0; i < selectedRows.length; ++i) {
                    int index = selectedRows[i].getIndex();
                    newSelectedRowIndices[selectedRows[i] == focusedRow ? 0 : pos++] = index;
                    if (Arrays.binarySearch(selectedRowIndices, index) < 0) continue;
                    ++numSame;
                }
                if (numSame < selectedRows.length) {
                    this.table.setSelection(newSelectedRowIndices);
                }
            }
        }
        finally {
            this.sortColumn_mon.exit();
        }
    }

    public void sortColumnReverse(TableColumnCore tableColumn) {
        boolean bSameColumn = this.rowSorter.sColumnName.equals(tableColumn.getName());
        if (!bSameColumn) {
            int iSortDirection = configMan.getIntParameter(CFG_SORTDIRECTION);
            this.rowSorter.bAscending = iSortDirection == 0 ? true : (iSortDirection == 1 ? false : !this.rowSorter.bAscending);
            this.rowSorter.sColumnName = tableColumn.getName();
            configMan.setParameter(this.sTableID + ".sortAsc", this.rowSorter.bAscending);
            configMan.setParameter(this.sTableID + ".sortColumn", this.rowSorter.sColumnName);
        } else {
            this.rowSorter.bAscending = !this.rowSorter.bAscending;
            configMan.setParameter(this.sTableID + ".sortAsc", this.rowSorter.bAscending);
        }
        this.changeColumnIndicator();
        this.sortColumn(!bSameColumn);
    }

    private void changeColumnIndicator() {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        try {
            TableColumn[] tcs = this.table.getColumns();
            for (int i = 0; i < tcs.length; ++i) {
                String sName = (String)tcs[i].getData("Name");
                if (sName == null || !sName.equals(this.rowSorter.sColumnName)) continue;
                this.table.setSortDirection(this.rowSorter.bAscending ? 128 : 1024);
                this.table.setSortColumn(tcs[i]);
                return;
            }
            this.table.setSortColumn(null);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visibleRowsChanged() {
        TableRowCore row;
        int i;
        int tmpIndex;
        if (!this.table.isVisible()) {
            this.lastTopIndex = 0;
            this.lastBottomIndex = -1;
            return;
        }
        int iTopIndex = this.table.getTopIndex();
        int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
        if (this.lastTopIndex != iTopIndex) {
            tmpIndex = this.lastTopIndex;
            this.lastTopIndex = iTopIndex;
            if (iTopIndex < tmpIndex) {
                if (tmpIndex > iBottomIndex + 1 && iBottomIndex >= 0) {
                    tmpIndex = iBottomIndex + 1;
                }
                try {
                    this.sortedRows_mon.enter();
                    for (i = iTopIndex; i < tmpIndex && i < this.sortedRows.size(); ++i) {
                        row = (TableRowCore)this.sortedRows.get(i);
                        row.refresh(true);
                    }
                }
                finally {
                    this.sortedRows_mon.exit();
                }
                iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
            }
        }
        if (this.lastBottomIndex != iBottomIndex) {
            tmpIndex = this.lastBottomIndex;
            this.lastBottomIndex = iBottomIndex;
            if (tmpIndex < iTopIndex - 1) {
                tmpIndex = iTopIndex - 1;
            }
            if (tmpIndex <= iBottomIndex) {
                try {
                    this.sortedRows_mon.enter();
                    for (i = tmpIndex + 1; i <= iBottomIndex && i < this.sortedRows.size(); ++i) {
                        row = (TableRowCore)this.sortedRows.get(i);
                        row.refresh(true);
                    }
                }
                finally {
                    this.sortedRows_mon.exit();
                }
            }
        }
    }

    static /* synthetic */ long access$1700(TableView x0) {
        return x0.lLastColumnResizeOn;
    }

    private class TableTooltips
    implements Listener {
        Shell toolTipShell = null;
        Shell mainShell = null;
        Label toolTipLabel = null;

        public TableTooltips(Table table) {
            this.mainShell = table.getShell();
            table.addListener(12, (Listener)this);
            table.addListener(1, (Listener)this);
            table.addListener(5, (Listener)this);
            table.addListener(32, (Listener)this);
            this.mainShell.addListener(27, (Listener)this);
            TableView.this.getComposite().addListener(27, (Listener)this);
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 32: {
                    Rectangle displayRect;
                    TableCellCore cell;
                    if (this.toolTipShell != null && !this.toolTipShell.isDisposed()) {
                        this.toolTipShell.dispose();
                    }
                    if ((cell = TableView.this.getTableCell(event.x, event.y)) == null) {
                        return;
                    }
                    cell.invokeToolTipListeners(0);
                    Object oToolTip = cell.getToolTip();
                    if (oToolTip == null || !(oToolTip instanceof String)) {
                        return;
                    }
                    String sToolTip = (String)oToolTip;
                    Display d = TableView.this.table.getDisplay();
                    if (d == null) {
                        return;
                    }
                    this.toolTipShell = new Shell(TableView.this.table.getShell(), 16384);
                    FillLayout f = new FillLayout();
                    try {
                        f.marginWidth = 3;
                        f.marginHeight = 1;
                    }
                    catch (NoSuchFieldError e) {
                        // empty catch block
                    }
                    this.toolTipShell.setLayout((Layout)f);
                    this.toolTipShell.setBackground(d.getSystemColor(29));
                    this.toolTipLabel = new Label((Composite)this.toolTipShell, 64);
                    this.toolTipLabel.setForeground(d.getSystemColor(28));
                    this.toolTipLabel.setBackground(d.getSystemColor(29));
                    this.toolTipShell.setData("TableCellCore", (Object)cell);
                    this.toolTipLabel.setText(sToolTip.replaceAll("&", "&&"));
                    Point size = this.toolTipLabel.computeSize(-1, -1);
                    if (size.x > 600) {
                        size = this.toolTipLabel.computeSize(600, -1, true);
                    }
                    size.x += this.toolTipShell.getBorderWidth() * 2 + 2;
                    size.y += this.toolTipShell.getBorderWidth() * 2;
                    try {
                        size.x += this.toolTipShell.getBorderWidth() * 2 + f.marginWidth * 2;
                        size.y += this.toolTipShell.getBorderWidth() * 2 + f.marginHeight * 2;
                    }
                    catch (NoSuchFieldError e) {
                        // empty catch block
                    }
                    Point pt = TableView.this.table.toDisplay(event.x, event.y);
                    try {
                        displayRect = this.toolTipShell.getMonitor().getClientArea();
                    }
                    catch (NoSuchMethodError e) {
                        displayRect = this.toolTipShell.getDisplay().getClientArea();
                    }
                    if (pt.x + size.x > displayRect.x + displayRect.width) {
                        pt.x = displayRect.x + displayRect.width - size.x;
                    }
                    pt.y = pt.y + size.y > displayRect.y + displayRect.height ? (pt.y -= size.y + 2) : (pt.y += 21);
                    this.toolTipShell.setBounds(pt.x, pt.y < 0 ? 0 : pt.y, size.x, size.y);
                    this.toolTipShell.setVisible(true);
                    break;
                }
                case 12: {
                    if (this.mainShell != null && !this.mainShell.isDisposed()) {
                        this.mainShell.removeListener(27, (Listener)this);
                    }
                    if (TableView.this.getComposite() != null && !TableView.this.getComposite().isDisposed()) {
                        this.mainShell.removeListener(27, (Listener)this);
                    }
                }
                default: {
                    if (this.toolTipShell == null) break;
                    this.toolTipShell.dispose();
                    this.toolTipShell = null;
                    this.toolTipLabel = null;
                }
            }
        }
    }

    private class ColumnMoveListener
    implements Listener {
        private ColumnMoveListener() {
        }

        public void handleEvent(Event event) {
            int[] iColumnOrder;
            int iAddedPosition;
            TableColumn column = (TableColumn)event.widget;
            if (column == null) {
                return;
            }
            TableColumnCore tableColumnCore = (TableColumnCore)column.getData("TableColumnCore");
            if (tableColumnCore == null) {
                return;
            }
            Table table = column.getParent();
            TableColumn[] tableColumns = table.getColumns();
            for (iAddedPosition = 0; iAddedPosition < tableColumns.length && column != tableColumns[iAddedPosition]; ++iAddedPosition) {
            }
            if (iAddedPosition >= tableColumns.length) {
                return;
            }
            try {
                iColumnOrder = table.getColumnOrder();
            }
            catch (NoSuchMethodError e) {
                return;
            }
            for (int i = 0; i < iColumnOrder.length; ++i) {
                if (iColumnOrder[i] != iAddedPosition) continue;
                int iNewPosition = i - (TableView.this.bSkipFirstColumn ? 1 : 0);
                if (tableColumnCore.getPosition() == iNewPosition) break;
                tableColumnCore.setPositionNoShift(iNewPosition);
                tableColumnCore.saveSettings();
                TableStructureEventDispatcher.getInstance(TableView.this.sTableID).columnOrderChanged(iColumnOrder);
                break;
            }
        }
    }

    private class ColumnSelectionListener
    implements Listener {
        private ColumnSelectionListener() {
        }

        public void handleEvent(Event event) {
            if (COLUMN_CLICK_DELAY) {
                Timer timer = new Timer("Column Selection Wait");
                timer.addEvent(System.currentTimeMillis() + 85L, new TimerEventPerformer(this, event, timer){
                    private final /* synthetic */ Event val$event;
                    private final /* synthetic */ Timer val$timer;
                    private final /* synthetic */ ColumnSelectionListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                        this.val$timer = val$timer;
                    }

                    public void perform(TimerEvent timerEvent2) {
                        Utils.execSWTThread(new AERunnable(this){
                            private final /* synthetic */ 32 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void runSupport() {
                                if (TableView.access$1700(ColumnSelectionListener.access$3300(32.access$3200(this.this$2))) == -1L || System.currentTimeMillis() - TableView.access$1700(ColumnSelectionListener.access$3300(32.access$3200(this.this$2))) > 220L) {
                                    ColumnSelectionListener.access$3500(32.access$3200(this.this$2), 32.access$3400(this.this$2));
                                }
                            }
                        });
                        this.val$timer.destroy();
                    }

                    static /* synthetic */ ColumnSelectionListener access$3200(32 x0) {
                        return x0.this$1;
                    }

                    static /* synthetic */ Event access$3400(32 x0) {
                        return x0.val$event;
                    }
                });
            } else {
                this.reallyHandleEvent(event);
            }
        }

        private void reallyHandleEvent(Event event) {
            TableColumn column = (TableColumn)event.widget;
            if (column == null) {
                return;
            }
            TableColumnCore tableColumnCore = (TableColumnCore)column.getData("TableColumnCore");
            if (tableColumnCore != null) {
                TableView.this.sortColumnReverse(tableColumnCore);
                TableView.this.refreshTable(true);
            }
        }

        static /* synthetic */ TableView access$3300(ColumnSelectionListener x0) {
            return x0.TableView.this;
        }

        static /* synthetic */ void access$3500(ColumnSelectionListener x0, Event x1) {
            x0.reallyHandleEvent(x1);
        }
    }

    public abstract class SelectedTableRowsListener
    extends GroupTableRowRunner
    implements Listener {
        protected Event event;

        public void handleEvent(Event e) {
            this.event = e;
            TableView.this.runForSelectedRows(this);
        }
    }

    public abstract class GroupTableRowRunner {
        public void run(TableRowCore row) {
        }
    }
}

