/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.ConfigSectionSWT;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnection;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnectionAdvanced;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnectionProxy;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFile;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFilePerformance;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFileTorrents;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionIPFilter;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterface;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceColor;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceDisplay;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceLanguage;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceStart;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionLogging;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionMode;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionPlugins;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSecurity;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSharing;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionStats;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTracker;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTrackerClient;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTrackerServer;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTransfer;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTransferLAN;

public class ConfigView
extends AbstractIView {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final String sSectionPrefix = "ConfigView.section.";
    AzureusCore azureus_core;
    Composite cConfig;
    Composite cConfigSection;
    StackLayout layoutConfigSection;
    Label lHeader;
    Font headerFont;
    Tree tree;
    TreeItem treePlugins;
    ArrayList pluginSections;

    public ConfigView(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
    }

    public void initialize(Composite composite) {
        try {
            this.cConfig = new Composite(composite, 0);
            GridLayout configLayout = new GridLayout();
            configLayout.marginHeight = 0;
            configLayout.marginWidth = 0;
            this.cConfig.setLayout((Layout)configLayout);
            GridData gridData = new GridData(1808);
            this.cConfig.setLayoutData((Object)gridData);
            SashForm form = new SashForm(this.cConfig, 256);
            gridData = new GridData(1808);
            form.setLayoutData((Object)gridData);
            this.tree = new Tree((Composite)form, 2048);
            this.tree.setLayout((Layout)new FillLayout());
            Composite cRightSide = new Composite((Composite)form, 0);
            configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            cRightSide.setLayout((Layout)configLayout);
            Composite cHeader = new Composite(cRightSide, 2048);
            configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            cHeader.setLayout((Layout)configLayout);
            gridData = new GridData(772);
            cHeader.setLayoutData((Object)gridData);
            Display d = cRightSide.getDisplay();
            cHeader.setBackground(d.getSystemColor(26));
            cHeader.setForeground(d.getSystemColor(27));
            this.lHeader = new Label(cHeader, 0);
            this.lHeader.setBackground(d.getSystemColor(26));
            this.lHeader.setForeground(d.getSystemColor(27));
            FontData[] fontData = this.lHeader.getFont().getFontData();
            fontData[0].setStyle(1);
            int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
            fontData[0].setHeight(fontHeight);
            this.headerFont = new Font((Device)d, fontData);
            this.lHeader.setFont(this.headerFont);
            gridData = new GridData(772);
            this.lHeader.setLayoutData((Object)gridData);
            this.cConfigSection = new Composite(cRightSide, 0);
            this.layoutConfigSection = new StackLayout();
            this.cConfigSection.setLayout((Layout)this.layoutConfigSection);
            gridData = new GridData(1808);
            this.cConfigSection.setLayoutData((Object)gridData);
            form.setWeights(new int[]{20, 80});
            this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Tree tree = (Tree)e.getSource();
                    if (tree.getSelection().length > 0) {
                        ConfigView.this.showSection(tree.getSelection()[0]);
                    }
                }
            });
            this.tree.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    TreeItem item = (TreeItem)e.item;
                    if (item != null) {
                        item.setExpanded(!item.getExpanded());
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error initializing ConfigView", e));
        }
        this.pluginSections = ConfigSectionRepository.getInstance().getList();
        ConfigSection[] internalSections = new ConfigSection[]{new ConfigSectionConnection(), new ConfigSectionConnectionProxy(), new ConfigSectionConnectionAdvanced(), new ConfigSectionTransfer(), new ConfigSectionTransferLAN(), new ConfigSectionFile(), new ConfigSectionFileTorrents(), new ConfigSectionFilePerformance(), new ConfigSectionInterface(), new ConfigSectionInterfaceLanguage(), new ConfigSectionInterfaceStart(), new ConfigSectionInterfaceDisplay(), new ConfigSectionInterfaceColor(), new ConfigSectionMode(), new ConfigSectionIPFilter(this.azureus_core), new ConfigSectionPlugins(this, this.azureus_core), new ConfigSectionStats(), new ConfigSectionTracker(this.azureus_core), new ConfigSectionTrackerClient(), new ConfigSectionTrackerServer(this.azureus_core), new ConfigSectionSecurity(), new ConfigSectionSharing(), new ConfigSectionLogging()};
        this.pluginSections.addAll(0, Arrays.asList(internalSections));
        for (int i = 0; i < this.pluginSections.size(); ++i) {
            String name;
            boolean plugin_section = i >= internalSections.length;
            ConfigSection section = (ConfigSection)this.pluginSections.get(i);
            if (!(section instanceof ConfigSectionSWT) && !(section instanceof UISWTConfigSection)) continue;
            try {
                name = section.configSectionGetName();
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "A ConfigSection plugin caused an error while trying to call its configSectionGetName function", e));
                name = "Bad Plugin";
            }
            try {
                TreeItem treeItemFound;
                TreeItem treeItem = null;
                String location = section.configSectionGetParentSection();
                if (location.equalsIgnoreCase("root")) {
                    treeItem = new TreeItem(this.tree, 0);
                } else if (location != "" && (treeItemFound = this.findTreeItem(this.tree, location)) != null) {
                    treeItem = new TreeItem(treeItemFound, 0);
                }
                if (treeItem == null) {
                    treeItem = new TreeItem(this.treePlugins, 0);
                }
                ScrolledComposite sc = new ScrolledComposite(this.cConfigSection, 768);
                sc.setExpandHorizontal(true);
                sc.setExpandVertical(true);
                sc.setLayoutData((Object)new GridData(1808));
                if (i == 0) {
                    Composite c = section instanceof ConfigSectionSWT ? ((ConfigSectionSWT)section).configSectionCreate((Composite)sc) : ((UISWTConfigSection)section).configSectionCreate((Composite)sc);
                    sc.setContent((Control)c);
                }
                String section_key = name;
                if (plugin_section) {
                    if (!MessageText.keyExists(section_key)) {
                        section_key = sSectionPrefix + name;
                    }
                } else {
                    section_key = sSectionPrefix + name;
                }
                Messages.setLanguageText((Widget)treeItem, section_key);
                treeItem.setData("Panel", (Object)sc);
                treeItem.setData("ID", (Object)name);
                treeItem.setData("ConfigSectionSWT", (Object)section);
                if (!(section instanceof ConfigSectionPlugins)) continue;
                ((ConfigSectionPlugins)section).initPluginSubSections();
                continue;
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "ConfigSection plugin '" + name + "' caused an error", e));
            }
        }
        this.initSaveButton();
        TreeItem[] items = new TreeItem[]{this.tree.getItems()[0]};
        this.tree.setSelection(items);
        this.showSection(items[0]);
    }

    private void showSection(TreeItem section) {
        ScrolledComposite item = (ScrolledComposite)section.getData("Panel");
        if (item != null) {
            ConfigSection configSection = (ConfigSection)section.getData("ConfigSectionSWT");
            if (configSection != null) {
                Control previous = item.getContent();
                if (previous instanceof Composite) {
                    configSection.configSectionDelete();
                    Utils.disposeComposite((Composite)previous, true);
                }
                Composite c = configSection instanceof ConfigSectionSWT ? ((ConfigSectionSWT)configSection).configSectionCreate((Composite)item) : ((UISWTConfigSection)configSection).configSectionCreate((Composite)item);
                item.setContent((Control)c);
                c.layout();
            }
            this.layoutConfigSection.topControl = item;
            Composite c = (Composite)item.getContent();
            item.setMinSize(c.computeSize(-1, -1));
            this.cConfigSection.layout();
            this.updateHeader(section);
        }
    }

    private void updateHeader(TreeItem section) {
        if (section == null) {
            return;
        }
        String sHeader = section.getText();
        for (section = section.getParentItem(); section != null; section = section.getParentItem()) {
            sHeader = section.getText() + " : " + sHeader;
        }
        this.lHeader.setText(" " + sHeader.replaceAll("&", "&&"));
    }

    private Composite createConfigSection(String sNameID) {
        return this.createConfigSection(null, sNameID, -1, true);
    }

    private Composite createConfigSection(String sNameID, int position) {
        return this.createConfigSection(null, sNameID, position, true);
    }

    public Composite createConfigSection(TreeItem treeItemParent, String sNameID, int position, boolean bPrefix) {
        ScrolledComposite sc = new ScrolledComposite(this.cConfigSection, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setLayoutData((Object)new GridData(1808));
        Composite cConfigSection = new Composite((Composite)sc, 0);
        TreeItem treeItem = treeItemParent == null ? (position >= 0 ? new TreeItem(this.tree, 0, position) : new TreeItem(this.tree, 0)) : (position >= 0 ? new TreeItem(treeItemParent, 0, position) : new TreeItem(treeItemParent, 0));
        Messages.setLanguageText((Widget)treeItem, (bPrefix ? sSectionPrefix : "") + sNameID);
        treeItem.setData("Panel", (Object)sc);
        treeItem.setData("ID", (Object)sNameID);
        sc.setContent((Control)cConfigSection);
        return cConfigSection;
    }

    public TreeItem findTreeItem(String ID) {
        return this.findTreeItem((Tree)null, ID);
    }

    private TreeItem findTreeItem(Tree tree, String ID) {
        if (tree == null) {
            tree = this.tree;
        }
        TreeItem[] items = tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            String itemID = (String)items[i].getData("ID");
            if (itemID != null && itemID.equalsIgnoreCase(ID)) {
                return items[i];
            }
            TreeItem itemFound = this.findTreeItem(items[i], ID);
            if (itemFound == null) continue;
            return itemFound;
        }
        return null;
    }

    private TreeItem findTreeItem(TreeItem item, String ID) {
        TreeItem[] subItems = item.getItems();
        for (int i = 0; i < subItems.length; ++i) {
            String itemID = (String)subItems[i].getData("ID");
            if (itemID != null && itemID.equalsIgnoreCase(ID)) {
                return subItems[i];
            }
            TreeItem itemFound = this.findTreeItem(subItems[i], ID);
            if (itemFound == null) continue;
            return itemFound;
        }
        return null;
    }

    private void initSaveButton() {
        Button save = new Button(this.cConfig, 8);
        Messages.setLanguageText((Widget)save, "ConfigView.button.save");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 80;
        save.setLayoutData((Object)gridData);
        save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                COConfigurationManager.setParameter("updated", 1);
                COConfigurationManager.save();
                for (int i = 0; i < ConfigView.this.pluginSections.size(); ++i) {
                    ((ConfigSection)ConfigView.this.pluginSections.get(i)).configSectionSave();
                }
            }
        });
    }

    public Composite getComposite() {
        return this.cConfig;
    }

    public void updateLanguage() {
        super.updateLanguage();
        this.updateHeader(this.tree.getSelection()[0]);
    }

    public void delete() {
        MainWindow.getWindow().clearConfig();
        for (int i = 0; i < this.pluginSections.size(); ++i) {
            ((ConfigSection)this.pluginSections.get(i)).configSectionDelete();
        }
        this.pluginSections.clear();
        if (!this.tree.isDisposed()) {
            TreeItem[] items = this.tree.getItems();
            for (int i = 0; i < items.length; ++i) {
                Composite c = (Composite)items[i].getData("Panel");
                Utils.disposeComposite(c);
                items[i].setData("Panel", null);
                items[i].setData("ConfigSectionSWT", null);
            }
        }
        Utils.disposeComposite(this.cConfig);
        if (this.headerFont != null && !this.headerFont.isDisposed()) {
            this.headerFont.dispose();
            this.headerFont = null;
        }
    }

    public String getFullTitle() {
        return MessageText.getString("ConfigView.title.full");
    }

    public boolean selectSection(String id) {
        TreeItem ti = this.findTreeItem(id);
        if (ti == null) {
            return false;
        }
        this.tree.setSelection(new TreeItem[]{ti});
        this.showSection(ti);
        return true;
    }

    public void selectSection(Class config_section_class) {
        TreeItem[] items = this.tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            TreeItem item = items[i];
            ConfigSection section = (ConfigSection)item.getData("ConfigSectionSWT");
            if (section == null || section.getClass() != config_section_class) continue;
            this.tree.setSelection(new TreeItem[]{item});
            this.showSection(item);
            break;
        }
    }
}

