/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.updater2;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.swt.updater2.SWTVersionGetter;

public class SWTUpdateChecker
implements UpdatableComponent {
    private static final LogIDs LOGID = LogIDs.GUI;

    public static void initialize() {
        PluginInitializer.getDefaultInterface().getUpdateManager().registerUpdatableComponent(new SWTUpdateChecker(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdate(final UpdateChecker checker) {
        block10: {
            try {
                SWTVersionGetter versionGetter = new SWTVersionGetter(checker);
                if (!versionGetter.needsUpdate() || System.getProperty("azureus.skipSWTcheck") != null) break block10;
                String[] mirrors = versionGetter.getMirrors();
                ResourceDownloader swtDownloader = null;
                ResourceDownloaderFactory factory = ResourceDownloaderFactoryImpl.getSingleton();
                ArrayList<ResourceDownloader> downloaders = new ArrayList<ResourceDownloader>();
                for (int i = 0; i < mirrors.length; ++i) {
                    try {
                        downloaders.add(factory.getSuffixBasedDownloader(factory.create(new URL(mirrors[i]))));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        if (!Logger.isEnabled()) continue;
                        Logger.log(new LogEvent(LOGID, 1, "Cannot use URL " + mirrors[i] + " (not valid)"));
                    }
                }
                ResourceDownloader[] resourceDownloaders = downloaders.toArray(new ResourceDownloader[downloaders.size()]);
                swtDownloader = factory.getRandomDownloader(resourceDownloaders);
                swtDownloader.addListener(new ResourceDownloaderAdapter(){

                    public boolean completed(ResourceDownloader downloader, InputStream data) {
                        return SWTUpdateChecker.this.processData(checker, data);
                    }
                });
                try {
                    swtDownloader.getSize();
                }
                catch (ResourceDownloaderException e) {
                    Debug.printStackTrace(e);
                }
                checker.addUpdate("SWT Library for " + versionGetter.getPlatform(), new String[]{"SWT is the graphical library used by Azureus"}, "" + versionGetter.getLatestVersion(), swtDownloader, 2);
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(false, "SWT Version check failed", e));
                checker.failed();
            }
            finally {
                checker.completed();
            }
        }
    }

    private boolean processData(UpdateChecker checker, InputStream data) {
        try {
            String osx_app = "/" + SystemProperties.getApplicationName() + ".app";
            UpdateInstaller installer = checker.createInstaller();
            ZipInputStream zip = new ZipInputStream(data);
            ZipEntry entry2 = null;
            while ((entry2 = zip.getNextEntry()) != null) {
                String name = entry2.getName();
                if (name.endsWith(".jar")) {
                    installer.addResource(name, zip, false);
                    if (Constants.isOSX) {
                        installer.addMoveAction(name, installer.getInstallDir() + osx_app + "/Contents/Resources/Java/" + name);
                        continue;
                    }
                    installer.addMoveAction(name, installer.getInstallDir() + File.separator + name);
                    continue;
                }
                if (name.endsWith(".jnilib") && Constants.isOSX) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, installer.getInstallDir() + osx_app + "/Contents/Resources/Java/dll/" + name);
                    continue;
                }
                if (name.equals("java_swt")) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, installer.getInstallDir() + osx_app + "/Contents/MacOS/" + name);
                    installer.addChangeRightsAction("755", installer.getInstallDir() + osx_app + "/Contents/MacOS/" + name);
                    continue;
                }
                if (name.endsWith(".dll") || name.endsWith(".so") || name.indexOf(".so.") != -1) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, installer.getInstallDir() + File.separator + name);
                    continue;
                }
                if (name.equals("javaw.exe.manifest")) continue;
                Debug.out("SWTUpdate: ignoring zip entry '" + name + "'");
            }
            zip.close();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public String getName() {
        return "SWT library";
    }

    public int getMaximumCheckTime() {
        return 30;
    }
}

