/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.maketorrent.ProgressPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class SavePathPanel
extends AbstractWizardPanel {
    protected long file_size;
    protected long piece_size;
    protected long piece_count;

    public SavePathPanel(NewTorrentWizard _wizard, AbstractWizardPanel _previousPanel) {
        super(_wizard, _previousPanel);
    }

    public void show() {
        File temp;
        String existing_parent;
        final NewTorrentWizard _wizard = (NewTorrentWizard)this.wizard;
        try {
            this.file_size = TOTorrentFactory.getTorrentDataSizeFromFileOrDir(new File(_wizard.create_from_dir ? _wizard.directoryPath : _wizard.singlePath));
            this.piece_size = TOTorrentFactory.getComputedPieceSize(this.file_size);
            this.piece_count = TOTorrentFactory.getPieceCount(this.file_size, this.piece_size);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.wizard.setTitle(MessageText.getString("wizard.torrentFile"));
        this.wizard.setCurrentInfo(MessageText.getString("wizard.choosetorrent"));
        Composite panel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        final Text file = new Text(panel, 2048);
        file.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String fName;
                ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).savePath = fName = file.getText();
                String error = "";
                if (!fName.equals("")) {
                    File f = new File(file.getText());
                    if (f.exists() || f.isDirectory()) {
                        error = MessageText.getString("wizard.invalidfile");
                    } else {
                        String parent = f.getParent();
                        if (parent != null) {
                            ((NewTorrentWizard)SavePathPanel.this.wizard).setDefaultSaveDir(parent);
                        }
                    }
                }
                SavePathPanel.this.wizard.setErrorMessage(error);
                SavePathPanel.this.wizard.setFinishEnabled(!((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).savePath.equals("") && error.equals(""));
            }
        });
        String target_file = ((NewTorrentWizard)this.wizard).create_from_dir ? ((NewTorrentWizard)this.wizard).directoryPath + ".torrent" : ((NewTorrentWizard)this.wizard).singlePath + ".torrent";
        String default_save = ((NewTorrentWizard)this.wizard).getDefaultSaveDir();
        if (default_save.length() > 0 && (existing_parent = (temp = new File(target_file)).getParent()) != null) {
            target_file = new File(default_save, temp.getName()).toString();
        }
        ((NewTorrentWizard)this.wizard).savePath = target_file;
        file.setText(((NewTorrentWizard)this.wizard).savePath);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        file.setLayoutData((Object)gridData);
        Button browse = new Button(panel, 8);
        browse.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String f;
                FileDialog fd = new FileDialog(SavePathPanel.this.wizard.getWizardWindow(), 8192);
                String path = ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).savePath;
                if (SavePathPanel.this.wizard.getErrorMessage().equals("") && !path.equals("")) {
                    File fsPath = new File(path);
                    if (!path.endsWith(File.separator)) {
                        fd.setFilterPath(fsPath.getParent());
                        fd.setFileName(fsPath.getName());
                    } else {
                        fd.setFileName(path);
                    }
                }
                if ((f = fd.open()) != null) {
                    file.setText(f);
                    File ff = new File(f);
                    String parent = ff.getParent();
                    if (parent != null) {
                        ((NewTorrentWizard)SavePathPanel.this.wizard).setDefaultSaveDir(parent);
                    }
                }
            }
        });
        Messages.setLanguageText((Widget)browse, "wizard.browse");
        Label label = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Composite gFileStuff = new Composite(panel, 0);
        gridData = new GridData(272);
        gridData.horizontalSpan = 3;
        gFileStuff.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        gFileStuff.setLayout((Layout)layout);
        label = new Label(gFileStuff, 0);
        Messages.setLanguageText((Widget)label, "wizard.maketorrent.filesize");
        Label file_size_label = new Label(gFileStuff, 0);
        file_size_label.setText(DisplayFormatters.formatByteCountToKiBEtc(this.file_size));
        label = new Label(gFileStuff, 0);
        label = new Label(gFileStuff, 0);
        label = new Label(gFileStuff, 0);
        Messages.setLanguageText((Widget)label, "wizard.maketorrent.piececount");
        final Label piece_count_label = new Label(gFileStuff, 0);
        piece_count_label.setText("" + this.piece_count);
        label = new Label(gFileStuff, 0);
        label = new Label(gFileStuff, 0);
        label = new Label(gFileStuff, 0);
        Messages.setLanguageText((Widget)label, "wizard.maketorrent.piecesize");
        final Label piece_size_label = new Label(gFileStuff, 0);
        gridData = new GridData();
        gridData.widthHint = 75;
        piece_size_label.setLayoutData((Object)gridData);
        piece_size_label.setText(DisplayFormatters.formatByteCountToKiBEtc(this.piece_size));
        final Combo manual = new Combo(gFileStuff, 12);
        final long[] sizes = TOTorrentFactory.STANDARD_PIECE_SIZES;
        manual.add(MessageText.getString("wizard.maketorrent.auto"));
        for (int i = 0; i < sizes.length; ++i) {
            manual.add(DisplayFormatters.formatByteCountToKiBEtc(sizes[i]));
        }
        manual.select(0);
        manual.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = manual.getSelectionIndex();
                if (index == 0) {
                    _wizard.setPieceSizeComputed();
                    SavePathPanel.this.piece_size = TOTorrentFactory.getComputedPieceSize(SavePathPanel.this.file_size);
                } else {
                    SavePathPanel.this.piece_size = sizes[index - 1];
                    _wizard.setPieceSizeManual(SavePathPanel.this.piece_size);
                }
                SavePathPanel.this.piece_count = TOTorrentFactory.getPieceCount(SavePathPanel.this.file_size, SavePathPanel.this.piece_size);
                piece_size_label.setText(DisplayFormatters.formatByteCountToKiBEtc(SavePathPanel.this.piece_size));
                piece_count_label.setText("" + SavePathPanel.this.piece_count);
            }
        });
        label = new Label(gFileStuff, 0);
        label = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        final Button bAutoOpen = new Button(panel, 32);
        Messages.setLanguageText((Widget)bAutoOpen, "wizard.maketorrents.autoopen");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bAutoOpen.setLayoutData((Object)gridData);
        final Button bAutoHost = new Button(panel, 32);
        Messages.setLanguageText((Widget)bAutoHost, "wizard.maketorrents.autohost");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bAutoHost.setLayoutData((Object)gridData);
        bAutoHost.setEnabled(false);
        bAutoOpen.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                _wizard.autoOpen = bAutoOpen.getSelection();
                bAutoHost.setEnabled(_wizard.autoOpen && _wizard.tracker_type != 2);
            }
        });
        bAutoHost.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                _wizard.autoHost = bAutoHost.getSelection();
            }
        });
        final Button bPrivateTorrent = new Button(panel, 32);
        Messages.setLanguageText((Widget)bPrivateTorrent, "ConfigView.section.sharing.privatetorrent");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bPrivateTorrent.setLayoutData((Object)gridData);
        final Button bAllowDHT = new Button(panel, 32);
        Messages.setLanguageText((Widget)bAllowDHT, "ConfigView.section.sharing.permitdht");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bAllowDHT.setLayoutData((Object)gridData);
        bAllowDHT.setSelection(true);
        bAllowDHT.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                _wizard.permitDHT = bAllowDHT.getSelection();
            }
        });
        bPrivateTorrent.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                _wizard.privateTorrent = bPrivateTorrent.getSelection();
                bAllowDHT.setEnabled(!_wizard.privateTorrent);
            }
        });
        if (_wizard.tracker_type == 3) {
            bAllowDHT.setEnabled(false);
            bPrivateTorrent.setEnabled(false);
        }
    }

    public IWizardPanel getFinishPanel() {
        return new ProgressPanel((NewTorrentWizard)this.wizard, (IWizardPanel)this);
    }
}

