/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatChecker;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.config.wizard.FilePanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class NatPanel
extends AbstractWizardPanel {
    StyledText textResults;
    Checker checker;
    Button bTest;
    Button bCancel;

    public NatPanel(ConfigureWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("configureWizard.nat.title"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 380;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.message");
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.server.tcp_listen_port");
        final Text textServerTCPListen = new Text(panel, 2048);
        gridData = new GridData();
        gridData.widthHint = 100;
        textServerTCPListen.setLayoutData((Object)gridData);
        textServerTCPListen.setText("" + ((ConfigureWizard)this.wizard).serverTCPListenPort);
        textServerTCPListen.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        textServerTCPListen.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                int TCPListenPort;
                ((ConfigureWizard)((NatPanel)NatPanel.this).wizard).serverTCPListenPort = TCPListenPort = Integer.parseInt(textServerTCPListen.getText());
            }
        });
        this.bTest = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bTest, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bTest.setLayoutData((Object)gridData);
        this.bCancel = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bCancel, "Button.cancel");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bCancel.setLayoutData((Object)gridData);
        this.bCancel.setEnabled(false);
        this.textResults = new StyledText(panel, 2562);
        gridData = new GridData();
        gridData.widthHint = 350;
        gridData.heightHint = 100;
        gridData.horizontalSpan = 2;
        this.textResults.setLayoutData((Object)gridData);
        this.textResults.setBackground(panel.getDisplay().getSystemColor(1));
        this.bTest.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NatPanel.this.wizard.setNextEnabled(false);
                NatPanel.this.bTest.setEnabled(false);
                NatPanel.this.bCancel.setEnabled(true);
                NatPanel.this.textResults.setText("");
                ConfigureWizard cw = (ConfigureWizard)NatPanel.this.wizard;
                int TCPListenPort = cw.serverTCPListenPort;
                NatPanel.this.checker = new Checker(TCPListenPort);
                NatPanel.this.checker.start();
            }
        });
        this.bCancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (NatPanel.this.checker != null) {
                    NatPanel.this.checker.stopIt();
                }
                NatPanel.this.bCancel.setEnabled(false);
            }
        });
    }

    public void printMessage(final String message) {
        Display display = this.wizard.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (NatPanel.this.textResults == null || NatPanel.this.textResults.isDisposed()) {
                    return;
                }
                NatPanel.this.textResults.append(message);
            }
        });
    }

    public void enableNext() {
        Display display = this.wizard.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                NatPanel.this.wizard.setNextEnabled(true);
                NatPanel.this.bTest.setEnabled(true);
                NatPanel.this.bCancel.setEnabled(false);
            }
        });
    }

    public boolean isNextEnabled() {
        return true;
    }

    public IWizardPanel getNextPanel() {
        return new FilePanel((ConfigureWizard)this.wizard, (IWizardPanel)this);
    }

    public class Checker
    extends AEThread {
        private int TCPListenPort;
        private boolean bContinue;

        public Checker(int tcp_listen_port) {
            super("NAT Checker");
            this.TCPListenPort = tcp_listen_port;
            this.bContinue = true;
        }

        public void runSupport() {
            NatPanel.this.printMessage(MessageText.getString("configureWizard.nat.testing") + " " + this.TCPListenPort + " ... ");
            int portResult = NatChecker.test(NatPanel.this.wizard.getAzureusCore(), this.TCPListenPort);
            switch (portResult) {
                case 1: {
                    NatPanel.this.printMessage(MessageText.getString("configureWizard.nat.ok") + "\n");
                    break;
                }
                case 2: {
                    NatPanel.this.printMessage(MessageText.getString("configureWizard.nat.ko") + "\n");
                    this.bContinue = false;
                    break;
                }
                default: {
                    NatPanel.this.printMessage(MessageText.getString("configureWizard.nat.unable") + "\n");
                }
            }
            NatPanel.this.enableNext();
        }

        public void stopIt() {
            this.bContinue = false;
        }
    }
}

