/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.config.Parameter;

public class IntListParameter
extends Parameter {
    Combo list;

    public IntListParameter(Composite composite, String name, String[] labels, int[] values) {
        this(composite, name, COConfigurationManager.getIntParameter(name), labels, values);
    }

    public IntListParameter(Composite composite, final String name, int defaultValue, String[] labels, final int[] values) {
        if (labels.length != values.length) {
            return;
        }
        int value = COConfigurationManager.getIntParameter(name, defaultValue);
        int index = this.findIndex(value, values);
        this.list = new Combo(composite, 12);
        for (int i = 0; i < labels.length; ++i) {
            this.list.add(labels[i]);
        }
        this.list.select(index);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                COConfigurationManager.setParameter(name, values[IntListParameter.this.list.getSelectionIndex()]);
            }
        });
    }

    private int findIndex(int value, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != value) continue;
            return i;
        }
        return 0;
    }

    public void setLayoutData(Object layoutData) {
        this.list.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.list;
    }
}

