/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentEncodingException;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.torrent.TorrentManagerEvent;
import org.gudy.azureus2.plugins.torrent.TorrentManagerListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeCategoryImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeNetworksImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributePeerSourcesImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeTrackerClientExtImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentDownloaderImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class TorrentManagerImpl
implements TorrentManager,
TOTorrentProgressListener {
    private static TorrentManagerImpl singleton;
    private static AEMonitor class_mon;
    private static TorrentAttribute category_attribute;
    private static TorrentAttribute networks_attribute;
    private static TorrentAttribute peer_sources_attribute;
    private static TorrentAttribute tr_ext_attribute;
    private static Map attribute_map;
    protected static List listeners;
    protected PluginInterface plugin_interface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TorrentManagerImpl getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TorrentManagerImpl(null);
            }
            TorrentManagerImpl torrentManagerImpl = singleton;
            return torrentManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TorrentManagerImpl(PluginInterface _pi) {
        this.plugin_interface = _pi;
    }

    public TorrentManager specialise(PluginInterface _pi) {
        return new TorrentManagerImpl(_pi);
    }

    public TorrentDownloader getURLDownloader(URL url) throws TorrentException {
        return new TorrentDownloaderImpl(this, url);
    }

    public TorrentDownloader getURLDownloader(URL url, String user_name, String password) throws TorrentException {
        return new TorrentDownloaderImpl(this, url, user_name, password);
    }

    public Torrent createFromBEncodedFile(File file) throws TorrentException {
        try {
            return new TorrentImpl(this.plugin_interface, TorrentUtils.readFromFile(file, false));
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", e);
        }
    }

    public Torrent createFromBEncodedInputStream(InputStream data) throws TorrentException {
        try {
            return new TorrentImpl(this.plugin_interface, TOTorrentFactory.deserialiseFromBEncodedInputStream(data));
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", e);
        }
    }

    public Torrent createFromBEncodedData(byte[] data) throws TorrentException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(data);
            TorrentImpl torrentImpl = new TorrentImpl(this.plugin_interface, TOTorrentFactory.deserialiseFromBEncodedInputStream(is));
            return torrentImpl;
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedData Fails", e);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public Torrent createFromDataFile(File data, URL announce_url) throws TorrentException {
        return this.createFromDataFile(data, announce_url, false);
    }

    public Torrent createFromDataFile(File data, URL announce_url, boolean include_other_hashes) throws TorrentException {
        try {
            TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(data, announce_url, include_other_hashes);
            c.addListener(this);
            return new TorrentImpl(this.plugin_interface, c.create());
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromDataFile Fails", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentAttribute[] getDefinedAttributes() {
        try {
            class_mon.enter();
            Collection entries = attribute_map.values();
            TorrentAttribute[] res = new TorrentAttribute[entries.size()];
            entries.toArray(res);
            TorrentAttribute[] torrentAttributeArray = res;
            return torrentAttributeArray;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentAttribute getAttribute(String name) {
        try {
            class_mon.enter();
            TorrentAttribute res = (TorrentAttribute)attribute_map.get(name);
            if (res == null && name.startsWith("Plugin.")) {
                res = new TorrentAttributePluginImpl(name);
                attribute_map.put(name, res);
            }
            TorrentAttribute torrentAttribute = res;
            return torrentAttribute;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentAttribute getPluginAttribute(String name) {
        name = "Plugin." + this.plugin_interface.getPluginID() + "." + name;
        try {
            class_mon.enter();
            TorrentAttribute res = (TorrentAttribute)attribute_map.get(name);
            if (res != null) {
                TorrentAttribute torrentAttribute = res;
                return torrentAttribute;
            }
            res = new TorrentAttributePluginImpl(name);
            attribute_map.put(name, res);
            TorrentAttribute torrentAttribute = res;
            return torrentAttribute;
        }
        finally {
            class_mon.exit();
        }
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(final String task_description) {
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ((TorrentManagerListener)it.next()).event(new TorrentManagerEvent(){

                public Object getData() {
                    return task_description;
                }
            });
        }
    }

    protected void tryToSetTorrentEncoding(TOTorrent torrent, String encoding) throws TorrentEncodingException {
        try {
            LocaleUtil.getSingleton().setTorrentEncoding(torrent, encoding);
        }
        catch (LocaleUtilEncodingException e) {
            String[] charsets = e.getValidCharsets();
            if (charsets == null) {
                throw new TorrentEncodingException("Failed to set requested encoding", e);
            }
            throw new TorrentEncodingException(charsets, e.getValidTorrentNames());
        }
    }

    protected void tryToSetDefaultTorrentEncoding(TOTorrent torrent) throws TorrentException {
        try {
            LocaleUtil.getSingleton().setDefaultTorrentEncoding(torrent);
        }
        catch (LocaleUtilEncodingException e) {
            String[] charsets = e.getValidCharsets();
            if (charsets == null) {
                throw new TorrentEncodingException("Failed to set default encoding", e);
            }
            throw new TorrentEncodingException(charsets, e.getValidTorrentNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TorrentManagerListener l) {
        try {
            class_mon.enter();
            ArrayList<TorrentManagerListener> new_listeners = new ArrayList<TorrentManagerListener>(listeners);
            new_listeners.add(l);
            listeners = new_listeners;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TorrentManagerListener l) {
        try {
            class_mon.enter();
            ArrayList new_listeners = new ArrayList(listeners);
            new_listeners.remove(l);
            listeners = new_listeners;
        }
        finally {
            class_mon.exit();
        }
    }

    static {
        class_mon = new AEMonitor("TorrentManager");
        category_attribute = new TorrentAttributeCategoryImpl();
        networks_attribute = new TorrentAttributeNetworksImpl();
        peer_sources_attribute = new TorrentAttributePeerSourcesImpl();
        tr_ext_attribute = new TorrentAttributeTrackerClientExtImpl();
        attribute_map = new HashMap();
        attribute_map.put("Category", category_attribute);
        attribute_map.put("Networks", networks_attribute);
        attribute_map.put("PeerSources", peer_sources_attribute);
        attribute_map.put("TrackerClientExtensions", tr_ext_attribute);
        listeners = new ArrayList();
    }
}

