/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;

public class DownloadManagerImpl
implements DownloadManager {
    protected static DownloadManagerImpl singleton;
    protected static AEMonitor class_mon;
    private AzureusCore azureus_core;
    private GlobalManager global_manager;
    private DownloadManagerStats stats;
    private List listeners = new ArrayList();
    private AEMonitor listeners_mon = new AEMonitor("DownloadManager:L");
    private List downloads = new ArrayList();
    private Map download_map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadManagerImpl getSingleton(AzureusCore azureus_core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new DownloadManagerImpl(azureus_core);
            }
            DownloadManagerImpl downloadManagerImpl = singleton;
            return downloadManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected DownloadManagerImpl(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        this.global_manager = _azureus_core.getGlobalManager();
        this.stats = new DownloadManagerStatsImpl(this.global_manager);
        this.global_manager.addListener(new GlobalManagerListener(){

            public void downloadManagerAdded(org.gudy.azureus2.core3.download.DownloadManager dm) {
                DownloadManagerImpl.this.addDownloadManager(dm);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadManagerRemoved(org.gudy.azureus2.core3.download.DownloadManager dm) {
                List listeners_ref = null;
                DownloadImpl dl = null;
                try {
                    DownloadManagerImpl.this.listeners_mon.enter();
                    dl = (DownloadImpl)DownloadManagerImpl.this.download_map.get(dm);
                    if (dl == null) {
                        System.out.println("DownloadManager:unknown manager removed");
                    } else {
                        DownloadManagerImpl.this.downloads.remove(dl);
                        DownloadManagerImpl.this.download_map.remove(dm);
                        dl.destroy();
                        listeners_ref = DownloadManagerImpl.this.listeners;
                    }
                }
                finally {
                    DownloadManagerImpl.this.listeners_mon.exit();
                }
                if (dl != null) {
                    for (int i = 0; i < listeners_ref.size(); ++i) {
                        ((DownloadManagerListener)listeners_ref.get(i)).downloadRemoved(dl);
                    }
                }
            }

            public void destroyInitiated() {
            }

            public void destroyed() {
            }

            public void seedingStatusChanged(boolean seeding_only_mode) {
            }
        });
        this.global_manager.addDownloadWillBeRemovedListener(new GlobalManagerDownloadWillBeRemovedListener(){

            public void downloadWillBeRemoved(org.gudy.azureus2.core3.download.DownloadManager dm) throws GlobalManagerDownloadRemovalVetoException {
                DownloadImpl download = (DownloadImpl)DownloadManagerImpl.this.download_map.get(dm);
                if (download != null) {
                    try {
                        download.isRemovable();
                    }
                    catch (DownloadRemovalVetoException e) {
                        throw new GlobalManagerDownloadRemovalVetoException(e.getMessage());
                    }
                }
            }
        });
    }

    public void addDownload(File fileName) {
        UIManagerImpl.fireEvent(2, fileName);
    }

    public void addDownload(URL url) {
        this.addDownload(url, null);
    }

    public void addDownload(URL url, URL referrer) {
        UIManagerImpl.fireEvent(3, new URL[]{url, referrer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloadManager(org.gudy.azureus2.core3.download.DownloadManager dm) {
        List listeners_ref = null;
        DownloadImpl dl = null;
        try {
            this.listeners_mon.enter();
            if (this.download_map.get(dm) == null) {
                dl = new DownloadImpl(dm);
                this.downloads.add(dl);
                this.download_map.put(dm, dl);
                listeners_ref = this.listeners;
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        if (dl != null) {
            for (int i = 0; i < listeners_ref.size(); ++i) {
                try {
                    ((DownloadManagerListener)listeners_ref.get(i)).downloadAdded(dl);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public Download addDownload(Torrent torrent) throws DownloadException {
        return this.addDownload(torrent, null, null);
    }

    public Download addDownload(Torrent torrent, File torrent_file, File data_location) throws DownloadException {
        org.gudy.azureus2.core3.download.DownloadManager dm;
        if (torrent_file == null) {
            String torrent_dir = null;
            if (COConfigurationManager.getBooleanParameter("Save Torrent Files", true)) {
                try {
                    torrent_dir = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                }
                catch (Exception egnore) {
                    // empty catch block
                }
            }
            if (torrent_dir == null || torrent_dir.length() == 0) {
                throw new DownloadException("DownloadManager::addDownload: default torrent save directory must be configured");
            }
            torrent_file = new File(torrent_dir + File.separator + torrent.getName() + ".torrent");
            try {
                torrent.writeToFile(torrent_file);
            }
            catch (TorrentException e) {
                throw new DownloadException("DownloadManager::addDownload: failed to write torrent to '" + torrent_file.toString() + "'", e);
            }
        }
        if (data_location == null) {
            boolean useDefDataDir = COConfigurationManager.getBooleanParameter("Use default data dir");
            String data_dir = null;
            if (useDefDataDir) {
                data_dir = COConfigurationManager.getStringParameter("Default save path");
            }
            if (data_dir == null || data_dir.length() == 0) {
                throw new DownloadException("DownloadManager::addDownload: default data save directory must be configured");
            }
            data_location = new File(data_dir);
            data_location.mkdirs();
        }
        if ((dm = this.global_manager.addDownloadManager(torrent_file.toString(), data_location.toString(), this.getInitialState(), true)) == null) {
            throw new DownloadException("DownloadManager::addDownload - failed");
        }
        this.addDownloadManager(dm);
        return this.getDownload(dm);
    }

    public Download addNonPersistentDownload(Torrent torrent, File torrent_file, File data_location) throws DownloadException {
        org.gudy.azureus2.core3.download.DownloadManager dm = this.global_manager.addDownloadManager(torrent_file.toString(), data_location.toString(), this.getInitialState(), false);
        if (dm == null) {
            throw new DownloadException("DownloadManager::addDownload - failed");
        }
        this.addDownloadManager(dm);
        return this.getDownload(dm);
    }

    protected int getInitialState() {
        boolean default_start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
        return default_start_stopped ? 70 : 0;
    }

    protected Download getDownload(org.gudy.azureus2.core3.download.DownloadManager dm) throws DownloadException {
        Download dl = (Download)this.download_map.get(dm);
        if (dl == null) {
            throw new DownloadException("DownloadManager::getDownload: download not found");
        }
        return dl;
    }

    public static Download getDownloadStatic(org.gudy.azureus2.core3.download.DownloadManager dm) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(dm);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public static Download getDownloadStatic(DiskManager dm) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(dm);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public Download getDownload(DiskManager dm) throws DownloadException {
        List dls = this.global_manager.getDownloadManagers();
        for (int i = 0; i < dls.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager man = (org.gudy.azureus2.core3.download.DownloadManager)dls.get(i);
            if (man.getDiskManager() != dm) continue;
            return this.getDownload(man.getTorrent());
        }
        return null;
    }

    protected Download getDownload(TOTorrent torrent) throws DownloadException {
        for (int i = 0; i < this.downloads.size(); ++i) {
            Download dl = (Download)this.downloads.get(i);
            TorrentImpl t = (TorrentImpl)dl.getTorrent();
            if (t == null || !t.getTorrent().hasSameHashAs(torrent)) continue;
            return dl;
        }
        throw new DownloadException("DownloadManager::getDownload: download not found");
    }

    public static Download getDownloadStatic(TOTorrent torrent) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(torrent);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public Download getDownload(Torrent _torrent) {
        TorrentImpl torrent = (TorrentImpl)_torrent;
        try {
            return this.getDownload(torrent.getTorrent());
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public Download getDownload(byte[] hash) {
        List dls = this.global_manager.getDownloadManagers();
        for (int i = 0; i < dls.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager man = (org.gudy.azureus2.core3.download.DownloadManager)dls.get(i);
            TOTorrent torrent = man.getTorrent();
            if (torrent == null) continue;
            try {
                if (!Arrays.equals(torrent.getHash(), hash)) continue;
                return this.getDownload(torrent);
            }
            catch (DownloadException e) {
                continue;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Download[] getDownloads() {
        ArrayList res_l = new ArrayList();
        List dms = this.global_manager.getDownloadManagers();
        try {
            this.listeners_mon.enter();
            for (int i = 0; i < dms.size(); ++i) {
                Object dl = this.download_map.get(dms.get(i));
                if (dl == null) continue;
                res_l.add(dl);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        Download[] res = new Download[res_l.size()];
        res_l.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Download[] getDownloads(boolean bSorted) {
        if (bSorted) {
            return this.getDownloads();
        }
        try {
            this.listeners_mon.enter();
            Download[] res = new Download[this.downloads.size()];
            this.downloads.toArray(res);
            Download[] downloadArray = res;
            return downloadArray;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void pauseDownloads() {
        this.global_manager.pauseDownloads();
    }

    public void resumeDownloads() {
        this.global_manager.resumeDownloads();
    }

    public void startAllDownloads() {
        this.global_manager.startAllDownloads();
    }

    public void stopAllDownloads() {
        this.global_manager.stopAllDownloads();
    }

    public DownloadManagerStats getStats() {
        return this.stats;
    }

    public boolean isSeedingOnly() {
        return this.global_manager.isSeedingOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadManagerListener l) {
        ArrayList downloads_copy;
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadManagerListener> new_listeners = new ArrayList<DownloadManagerListener>(this.listeners);
            new_listeners.add(l);
            this.listeners = new_listeners;
            downloads_copy = new ArrayList(this.downloads);
        }
        finally {
            this.listeners_mon.exit();
        }
        for (int i = 0; i < downloads_copy.size(); ++i) {
            try {
                l.downloadAdded((Download)downloads_copy.get(i));
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadManagerListener l) {
        try {
            this.listeners_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners);
            new_listeners.remove(l);
            this.listeners = new_listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    static {
        class_mon = new AEMonitor("DownloadManager:class");
    }
}

