/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32.access.impl;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.win32.access.AEWin32Access;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessException;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessListener;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessCallback;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessInterface;

public class AEWin32AccessImpl
implements AEWin32Access,
AEWin32AccessCallback {
    protected static AEWin32AccessImpl singleton;
    protected static AEMonitor class_mon;
    private List listeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AEWin32Access getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new AEWin32AccessImpl();
            }
            AEWin32AccessImpl aEWin32AccessImpl = singleton;
            return aEWin32AccessImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected AEWin32AccessImpl() {
        AEWin32AccessInterface.load(this);
    }

    public long windowsMessage(int msg, int param1, long param2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AEWin32AccessListener)this.listeners.get(i)).eventOccurred(msg);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return -1L;
    }

    public String getVersion() {
        return AEWin32AccessInterface.getVersion();
    }

    public String readStringValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        return AEWin32AccessInterface.readStringValue(type, subkey, value_name);
    }

    public void writeStringValue(int type, String subkey, String value_name, String value_value) throws AEWin32AccessException {
        AEWin32AccessInterface.writeStringValue(type, subkey, value_name, value_value);
    }

    public int readWordValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        return AEWin32AccessInterface.readWordValue(type, subkey, value_name);
    }

    public void writeWordValue(int type, String subkey, String value_name, int value_value) throws AEWin32AccessException {
        AEWin32AccessInterface.writeWordValue(type, subkey, value_name, value_value);
    }

    public void deleteKey(int type, String subkey) throws AEWin32AccessException {
        this.deleteKey(type, subkey, false);
    }

    public void deleteKey(int type, String subkey, boolean recursive) throws AEWin32AccessException {
        AEWin32AccessInterface.deleteKey(type, subkey, recursive);
    }

    public void deleteValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        AEWin32AccessInterface.deleteValue(type, subkey, value_name);
    }

    public String getUserAppData() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "appdata";
        return this.readStringValue(4, app_data_key, app_data_name);
    }

    public String getApplicationInstallDir(String app_name) throws AEWin32AccessException {
        return this.readStringValue(3, "software\\" + app_name, null);
    }

    public void createProcess(String command_line, boolean inherit_handles) throws AEWin32AccessException {
        AEWin32AccessInterface.createProcess(command_line, inherit_handles);
    }

    public void moveToRecycleBin(String file_name) throws AEWin32AccessException {
        AEWin32AccessInterface.moveToRecycleBin(file_name);
    }

    public void addListener(AEWin32AccessListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AEWin32AccessListener listener) {
        this.listeners.remove(listener);
    }

    static {
        class_mon = new AEMonitor("AEWin32Access");
    }
}

