/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;

public class TRBlockingServerProcessor
extends TRTrackerServerProcessorTCP {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    protected Socket socket;
    protected int timeout_ticks = 1;
    protected String current_request;

    protected TRBlockingServerProcessor(TRTrackerServerTCP _server, Socket _socket) {
        super(_server);
        this.socket = _socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void runSupport() {
        try {
            this.setTaskState("entry");
            try {
                this.socket.setSoTimeout(5000);
            }
            catch (SocketException e) {
                // empty catch block
            }
            String header_plus = "";
            this.setTaskState("reading header");
            try {
                File post_file;
                block42: {
                    void var6_14;
                    String lowercase_header;
                    String actual_header;
                    int len;
                    InputStream is = this.socket.getInputStream();
                    byte[] buffer = new byte[1024];
                    while (header_plus.length() < 4096 && (len = is.read(buffer)) != -1 && !(header_plus = header_plus + new String(buffer, 0, len, "ISO-8859-1")).endsWith("\r\n\r\n") && header_plus.indexOf("\r\n\r\n") == -1) {
                    }
                    if (Logger.isEnabled()) {
                        String log_str = header_plus;
                        int pos = log_str.indexOf("\r\n");
                        if (pos != -1) {
                            log_str = log_str.substring(0, pos);
                        }
                        Logger.log(new LogEvent(LOGID, "Tracker Server: received header '" + log_str + "'"));
                    }
                    InputStream post_is = null;
                    post_file = null;
                    boolean head = false;
                    if (header_plus.startsWith("GET ")) {
                        this.timeout_ticks = 1;
                        actual_header = header_plus;
                        lowercase_header = actual_header.toLowerCase();
                    } else if (header_plus.startsWith("HEAD ")) {
                        this.timeout_ticks = 1;
                        actual_header = header_plus;
                        lowercase_header = actual_header.toLowerCase();
                        head = true;
                    } else if (header_plus.startsWith("POST ")) {
                        OutputStream data_os;
                        this.timeout_ticks = TRTrackerServerTCP.PROCESSING_POST_MULTIPLIER;
                        if (this.timeout_ticks == 0) {
                            this.setTimeoutsDisabled(true);
                        }
                        this.setTaskState("reading content");
                        int header_end = header_plus.indexOf("\r\n\r\n");
                        if (header_end == -1) {
                            throw new TRTrackerServerException("header truncated");
                        }
                        actual_header = header_plus.substring(0, header_end + 4);
                        lowercase_header = actual_header.toLowerCase();
                        int cl_start = lowercase_header.indexOf("content-length:");
                        if (cl_start == -1) {
                            throw new TRTrackerServerException("header Content-Length start missing");
                        }
                        int cl_end = actual_header.indexOf("\r\n", cl_start);
                        if (cl_end == -1) {
                            throw new TRTrackerServerException("header Content-Length end missing");
                        }
                        int content_length = Integer.parseInt(actual_header.substring(cl_start + 15, cl_end).trim());
                        ByteArrayOutputStream baos = null;
                        FileOutputStream fos = null;
                        if (content_length <= 262144) {
                            baos = new ByteArrayOutputStream();
                            data_os = baos;
                        } else {
                            post_file = AETemporaryFileHandler.createTempFile("AZU", null);
                            post_file.deleteOnExit();
                            fos = new FileOutputStream(post_file);
                            data_os = fos;
                        }
                        int rem = header_plus.length() - (header_end + 4);
                        if (rem > 0) {
                            content_length -= rem;
                            data_os.write(header_plus.substring(header_plus.length() - rem).getBytes("ISO-8859-1"));
                        }
                        while (content_length > 0) {
                            int len2 = is.read(buffer);
                            if (len2 < 0) {
                                throw new TRTrackerServerException("premature end of input stream");
                            }
                            data_os.write(buffer, 0, len2);
                            content_length -= len2;
                        }
                        if (baos != null) {
                            post_is = new ByteArrayInputStream(baos.toByteArray());
                        } else {
                            fos.close();
                            post_is = new BufferedInputStream(new FileInputStream(post_file), 262144);
                        }
                    } else {
                        throw new TRTrackerServerException("header doesn't start with GET or POST ('" + (header_plus.length() > 256 ? header_plus.substring(0, 256) : header_plus) + "')");
                    }
                    this.setTaskState("processing request");
                    this.current_request = var6_14;
                    try {
                        void var7_15;
                        String url;
                        int pos;
                        if (post_is == null) {
                            post_is = new ByteArrayInputStream(new byte[0]);
                        }
                        if ((pos = (url = var6_14.substring(4).trim()).indexOf(" ")) == -1) {
                            throw new TRTrackerServerException("header doesn't have space in right place");
                        }
                        url = url.substring(0, pos);
                        if (head) {
                            ByteArrayOutputStream head_response = new ByteArrayOutputStream(4096);
                            this.processRequest((String)var6_14, (String)var7_15, url, this.socket.getInetAddress().getHostAddress(), false, post_is, head_response);
                            byte[] head_data = head_response.toByteArray();
                            int header_length = head_data.length;
                            for (int i = 3; i < head_data.length; ++i) {
                                if (head_data[i - 3] != 13 || head_data[i - 2] != 10 || head_data[i - 1] != 13 || head_data[i] != 10) continue;
                                header_length = i + 1;
                                break;
                            }
                            this.setTaskState("writing head response");
                            this.socket.getOutputStream().write(head_data, 0, header_length);
                            this.socket.getOutputStream().flush();
                        } else {
                            this.processRequest((String)var6_14, (String)var7_15, url, this.socket.getInetAddress().getHostAddress(), false, post_is, this.socket.getOutputStream());
                        }
                        Object var19_30 = null;
                        if (post_is == null) break block42;
                    }
                    catch (Throwable throwable) {
                        Object var19_31 = null;
                        if (post_is != null) {
                            ((InputStream)post_is).close();
                        }
                        if (post_file != null) {
                            post_file.delete();
                        }
                        throw throwable;
                    }
                    ((InputStream)post_is).close();
                }
                if (post_file != null) {
                    post_file.delete();
                }
            }
            catch (SocketTimeoutException e) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.setTaskState("final socket close");
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void interruptTask() {
        try {
            if (!this.areTimeoutsDisabled()) {
                --this.timeout_ticks;
                if (this.timeout_ticks <= 0) {
                    System.out.println("Tracker task interrupted in state '" + this.getTaskState() + "' : processing time limit exceeded for " + this.socket.getInetAddress());
                    this.socket.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

