/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentCreatorImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileHasher;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileHasherListener;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TOTorrentCreateImpl
extends TOTorrentImpl
implements TOTorrentFileHasherListener {
    protected File torrent_base;
    protected long piece_length;
    protected TOTorrentFileHasher file_hasher;
    protected long total_file_size = -1L;
    protected long total_file_count = 0L;
    protected long piece_count;
    protected boolean add_other_hashes;
    protected List progress_listeners = new ArrayList();
    protected int reported_progress;
    protected Set ignore_set = new HashSet();
    protected boolean cancelled;

    public static TOTorrentCreator create(File _torrent_base, URL _announce_url, boolean _add_other_hashes, long _piece_length) throws TOTorrentException {
        TOTorrentCreateImpl t = new TOTorrentCreateImpl(_torrent_base, _announce_url, _add_other_hashes, _piece_length);
        return new TOTorrentCreatorImpl(t);
    }

    public static TOTorrentCreator create(File _torrent_base, URL _announce_url, boolean _add_other_hashes, long _piece_min_size, long _piece_max_size, long _piece_num_lower, long _piece_num_upper) throws TOTorrentException {
        TOTorrentCreateImpl t = new TOTorrentCreateImpl(_torrent_base, _announce_url, _add_other_hashes, _piece_min_size, _piece_max_size, _piece_num_lower, _piece_num_upper);
        return new TOTorrentCreatorImpl(t);
    }

    protected TOTorrentCreateImpl(File _torrent_base, URL _announce_url, boolean _add_other_hashes, long _piece_length) throws TOTorrentException {
        super(_torrent_base.getName(), _announce_url, _torrent_base.isFile());
        this.torrent_base = _torrent_base;
        this.piece_length = _piece_length;
        this.add_other_hashes = _add_other_hashes;
    }

    protected TOTorrentCreateImpl(File _torrent_base, URL _announce_url, boolean _add_other_hashes, long _piece_min_size, long _piece_max_size, long _piece_num_lower, long _piece_num_upper) throws TOTorrentException {
        super(_torrent_base.getName(), _announce_url, _torrent_base.isFile());
        this.torrent_base = _torrent_base;
        this.add_other_hashes = _add_other_hashes;
        long total_size = this.calculateTotalFileSize(_torrent_base);
        this.piece_length = TOTorrentCreateImpl.getComputedPieceSize(total_size, _piece_min_size, _piece_max_size, _piece_num_lower, _piece_num_upper);
    }

    protected void create() throws TOTorrentException {
        this.constructFixed(this.torrent_base, this.piece_length);
    }

    protected void constructFixed(File _torrent_base, long _piece_length) throws TOTorrentException {
        this.setIgnoreList();
        this.setCreationDate(SystemTime.getCurrentTime() / 1000L);
        this.setCreatedBy("Azureus/2.3.0.7_B51");
        this.setPieceLength(_piece_length);
        this.report("Torrent.create.progress.piecelength", _piece_length);
        this.piece_count = this.calculateNumberOfPieces(_torrent_base, _piece_length);
        if (this.piece_count == 0L) {
            throw new TOTorrentException("TOTorrentCreate: specified files have zero total length", 2);
        }
        this.report("Torrent.create.progress.hashing");
        for (int i = 0; i < this.progress_listeners.size(); ++i) {
            ((TOTorrentProgressListener)this.progress_listeners.get(i)).reportProgress(0);
        }
        boolean add_other_per_file_hashes = this.add_other_hashes && !this.getSimpleTorrent();
        this.file_hasher = new TOTorrentFileHasher(this.add_other_hashes, add_other_per_file_hashes, (int)_piece_length, this.progress_listeners.size() == 0 ? null : this);
        if (this.cancelled) {
            throw new TOTorrentException("TOTorrentCreate: operation cancelled", 9);
        }
        if (this.getSimpleTorrent()) {
            long length = this.file_hasher.add(_torrent_base);
            this.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)this, length, new byte[][]{this.getName()})});
            this.setPieces(this.file_hasher.getPieces());
        } else {
            Vector encoded = new Vector();
            this.processDir(this.file_hasher, _torrent_base, encoded, "");
            Object[] files = new TOTorrentFileImpl[encoded.size()];
            encoded.copyInto(files);
            this.setFiles((TOTorrentFileImpl[])files);
        }
        this.setPieces(this.file_hasher.getPieces());
        if (this.add_other_hashes) {
            byte[] sha1_digest = this.file_hasher.getSHA1Digest();
            byte[] ed2k_digest = this.file_hasher.getED2KDigest();
            this.addAdditionalInfoProperty("sha1", sha1_digest);
            this.addAdditionalInfoProperty("ed2k", ed2k_digest);
        }
    }

    protected void processDir(TOTorrentFileHasher hasher, File dir, Vector encoded, String root) throws TOTorrentException {
        File[] dir_file_list = dir.listFiles();
        if (dir_file_list == null) {
            throw new TOTorrentException("TOTorrentCreate: directory '" + dir.getAbsolutePath() + "' returned error when listing files in it", 1);
        }
        ArrayList<File> file_list = new ArrayList<File>(Arrays.asList(dir_file_list));
        Collections.sort(file_list);
        for (int i = 0; i < file_list.size(); ++i) {
            File file = (File)file_list.get(i);
            String file_name = file.getName();
            if (file_name.equals(".") || file_name.equals("..")) continue;
            if (file.isDirectory()) {
                if (root.length() > 0) {
                    file_name = root + File.separator + file_name;
                }
                this.processDir(hasher, file, encoded, file_name);
                continue;
            }
            if (this.ignoreFile(file_name)) continue;
            if (root.length() > 0) {
                file_name = root + File.separator + file_name;
            }
            long length = hasher.add(file);
            TOTorrentFileImpl tf = new TOTorrentFileImpl((TOTorrent)this, length, file_name);
            if (this.add_other_hashes) {
                byte[] ed2k_digest = hasher.getPerFileED2KDigest();
                byte[] sha1_digest = hasher.getPerFileSHA1Digest();
                tf.setAdditionalProperty("sha1", sha1_digest);
                tf.setAdditionalProperty("ed2k", ed2k_digest);
            }
            encoded.addElement(tf);
        }
    }

    public void pieceHashed(int piece_number) {
        for (int i = 0; i < this.progress_listeners.size(); ++i) {
            int this_progress = (int)((long)(piece_number * 100) / this.piece_count);
            if (this_progress == this.reported_progress) continue;
            this.reported_progress = this_progress;
            ((TOTorrentProgressListener)this.progress_listeners.get(i)).reportProgress(this.reported_progress);
        }
    }

    protected long calculateNumberOfPieces(File _file, long _piece_length) throws TOTorrentException {
        long res = TOTorrentCreateImpl.getPieceCount(this.calculateTotalFileSize(_file), _piece_length);
        this.report("Torrent.create.progress.piececount", "" + res);
        return res;
    }

    protected long calculateTotalFileSize(File file) throws TOTorrentException {
        if (this.total_file_size == -1L) {
            this.total_file_size = this.getTotalFileSize(file);
        }
        return this.total_file_size;
    }

    protected long getTotalFileSize(File file) throws TOTorrentException {
        this.report("Torrent.create.progress.parsingfiles");
        long res = this.getTotalFileSizeSupport(file);
        this.report("Torrent.create.progress.totalfilesize", res);
        this.report("Torrent.create.progress.totalfilecount", "" + this.total_file_count);
        return res;
    }

    protected long getTotalFileSizeSupport(File file) throws TOTorrentException {
        String name = file.getName();
        if (name.equals(".") || name.equals("..")) {
            return 0L;
        }
        if (!file.exists()) {
            throw new TOTorrentException("TOTorrentCreate: file '" + file.getName() + "' doesn't exist", 1);
        }
        if (file.isFile()) {
            if (!this.ignoreFile(name)) {
                ++this.total_file_count;
                return file.length();
            }
            return 0L;
        }
        File[] dir_files = file.listFiles();
        if (dir_files == null) {
            throw new TOTorrentException("TOTorrentCreate: directory '" + file.getAbsolutePath() + "' returned error when listing files in it", 1);
        }
        long length = 0L;
        for (int i = 0; i < dir_files.length; ++i) {
            length += this.getTotalFileSizeSupport(dir_files[i]);
        }
        return length;
    }

    protected void report(String resource_key) {
        this.report(resource_key, null);
    }

    protected void report(String resource_key, long bytes) {
        if (this.progress_listeners.size() > 0) {
            this.report(resource_key, DisplayFormatters.formatByteCountToKiBEtc(bytes));
        }
    }

    protected void report(String resource_key, String additional_text) {
        if (this.progress_listeners.size() > 0) {
            String prefix = MessageText.getString(resource_key);
            for (int i = 0; i < this.progress_listeners.size(); ++i) {
                ((TOTorrentProgressListener)this.progress_listeners.get(i)).reportCurrentTask(prefix + (additional_text == null ? "" : additional_text));
            }
        }
    }

    protected static long getTorrentDataSizeFromFileOrDirSupport(File file) {
        String name = file.getName();
        if (name.equals(".") || name.equals("..")) {
            return 0L;
        }
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        File[] dir_files = file.listFiles();
        long length = 0L;
        for (int i = 0; i < dir_files.length; ++i) {
            length += TOTorrentCreateImpl.getTorrentDataSizeFromFileOrDirSupport(dir_files[i]);
        }
        return length;
    }

    public static long getTorrentDataSizeFromFileOrDir(File file_or_dir) {
        return TOTorrentCreateImpl.getTorrentDataSizeFromFileOrDirSupport(file_or_dir);
    }

    public static long getComputedPieceSize(long total_size, long _piece_min_size, long _piece_max_size, long _piece_num_lower, long _piece_num_upper) {
        long piece_length = -1L;
        for (long current_piece_size = _piece_min_size; current_piece_size <= _piece_max_size; current_piece_size <<= 1) {
            long pieces = total_size / current_piece_size;
            if (pieces > _piece_num_upper) continue;
            piece_length = current_piece_size;
            break;
        }
        if (piece_length == -1L) {
            piece_length = _piece_max_size;
        }
        return piece_length;
    }

    public static long getPieceCount(long total_size, long piece_size) {
        return (total_size + (piece_size - 1L)) / piece_size;
    }

    protected void setIgnoreList() {
        try {
            this.ignore_set = TorrentUtils.getIgnoreSet();
        }
        catch (NoClassDefFoundError e) {
            return;
        }
    }

    protected boolean ignoreFile(String file) {
        if (this.ignore_set.contains(file.toLowerCase())) {
            this.report("Torrent.create.progress.ignoringfile", " '" + file + "'");
            return true;
        }
        return false;
    }

    protected void cancel() {
        if (!this.cancelled) {
            this.report("Torrent.create.progress.cancelled");
            this.cancelled = true;
            if (this.file_hasher != null) {
                this.file_hasher.cancel();
            }
        }
    }

    protected void addListener(TOTorrentProgressListener listener) {
        this.progress_listeners.add(listener);
    }

    protected void removeListener(TOTorrentProgressListener listener) {
        this.progress_listeners.remove(listener);
    }
}

