/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerWriteRequestImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class DMWriterImpl
implements DMWriter {
    private static final LogIDs LOGID = LogIDs.DISK;
    private DiskManagerHelper disk_manager;
    private DiskAccessController disk_access;
    private int async_writes;
    private AESemaphore async_write_sem = new AESemaphore("DMWriter::asyncWrite");
    private boolean started;
    private volatile boolean stopped;
    private int pieceLength;
    private long totalLength;
    private boolean complete_recheck_in_progress;
    private AEMonitor this_mon = new AEMonitor("DMWriter");

    public DMWriterImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
        this.disk_access = this.disk_manager.getDiskAccessController();
        this.pieceLength = this.disk_manager.getPieceLength();
        this.totalLength = this.disk_manager.getTotalLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMWWriter: start while started");
            }
            if (this.stopped) {
                throw new RuntimeException("DMWWriter: start after stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int write_wait;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            write_wait = this.async_writes;
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < write_wait; ++i) {
            this.async_write_sem.reserve();
        }
    }

    public boolean isChecking() {
        return this.complete_recheck_in_progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zeroFile(DiskManagerFileInfoImpl file, long length) {
        CacheFile cache_file = file.getCacheFile();
        long written = 0L;
        try {
            if (length == 0L) {
                cache_file.setLength(0L);
            } else {
                DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)7, this.pieceLength);
                try {
                    buffer.limit((byte)8, this.pieceLength);
                    for (int i = 0; i < buffer.limit((byte)8); ++i) {
                        buffer.put((byte)8, (byte)0);
                    }
                    buffer.position((byte)8, 0);
                    while (written < length && !this.stopped) {
                        int write_size = buffer.capacity((byte)8);
                        if (length - written < (long)write_size) {
                            write_size = (int)(length - written);
                        }
                        buffer.limit((byte)8, write_size);
                        final AESemaphore sem = new AESemaphore("DMW&C:zeroFile");
                        final Throwable[] op_failed = new Throwable[]{null};
                        this.disk_access.queueWriteRequest(cache_file, written, buffer, false, new DiskAccessRequestListener(){

                            public void requestComplete(DiskAccessRequest request2) {
                                sem.release();
                            }

                            public void requestCancelled(DiskAccessRequest request2) {
                                op_failed[0] = new Throwable("Request cancelled");
                                sem.release();
                            }

                            public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                                op_failed[0] = cause;
                                sem.release();
                            }
                        });
                        sem.reserve();
                        if (op_failed[0] != null) {
                            throw op_failed[0];
                        }
                        buffer.position((byte)8, 0);
                        written += (long)write_size;
                        this.disk_manager.setAllocated(this.disk_manager.getAllocated() + (long)write_size);
                        this.disk_manager.setPercentDone((int)(this.disk_manager.getAllocated() * 1000L / this.totalLength));
                    }
                }
                finally {
                    buffer.returnToPool();
                }
            }
            if (this.stopped) {
                return false;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer buffer, Object user_data) {
        return new DiskManagerWriteRequestImpl(pieceNumber, offset, buffer, user_data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(DiskManagerWriteRequest request2, final DiskManagerWriteRequestListener listener) {
        block12: {
            try {
                int pieceNumber = request2.getPieceNumber();
                DirectByteBuffer buffer = request2.getBuffer();
                int offset = request2.getOffset();
                final DiskManagerPiece dmPiece = this.disk_manager.getPieces()[pieceNumber];
                if (dmPiece.isDone()) {
                    buffer.returnToPool();
                    listener.writeCompleted(request2);
                    break block12;
                }
                int buffer_position = buffer.position((byte)8);
                int buffer_limit = buffer.limit((byte)8);
                int previousFilesLength = 0;
                int currentFile = 0;
                DMPieceList pieceList = this.disk_manager.getPieceList(pieceNumber);
                DMPieceMapEntry current_piece = pieceList.get(currentFile);
                long fileOffset = current_piece.getOffset();
                while (previousFilesLength + current_piece.getLength() < offset) {
                    previousFilesLength += current_piece.getLength();
                    fileOffset = 0L;
                    current_piece = pieceList.get(++currentFile);
                }
                ArrayList<Object[]> chunks = new ArrayList<Object[]>();
                while (buffer_position < buffer_limit) {
                    current_piece = pieceList.get(currentFile);
                    long file_limit = (long)buffer_position + (current_piece.getFile().getLength() - current_piece.getOffset() - (long)(offset - previousFilesLength));
                    if (file_limit > (long)buffer_limit) {
                        file_limit = buffer_limit;
                    }
                    if (file_limit > (long)buffer_position) {
                        long file_pos = fileOffset + (long)(offset - previousFilesLength);
                        chunks.add(new Object[]{current_piece.getFile(), new Long(file_pos), new Integer((int)file_limit)});
                        buffer_position = (int)file_limit;
                    }
                    ++currentFile;
                    fileOffset = 0L;
                    previousFilesLength = offset;
                }
                DiskManagerWriteRequestListener l = new DiskManagerWriteRequestListener(){

                    public void writeCompleted(DiskManagerWriteRequest request2) {
                        this.complete();
                        listener.writeCompleted(request2);
                    }

                    public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
                        this.complete();
                        if (dmPiece.isDone()) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(DMWriterImpl.this.disk_manager, LOGID, "Piece " + dmPiece.getPieceNumber() + " write failed but already marked as done"));
                            }
                            listener.writeCompleted(request2);
                        } else {
                            DMWriterImpl.this.disk_manager.setFailed("Disk write error - " + Debug.getNestedExceptionMessage(cause));
                            Debug.printStackTrace(cause);
                            listener.writeFailed(request2, cause);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void complete() {
                        try {
                            DMWriterImpl.this.this_mon.enter();
                            DMWriterImpl.this.async_writes--;
                            if (DMWriterImpl.this.stopped) {
                                DMWriterImpl.this.async_write_sem.release();
                            }
                        }
                        finally {
                            DMWriterImpl.this.this_mon.exit();
                        }
                    }
                };
                try {
                    this.this_mon.enter();
                    if (this.stopped) {
                        buffer.returnToPool();
                        listener.writeFailed(request2, new Exception("Disk writer has been stopped"));
                        return;
                    }
                    ++this.async_writes;
                }
                finally {
                    this.this_mon.exit();
                }
                new requestDispatcher(request2, l, buffer, chunks);
            }
            catch (Throwable e) {
                request2.getBuffer().returnToPool();
                this.disk_manager.setFailed("Disk write error - " + Debug.getNestedExceptionMessage(e));
                Debug.printStackTrace(e);
                listener.writeFailed(request2, e);
            }
        }
    }

    protected class requestDispatcher
    implements DiskAccessRequestListener {
        private DiskManagerWriteRequest request;
        private DiskManagerWriteRequestListener listener;
        private DirectByteBuffer buffer;
        private List chunks;
        private int chunk_index;

        protected requestDispatcher(DiskManagerWriteRequest _request, DiskManagerWriteRequestListener _listener, DirectByteBuffer _buffer, List _chunks) {
            this.request = _request;
            this.listener = _listener;
            this.buffer = _buffer;
            this.chunks = _chunks;
            this.dispatch();
        }

        protected void dispatch() {
            try {
                if (this.chunk_index == this.chunks.size()) {
                    this.listener.writeCompleted(this.request);
                } else if (this.chunk_index == 1 && this.chunks.size() > 32) {
                    for (int i = 1; i < this.chunks.size(); ++i) {
                        AESemaphore sem = new AESemaphore("DMW&C:dispatch:asyncReq");
                        Throwable[] error = new Throwable[]{null};
                        this.doRequest(new DiskAccessRequestListener(this, sem, error){
                            private final /* synthetic */ AESemaphore val$sem;
                            private final /* synthetic */ Throwable[] val$error;
                            private final /* synthetic */ requestDispatcher this$1;
                            {
                                this.this$1 = this$1;
                                this.val$sem = val$sem;
                                this.val$error = val$error;
                            }

                            public void requestComplete(DiskAccessRequest request2) {
                                this.val$sem.release();
                            }

                            public void requestCancelled(DiskAccessRequest request2) {
                                Debug.out("shouldn't get here");
                            }

                            public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                                this.val$error[0] = cause;
                                this.val$sem.release();
                            }
                        });
                        sem.reserve();
                        if (error[0] == null) continue;
                        throw error[0];
                    }
                    this.listener.writeCompleted(this.request);
                } else {
                    this.doRequest(this);
                }
            }
            catch (Throwable e) {
                this.failed(e);
            }
        }

        protected void doRequest(DiskAccessRequestListener l) throws CacheFileManagerException {
            Object[] stuff = (Object[])this.chunks.get(this.chunk_index++);
            DiskManagerFileInfoImpl file = (DiskManagerFileInfoImpl)stuff[0];
            this.buffer.limit((byte)7, (Integer)stuff[2]);
            if (file.getAccessMode() == 1) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(DMWriterImpl.this.disk_manager, LOGID, "Changing " + file.getFile(true).getName() + " to read/write"));
                }
                file.setAccessMode(2);
            }
            boolean handover_buffer = this.chunk_index == this.chunks.size();
            DMWriterImpl.this.disk_access.queueWriteRequest(file.getCacheFile(), (Long)stuff[1], this.buffer, handover_buffer, l);
        }

        public void requestComplete(DiskAccessRequest request2) {
            this.dispatch();
        }

        public void requestCancelled(DiskAccessRequest request2) {
            Debug.out("shouldn't get here");
        }

        public void requestFailed(DiskAccessRequest request2, Throwable cause) {
            this.failed(cause);
        }

        protected void failed(Throwable cause) {
            this.buffer.returnToPool();
            this.listener.writeFailed(this.request, cause);
        }
    }
}

