/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerAllocationScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.DMReaderAdapter;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class DiskManagerImpl
extends LogRelation
implements DiskManagerHelper,
DMReaderAdapter {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static DiskAccessController disk_access_controller;
    private static DiskManagerRecheckScheduler recheck_scheduler;
    private static DiskManagerAllocationScheduler allocation_scheduler;
    private boolean used = false;
    private boolean started = false;
    private AESemaphore started_sem = new AESemaphore("DiskManager::started");
    private boolean starting;
    private boolean stopping;
    private int state_set_via_method;
    protected String errorMessage = "";
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long remaining;
    private TOTorrent torrent;
    private DMReader reader;
    private DMChecker checker;
    private DMWriter writer;
    private RDResumeHandler resume_handler;
    private DMPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private DMPieceList[] pieceMap;
    private DiskManagerFileInfoImpl[] files;
    protected DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private boolean skipped_file_set_changed = true;
    private long skipped_file_set_size;
    private long skipped_but_downloaded;
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_PRIOCHANGED = 2;
    private static final int LDT_PIECE_DONE_CHANGED = 3;
    private static final int LDT_ACCESS_MODE_CHANGED = 4;
    protected static ListenerManager listeners_aggregator;
    private ListenerManager listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor start_stop_mon = new AEMonitor("DiskManager:startStop");
    private AEMonitor file_piece_mon = new AEMonitor("DiskManager:filePiece");
    protected static int max_read_block_size;

    public DiskManagerImpl(TOTorrent _torrent, DownloadManager _dmanager) {
        this.torrent = _torrent;
        this.download_manager = _dmanager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        if (this.torrent == null) {
            this.errorMessage = "Torrent not available";
            this.setState(10);
            return;
        }
        LocaleUtilDecoder locale_decoder = null;
        try {
            locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(this.torrent);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this.errorMessage = TorrentUtils.exceptionToText(e);
            this.setState(10);
            return;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Initialisation failed - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.piece_mapper = DMPieceMapperFactory.create(this.torrent);
        try {
            this.piece_mapper.construct(locale_decoder, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Failed to build piece map - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.remaining = this.totalLength = this.piece_mapper.getTotalLength();
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        for (int i = 0; i < this.nbPieces; ++i) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i);
        }
        this.reader = DMAccessFactory.createReader(this);
        this.checker = DMAccessFactory.createChecker(this);
        this.writer = DMAccessFactory.createWriter(this);
        this.resume_handler = new RDResumeHandler(this, this.checker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.start_stop_mon.enter();
            if (this.used) {
                Debug.out("DiskManager reuse not supported!!!!");
            }
            this.used = true;
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                return;
            }
            this.started = true;
            this.starting = true;
            AEThread init = new AEThread("DiskManager:start"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    boolean stop_required;
                    try {
                        DiskManagerImpl.this.startSupport();
                    }
                    catch (Throwable e) {
                        DiskManagerImpl.this.errorMessage = Debug.getNestedExceptionMessage(e) + " (start)";
                        DiskManagerImpl.this.setState(10);
                    }
                    finally {
                        DiskManagerImpl.this.started_sem.release();
                    }
                    try {
                        DiskManagerImpl.this.start_stop_mon.enter();
                        stop_required = DiskManagerImpl.this.getState() == 10 || DiskManagerImpl.this.stopping;
                        DiskManagerImpl.this.starting = false;
                    }
                    finally {
                        DiskManagerImpl.this.start_stop_mon.exit();
                    }
                    if (stop_required) {
                        DiskManagerImpl.this.stop();
                    }
                }
            };
            init.setPriority(1);
            init.start();
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void startSupport() {
        boolean moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done", false);
        String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        if (moveWhenDone && moveToDir.length() > 0 && this.download_manager.isPersistent() && this.filesExist(moveToDir)) {
            this.alreadyMoved = true;
            this.download_manager.setTorrentSaveDir(moveToDir);
        }
        this.reader.start();
        this.checker.start();
        this.writer.start();
        int newFiles = this.allocateFiles();
        if (this.getState() == 10) {
            return;
        }
        this.pieceMap = this.piece_mapper.getPieceMap();
        this.constructFilesPieces();
        if (this.getState() == 10) {
            return;
        }
        this.resume_handler.start();
        if (newFiles == 0) {
            this.resume_handler.checkAllPieces(false);
        } else if (newFiles != this.files.length) {
            this.resume_handler.checkAllPieces(true);
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.start_stop_mon.enter();
            if (!this.started) {
                return;
            }
            if (this.starting) {
                this.stopping = true;
                this.checker.stop();
                this.writer.stop();
                this.reader.stop();
                this.resume_handler.stop();
                return;
            }
            this.started = false;
            this.stopping = false;
        }
        finally {
            this.start_stop_mon.exit();
        }
        this.started_sem.reserve();
        boolean checking = this.checker.getCompleteRecheckStatus() != -1;
        this.checker.stop();
        this.writer.stop();
        this.reader.stop();
        this.resume_handler.stop();
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    if (this.files[i] == null) continue;
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable e) {
                    this.setFailed("File close fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
        if (this.getState() == 4) {
            if (checking) {
                this.resume_handler.clearResumeData();
            } else {
                try {
                    this.dumpResumeDataToDisk(true, false);
                }
                catch (Exception e) {
                    this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
        this.saveState();
        this.listeners.clear();
    }

    public boolean filesExist() {
        return this.filesExist(this.download_manager.getAbsoluteSaveLocation().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean filesExist(String root_dir) {
        if (!this.torrent.isSimpleTorrent()) {
            root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
        }
        if (!root_dir.endsWith(File.separator)) {
            root_dir = root_dir + File.separator;
        }
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        String[] storage_types = this.getStorageTypes();
        for (int i = 0; i < pm_files.length; ++i) {
            DMPieceMapperFile pm_info = pm_files[i];
            File relative_file = pm_info.getDataFile();
            long target_length = pm_info.getLength();
            DiskManagerFileInfoImpl file_info = pm_info.getFileInfo();
            boolean close_it = false;
            try {
                if (file_info == null) {
                    boolean linear = storage_types[i].equals("L");
                    file_info = new DiskManagerFileInfoImpl(this, new File(root_dir + relative_file.toString()), i, pm_info.getTorrentFile(), linear);
                    close_it = true;
                }
                try {
                    CacheFile cache_file = file_info.getCacheFile();
                    File data_file = file_info.getFile(true);
                    if (!cache_file.exists()) {
                        File parent;
                        File current = data_file;
                        while (!current.exists() && (parent = current.getParentFile()) != null) {
                            if (parent.exists()) {
                                this.errorMessage = parent.isDirectory() ? current.toString() + " not found." : parent.toString() + " is not a directory.";
                                boolean bl = false;
                                return bl;
                            }
                            current = parent;
                        }
                        this.errorMessage = data_file.toString() + " not found.";
                        boolean bl = false;
                        return bl;
                    }
                    long existing_length = file_info.getCacheFile().getLength();
                    if (existing_length <= target_length) continue;
                    if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                        file_info.setAccessMode(2);
                        file_info.getCacheFile().setLength(target_length);
                        Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                        continue;
                    }
                    this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (close_it) {
                        file_info.getCacheFile().close();
                    }
                }
            }
            catch (Throwable e) {
                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (filesExist:" + relative_file.toString() + ")";
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int allocateFiles() {
        block57: {
            block56: {
                block54: {
                    block53: {
                        block58: {
                            block52: {
                                pm_files = this.piece_mapper.getFiles();
                                allocated_files = new DiskManagerFileInfoImpl[pm_files.length];
                                try {
                                    DiskManagerImpl.allocation_scheduler.register(this);
                                    this.setState(2);
                                    this.allocated = 0L;
                                    numNewFiles = 0;
                                    root_dir = this.download_manager.getAbsoluteSaveLocation().getParent();
                                    if (!this.torrent.isSimpleTorrent()) {
                                        root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
                                    }
                                    root_dir = root_dir + File.separator;
                                    storage_types = this.getStorageTypes();
                                    for (i = 0; i < pm_files.length; ++i) {
                                        block55: {
                                            block59: {
                                                pm_info = pm_files[i];
                                                target_length = pm_info.getLength();
                                                relative_data_file = pm_info.getDataFile();
                                                try {
                                                    linear = storage_types[i].equals("L");
                                                    allocated_files[i] = fileInfo = new DiskManagerFileInfoImpl(this, new File(root_dir + relative_data_file.toString()), i, pm_info.getTorrentFile(), linear);
                                                    pm_info.setFileInfo(fileInfo);
                                                }
                                                catch (CacheFileManagerException e) {
                                                    this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles:" + relative_data_file.toString() + ")";
                                                    this.setState(10);
                                                    var13_15 = -1;
                                                    var22_31 = null;
                                                    DiskManagerImpl.allocation_scheduler.unregister(this);
                                                    if (this.files == null) {
                                                        for (i = 0; i < allocated_files.length; ++i) {
                                                            if (allocated_files[i] == null) continue;
                                                            try {
                                                                allocated_files[i].getCacheFile().close();
                                                                continue;
                                                            }
                                                            catch (Throwable e) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    return var13_15;
                                                }
                                                cache_file = fileInfo.getCacheFile();
                                                data_file = fileInfo.getFile(true);
                                                data_file_name = data_file.getName();
                                                separator = data_file_name.lastIndexOf(".");
                                                if (separator == -1) {
                                                    separator = 0;
                                                }
                                                fileInfo.setExtension(data_file_name.substring(separator));
                                                extensions = COConfigurationManager.getStringParameter("priorityExtensions", "");
                                                if (!extensions.equals("")) {
                                                    bIgnoreCase = COConfigurationManager.getBooleanParameter("priorityExtensionsIgnoreCase");
                                                    st = new StringTokenizer(extensions, ";");
                                                    while (st.hasMoreTokens()) {
                                                        extension = st.nextToken();
                                                        if (!(extension = extension.trim()).startsWith(".")) {
                                                            extension = "." + extension;
                                                        }
                                                        if (!(bHighPriority = bIgnoreCase != false ? fileInfo.getExtension().equalsIgnoreCase(extension) : fileInfo.getExtension().equals(extension))) continue;
                                                        fileInfo.setPriority(true);
                                                    }
                                                }
                                                fileInfo.setLength(target_length);
                                                fileInfo.setDownloaded(0L);
                                                if (!cache_file.exists()) break block59;
                                                try {
                                                    block60: {
                                                        existing_length = fileInfo.getCacheFile().getLength();
                                                        if (existing_length <= target_length) ** GOTO lbl-1000
                                                        if (!COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) break block60;
                                                        fileInfo.setAccessMode(2);
                                                        cache_file.setLength(target_length);
                                                        Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                                                        ** GOTO lbl-1000
                                                    }
                                                    this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                                                    this.setState(10);
                                                    var19_29 = -1;
                                                }
                                                catch (CacheFileManagerException e) {
                                                    this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles existing:" + data_file.getAbsolutePath() + ")";
                                                    this.setState(10);
                                                    var18_26 = -1;
                                                    var22_33 = null;
                                                    DiskManagerImpl.allocation_scheduler.unregister(this);
                                                    if (this.files == null) {
                                                        for (i = 0; i < allocated_files.length; ++i) {
                                                            if (allocated_files[i] == null) continue;
                                                            ** try [egrp 7[TRYBLOCK] [15 : 1094->1109)] { 
lbl84:
                                                            // 1 sources

                                                            allocated_files[i].getCacheFile().close();
                                                            continue;
lbl86:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    return var18_26;
                                                }
                                                var22_32 = null;
                                                DiskManagerImpl.allocation_scheduler.unregister(this);
                                                if (this.files != null) ** GOTO lbl96
                                                i = 0;
lbl94:
                                                // 2 sources

                                                while (true) {
                                                    if (i < allocated_files.length) break block52;
lbl96:
                                                    // 2 sources

                                                    return var19_29;
                                                }
lbl-1000:
                                                // 2 sources

                                                {
                                                    fileInfo.setAccessMode(1);
                                                }
                                                this.allocated += target_length;
                                                continue;
                                            }
                                            if (this.download_manager.isDataAlreadyAllocated()) {
                                                this.errorMessage = "Data file missing: " + data_file.getAbsolutePath();
                                                this.setState(10);
                                                e = -1;
                                                break block53;
                                            }
                                            while (this.started && !DiskManagerImpl.allocation_scheduler.getPermission(this)) {
                                            }
                                            if (!this.started) {
                                                e = -1;
                                                break block54;
                                            }
                                            try {
                                                fileInfo.setAccessMode(2);
                                                if (COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
                                                    fileInfo.getCacheFile().setLength(0L);
                                                    break block55;
                                                }
                                                if (COConfigurationManager.getBooleanParameter("Zero New")) {
                                                    if (this.writer.zeroFile(fileInfo, target_length)) break block55;
                                                    try {
                                                        fileInfo.getCacheFile().close();
                                                        fileInfo.getCacheFile().delete();
                                                    }
                                                    catch (Throwable e) {
                                                        // empty catch block
                                                    }
                                                    this.setState(10);
                                                    e = -1;
                                                    break block56;
                                                }
                                            }
                                            catch (Exception e) {
                                                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles new:" + data_file.toString() + ")";
                                                this.setState(10);
                                                var18_27 = -1;
                                                var22_37 = null;
                                                DiskManagerImpl.allocation_scheduler.unregister(this);
                                                if (this.files == null) {
                                                    for (i = 0; i < allocated_files.length; ++i) {
                                                        if (allocated_files[i] == null) continue;
                                                        ** try [egrp 7[TRYBLOCK] [15 : 1094->1109)] { 
lbl141:
                                                        // 1 sources

                                                        allocated_files[i].getCacheFile().close();
                                                        continue;
lbl143:
                                                        // 1 sources

                                                        catch (Throwable e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                return var18_27;
                                            }
                                            {
                                                fileInfo.getCacheFile().setLength(target_length);
                                                this.allocated += target_length;
                                            }
                                        }
                                        ++numNewFiles;
                                    }
                                    this.files = allocated_files;
                                    this.loadFilePriorities();
                                    this.download_manager.setDataAlreadyAllocated(true);
                                    var6_6 = numNewFiles;
                                    break block57;
                                }
                                catch (Throwable var21_58) {
                                    var22_39 = null;
                                    DiskManagerImpl.allocation_scheduler.unregister(this);
                                    if (this.files == null) {
                                        for (i = 0; i < allocated_files.length; ++i) {
                                            if (allocated_files[i] == null) continue;
                                            ** try [egrp 7[TRYBLOCK] [15 : 1094->1109)] { 
lbl166:
                                            // 1 sources

                                            allocated_files[i].getCacheFile().close();
                                            continue;
lbl168:
                                            // 1 sources

                                            catch (Throwable e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    throw var21_58;
                                }
                            }
                            if (allocated_files[i] != null) {
                                ** try [egrp 7[TRYBLOCK] [15 : 1094->1109)] { 
lbl175:
                                // 1 sources

                                allocated_files[i].getCacheFile().close();
                                break block58;
lbl177:
                                // 1 sources

                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                        }
                        ++i;
                        ** while (true)
                    }
                    var22_34 = null;
                    DiskManagerImpl.allocation_scheduler.unregister(this);
                    if (this.files == null) {
                        for (i = 0; i < allocated_files.length; ++i) {
                            if (allocated_files[i] == null) continue;
                            ** try [egrp 7[TRYBLOCK] [15 : 1094->1109)] { 
lbl189:
                            // 1 sources

                            allocated_files[i].getCacheFile().close();
                            continue;
lbl191:
                            // 1 sources

                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                    return e;
                }
                var22_35 = null;
                DiskManagerImpl.allocation_scheduler.unregister(this);
                if (this.files == null) {
                    for (i = 0; i < allocated_files.length; ++i) {
                        if (allocated_files[i] == null) continue;
                        ** try [egrp 7[TRYBLOCK] [15 : 1094->1109)] { 
lbl202:
                        // 1 sources

                        allocated_files[i].getCacheFile().close();
                        continue;
lbl204:
                        // 1 sources

                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                }
                return e;
            }
            var22_36 = null;
            DiskManagerImpl.allocation_scheduler.unregister(this);
            if (this.files == null) {
                for (i = 0; i < allocated_files.length; ++i) {
                    if (allocated_files[i] == null) continue;
                    ** try [egrp 7[TRYBLOCK] [15 : 1094->1109)] { 
lbl215:
                    // 1 sources

                    allocated_files[i].getCacheFile().close();
                    continue;
lbl217:
                    // 1 sources

                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            return e;
        }
        var22_38 = null;
        DiskManagerImpl.allocation_scheduler.unregister(this);
        if (this.files == null) {
            for (i = 0; i < allocated_files.length; ++i) {
                if (allocated_files[i] == null) continue;
                ** try [egrp 7[TRYBLOCK] [15 : 1094->1109)] { 
lbl228:
                // 1 sources

                allocated_files[i].getCacheFile().close();
                continue;
lbl230:
                // 1 sources

                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return var6_6;
    }

    public DiskAccessController getDiskAccessController() {
        return disk_access_controller;
    }

    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.readBlock(request2, listener);
    }

    public int getNbPieces() {
        return this.nbPieces;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public void setPercentDone(int num) {
        this.percentDone = num;
    }

    public long getRemaining() {
        return this.remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemainingExcludingDND() {
        long rem;
        DiskManagerFileInfoImpl[] current_files;
        if (this.skipped_file_set_changed && (current_files = this.files) != null) {
            this.skipped_file_set_changed = false;
            try {
                this.file_piece_mon.enter();
                this.skipped_file_set_size = 0L;
                this.skipped_but_downloaded = 0L;
                for (int i = 0; i < current_files.length; ++i) {
                    DiskManagerFileInfoImpl file = current_files[i];
                    if (!file.isSkipped()) continue;
                    this.skipped_file_set_size += file.getLength();
                    this.skipped_but_downloaded += file.getDownloaded();
                }
            }
            finally {
                this.file_piece_mon.exit();
            }
        }
        if ((rem = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded)) < 0L) {
            rem = 0L;
        }
        return rem;
    }

    public long getAllocated() {
        return this.allocated;
    }

    public void setAllocated(long num) {
        this.allocated = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPieceDone(DiskManagerPieceImpl dmPiece, boolean done) {
        int piece_number = dmPiece.getPieceNumber();
        int piece_length = dmPiece.getLength();
        DMPieceList piece_list = this.pieceMap[piece_number];
        try {
            this.file_piece_mon.enter();
            if (dmPiece.isDone() != done) {
                dmPiece.setDoneSupport(done);
                this.remaining = done ? (this.remaining -= (long)piece_length) : (this.remaining += (long)piece_length);
                for (int i = 0; i < piece_list.size(); ++i) {
                    long file_done;
                    DMPieceMapEntry piece_map_entry = piece_list.get(i);
                    DiskManagerFileInfoImpl this_file = piece_map_entry.getFile();
                    long file_length = this_file.getLength();
                    long file_done_before = file_done = this_file.getDownloaded();
                    file_done = done ? (file_done += (long)piece_map_entry.getLength()) : (file_done -= (long)piece_map_entry.getLength());
                    if (file_done < 0L) {
                        Debug.out("piece map entry length negative");
                        file_done = 0L;
                    } else if (file_done > file_length) {
                        Debug.out("piece map entry length too large");
                        file_done = file_length;
                    }
                    if (this_file.isSkipped()) {
                        this.skipped_but_downloaded += file_done - file_done_before;
                    }
                    this_file.setDownloaded(file_done);
                    if (file_done != file_length || this_file.getAccessMode() != 2) continue;
                    try {
                        this_file.setAccessMode(1);
                        continue;
                    }
                    catch (Exception e) {
                        this.setFailed("Disk access error - " + Debug.getNestedExceptionMessage(e));
                        Debug.printStackTrace(e);
                    }
                }
                this.listeners.dispatch(3, dmPiece);
            }
        }
        finally {
            this.file_piece_mon.exit();
        }
    }

    public void accessModeChanged(DiskManagerFileInfoImpl file, int old_mode, int new_mode) {
        this.listeners.dispatch(4, new Object[]{file, new Integer(old_mode), new Integer(new_mode)});
    }

    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    public DiskManagerPiece getPiece(int PieceNumber) {
        return this.pieces[PieceNumber];
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    public int getState() {
        return this.state_set_via_method;
    }

    public void setState(int _state) {
        if (this.state_set_via_method == 10) {
            if (_state != 10) {
                Debug.out("DiskManager: attempt to move from faulty state to " + _state);
            }
            return;
        }
        if (this.state_set_via_method != _state) {
            int[] params = new int[]{this.state_set_via_method, _state};
            this.state_set_via_method = _state;
            this.listeners.dispatch(1, params);
        }
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    private void constructFilesPieces() {
        for (int i = 0; i < this.pieceMap.length; ++i) {
            DMPieceList pieceList = this.pieceMap[i];
            for (int j = 0; j < pieceList.size(); ++j) {
                DiskManagerFileInfoImpl fileInfo2 = pieceList.get(j).getFile();
                if (fileInfo2.getFirstPieceNumber() == -1) {
                    fileInfo2.setFirstPieceNumber(i);
                }
                fileInfo2.setNbPieces(fileInfo2.getNbPieces() + 1);
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setFailed(final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert(false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop();
            }
        }.start();
    }

    public void setFailed(final DiskManagerFileInfo file, final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert(false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop();
                RDResumeHandler.recheckFile(DiskManagerImpl.this.download_manager, file);
            }
        }.start();
    }

    public DMPieceList getPieceList(int piece_number) {
        return this.pieceMap[piece_number];
    }

    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.torrent.getPieces()[piece_number];
    }

    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createRequest(pieceNumber, offset, length);
    }

    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        return this.checker.createRequest(pieceNumber, user_data);
    }

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCompleteRecheckRequest(request2, listener);
    }

    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCheckRequest(request2, listener);
    }

    public int getCompleteRecheckStatus() {
        return this.checker.getCompleteRecheckStatus();
    }

    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
        return this.writer.createWriteRequest(pieceNumber, offset, data, user_data);
    }

    public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
        this.writer.writeBlock(request2, listener);
    }

    public boolean checkBlockConsistency(int pieceNumber, int offset, DirectByteBuffer data) {
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: pieceNumber=" + pieceNumber + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int length = this.pieceLength;
        if (pieceNumber == this.nbPieces - 1) {
            length = this.lastPieceLength;
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: offset=" + offset + " > length=" + length));
            }
            return false;
        }
        int size = data.remaining((byte)8);
        if (size <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: size=" + size + " <= 0"));
            }
            return false;
        }
        if (offset + size > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: offset=" + offset + " + size=" + size + " > length=" + length));
            }
            return false;
        }
        return true;
    }

    public boolean checkBlockConsistency(int pieceNumber, int offset, int length) {
        if (length > max_read_block_size) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: length=" + length + " > " + max_read_block_size));
            }
            return false;
        }
        if (length <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: length=" + length + " <= 0"));
            }
            return false;
        }
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: pieceNumber=" + pieceNumber + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int pLength = this.pieceLength;
        if (pieceNumber == this.nbPieces - 1) {
            pLength = this.lastPieceLength;
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: offset=" + offset + " > pLength=" + pLength));
            }
            return false;
        }
        if (offset + length > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: offset=" + offset + " + length=" + length + " > pLength=" + pLength));
            }
            return false;
        }
        if (!this.pieces[pieceNumber].isDone()) {
            Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: piece #" + pieceNumber + " not done"));
            return false;
        }
        return true;
    }

    public void dumpResumeDataToDisk(boolean savePartialPieces, boolean force_recheck) throws Exception {
        this.resume_handler.dumpResumeDataToDisk(savePartialPieces, force_recheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadEnded() {
        try {
            this.start_stop_mon.enter();
            String rPath = this.download_manager.getAbsoluteSaveLocation().getParent();
            if (!this.download_manager.isPersistent()) {
                return;
            }
            if (this.alreadyMoved) {
                return;
            }
            this.alreadyMoved = true;
            boolean moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done", false);
            if (!moveWhenDone) {
                return;
            }
            String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
            if (moveToDir.length() == 0) {
                return;
            }
            boolean moveOnlyInDefault = COConfigurationManager.getBooleanParameter("Move Only When In Default Save Dir");
            if (moveOnlyInDefault) {
                String defSaveDir = COConfigurationManager.getStringParameter("Default save path");
                try {
                    defSaveDir = new File(defSaveDir).getCanonicalPath();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                if (!rPath.equals(defSaveDir)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LOGID, 1, "Not moving-on-complete since data is not within default save dir"));
                    }
                    return;
                }
            }
            boolean moveTorrent = COConfigurationManager.getBooleanParameter("Move Torrent When Done", true);
            this.moveFiles(moveToDir, moveTorrent, true);
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    public void moveDataFiles(File new_parent_dir) {
        this.moveFiles(new_parent_dir.toString(), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void moveFiles(String move_to_dir, boolean move_torrent, boolean change_to_read_only) {
        block45: {
            block41: {
                block44: {
                    block39: {
                        save_location = this.download_manager.getAbsoluteSaveLocation();
                        move_from_dir = save_location.getParent();
                        try {
                            try {
                                this.start_stop_mon.enter();
                                new_files = new File[this.files.length];
                                old_files = new File[this.files.length];
                                for (i = 0; i < this.files.length; ++i) {
                                    old_file = this.files[i].getFile(false);
                                    linked_file = FMFileManagerFactory.getSingleton().getFileLink(this.torrent, old_file);
                                    skip = false;
                                    if (linked_file != old_file) {
                                        if (save_location.isDirectory() && !linked_file.getCanonicalPath().startsWith(save_location.getCanonicalPath())) {
                                            skip = true;
                                        }
                                        old_file = linked_file;
                                    }
                                    if (skip) continue;
                                    old_files[i] = old_file;
                                    fullPath = old_file.getParent();
                                    subPath = fullPath.substring(fullPath.indexOf(move_from_dir) + move_from_dir.length());
                                    if (subPath.startsWith(File.separator)) {
                                        subPath = subPath.substring(1);
                                    }
                                    destDir = new File(move_to_dir, subPath);
                                    new_files[i] = newFile = new File(destDir, old_file.getName());
                                    if (newFile.exists()) {
                                        msg = "" + linked_file.getName() + " already exists in MoveTo destination dir";
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent((Object)this, DiskManagerImpl.LOGID, 3, msg));
                                        }
                                        Logger.logTextResource(new LogAlert(false, 3, "DiskManager.alert.movefileexists"), new String[]{old_file.getName()});
                                        Debug.out(msg);
                                        var18_24 = null;
                                        break block39;
                                    }
                                    destDir.mkdirs();
                                }
                                for (i = 0; i < this.files.length; ++i) {
                                    new_file = new_files[i];
                                    if (new_file == null) continue;
                                    try {
                                        this.files[i].moveFile(new_file);
                                        if (!change_to_read_only) continue;
                                        this.files[i].setAccessMode(1);
                                        continue;
                                    }
                                    catch (CacheFileManagerException e) {
                                        msg = "Failed to move " + old_files[i].toString() + " to destination dir";
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent((Object)this, DiskManagerImpl.LOGID, 3, msg));
                                        }
                                        Logger.logTextResource(new LogAlert(false, 3, "DiskManager.alert.movefilefails"), new String[]{old_files[i].toString(), Debug.getNestedExceptionMessage(e)});
                                        Debug.out(msg);
                                        for (j = 0; j < i; ++j) {
                                            if (new_files[j] == null) continue;
                                            try {
                                                this.files[j].moveFile(old_files[j]);
                                                continue;
                                            }
                                            catch (CacheFileManagerException f) {
                                                Logger.logTextResource(new LogAlert(false, 3, "DiskManager.alert.movefilerecoveryfails"), new String[]{old_files[j].toString(), Debug.getNestedExceptionMessage(f)});
                                            }
                                        }
                                        var18_25 = null;
                                        try {
                                            resumeEnabled = COConfigurationManager.getBooleanParameter("Use Resume", true);
                                            if (resumeEnabled) {
                                                try {
                                                    this.dumpResumeDataToDisk(true, false);
                                                }
                                                catch (Exception e) {
                                                    Debug.out("dumpResumeDataToDisk fails");
                                                }
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                        this.start_stop_mon.exit();
                                        return;
                                    }
                                }
                                if (save_location.isDirectory()) {
                                    FileUtil.recursiveEmptyDirDelete(save_location, false);
                                }
                                this.download_manager.setTorrentSaveDir(move_to_dir);
                                if (!move_torrent || (newTorrentFile = new File(move_to_dir, oldFileName = (oldTorrentFile = new File(oldFullName = this.download_manager.getTorrentFileName())).getName())).equals(oldTorrentFile)) break block41;
                                if (TorrentUtils.move(oldTorrentFile, newTorrentFile)) {
                                    this.download_manager.setTorrentFileName(newTorrentFile.getCanonicalPath());
                                    break block41;
                                } else {
                                    msg = "Failed to move " + oldTorrentFile.toString() + " to " + newTorrentFile.toString();
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent((Object)this, DiskManagerImpl.LOGID, 3, msg));
                                    }
                                    Logger.logTextResource(new LogAlert(false, 3, "DiskManager.alert.movefilefails"), new String[]{oldTorrentFile.toString(), newTorrentFile.toString()});
                                    Debug.out(msg);
                                }
                                break block41;
                            }
                            catch (Exception e) {
                                block42: {
                                    Debug.printStackTrace(e);
                                    var18_27 = null;
                                    ** try [egrp 4[TRYBLOCK] [11 : 828->862)] { 
lbl91:
                                    // 1 sources

                                    resumeEnabled = COConfigurationManager.getBooleanParameter("Use Resume", true);
                                    if (resumeEnabled) {
                                        ** try [egrp 5[TRYBLOCK] [10 : 842->851)] { 
lbl94:
                                        // 1 sources

                                        this.dumpResumeDataToDisk(true, false);
lbl96:
                                        // 1 sources

                                        catch (Exception e) {
                                            Debug.out("dumpResumeDataToDisk fails");
                                        }
                                    }
                                    break block42;
lbl99:
                                    // 1 sources

                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                this.start_stop_mon.exit();
                                return;
                            }
                        }
                        catch (Throwable var17_44) {
                            block43: {
                                var18_28 = null;
                                ** try [egrp 4[TRYBLOCK] [11 : 828->862)] { 
lbl108:
                                // 1 sources

                                resumeEnabled = COConfigurationManager.getBooleanParameter("Use Resume", true);
                                if (resumeEnabled) {
                                    ** try [egrp 5[TRYBLOCK] [10 : 842->851)] { 
lbl111:
                                    // 1 sources

                                    this.dumpResumeDataToDisk(true, false);
lbl113:
                                    // 1 sources

                                    catch (Exception e) {
                                        Debug.out("dumpResumeDataToDisk fails");
                                    }
                                }
                                break block43;
lbl116:
                                // 1 sources

                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            this.start_stop_mon.exit();
                            throw var17_44;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [11 : 828->862)] { 
lbl123:
                    // 1 sources

                    resumeEnabled = COConfigurationManager.getBooleanParameter("Use Resume", true);
                    if (resumeEnabled) {
                        ** try [egrp 5[TRYBLOCK] [10 : 842->851)] { 
lbl126:
                        // 1 sources

                        this.dumpResumeDataToDisk(true, false);
lbl128:
                        // 1 sources

                        catch (Exception e) {
                            Debug.out("dumpResumeDataToDisk fails");
                        }
                    }
                    break block44;
lbl131:
                    // 1 sources

                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                this.start_stop_mon.exit();
                return;
            }
            var18_26 = null;
            ** try [egrp 4[TRYBLOCK] [11 : 828->862)] { 
lbl139:
            // 1 sources

            resumeEnabled = COConfigurationManager.getBooleanParameter("Use Resume", true);
            if (resumeEnabled) {
                ** try [egrp 5[TRYBLOCK] [10 : 842->851)] { 
lbl142:
                // 1 sources

                this.dumpResumeDataToDisk(true, false);
lbl144:
                // 1 sources

                catch (Exception e) {
                    Debug.out("dumpResumeDataToDisk fails");
                }
            }
            break block45;
lbl147:
            // 1 sources

            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        this.start_stop_mon.exit();
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void addListener(DiskManagerListener l) {
        this.listeners.addListener(l);
        int[] params = new int[]{this.getState(), this.getState()};
        this.listeners.dispatch(l, 1, params);
    }

    public void removeListener(DiskManagerListener l) {
        this.listeners.removeListener(l);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        block8: {
            if (torrent == null || torrent_save_file == null) {
                return;
            }
            try {
                if (torrent.isSimpleTorrent()) {
                    File target = new File(torrent_save_dir, torrent_save_file);
                    target = FMFileManagerFactory.getSingleton().getFileLink(torrent, target.getCanonicalFile());
                    FileUtil.deleteWithRecycle(target);
                    break block8;
                }
                PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
                if (Constants.isOSX && torrent_save_file.length() > 0 && COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && mgr.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    try {
                        String dir = torrent_save_dir + File.separatorChar + torrent_save_file + File.separatorChar;
                        if (DiskManagerImpl.countFiles(new File(dir)) == DiskManagerImpl.countDataFiles(torrent, torrent_save_dir, torrent_save_file)) {
                            mgr.performRecoverableFileDelete(dir);
                            break block8;
                        }
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
                    }
                    catch (PlatformManagerException ex) {
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
                    }
                    break block8;
                }
                DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private static int countFiles(File f) {
        if (f.isFile()) {
            return 1;
        }
        int res = 0;
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                res += DiskManagerImpl.countFiles(files[i]);
            }
        }
        return res;
    }

    private static int countDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        try {
            int res = 0;
            LocaleUtilDecoder locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(torrent);
            TOTorrentFile[] files = torrent.getFiles();
            for (int i = 0; i < files.length; ++i) {
                byte[][] path_comps = files[i].getPathComponents();
                String path_str = torrent_save_dir + File.separator + torrent_save_file + File.separator;
                for (int j = 0; j < path_comps.length; ++j) {
                    String comp = locale_decoder.decodeString(path_comps[j]);
                    comp = FileUtil.convertOSSpecificChars(comp);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp;
                }
                File file = new File(path_str).getCanonicalFile();
                File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, file);
                boolean skip = false;
                if (linked_file != file && !linked_file.getCanonicalPath().startsWith(new File(torrent_save_dir).getCanonicalPath())) {
                    skip = true;
                }
                if (skip || !file.exists() || file.isDirectory()) continue;
                ++res;
            }
            return res;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return -1;
        }
    }

    private static void deleteDataFileContents(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        LocaleUtilDecoder locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(torrent);
        TOTorrentFile[] files = torrent.getFiles();
        String root_path = torrent_save_dir + File.separator + torrent_save_file + File.separator;
        for (int i = 0; i < files.length; ++i) {
            boolean delete;
            byte[][] path_comps = files[i].getPathComponents();
            String path_str = root_path;
            for (int j = 0; j < path_comps.length; ++j) {
                try {
                    String comp = locale_decoder.decodeString(path_comps[j]);
                    comp = FileUtil.convertOSSpecificChars(comp);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp;
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    Debug.out("file - unsupported encoding!!!!");
                }
            }
            File file = new File(path_str);
            File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, file);
            if (linked_file == file) {
                delete = true;
            } else {
                try {
                    if (linked_file.getCanonicalPath().startsWith(new File(root_path).getCanonicalPath())) {
                        file = linked_file;
                        delete = true;
                    } else {
                        delete = false;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    delete = false;
                }
            }
            if (!delete || !file.exists() || file.isDirectory()) continue;
            try {
                FileUtil.deleteWithRecycle(file);
                continue;
            }
            catch (Exception e) {
                Debug.out(e.toString());
            }
        }
        FileUtil.recursiveEmptyDirDelete(new File(torrent_save_dir, torrent_save_file));
    }

    public void skippedFileSetChanged(DiskManagerFileInfo file) {
        this.skipped_file_set_changed = true;
        this.listeners.dispatch(2, file);
    }

    public void priorityChanged(DiskManagerFileInfo file) {
        this.listeners.dispatch(2, file);
    }

    private void loadFilePriorities() {
        DiskManagerImpl.loadFilePriorities(this.download_manager, this.files);
    }

    private static void loadFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        try {
            if (files == null) {
                return;
            }
            List file_priorities = (List)download_manager.getData("file_priorities");
            if (file_priorities == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo file = files[i];
                if (file == null) {
                    return;
                }
                int priority = ((Long)file_priorities.get(i)).intValue();
                if (priority == 0) {
                    file.setSkipped(true);
                    continue;
                }
                if (priority != 1) continue;
                file.setPriority(true);
            }
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    protected void storeFilePriorities() {
        DiskManagerImpl.storeFilePriorities(this.download_manager, this.files);
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        if (files == null) {
            return;
        }
        ArrayList<Long> file_priorities = new ArrayList<Long>();
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo file = files[i];
            if (file == null) {
                return;
            }
            boolean skipped = file.isSkipped();
            boolean priority = file.isPriority();
            int value = -1;
            if (skipped) {
                value = 0;
            } else if (priority) {
                value = 1;
            }
            file_priorities.add(i, new Long(value));
        }
        download_manager.setData("file_priorities", file_priorities);
    }

    protected static void storeFileDownloaded(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        DownloadManagerState state = download_manager.getDownloadState();
        HashMap details = new HashMap();
        ArrayList<Long> downloaded = new ArrayList<Long>();
        details.put("downloaded", downloaded);
        for (int i = 0; i < files.length; ++i) {
            downloaded.add(new Long(files[i].getDownloaded()));
        }
        state.setMapAttribute("filedownloaded", details);
        state.save();
    }

    protected static void loadFileDownloaded(DownloadManager download_manager, DiskManagerFileInfoHelper[] files) {
        DownloadManagerState state = download_manager.getDownloadState();
        Map details = state.getMapAttribute("filedownloaded");
        if (details == null) {
            return;
        }
        List downloaded = (List)details.get("downloaded");
        if (downloaded == null) {
            return;
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                files[i].setDownloaded((Long)downloaded.get(i));
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void saveState() {
        if (this.files != null) {
            DiskManagerImpl.storeFileDownloaded(this.download_manager, this.files);
            this.storeFilePriorities();
        }
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    public String getInternalName() {
        return this.download_manager.getInternalName();
    }

    public DownloadManagerState getDownloadState() {
        return this.download_manager.getDownloadState();
    }

    public File getSaveLocation() {
        return this.download_manager.getSaveLocation();
    }

    public String[] getStorageTypes() {
        return DiskManagerImpl.getStorageTypes(this.download_manager);
    }

    protected static String[] getStorageTypes(DownloadManager download_manager) {
        DownloadManagerState state = download_manager.getDownloadState();
        String[] types = state.getListAttribute("storetypes");
        if (types.length == 0) {
            types = new String[download_manager.getTorrent().getFiles().length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = "L";
            }
        }
        return types;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static boolean setFileLink(DownloadManager download_manager, DiskManagerFileInfo[] info, DiskManagerFileInfo file_info, File from_link, File to_link) {
        File existing_link = FMFileManagerFactory.getSingleton().getFileLink(download_manager.getTorrent(), to_link);
        if (!existing_link.equals(to_link) && !from_link.equals(to_link)) {
            Logger.log(new LogAlert(true, 3, "Attempt to link to existing link '" + existing_link.toString() + "'"));
            return false;
        }
        for (int i = 0; i < info.length; ++i) {
            if (!to_link.equals(info[i].getFile(true))) continue;
            Logger.log(new LogAlert(true, 3, "Attempt to link to existing file '" + info[i].getFile(true) + "'"));
            return false;
        }
        File existing_file = file_info.getFile(true);
        if (to_link.exists()) {
            if (to_link.equals(existing_file)) {
                return true;
            }
            if (!existing_file.exists()) {
                download_manager.recheckFile(file_info);
            } else {
                if (!FileUtil.deleteWithRecycle(existing_file)) {
                    Logger.log(new LogAlert(true, 3, "Failed to delete '" + existing_file.toString() + "'"));
                    return false;
                }
                download_manager.recheckFile(file_info);
            }
        } else if (existing_file.exists() && !FileUtil.renameFile(existing_file, to_link)) {
            Logger.log(new LogAlert(true, 3, "Failed to rename '" + existing_file.toString() + "'"));
            return false;
        }
        DownloadManagerState state = download_manager.getDownloadState();
        state.setFileLink(from_link, to_link);
        state.save();
        return true;
    }

    public static DiskManagerFileInfo[] getFileInfoSkeleton(final DownloadManager download_manager) {
        TOTorrent torrent = download_manager.getTorrent();
        if (torrent == null) {
            return new DiskManagerFileInfo[0];
        }
        String root_dir = download_manager.getAbsoluteSaveLocation().getParent();
        if (!torrent.isSimpleTorrent()) {
            root_dir = root_dir + File.separator + download_manager.getAbsoluteSaveLocation().getName();
        }
        root_dir = root_dir + File.separator;
        try {
            LocaleUtilDecoder locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(torrent);
            TOTorrentFile[] torrent_files = torrent.getFiles();
            long piece_size = torrent.getPieceLength();
            long size_so_far = 0L;
            DiskManagerFileInfo[] res = new DiskManagerFileInfoHelper[torrent_files.length];
            for (int i = 0; i < res.length; ++i) {
                TOTorrentFile torrent_file = torrent_files[i];
                int file_index = i;
                long file_length = torrent_file.getLength();
                int first_piece = (int)(size_so_far / piece_size);
                int last_piece = (int)(((size_so_far += file_length) - 1L) / piece_size);
                String path_str = root_dir + File.separator;
                if (torrent.isSimpleTorrent()) {
                    path_str = path_str + download_manager.getAbsoluteSaveLocation().getName();
                } else {
                    byte[][] path_comps = torrent_file.getPathComponents();
                    for (int j = 0; j < path_comps.length; ++j) {
                        String comp = locale_decoder.decodeString(path_comps[j]);
                        comp = FileUtil.convertOSSpecificChars(comp);
                        path_str = path_str + (j == 0 ? "" : File.separator) + comp;
                    }
                }
                File data_file = new File(path_str);
                String data_name = data_file.getName();
                int separator = data_name.lastIndexOf(".");
                if (separator == -1) {
                    separator = 0;
                }
                String data_extension = data_name.substring(separator);
                DiskManagerFileInfoHelper info = new DiskManagerFileInfoHelper((DiskManagerFileInfoHelper[])res, data_extension, first_piece, last_piece, torrent_file, file_index, data_file){
                    private boolean priority;
                    private boolean skipped;
                    private long downloaded;
                    private final /* synthetic */ DiskManagerFileInfoHelper[] val$res;
                    private final /* synthetic */ String val$data_extension;
                    private final /* synthetic */ int val$first_piece;
                    private final /* synthetic */ int val$last_piece;
                    private final /* synthetic */ TOTorrentFile val$torrent_file;
                    private final /* synthetic */ int val$file_index;
                    private final /* synthetic */ File val$data_file;
                    {
                        this.val$res = val$res;
                        this.val$data_extension = val$data_extension;
                        this.val$first_piece = val$first_piece;
                        this.val$last_piece = val$last_piece;
                        this.val$torrent_file = val$torrent_file;
                        this.val$file_index = val$file_index;
                        this.val$data_file = val$data_file;
                    }

                    public void setPriority(boolean b) {
                        this.priority = b;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                    }

                    public void setSkipped(boolean b) {
                        this.skipped = b;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                    }

                    public int getAccessMode() {
                        return 1;
                    }

                    public long getDownloaded() {
                        return this.downloaded;
                    }

                    public void setDownloaded(long l) {
                        this.downloaded = l;
                    }

                    public String getExtension() {
                        return this.val$data_extension;
                    }

                    public int getFirstPieceNumber() {
                        return this.val$first_piece;
                    }

                    public int getLastPieceNumber() {
                        return this.val$last_piece;
                    }

                    public long getLength() {
                        return this.val$torrent_file.getLength();
                    }

                    public int getIndex() {
                        return this.val$file_index;
                    }

                    public int getNbPieces() {
                        return this.val$last_piece - this.val$first_piece + 1;
                    }

                    public boolean isPriority() {
                        return this.priority;
                    }

                    public boolean isSkipped() {
                        return this.skipped;
                    }

                    public DiskManager getDiskManager() {
                        return null;
                    }

                    public DownloadManager getDownloadManager() {
                        return download_manager;
                    }

                    public File getFile(boolean follow_link) {
                        File link;
                        if (follow_link && (link = this.getLink()) != null) {
                            return link;
                        }
                        return this.val$data_file;
                    }

                    public TOTorrentFile getTorrentFile() {
                        return this.val$torrent_file;
                    }

                    public boolean setLink(File link_destination) {
                        return DiskManagerImpl.setFileLink(download_manager, this.val$res, this, this.val$data_file, link_destination);
                    }

                    public File getLink() {
                        return download_manager.getDownloadState().getFileLink(this.val$data_file);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean setStorageType(int type) {
                        boolean bl;
                        int old_type;
                        String[] types = DiskManagerImpl.getStorageTypes(download_manager);
                        int n = old_type = types[this.val$file_index].equals("L") ? 1 : 2;
                        if (type == old_type) {
                            return true;
                        }
                        try {
                            CacheFile cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(this){
                                private final /* synthetic */ 7 this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                public String getCacheFileOwnerName() {
                                    return 7.access$500(this.this$0).getInternalName();
                                }

                                public TOTorrentFile getCacheFileTorrentFile() {
                                    return 7.access$600(this.this$0);
                                }

                                public File getCacheFileControlFile(String name) {
                                    return 7.access$500(this.this$0).getDownloadState().getStateFile(name);
                                }
                            }, this.getFile(true), type == 1 ? 1 : 2);
                            cache_file.close();
                            int cleared = RDResumeHandler.storageTypeChanged(download_manager, this);
                            if (cleared > 0) {
                                this.downloaded -= (long)cleared * this.val$torrent_file.getTorrent().getPieceLength();
                                if (this.downloaded < 0L) {
                                    this.downloaded = 0L;
                                }
                                DiskManagerImpl.storeFileDownloaded(download_manager, this.val$res);
                            }
                            bl = true;
                            Object var8_9 = null;
                            types[this.val$file_index] = type == 1 ? "L" : "C";
                        }
                        catch (Throwable e) {
                            boolean bl2;
                            try {
                                Debug.printStackTrace(e);
                                Logger.log(new LogAlert(true, 3, "Failed to change storage type for '" + this.getFile(true) + "': " + Debug.getNestedExceptionMessage(e)));
                                RDResumeHandler.recheckFile(download_manager, this);
                                bl2 = false;
                                Object var8_10 = null;
                                types[this.val$file_index] = type == 1 ? "L" : "C";
                            }
                            catch (Throwable throwable) {
                                Object var8_11 = null;
                                types[this.val$file_index] = type == 1 ? "L" : "C";
                                DownloadManagerState dm_state = download_manager.getDownloadState();
                                dm_state.setListAttribute("storetypes", types);
                                dm_state.save();
                                throw throwable;
                            }
                            DownloadManagerState dm_state = download_manager.getDownloadState();
                            dm_state.setListAttribute("storetypes", types);
                            dm_state.save();
                            return bl2;
                        }
                        DownloadManagerState dm_state = download_manager.getDownloadState();
                        dm_state.setListAttribute("storetypes", types);
                        dm_state.save();
                        return bl;
                    }

                    public int getStorageType() {
                        String[] types = DiskManagerImpl.getStorageTypes(download_manager);
                        return types[this.val$file_index].equals("L") ? 1 : 2;
                    }

                    public void flushCache() {
                    }

                    static /* synthetic */ DownloadManager access$500(7 x0) {
                        return x0.download_manager;
                    }

                    static /* synthetic */ TOTorrentFile access$600(7 x0) {
                        return x0.val$torrent_file;
                    }
                };
                res[i] = info;
            }
            DiskManagerImpl.loadFilePriorities(download_manager, res);
            DiskManagerImpl.loadFileDownloaded(download_manager, (DiskManagerFileInfoHelper[])res);
            return res;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new DiskManagerFileInfo[0];
        }
    }

    public static void setFileLinks(DownloadManager download_manager, Map links) {
        try {
            CacheFileManagerFactory.getSingleton().setFileLinks(download_manager.getTorrent(), links);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public String getRelationText() {
        return "TorrentDM: '" + this.download_manager.getDisplayName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager, this.torrent};
    }

    public DiskManagerRecheckScheduler getRecheckScheduler() {
        return recheck_scheduler;
    }

    public boolean isInteresting(int pieceNumber) {
        return this.pieces[pieceNumber].isInteresting();
    }

    public boolean isDone(int pieceNumber) {
        return this.pieces[pieceNumber].isDone();
    }

    static {
        int max_read_threads = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxthreads");
        int max_read_mb = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxmb");
        int max_write_threads = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxthreads");
        int max_write_mb = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxmb");
        disk_access_controller = DiskAccessControllerFactory.create(max_read_threads, max_read_mb, max_write_threads, max_write_mb);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Disk access controller params: " + max_read_threads + "/" + max_read_mb + "/" + max_write_threads + "/" + max_write_mb));
        }
        recheck_scheduler = new DiskManagerRecheckScheduler();
        allocation_scheduler = new DiskManagerAllocationScheduler();
        listeners_aggregator = ListenerManager.createAsyncManager("DiskM:ListenAggregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DiskManagerListener listener = (DiskManagerListener)_listener;
                if (type == 1) {
                    int[] params = (int[])value;
                    listener.stateChanged(params[0], params[1]);
                } else if (type == 2) {
                    listener.filePriorityChanged((DiskManagerFileInfo)value);
                } else if (type == 3) {
                    listener.pieceDoneChanged((DiskManagerPiece)value);
                } else if (type == 4) {
                    Object[] o = (Object[])value;
                    listener.fileAccessModeChanged((DiskManagerFileInfo)o[0], (Integer)o[1], (Integer)o[2]);
                }
            }
        });
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
    }
}

