/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;

public final class TransferSpeedValidator {
    public static final String UPLOAD_CONFIGKEY = "Max Upload Speed KBs";
    public static final String UPLOAD_SEEDING_CONFIGKEY = "Max Upload Speed Seeding KBs";
    public static final String DOWNLOAD_CONFIGKEY = "Max Download Speed KBs";
    private final String configKey;
    private final Object configValue;
    private static boolean seeding_upload_enabled;

    public TransferSpeedValidator(String configKey, Object value) {
        this.configKey = configKey;
        this.configValue = value;
    }

    private static Object validate(String configKey, Object value) {
        int newValue = ((Number)value).intValue();
        if (newValue < 0) {
            newValue = 0;
        }
        if (configKey == UPLOAD_CONFIGKEY) {
            int downValue = COConfigurationManager.getIntParameter(DOWNLOAD_CONFIGKEY);
            if (newValue != 0 && newValue < 5 && (downValue == 0 || downValue > newValue * 2)) {
                newValue = (downValue + 1) / 2;
            }
        } else if (configKey == DOWNLOAD_CONFIGKEY) {
            int upValue = COConfigurationManager.getIntParameter(UPLOAD_CONFIGKEY);
            if (upValue != 0 && upValue < 5) {
                if (newValue > upValue * 2) {
                    newValue = upValue * 2;
                } else if (newValue == 0) {
                    newValue = upValue * 2;
                }
            }
        } else if (configKey != UPLOAD_SEEDING_CONFIGKEY) {
            throw new IllegalArgumentException("Invalid Configuation Key; use key for max upload and max download");
        }
        return new Integer(newValue);
    }

    public Object getValue() {
        return TransferSpeedValidator.validate(this.configKey, this.configValue);
    }

    public static String getActiveUploadParameter(GlobalManager gm) {
        if (gm.isSeedingOnly() && seeding_upload_enabled) {
            return UPLOAD_SEEDING_CONFIGKEY;
        }
        return UPLOAD_CONFIGKEY;
    }

    static {
        COConfigurationManager.addAndFireParameterListener("enable.seedingonly.upload.rate", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                seeding_upload_enabled = COConfigurationManager.getBooleanParameter(parameterName);
            }
        });
    }
}

