/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc.impl;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerRequest;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.SystemTime;

public class PRUDPPacketHandlerRequestImpl
implements PRUDPPacketHandlerRequest {
    private AESemaphore sem = new AESemaphore("PRUDPPacketHandlerRequest");
    private long timeout;
    private PRUDPPacketReceiver receiver;
    private PRUDPPacketHandlerException exception;
    private PRUDPPacket reply;
    private long send_time;
    private long reply_time;

    protected PRUDPPacketHandlerRequestImpl(PRUDPPacketReceiver _receiver, long _timeout) {
        this.receiver = _receiver;
        this.timeout = _timeout;
    }

    protected void sent() {
        this.send_time = SystemTime.getCurrentTime();
    }

    protected long getSendTime() {
        return this.send_time;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    public long getElapsedTime() {
        if (this.send_time == 0L || this.reply_time == 0L) {
            return -1L;
        }
        long res = this.reply_time - this.send_time;
        if (res < 0L) {
            res = 0L;
        }
        if (res == 0L) {
            res = 12L;
        }
        return res;
    }

    protected void setReply(PRUDPPacket packet, InetSocketAddress originator) {
        if (this.reply == null) {
            this.reply_time = SystemTime.getCurrentTime();
            this.reply = packet;
        } else {
            packet.setPreviousPacket(this.reply);
            this.reply = packet;
        }
        if (!packet.hasContinuation()) {
            this.sem.release();
        }
        if (this.receiver != null) {
            this.receiver.packetReceived(this, packet, originator);
        }
    }

    protected void setException(PRUDPPacketHandlerException e) {
        if (this.reply == null) {
            this.reply_time = SystemTime.getCurrentTime();
            this.exception = e;
        }
        this.sem.release();
        if (this.receiver != null) {
            this.receiver.error(e);
        }
    }

    protected PRUDPPacket getReply() throws PRUDPPacketHandlerException {
        this.sem.reserve();
        if (this.exception != null) {
            throw this.exception;
        }
        return this.reply;
    }
}

