/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.local;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.Monitor;

public class LocalTrackerPlugin
implements Plugin,
AZInstanceManagerListener,
DownloadManagerListener,
DownloadListener {
    private static final String PLUGIN_NAME = "LAN Peer Finder";
    private static final String PLUGIN_CONFIGSECTION_ID = "Plugin.localtracker.name";
    private static final long ANNOUNCE_PERIOD = 1200000L;
    private static final long RE_ANNOUNCE_PERIOD = 60000L;
    private PluginInterface plugin_interface;
    private AZInstanceManager instance_manager;
    private boolean active;
    private TorrentAttribute ta_networks;
    private Map downloads = new HashMap();
    private Map track_times = new HashMap();
    private BooleanParameter enabled;
    private long plugin_start_time;
    private LoggerChannel log;
    private Monitor mon;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
        this.mon = this.plugin_interface.getUtilities().getMonitor();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addLabelParameter2("Plugin.localtracker.info");
        this.enabled = config.addBooleanParameter2("Plugin.localtracker.enable", "Plugin.localtracker.enable", true);
        final BasicPluginViewModel view_model = this.plugin_interface.getUIManager().createBasicPluginViewModel(PLUGIN_CONFIGSECTION_ID);
        view_model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        view_model.getActivity().setVisible(false);
        view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                view_model.getLogArea().appendText(content + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    view_model.getLogArea().appendText(str + "\n");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                view_model.getLogArea().appendText(sw.toString() + "\n");
            }
        });
        this.plugin_start_time = this.plugin_interface.getUtilities().getCurrentSystemTime();
        this.instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
        this.instance_manager.addListener(this);
        this.plugin_interface.getDownloadManager().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceFound(AZInstance instance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Found: " + instance.getString());
        try {
            this.mon.enter();
            if (this.active) {
                return;
            }
            this.active = true;
            this.plugin_interface.getUtilities().createThread("Tracker", new Runnable(){

                public void run() {
                    LocalTrackerPlugin.this.track();
                }
            });
        }
        finally {
            this.mon.exit();
        }
    }

    public void instanceChanged(AZInstance instance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Changed: " + instance.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceLost(AZInstance instance) {
        try {
            this.mon.enter();
            this.track_times.remove(instance.getID());
        }
        finally {
            this.mon.exit();
        }
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Lost: " + instance.getString());
    }

    public void instanceTracked(AZInstanceTracked instance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.handleTrackResult(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void track() {
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        if (now - this.plugin_start_time < 60000L) {
            try {
                Thread.sleep(15000L);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        while (true) {
            now = this.plugin_interface.getUtilities().getCurrentSystemTime();
            try {
                ArrayList<Download> todo = new ArrayList<Download>();
                try {
                    this.mon.enter();
                    Iterator it = this.downloads.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry2 = it.next();
                        Download dl = (Download)entry2.getKey();
                        long when = (Long)entry2.getValue();
                        if (when <= now && now - when <= 1200000L) continue;
                        todo.add(dl);
                    }
                }
                finally {
                    this.mon.exit();
                }
                for (int i = 0; i < todo.size(); ++i) {
                    this.track((Download)todo.get(i));
                }
                Thread.sleep(60000L);
                continue;
            }
            catch (Throwable e) {
                this.log.log(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void track(Download download) {
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        boolean ok = false;
        try {
            this.mon.enter();
            Long l_last_track = (Long)this.downloads.get(download);
            if (l_last_track == null) {
                return;
            }
            long last_track = l_last_track;
            if (last_track > now || now - last_track > 60000L) {
                ok = true;
                this.downloads.put(download, new Long(now));
            }
        }
        finally {
            this.mon.exit();
        }
        if (ok) {
            this.trackSupport(download);
        }
    }

    protected void trackSupport(Download download) {
        if (!this.enabled.getValue()) {
            return;
        }
        int state = download.getState();
        if (state == 8 || state == 7) {
            return;
        }
        AZInstanceTracked[] peers = this.instance_manager.track(download);
        for (int i = 0; i < peers.length; ++i) {
            this.handleTrackResult(peers[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTrackResult(AZInstanceTracked tracked_inst) {
        AZInstance inst = tracked_inst.getInstance();
        Download download = tracked_inst.getDownload();
        boolean is_seed = tracked_inst.isSeed();
        long now = SystemTime.getCurrentTime();
        boolean skip = false;
        try {
            long lt;
            String dl_key;
            Long last_track;
            this.mon.enter();
            HashMap<String, Long> map = (HashMap<String, Long>)this.track_times.get(inst.getID());
            if (map == null) {
                map = new HashMap<String, Long>();
                this.track_times.put(inst.getID(), map);
            }
            if ((last_track = (Long)map.get(dl_key = this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(download.getTorrent().getHash()))) != null && now - (lt = last_track.longValue()) < 60000L) {
                skip = true;
            }
            map.put(dl_key, new Long(now));
        }
        finally {
            this.mon.exit();
        }
        if (skip) {
            return;
        }
        this.log.log("Tracked: " + inst.getString() + ": " + download.getName() + ", seed = " + is_seed);
        if (download.isComplete() && is_seed) {
            return;
        }
        PeerManager peer_manager = download.getPeerManager();
        if (peer_manager != null) {
            String peer_ip = inst.getInternalAddress().getHostAddress();
            int peer_port = inst.getTrackerClientPort();
            this.log.log("    " + download.getName() + ": Injecting peer " + peer_ip + ":" + peer_port);
            peer_manager.addPeer(peer_ip, peer_port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAdded(Download download) {
        try {
            this.mon.enter();
            Torrent torrent = download.getTorrent();
            if (torrent == null || torrent.isPrivate()) {
                return;
            }
            String[] networks = download.getListAttribute(this.ta_networks);
            boolean public_net = false;
            for (int i = 0; i < networks.length; ++i) {
                if (!networks[i].equalsIgnoreCase("Public")) continue;
                public_net = true;
                break;
            }
            if (!public_net) {
                return;
            }
            this.downloads.put(download, new Long(0L));
            download.addListener(this);
        }
        finally {
            this.mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRemoved(Download download) {
        try {
            this.mon.enter();
            this.downloads.remove(download);
            download.removeListener(this);
        }
        finally {
            this.mon.exit();
        }
    }

    public void stateChanged(Download download, int old_state, int new_state) {
        if (new_state == 4 || new_state == 5) {
            this.track(download);
        }
    }

    public void positionChanged(Download download, int oldPosition, int newPosition) {
    }
}

