/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.sharing.hoster;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadPropertyEvent;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceEvent;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;

public class ShareHosterPlugin
implements Plugin,
PluginListener,
ShareManagerListener {
    protected PluginInterface plugin_interface;
    protected LoggerChannel log;
    protected Tracker tracker;
    protected ShareManager share_manager;
    protected DownloadManager download_manager;
    protected Map resource_dl_map = new HashMap();
    protected Map resource_tt_map = new HashMap();
    protected Download download_being_removed;
    protected TrackerTorrent torrent_being_removed;
    protected boolean initialised = false;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Share Hoster");
        this.log = this.plugin_interface.getLogger().getChannel("ShareHosterPlugin");
        this.log.log(1, "ShareHosterPlugin: initialisation starts");
        this.plugin_interface.addListener(this);
    }

    public void initializationComplete() {
        this.plugin_interface.getUtilities().createThread("ShareHosterImplugin::init", new Runnable(){

            public void run() {
                ShareHosterPlugin.this.initialise();
            }
        });
    }

    protected void initialise() {
        this.log.log(1, "ShareHosterPlugin: initialisation complete");
        Thread.currentThread().setPriority(1);
        try {
            this.tracker = this.plugin_interface.getTracker();
            this.download_manager = this.plugin_interface.getDownloadManager();
            this.share_manager = this.plugin_interface.getShareManager();
            this.share_manager.addListener(this);
            this.share_manager.initialise();
            this.initialised = true;
            ShareResource[] shares = this.share_manager.getShares();
            for (int i = 0; i < shares.length; ++i) {
                this.resourceAdded(shares[i]);
            }
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
            this.log.log(e);
        }
    }

    public void closedownInitiated() {
    }

    public void closedownComplete() {
    }

    public void resourceAdded(final ShareResource resource) {
        this.log.log(1, "Resource added:".concat(resource.getName()));
        if (this.initialised) {
            try {
                ShareResourceDir dir_resource;
                Download download;
                Torrent torrent;
                ShareItem item;
                resource.addDeletionListener(new ShareResourceWillBeDeletedListener(){

                    public void resourceWillBeDeleted(ShareResource resource) throws ShareResourceDeletionVetoException {
                        ShareHosterPlugin.this.canResourceBeDeleted(resource);
                    }
                });
                Download new_download = null;
                int type = resource.getType();
                if (type == 1) {
                    ShareResourceFile file_resource = (ShareResourceFile)resource;
                    item = file_resource.getItem();
                    torrent = item.getTorrent();
                    download = this.download_manager.getDownload(torrent);
                    if (download == null) {
                        new_download = this.download_manager.addNonPersistentDownload(torrent, item.getTorrentFile(), file_resource.getFile());
                    }
                } else if (type == 2 && (download = this.download_manager.getDownload(torrent = (item = (dir_resource = (ShareResourceDir)resource).getItem()).getTorrent())) == null) {
                    new_download = this.download_manager.addNonPersistentDownload(torrent, item.getTorrentFile(), dir_resource.getDir());
                }
                if (new_download != null) {
                    final Download f_new_download = new_download;
                    this.resource_dl_map.put(resource, new_download);
                    resource.addChangeListener(new ShareResourceListener(){

                        public void shareResourceChanged(ShareResource resource, ShareResourceEvent event) {
                            if (event.getType() == 1) {
                                TorrentAttribute attribute = (TorrentAttribute)event.getData();
                                f_new_download.setAttribute(attribute, resource.getAttribute(attribute));
                            }
                        }
                    });
                    TorrentAttribute[] attributes = resource.getAttributes();
                    for (int i = 0; i < attributes.length; ++i) {
                        TorrentAttribute ta = attributes[i];
                        new_download.setAttribute(ta, resource.getAttribute(ta));
                    }
                    new_download.addPropertyListener(new DownloadPropertyListener(){

                        public void propertyChanged(Download download, DownloadPropertyEvent event) {
                            if (event.getType() == 1) {
                                TorrentAttribute at = (TorrentAttribute)event.getData();
                                resource.setAttribute(at, download.getAttribute(at));
                            }
                        }
                    });
                    Torrent dl_torrent = new_download.getTorrent();
                    if (dl_torrent != null) {
                        TrackerTorrent tt = this.tracker.host(dl_torrent, false);
                        tt.addRemovalListener(new TrackerTorrentWillBeRemovedListener(){

                            public void torrentWillBeRemoved(TrackerTorrent tt) throws TrackerTorrentRemovalVetoException {
                                if (tt != ShareHosterPlugin.this.torrent_being_removed) {
                                    throw new TrackerTorrentRemovalVetoException(MessageText.getString("plugin.sharing.torrent.remove.veto"));
                                }
                            }
                        });
                        this.resource_tt_map.put(resource, tt);
                    }
                    new_download.addDownloadWillBeRemovedListener(new DownloadWillBeRemovedListener(){

                        public void downloadWillBeRemoved(Download dl) throws DownloadRemovalVetoException {
                            if (dl != ShareHosterPlugin.this.download_being_removed) {
                                throw new DownloadRemovalVetoException(MessageText.getString("plugin.sharing.download.remove.veto"));
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void canResourceBeDeleted(ShareResource resource) throws ShareResourceDeletionVetoException {
        TrackerTorrent tt;
        Download dl = (Download)this.resource_dl_map.get(resource);
        if (dl != null) {
            try {
                this.download_being_removed = dl;
                dl.canBeRemoved();
            }
            catch (DownloadRemovalVetoException e) {
                throw new ShareResourceDeletionVetoException(e.getMessage());
            }
            finally {
                this.download_being_removed = null;
            }
        }
        if ((tt = (TrackerTorrent)this.resource_tt_map.get(resource)) != null) {
            try {
                this.torrent_being_removed = tt;
                tt.canBeRemoved();
            }
            catch (TrackerTorrentRemovalVetoException e) {
                throw new ShareResourceDeletionVetoException(e.getMessage());
            }
            finally {
                this.torrent_being_removed = null;
            }
        }
    }

    public void resourceModified(ShareResource resource) {
        this.log.log(1, "Resource modified:".concat(resource.getName()));
        if (this.initialised) {
            this.resourceDeleted(resource);
            this.resourceAdded(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceDeleted(ShareResource resource) {
        this.log.log(1, "Resource deleted:".concat(resource.getName()));
        if (this.initialised) {
            TrackerTorrent tt;
            Download dl = (Download)this.resource_dl_map.get(resource);
            if (dl != null) {
                try {
                    this.download_being_removed = dl;
                    try {
                        dl.stop();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    dl.remove();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                finally {
                    this.download_being_removed = null;
                }
                this.resource_dl_map.remove(resource);
            }
            if ((tt = (TrackerTorrent)this.resource_tt_map.get(resource)) != null) {
                try {
                    this.torrent_being_removed = tt;
                    tt.remove();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                finally {
                    this.torrent_being_removed = null;
                }
                this.resource_tt_map.remove(resource);
            }
        }
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(String task_description) {
        this.log.log(1, "Current Task:".concat(task_description));
    }
}

