/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.peer.impl;

import com.aelitis.azureus.plugins.jpc.JPCException;
import com.aelitis.azureus.plugins.jpc.JPCPlugin;
import com.aelitis.azureus.plugins.jpc.cache.JPCCache;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheDownloader;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheDownloaderAdapter;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheManager;
import com.aelitis.azureus.plugins.jpc.license.JPCLicense;
import com.aelitis.azureus.plugins.jpc.license.JPCLicenseVerifier;
import com.aelitis.azureus.plugins.jpc.license.JPCLicenseVerifierFactory;
import com.aelitis.azureus.plugins.jpc.peer.PeerController;
import com.aelitis.azureus.plugins.jpc.peer.impl.PeerControllerImpl;
import com.aelitis.azureus.plugins.jpc.peer.impl.messaging.JPCCacheHello;
import com.aelitis.azureus.plugins.jpc.peer.impl.messaging.JPCCacheReply;
import com.aelitis.azureus.plugins.jpc.validation.JPCValidator;
import com.aelitis.azureus.plugins.jpc.validation.JPCValidatorFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.MessageManagerListener;
import org.gudy.azureus2.plugins.messaging.bittorrent.BTMessageCancel;
import org.gudy.azureus2.plugins.messaging.bittorrent.BTMessageManager;
import org.gudy.azureus2.plugins.messaging.bittorrent.BTMessageRequest;
import org.gudy.azureus2.plugins.network.IncomingMessageQueueListener;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueueListener;
import org.gudy.azureus2.plugins.peers.Peer;

public class PeerControllerImpl
implements PeerController {
    private final JPCPlugin jpc_plugin;
    private final JPCCacheManager cache_manager;
    private final HashMap peers_uploading = new HashMap();
    private final HashMap peers_downloading = new HashMap();
    private JPCCacheDownloader download_cache;
    private final MessageManagerListener message_manager_listener = new MessageManagerListener(){

        public void compatiblePeerFound(Download download, Peer peer, Message message) {
            peer.getConnection().getIncomingMessageQueue().registerListener(new IncomingMessageQueueListener(this, peer, download){
                private final /* synthetic */ Peer val$peer;
                private final /* synthetic */ Download val$download;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$peer = val$peer;
                    this.val$download = val$download;
                }

                public boolean messageReceived(Message message) {
                    if (message.getID().equals("JPC_CACHE_HELLO")) {
                        PeerControllerImpl.access$100(1.access$000(this.this$1)).log("Received [" + message.getDescription() + "] message from peer [" + this.val$peer.getClient() + " @" + this.val$peer.getIp() + ":" + this.val$peer.getPort() + "]", 2);
                        if (!PeerControllerImpl.access$100(1.access$000(this.this$1)).isCacheUploadEnabled()) {
                            PeerControllerImpl.access$100(1.access$000(this.this$1)).log("Cache upload usage disabled....not responding to downloader hello", 2);
                            return true;
                        }
                        JPCCacheHello hello = (JPCCacheHello)message;
                        int id = hello.getSessionID();
                        PeerControllerImpl.access$200(1.access$000(this.this$1)).put(this.val$peer, new Integer(id));
                        PeerControllerImpl.access$300(1.access$000(this.this$1)).registerWithRemoteUploadCache(new InetSocketAddress(hello.getAddress(), hello.getPort()), this.val$download, this.val$peer, id);
                        return true;
                    }
                    if (message.getID().equals("JPC_CACHE_REPLY")) {
                        PeerControllerImpl.access$100(1.access$000(this.this$1)).log("Received [" + message.getDescription() + "] message from peer [" + this.val$peer.getClient() + " @" + this.val$peer.getIp() + ":" + this.val$peer.getPort() + "]", 2);
                        JPCCacheReply reply = (JPCCacheReply)message;
                        PeerControllerImpl.access$400(1.access$000(this.this$1)).put(new Integer(reply.getSessionID()), this.val$peer);
                        this.val$peer.getConnection().getOutgoingMessageQueue().registerListener(new OutgoingMessageQueueListener(this, reply){
                            private final /* synthetic */ JPCCacheReply val$reply;
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$reply = val$reply;
                            }

                            public boolean messageAdded(Message message) {
                                if (PeerControllerImpl.access$600(1.access$000(2.access$500(this.this$2))) == null) {
                                    return true;
                                }
                                if (message.getID().equals("BT_REQUEST")) {
                                    BTMessageRequest req = BTMessageManager.createCoreBTRequestAdaptation(message);
                                    int id = this.val$reply.getSessionID();
                                    byte[] hash = 2.access$700(this.this$2).getTorrent().getHash();
                                    int piece_num = req.getPieceNumber();
                                    int offset = req.getPieceOffset();
                                    int length = req.getLength();
                                    PeerControllerImpl.access$600(1.access$000(2.access$500(this.this$2))).requestBlock(id, hash, piece_num, offset, length);
                                    Message fake = BTMessageManager.createCoreBTRequest(piece_num, offset, length);
                                    2.access$800(this.this$2).getConnection().getOutgoingMessageQueue().notifyOfExternalSend(fake);
                                    return false;
                                }
                                if (message.getID().equals("BT_CANCEL")) {
                                    BTMessageCancel can = BTMessageManager.createCoreBTCancelAdaptation(message);
                                    int id = this.val$reply.getSessionID();
                                    byte[] hash = 2.access$700(this.this$2).getTorrent().getHash();
                                    int piece_num = can.getPieceNumber();
                                    int offset = can.getPieceOffset();
                                    int length = can.getLength();
                                    PeerControllerImpl.access$600(1.access$000(2.access$500(this.this$2))).sendCancel(id, hash, piece_num, offset, length);
                                    Message fake = BTMessageManager.createCoreBTCancel(piece_num, offset, length);
                                    2.access$800(this.this$2).getConnection().getOutgoingMessageQueue().notifyOfExternalSend(fake);
                                    return false;
                                }
                                return true;
                            }

                            public void messageSent(Message message) {
                            }

                            public void bytesSent(int byte_count) {
                            }
                        });
                        return true;
                    }
                    return false;
                }

                public void bytesReceived(int byte_count) {
                }

                static /* synthetic */ 1 access$500(2 x0) {
                    return x0.this$1;
                }

                static /* synthetic */ Download access$700(2 x0) {
                    return x0.val$download;
                }

                static /* synthetic */ Peer access$800(2 x0) {
                    return x0.val$peer;
                }
            });
            if (PeerControllerImpl.this.download_cache != null) {
                JPCCacheHello hello = new JPCCacheHello(PeerControllerImpl.this.download_cache.getAddress().getAddress().getHostAddress(), PeerControllerImpl.this.download_cache.getAddress().getPort(), PeerControllerImpl.this.download_cache.getSessionID());
                peer.getConnection().getOutgoingMessageQueue().sendMessage(hello);
            }
        }

        public void peerRemoved(Download download, Peer peer) {
            Integer downloader_id = (Integer)PeerControllerImpl.this.peers_downloading.remove(peer);
            if (downloader_id != null) {
                PeerControllerImpl.this.cache_manager.cancelRemoteUploadCacheRegistration(downloader_id);
                return;
            }
            Iterator i = PeerControllerImpl.this.peers_uploading.values().iterator();
            while (i.hasNext()) {
                Peer p = (Peer)i.next();
                if (p != peer) continue;
                PeerControllerImpl.this.jpc_plugin.log("Core reported cache upload peer as removed: " + peer.getIp() + ":" + peer.getPort() + ", dropping.", 2);
                i.remove();
                break;
            }
        }

        static /* synthetic */ PeerControllerImpl access$000(1 x0) {
            return x0.PeerControllerImpl.this;
        }
    };

    public PeerControllerImpl(JPCPlugin plugin, JPCCacheManager manager) {
        this.jpc_plugin = plugin;
        this.cache_manager = manager;
    }

    public void startPeerProcessing() {
        PluginInterface pi = this.jpc_plugin.getPluginInterface();
        try {
            pi.getMessageManager().registerMessageType(new JPCCacheHello("", -1, -1));
            pi.getMessageManager().registerMessageType(new JPCCacheReply(-1));
        }
        catch (MessageException e) {
            e.printStackTrace();
        }
        pi.getMessageManager().locateCompatiblePeers(pi, new JPCCacheHello("", -1, -1), this.message_manager_listener);
    }

    public void stopPeerProcessing() {
        this.jpc_plugin.getPluginInterface().getMessageManager().deregisterMessageType(new JPCCacheHello("", -1, -1));
        this.jpc_plugin.getPluginInterface().getMessageManager().deregisterMessageType(new JPCCacheReply(-1));
        this.jpc_plugin.getPluginInterface().getMessageManager().cancelCompatiblePeersLocation(this.message_manager_listener);
    }

    public void establishDownloadCacheSession() {
        if (this.download_cache != null) {
            return;
        }
        final JPCCacheDownloader[] temp = new JPCCacheDownloader[1];
        this.cache_manager.connectLocalDownloadCache(new JPCCacheDownloaderAdapter(){

            public void connectSuccess(JPCCache cache, boolean is_new_discovery) {
                if (is_new_discovery) {
                    temp[0] = (JPCCacheDownloader)cache;
                    temp[0].sendHello(PeerControllerImpl.this.jpc_plugin.getPluginInterface().getAzureusName() + "/" + PeerControllerImpl.this.jpc_plugin.getPluginInterface().getAzureusVersion() + "/" + "1.2");
                } else {
                    PeerControllerImpl.this.download_cache.requestLicense();
                }
            }

            public void receivedReply(int peer_id, int idle_time, int drop_timeout) {
                temp[0].requestLicense();
            }

            public void receivedActiveAck(int idle_time, int drop_timeout) {
            }

            public void receivedLicense(byte[] content) {
                JPCLicenseVerifier verifier = JPCLicenseVerifierFactory.create();
                try {
                    JPCLicense license = verifier.verify(content);
                    JPCValidator validator = JPCValidatorFactory.create(PeerControllerImpl.this.jpc_plugin);
                    try {
                        validator.validate(temp[0].getAddress(), PeerControllerImpl.this.jpc_plugin.getPluginInterface().getUtilities().getPublicAddress(), license);
                    }
                    catch (JPCException jex) {
                        PeerControllerImpl.this.jpc_plugin.log("Download cache validation failed: " + jex.getMessage(), 1);
                        throw jex;
                    }
                    if (PeerControllerImpl.this.download_cache == null) {
                        PeerControllerImpl.this.download_cache = temp[0];
                    }
                    PeerControllerImpl.this.jpc_plugin.log("Download cache validation succeeded, using cache.", 1);
                    PeerControllerImpl.this.jpc_plugin.updateVersionCheckString("$" + PeerControllerImpl.this.download_cache.getAddress().toString());
                }
                catch (JPCException e) {
                    PeerControllerImpl.this.jpc_plugin.log("Download cache validation failed", e, 1);
                    if (temp[0] != null) {
                        temp[0].closeConnection();
                        temp[0] = null;
                    }
                    PeerControllerImpl.this.dropDownloadCacheSession();
                }
            }

            public void receivedBlock(int peer_id, byte[] hash, int piece_index, int start_offset, ByteBuffer data) {
                Peer peer = (Peer)PeerControllerImpl.this.peers_uploading.get(new Integer(peer_id));
                if (peer == null) {
                    PeerControllerImpl.this.jpc_plugin.log("D: receivedBlock():: peer_id[" + peer_id + "] not found", 2);
                    return;
                }
                Message piece = BTMessageManager.createCoreBTPiece(piece_index, start_offset, data);
                peer.getConnection().getIncomingMessageQueue().notifyOfExternalReceive(piece);
            }

            public void receivedBye(String reason) {
                this.connectionError(new JPCException("download cache server said goodbye: " + reason));
            }

            public void receivedError(int peer_id, String reason) {
                Peer peer = (Peer)PeerControllerImpl.this.peers_uploading.remove(new Integer(peer_id));
                if (peer != null) {
                    PeerControllerImpl.this.jpc_plugin.log("Download cache server reported [" + reason + "] error for uploading peer #" + peer_id + ", dropping " + peer.getIp() + ":" + peer.getPort(), 2);
                }
            }

            public void connectionError(JPCException error) {
                PeerControllerImpl.this.jpc_plugin.log("[D] connectionError thrown: " + error.getMessage(), 2);
                if (temp[0] != null) {
                    temp[0].closeConnection();
                    temp[0] = null;
                }
                PeerControllerImpl.this.dropDownloadCacheSession();
            }
        });
    }

    public void dropDownloadCacheSession() {
        if (this.download_cache != null) {
            this.download_cache.closeConnection();
            this.download_cache = null;
        }
    }
}

