/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.network.RawMessage;

public class JPCRawMessageImpl
implements RawMessage {
    private final Message base_message;
    private final ByteBuffer[] raw_payload;

    public JPCRawMessageImpl(Message base_msg, byte jpc_id) {
        this.base_message = base_msg;
        ByteBuffer[] base_payload = base_msg.getPayload();
        int base_payload_size = 0;
        for (int i = 0; i < base_payload.length; ++i) {
            base_payload_size += base_payload[i].remaining();
        }
        ByteBuffer header = ByteBuffer.allocate(5);
        header.putInt(base_payload_size + 1);
        header.put(jpc_id);
        header.flip();
        this.raw_payload = new ByteBuffer[base_payload.length + 1];
        this.raw_payload[0] = header;
        for (int i = 0; i < base_payload.length; ++i) {
            this.raw_payload[i + 1] = base_payload[i];
        }
    }

    public String getID() {
        return this.base_message.getID();
    }

    public int getType() {
        return this.base_message.getType();
    }

    public String getDescription() {
        return this.base_message.getDescription();
    }

    public ByteBuffer[] getPayload() {
        return this.base_message.getPayload();
    }

    public Message create(ByteBuffer data) throws MessageException {
        return this.base_message.create(data);
    }

    public void destroy() {
        this.base_message.destroy();
    }

    public ByteBuffer[] getRawPayload() {
        return this.raw_payload;
    }

    public Message getOriginalMessage() {
        return this.base_message;
    }
}

