/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCacheMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class JPCPiece
implements JPCCacheMessage {
    private final String description;
    private final ByteBuffer[] buffer;
    private final int session_id;
    private final byte[] infohash;
    private final int piece_number;
    private final int piece_offset;

    public JPCPiece(int session_id, byte[] infohash, int piece_number, int piece_offset, ByteBuffer data) {
        this.session_id = session_id;
        this.infohash = infohash;
        this.piece_number = piece_number;
        this.piece_offset = piece_offset;
        this.description = this.getID() + " for session id# " + session_id + " infohash " + StaticUtilities.getFormatters().formatByteArray(infohash, true) + " piece #" + piece_number + ": " + piece_offset + "->" + (piece_offset + data.remaining() - 1);
        ByteBuffer header = ByteBuffer.allocate(32);
        header.putInt(session_id);
        header.put(infohash);
        header.putInt(piece_number);
        header.putInt(piece_offset);
        header.flip();
        this.buffer = new ByteBuffer[]{header, data};
    }

    public int getSessionID() {
        return this.session_id;
    }

    public byte[] getInfohash() {
        return this.infohash;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getPieceOffset() {
        return this.piece_offset;
    }

    public ByteBuffer getPieceData() {
        return this.buffer[1];
    }

    public String getID() {
        return "JPC_PIECE";
    }

    public byte getVersion() {
        return 1;
    }

    public int getType() {
        return 1;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteBuffer[] getPayload() {
        return this.buffer;
    }

    public void destroy() {
    }

    public Message create(ByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: data == null");
        }
        if (data.remaining() < 32) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: payload.remaining[" + data.remaining() + "] < 32");
        }
        int id = data.getInt();
        byte[] hash = new byte[20];
        data.get(hash);
        int number = data.getInt();
        if (number < 0) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: number < 0");
        }
        int offset = data.getInt();
        if (offset < 0) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: offset < 0");
        }
        return new JPCPiece(id, hash, number, offset, data);
    }
}

