/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCMessageFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.MessageStreamDecoder;
import org.gudy.azureus2.plugins.network.Transport;

public class JPCMessageDecoder
implements MessageStreamDecoder {
    private static final int MIN_MESSAGE_LENGTH = 1;
    private static final int MAX_MESSAGE_LENGTH = 65536;
    private ByteBuffer payload_buffer = null;
    private final ByteBuffer length_buffer = ByteBuffer.allocate(4);
    private final ByteBuffer[] decode_array = new ByteBuffer[]{this.payload_buffer, this.length_buffer};
    private boolean reading_length_mode = true;
    private int message_length;
    private int pre_read_start_buffer;
    private int pre_read_start_position;
    private boolean destroyed = false;
    private ArrayList messages_last_read = new ArrayList();
    private int protocol_bytes_last_read = 0;
    private int data_bytes_last_read = 0;
    private int data_bytes_owed = 0;

    public int performStreamDecode(Transport transport, int max_bytes) throws IOException {
        int bytes_remaining;
        int bytes_read;
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        for (bytes_remaining = max_bytes; bytes_remaining > 0; bytes_remaining -= bytes_read) {
            if (this.destroyed) {
                System.out.println("JPC decoder already destroyed");
                break;
            }
            int bytes_possible = this.preReadProcess(bytes_remaining);
            if (bytes_possible < 1) {
                System.out.println("ERROR: JPC bytes_possible < 1");
                break;
            }
            if (this.reading_length_mode) {
                transport.read(this.decode_array, 1, 1);
            } else {
                transport.read(this.decode_array, 0, 2);
            }
            bytes_read = this.postReadProcess();
            if (bytes_read >= bytes_possible) continue;
            break;
        }
        return max_bytes - bytes_remaining;
    }

    public Message[] removeDecodedMessages() {
        if (this.messages_last_read.isEmpty()) {
            return null;
        }
        Message[] msgs = this.messages_last_read.toArray(new Message[0]);
        this.messages_last_read.clear();
        return msgs;
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    public ByteBuffer destroy() {
        this.destroyed = true;
        int lbuff_read = 0;
        int pbuff_read = 0;
        this.length_buffer.limit(4);
        if (this.reading_length_mode) {
            lbuff_read = this.length_buffer.position();
        } else {
            this.length_buffer.position(4);
            lbuff_read = 4;
            pbuff_read = this.payload_buffer == null ? 0 : this.payload_buffer.position();
        }
        ByteBuffer unused = ByteBuffer.allocate(lbuff_read + pbuff_read);
        this.length_buffer.flip();
        unused.put(this.length_buffer);
        if (this.payload_buffer != null) {
            this.payload_buffer.flip();
            unused.put(this.payload_buffer);
        }
        unused.flip();
        for (int i = 0; i < this.messages_last_read.size(); ++i) {
            Message msg = (Message)this.messages_last_read.get(i);
            msg.destroy();
        }
        this.messages_last_read.clear();
        return unused;
    }

    private int preReadProcess(int allowed) {
        if (allowed < 1) {
            System.out.println("JPC allowed < 1");
        }
        this.decode_array[0] = this.payload_buffer;
        int bytes_available = 0;
        boolean shrink_remaining_buffers = false;
        int start_buff = this.reading_length_mode ? 1 : 0;
        boolean marked = false;
        for (int i = start_buff; i < 2; ++i) {
            ByteBuffer bb = this.decode_array[i];
            if (bb == null) {
                System.out.println("JPC preReadProcess:: bb[" + i + "] == null, decoder destroyed=" + this.destroyed);
            }
            if (shrink_remaining_buffers) {
                bb.limit(0);
                continue;
            }
            int remaining = bb.remaining();
            if (remaining < 1) continue;
            if (!marked) {
                this.pre_read_start_buffer = i;
                this.pre_read_start_position = bb.position();
                marked = true;
            }
            if (remaining > allowed) {
                bb.limit(bb.position() + allowed);
                bytes_available += bb.remaining();
                shrink_remaining_buffers = true;
                continue;
            }
            bytes_available += remaining;
            allowed -= remaining;
        }
        return bytes_available;
    }

    private int postReadProcess() throws IOException {
        int read;
        int bytes_read = 0;
        if (!this.reading_length_mode && !this.destroyed) {
            this.payload_buffer.limit(this.message_length);
            this.length_buffer.limit(4);
            read = this.payload_buffer.position() - this.pre_read_start_position;
            bytes_read += read;
            if (!this.payload_buffer.hasRemaining()) {
                this.payload_buffer.position(0);
                try {
                    Message msg = JPCMessageFactory.createJPCMessage(this.payload_buffer);
                    this.messages_last_read.add(msg);
                    if (msg.getType() == 1) {
                        this.data_bytes_owed += this.message_length;
                    }
                }
                catch (MessageException me) {
                    throw new IOException("JPC message decode failed: " + me.getMessage());
                }
                this.payload_buffer = null;
                this.reading_length_mode = true;
            }
        }
        if (this.reading_length_mode && !this.destroyed) {
            this.length_buffer.limit(4);
            read = this.pre_read_start_buffer == 1 ? this.length_buffer.position() - this.pre_read_start_position : this.length_buffer.position();
            bytes_read += read;
            if (!this.length_buffer.hasRemaining()) {
                this.reading_length_mode = false;
                this.length_buffer.position(0);
                this.message_length = this.length_buffer.getInt();
                this.length_buffer.position(0);
                if (this.message_length < 1 || this.message_length > 65536) {
                    throw new IOException("Invalid message length given for JPC message decode: " + this.message_length);
                }
                this.payload_buffer = ByteBuffer.allocate(this.message_length);
            }
        }
        if (bytes_read < this.data_bytes_owed) {
            this.data_bytes_last_read += bytes_read;
            this.data_bytes_owed -= bytes_read;
        } else {
            this.data_bytes_last_read += this.data_bytes_owed;
            this.data_bytes_owed = 0;
            this.protocol_bytes_last_read += bytes_read - this.data_bytes_owed;
        }
        return bytes_read;
    }

    public void pauseDecoding() {
    }

    public void resumeDecoding() {
    }
}

