/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.webseed;

import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderFactory;
import com.aelitis.azureus.plugins.extseed.impl.webseed.ExternalSeedReaderWebSeed;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderFactoryWebSeed
implements ExternalSeedReaderFactory {
    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download) {
        Torrent torrent = download.getTorrent();
        try {
            Object obj = torrent.getAdditionalProperty("httpseeds");
            if (obj instanceof List) {
                List urls = (List)obj;
                ArrayList<ExternalSeedReaderWebSeed> readers = new ArrayList<ExternalSeedReaderWebSeed>();
                for (int i = 0; i < urls.size(); ++i) {
                    try {
                        URL url = new URL(new String((byte[])urls.get(i)));
                        String protocol = url.getProtocol().toLowerCase();
                        plugin.log(download.getName() + ": WS found seed: " + url);
                        if (protocol.equals("http")) {
                            readers.add(new ExternalSeedReaderWebSeed(plugin, torrent, url));
                            continue;
                        }
                        plugin.log(download.getName() + ": WS unsupported protocol: " + url);
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                ExternalSeedReader[] res = new ExternalSeedReader[readers.size()];
                readers.toArray(res);
                return res;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new ExternalSeedReader[0];
    }

    public static void main(String[] args) {
        try {
            File file = new File("C:\\temp\\test.torrent");
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(file);
            Map map = torrent.serialiseToMap();
            ArrayList<String> urls = new ArrayList<String>();
            urls.add("http://192.168.1.2:8080/test.dat");
            map.put("httpseeds", urls);
            torrent = TOTorrentFactory.deserialiseFromMap(map);
            torrent.serialiseToBEncodedFile(file);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

