/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTHave
implements BTMessage {
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final int piece_number;

    public BTHave(int piece_number) {
        this.piece_number = piece_number;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public String getID() {
        return "BT_HAVE";
    }

    public String getFeatureID() {
        return "BT1";
    }

    public int getFeatureSubID() {
        return 4;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_HAVE piece #" + this.piece_number;
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)17, 4);
            this.buffer.putInt((byte)11, this.piece_number);
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 4) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 4");
        }
        int number = data.getInt((byte)11);
        if (number < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: number < 0");
        }
        data.returnToPool();
        return new BTHave(number);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

