/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageFactory;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class MessageManager {
    private static final MessageManager instance = new MessageManager();
    private final HashMap message_registrations = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("MessageManager");

    private MessageManager() {
    }

    public static MessageManager getSingleton() {
        return instance;
    }

    public void initialize() {
        AZMessageFactory.init();
        BTMessageFactory.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageType(Message message) throws MessageException {
        try {
            this.this_mon.enter();
            if (this.message_registrations.containsKey(message.getID())) {
                throw new MessageException("message type [" + message.getID() + "] already registered!");
            }
            this.message_registrations.put(message.getID(), message);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMessageType(Message message) {
        try {
            this.this_mon.enter();
            this.message_registrations.remove(message.getID());
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Message createMessage(String id, DirectByteBuffer message_data) throws MessageException {
        Message message = (Message)this.message_registrations.get(id);
        if (message == null) {
            throw new MessageException("message id[" + id + "] not registered");
        }
        return message.deserialize(message_data);
    }

    public Message lookupMessage(String id) {
        return (Message)this.message_registrations.get(id);
    }

    public Message[] getRegisteredMessages() {
        return this.message_registrations.values().toArray(new Message[this.message_registrations.size()]);
    }
}

