/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.TCPTransport;
import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.ConnectDisconnectManager;
import com.aelitis.azureus.core.networkmanager.impl.ProxyLoginHandler;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportStats;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;

public class TCPTransportImpl
implements TCPTransport {
    private static final LogIDs LOGID = LogIDs.NET;
    protected TCPTransportHelperFilter filter;
    protected volatile boolean is_ready_for_write = false;
    protected volatile boolean is_ready_for_read = false;
    protected Throwable write_select_failure = null;
    protected Throwable read_select_failure = null;
    private ConnectDisconnectManager.ConnectListener connect_request_key = null;
    private String description = "<disconnected>";
    private ByteBuffer data_already_read = null;
    private final boolean is_inbound_connection;
    private int transport_mode = 0;
    public volatile boolean has_been_closed = false;
    private static final TransportStats stats = null;
    private boolean connect_with_crypto;
    private byte[] shared_secret;
    private int fallback_count;
    private final boolean fallback_allowed;

    public TCPTransportImpl(boolean use_crypto, boolean allow_fallback, byte[] _shared_secret) {
        this.filter = null;
        this.is_inbound_connection = false;
        this.connect_with_crypto = use_crypto;
        this.shared_secret = _shared_secret;
        this.fallback_allowed = allow_fallback;
    }

    public TCPTransportImpl(TCPTransportHelperFilter filter, ByteBuffer already_read) {
        this.filter = filter;
        this.data_already_read = already_read;
        this.is_inbound_connection = true;
        this.connect_with_crypto = false;
        this.fallback_allowed = false;
        this.description = (this.is_inbound_connection ? "R" : "L") + ": " + filter.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + filter.getSocketChannel().socket().getPort();
        this.registerSelectHandling();
    }

    public void setAlreadyRead(ByteBuffer bytes_already_read) {
        if (bytes_already_read != null && bytes_already_read.hasRemaining()) {
            this.data_already_read = bytes_already_read;
        }
    }

    public SocketChannel getSocketChannel() {
        return this.filter.getSocketChannel();
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReadyForWrite() {
        return this.is_ready_for_write;
    }

    public boolean isReadyForRead() {
        return this.is_ready_for_read;
    }

    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.write_select_failure != null) {
            throw new IOException("write_select_failure: " + this.write_select_failure.getMessage());
        }
        long written = this.filter.write(buffers, array_offset, length);
        if (stats != null) {
            stats.bytesWritten((int)written);
        }
        if (written < 1L) {
            this.requestWriteSelect();
        }
        return written;
    }

    private void requestWriteSelect() {
        this.is_ready_for_write = false;
        if (this.filter != null) {
            NetworkManager.getSingleton().getWriteSelector().resumeSelects(this.filter.getSocketChannel());
        }
    }

    private void requestReadSelect() {
        this.is_ready_for_read = false;
        if (this.filter != null) {
            NetworkManager.getSingleton().getReadSelector().resumeSelects(this.filter.getSocketChannel());
        }
    }

    private void registerSelectHandling() {
        if (this.filter == null) {
            Debug.out("ERROR: registerSelectHandling():: socket_channel == null");
            return;
        }
        NetworkManager.getSingleton().getReadSelector().register(this.filter.getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){

            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                TCPTransportImpl.this.is_ready_for_read = true;
                return true;
            }

            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                TCPTransportImpl.this.read_select_failure = msg;
                TCPTransportImpl.this.is_ready_for_read = true;
            }
        }, null);
        NetworkManager.getSingleton().getWriteSelector().register(this.filter.getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){

            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                TCPTransportImpl.this.is_ready_for_write = true;
                return true;
            }

            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                TCPTransportImpl.this.write_select_failure = msg;
                TCPTransportImpl.this.is_ready_for_write = true;
            }
        }, null);
    }

    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.read_select_failure != null) {
            this.is_ready_for_read = false;
            throw new IOException("read_select_failure: " + this.read_select_failure.getMessage());
        }
        if (this.data_already_read != null) {
            int inserted = 0;
            for (int i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer bb = buffers[i];
                int orig_limit = this.data_already_read.limit();
                if (this.data_already_read.remaining() > bb.remaining()) {
                    this.data_already_read.limit(this.data_already_read.position() + bb.remaining());
                }
                inserted += this.data_already_read.remaining();
                bb.put(this.data_already_read);
                this.data_already_read.limit(orig_limit);
                if (this.data_already_read.hasRemaining()) continue;
                this.data_already_read = null;
                break;
            }
            if (!buffers[array_offset + length - 1].hasRemaining()) {
                return inserted;
            }
        }
        long bytes_read = this.filter.read(buffers, array_offset, length);
        if (stats != null) {
            stats.bytesRead((int)bytes_read);
        }
        if (bytes_read == 0L) {
            this.requestReadSelect();
        }
        return bytes_read;
    }

    public void establishOutboundConnection(final InetSocketAddress address, final TCPTransport.ConnectListener listener) {
        ConnectDisconnectManager.ConnectListener connect_listener;
        if (this.has_been_closed) {
            return;
        }
        if (this.filter != null) {
            Debug.out("socket_channel != null");
            listener.connectSuccess();
            return;
        }
        final boolean use_proxy = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable");
        final TCPTransportImpl transport_instance = this;
        this.connect_request_key = connect_listener = new ConnectDisconnectManager.ConnectListener(){

            public void connectAttemptStarted() {
                listener.connectAttemptStarted();
            }

            public void connectSuccess(SocketChannel channel) {
                if (channel == null) {
                    String msg = "connectSuccess:: given channel == null";
                    Debug.out(msg);
                    listener.connectFailure(new Exception(msg));
                    return;
                }
                if (TCPTransportImpl.this.has_been_closed) {
                    NetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(channel);
                    return;
                }
                TCPTransportImpl.this.connect_request_key = null;
                TCPTransportImpl.this.description = (TCPTransportImpl.this.is_inbound_connection ? "R" : "L") + ": " + channel.socket().getInetAddress().getHostAddress() + ": " + channel.socket().getPort();
                if (use_proxy) {
                    Logger.log(new LogEvent(LOGID, "Socket connection established to proxy server [" + TCPTransportImpl.this.description + "], login initiated..."));
                    TCPTransportImpl.this.filter = TCPTransportHelperFilterFactory.createTransparentFilter(channel);
                    new ProxyLoginHandler(transport_instance, address, new ProxyLoginHandler.ProxyListener(this, channel){
                        private final /* synthetic */ SocketChannel val$channel;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$channel = val$channel;
                        }

                        public void connectSuccess() {
                            Logger.log(new LogEvent(TCPTransportImpl.access$300(), "Proxy [" + TCPTransportImpl.access$100(3.access$400(this.this$1)) + "] login successful."));
                            3.access$400(this.this$1).handleCrypto(3.access$500(this.this$1), this.val$channel, 3.access$600(this.this$1));
                        }

                        public void connectFailure(Throwable failure_msg) {
                            NetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(this.val$channel);
                            3.access$600(this.this$1).connectFailure(failure_msg);
                        }
                    });
                } else {
                    TCPTransportImpl.this.handleCrypto(address, channel, listener);
                }
            }

            public void connectFailure(Throwable failure_msg) {
                TCPTransportImpl.this.connect_request_key = null;
                listener.connectFailure(failure_msg);
            }

            static /* synthetic */ TCPTransportImpl access$400(3 x0) {
                return x0.TCPTransportImpl.this;
            }

            static /* synthetic */ InetSocketAddress access$500(3 x0) {
                return x0.address;
            }

            static /* synthetic */ TCPTransport.ConnectListener access$600(3 x0) {
                return x0.listener;
            }
        };
        InetSocketAddress to_connect = use_proxy ? ProxyLoginHandler.SOCKS_SERVER_ADDRESS : address;
        NetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(to_connect, connect_listener);
    }

    protected void handleCrypto(final InetSocketAddress address, final SocketChannel channel, final TCPTransport.ConnectListener listener) {
        if (this.connect_with_crypto) {
            TransportCryptoManager.getSingleton().manageCrypto(channel, this.shared_secret, false, new TransportCryptoManager.HandshakeListener(){

                public void handshakeSuccess(TCPTransportHelperFilter _filter) {
                    TCPTransportImpl.this.filter = _filter;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + channel.socket().getRemoteSocketAddress() + " established, type = " + TCPTransportImpl.this.filter.getName()));
                    }
                    TCPTransportImpl.this.registerSelectHandling();
                    listener.connectSuccess();
                }

                public void handshakeFailure(Throwable failure_msg) {
                    if (TCPTransportImpl.this.fallback_allowed && NetworkManager.OUTGOING_HANDSHAKE_FALLBACK_ALLOWED) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, TCPTransportImpl.this.description + " | crypto handshake failure [" + failure_msg.getMessage() + "], attempting non-crypto fallback."));
                        }
                        TCPTransportImpl.this.connect_with_crypto = false;
                        TCPTransportImpl.this.fallback_count++;
                        NetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(channel);
                        TCPTransportImpl.this.close();
                        TCPTransportImpl.this.has_been_closed = false;
                        TCPTransportImpl.this.establishOutboundConnection(address, listener);
                    } else {
                        NetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(channel);
                        listener.connectFailure(failure_msg);
                    }
                }

                public int getMaximumPlainHeaderLength() {
                    throw new RuntimeException();
                }

                public int matchPlainHeader(ByteBuffer buffer) {
                    throw new RuntimeException();
                }
            });
        } else {
            this.filter = TCPTransportHelperFilterFactory.createTransparentFilter(channel);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + channel.socket().getRemoteSocketAddress() + " established, type = " + this.filter.getName() + ", fallback = " + (this.fallback_count == 0 ? "no" : "yes")));
            }
            this.registerSelectHandling();
            listener.connectSuccess();
        }
    }

    private void setTransportBuffersSize(int size_in_bytes) {
        if (this.filter == null) {
            Debug.out("socket_channel == null");
            return;
        }
        try {
            this.filter.getSocketChannel().socket().setSendBufferSize(size_in_bytes);
            this.filter.getSocketChannel().socket().setReceiveBufferSize(size_in_bytes);
            int snd_real = this.filter.getSocketChannel().socket().getSendBufferSize();
            int rcv_real = this.filter.getSocketChannel().socket().getReceiveBufferSize();
            Logger.log(new LogEvent(LOGID, "Setting new transport [" + this.description + "] buffer sizes: SND=" + size_in_bytes + " [" + snd_real + "] , RCV=" + size_in_bytes + " [" + rcv_real + "]"));
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    public void setTransportMode(int mode) {
        if (mode == this.transport_mode) {
            return;
        }
        switch (mode) {
            case 0: {
                this.setTransportBuffersSize(8192);
                break;
            }
            case 1: {
                this.setTransportBuffersSize(65536);
                break;
            }
            case 2: {
                this.setTransportBuffersSize(524288);
                break;
            }
            default: {
                Debug.out("invalid transport mode given: " + mode);
            }
        }
        this.transport_mode = mode;
    }

    public int getTransportMode() {
        return this.transport_mode;
    }

    public String getEncryption() {
        return this.filter == null ? "" : this.filter.getName();
    }

    public void close() {
        this.has_been_closed = true;
        if (this.connect_request_key != null) {
            NetworkManager.getSingleton().getConnectDisconnectManager().cancelRequest(this.connect_request_key);
        }
        this.is_ready_for_read = false;
        this.is_ready_for_write = false;
        if (this.filter != null) {
            NetworkManager.getSingleton().getReadSelector().cancel(this.filter.getSocketChannel());
            NetworkManager.getSingleton().getWriteSelector().cancel(this.filter.getSocketChannel());
            NetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(this.filter.getSocketChannel());
            this.filter = null;
        }
    }
}

