/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerUploader
implements RateControlledEntity {
    private final NetworkConnection connection;
    private final RateHandler rate_handler;

    public SinglePeerUploader(NetworkConnection connection, RateHandler rate_handler) {
        this.connection = connection;
        this.rate_handler = rate_handler;
    }

    public boolean canProcess() {
        if (!this.connection.getTCPTransport().isReadyForWrite()) {
            return false;
        }
        if (this.connection.getOutgoingMessageQueue().getTotalSize() < 1) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public boolean doProcessing() {
        if (!this.connection.getTCPTransport().isReadyForWrite()) {
            Debug.out("dW:not ready");
            return false;
        }
        int num_bytes_allowed = this.rate_handler.getCurrentNumBytesAllowed();
        if (num_bytes_allowed < 1) {
            return false;
        }
        int num_bytes_available = this.connection.getOutgoingMessageQueue().getTotalSize();
        if (num_bytes_available < 1) {
            Debug.out("dW:not avail");
            return false;
        }
        int num_bytes_to_write = num_bytes_allowed > num_bytes_available ? num_bytes_available : num_bytes_allowed;
        int written = 0;
        try {
            written = this.connection.getOutgoingMessageQueue().deliverToTransport(num_bytes_to_write, false);
        }
        catch (Throwable e) {
            this.connection.notifyOfException(e);
            return false;
        }
        if (written < 1) {
            return false;
        }
        this.rate_handler.bytesProcessed(written);
        return true;
    }

    public int getPriority() {
        return 0;
    }
}

