/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class DHTUDPPacketReply
extends PRUDPPacketReply
implements DHTUDPPacket {
    public static final int DHT_HEADER_SIZE = 22;
    private DHTTransportUDPImpl transport;
    private long connection_id;
    private byte protocol_version;
    private int network;
    private int target_instance_id;
    private long skew;
    public static final int VIVALDI_DATA_LENGTH = 4;
    public static final int VIVALDI_DATA_LENGTH_V1 = 4;
    private float[] vivaldi_data;

    public DHTUDPPacketReply(DHTTransportUDPImpl _transport, int _type, int _trans_id, long _conn_id, DHTTransportContact _local_contact, DHTTransportContact _remote_contact) {
        super(_type, _trans_id);
        this.transport = _transport;
        this.connection_id = _conn_id;
        this.protocol_version = _remote_contact.getProtocolVersion();
        if (this.protocol_version > _transport.getProtocolVersion()) {
            Debug.out("Trimming protocol version");
            this.protocol_version = _transport.getProtocolVersion();
        }
        this.target_instance_id = _local_contact.getInstanceID();
        this.skew = _local_contact.getClockSkew();
    }

    protected DHTUDPPacketReply(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, int type, int trans_id) throws IOException {
        super(type, trans_id);
        this.connection_id = is.readLong();
        this.protocol_version = is.readByte();
        if (this.protocol_version < 8) {
            throw new IOException("Invalid DHT protocol version, please update Azureus");
        }
        if (this.protocol_version >= 9) {
            this.network = is.readInt();
        }
        this.transport = network_handler.getTransport(this);
        this.target_instance_id = is.readInt();
    }

    public DHTTransportUDPImpl getTransport() {
        return this.transport;
    }

    protected int getTargetInstanceID() {
        return this.target_instance_id;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    protected long getClockSkew() {
        return this.skew;
    }

    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int _network) {
        this.network = _network;
    }

    protected float[] getVivaldiData() {
        return this.vivaldi_data;
    }

    protected void setVivaldiData(float[] data) {
        this.vivaldi_data = data;
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeLong(this.connection_id);
        os.writeByte(this.protocol_version);
        if (this.protocol_version >= 9) {
            os.writeInt(this.network);
        }
        os.writeInt(this.target_instance_id);
    }

    public String getString() {
        return super.getString() + ",[con=" + this.connection_id + "]";
    }
}

