/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.systray;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.List;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SelectableSpeedMenu;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class SystemTraySWT {
    Display display;
    UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
    Tray tray;
    TrayItem trayItem;
    Menu menu;

    public SystemTraySWT() {
        this.display = SWTThread.getInstance().getDisplay();
        this.tray = this.display.getSystemTray();
        this.trayItem = new TrayItem(this.tray, 0);
        this.trayItem.setImage(ImageRepository.getImage("azureus"));
        this.trayItem.setVisible(true);
        this.menu = new Menu((Decorations)this.uiFunctions.getMainShell(), 8);
        MenuItem itemShow = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemShow, "SystemTray.menu.show");
        new MenuItem(this.menu, 2);
        MenuItem itemCloseAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemCloseAll, "SystemTray.menu.closealldownloadbars");
        new MenuItem(this.menu, 2);
        this.createUploadLimitMenu(this.menu);
        this.createDownloadLimitMenu(this.menu);
        new MenuItem(this.menu, 2);
        MenuItem itemStartAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemStartAll, "SystemTray.menu.startalltransfers");
        MenuItem itemStopAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemStopAll, "SystemTray.menu.stopalltransfers");
        final MenuItem itemPause = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemPause, "SystemTray.menu.pausetransfers");
        final MenuItem itemResume = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemResume, "SystemTray.menu.resumetransfers");
        new MenuItem(this.menu, 2);
        MenuItem itemExit = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemExit, "SystemTray.menu.exit");
        itemShow.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.showMainWindow();
            }
        });
        itemStartAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                AzureusCoreFactory.getSingleton().getGlobalManager().startAllDownloads();
            }
        });
        itemStopAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncStopAll();
            }
        });
        itemPause.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncPause();
            }
        });
        itemResume.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                AzureusCoreFactory.getSingleton().getGlobalManager().resumeDownloads();
            }
        });
        this.menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent _menu) {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                itemPause.setEnabled(gm.canPauseDownloads());
                itemResume.setEnabled(gm.canResumeDownloads());
            }

            public void menuHidden(MenuEvent _menu) {
            }
        });
        itemCloseAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.uiFunctions.closeDownloadBars();
            }
        });
        itemExit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.uiFunctions.requestShutdown();
            }
        });
        this.trayItem.addListener(14, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.showMainWindow();
            }
        });
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.menu.setVisible(true);
            }
        });
    }

    private final void createUploadLimitMenu(Menu parent) {
        MenuItem uploadSpeedItem = new MenuItem(parent, 64);
        uploadSpeedItem.setText(MessageText.getString("GeneralView.label.maxuploadspeed"));
        final Menu uploadSpeedMenu = new Menu((Decorations)this.uiFunctions.getMainShell(), 4);
        uploadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                SelectableSpeedMenu.generateMenuItems(uploadSpeedMenu, core, core.getGlobalManager(), true);
            }
        });
        uploadSpeedItem.setMenu(uploadSpeedMenu);
    }

    private final void createDownloadLimitMenu(Menu parent) {
        MenuItem downloadSpeedItem = new MenuItem(parent, 64);
        downloadSpeedItem.setText(MessageText.getString("GeneralView.label.maxdownloadspeed"));
        final Menu downloadSpeedMenu = new Menu((Decorations)this.uiFunctions.getMainShell(), 4);
        downloadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                SelectableSpeedMenu.generateMenuItems(downloadSpeedMenu, core, core.getGlobalManager(), false);
            }
        });
        downloadSpeedItem.setMenu(downloadSpeedMenu);
    }

    public void dispose() {
        if (this.trayItem != null && !this.trayItem.isDisposed()) {
            this.trayItem.dispose();
        }
    }

    public void update() {
        if (this.trayItem.isDisposed()) {
            return;
        }
        List managers = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
        StringBuffer toolTip = new StringBuffer();
        int seeding = 0;
        int downloading = 0;
        for (int i = 0; i < managers.size(); ++i) {
            DownloadManager manager = (DownloadManager)managers.get(i);
            int state = manager.getState();
            if (state == 50) {
                ++downloading;
            }
            if (state != 60) continue;
            ++seeding;
        }
        String seeding_text = MessageText.getString("SystemTray.tooltip.seeding").replaceAll("%1", "" + seeding);
        String downloading_text = MessageText.getString("SystemTray.tooltip.downloading").replaceAll("%1", "" + downloading);
        if (!downloading_text.startsWith(" ")) {
            downloading_text = " " + downloading_text;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        toolTip.append(seeding_text).append(downloading_text).append("\n");
        toolTip.append(MessageText.getString("ConfigView.download.abbreviated")).append(" ");
        toolTip.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(gm.getStats().getDataReceiveRate() + gm.getStats().getProtocolReceiveRate()));
        toolTip.append(", ").append(MessageText.getString("ConfigView.upload.abbreviated")).append(" ");
        toolTip.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(gm.getStats().getDataSendRate() + gm.getStats().getProtocolSendRate()));
        this.trayItem.setToolTipText(toolTip.toString());
        this.trayItem.setVisible(true);
    }

    private void showMainWindow() {
        this.uiFunctions.bringToFront();
    }

    public void updateLanguage() {
        if (this.menu != null) {
            Messages.updateLanguageForControl((Widget)this.menu);
        }
        this.update();
    }
}

