/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfaceDisplay
implements UISWTConfigSection {
    private static final String MSG_PREFIX = "ConfigView.section.style.";
    private static final String LBLKEY_PREFIX = "ConfigView.label.";

    public String configSectionGetParentSection() {
        return "style";
    }

    public String configSectionGetName() {
        return "display";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cLook = new Composite(parent, 0);
        cLook.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cLook.setLayout((Layout)layout);
        BooleanParameter bpCustomTab = new BooleanParameter(cLook, "useCustomTab", true, "ConfigView.section.style.useCustomTabs");
        Control cFancyTab = new BooleanParameter(cLook, "GUI_SWT_bFancyTab", true, "ConfigView.section.style.useFancyTabs").getControl();
        Control[] controls = new Control[]{cFancyTab};
        bpCustomTab.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(controls));
        new BooleanParameter(cLook, "Show Download Basket", false, "ConfigView.section.style.showdownloadbasket");
        new BooleanParameter(cLook, "IconBar.enabled", false, "ConfigView.section.style.showiconbar");
        Composite cStatusBar = new Composite(cLook, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 5;
        cStatusBar.setLayout((Layout)layout);
        cStatusBar.setLayoutData((Object)new GridData());
        Label label = new Label(cStatusBar, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.status");
        new BooleanParameter(cStatusBar, "Status Area Show SR", true, "ConfigView.section.style.status.show_sr");
        new BooleanParameter(cStatusBar, "Status Area Show NAT", true, "ConfigView.section.style.status.show_nat");
        new BooleanParameter(cStatusBar, "Status Area Show DDB", true, "ConfigView.section.style.status.show_ddb");
        new BooleanParameter(cLook, "Add URL Silently", false, "ConfigView.section.style.addurlsilently");
        new BooleanParameter(cLook, "add_torrents_silently", false, "ConfigView.section.interface.display.add_torrents_silently");
        if (Constants.isWindowsXP) {
            final Button enableXPStyle = new Button(cLook, 32);
            Messages.setLanguageText((Widget)enableXPStyle, "ConfigView.section.style.enableXPStyle");
            boolean enabled = false;
            boolean valid = false;
            try {
                File f = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                if (f.exists()) {
                    enabled = true;
                }
                if ((f = FileUtil.getApplicationFile("javaw.exe.manifest")).exists()) {
                    valid = true;
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                valid = false;
            }
            enableXPStyle.setEnabled(valid);
            enableXPStyle.setSelection(enabled);
            enableXPStyle.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (enableXPStyle.getSelection()) {
                        try {
                            File fDest = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                            File fOrigin = new File("javaw.exe.manifest");
                            if (!fDest.exists() && fOrigin.exists()) {
                                FileUtil.copyFile(fOrigin, fDest);
                            }
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    } else {
                        try {
                            File fDest = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                            fDest.delete();
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            });
        }
        if (Utils.isGTK) {
            new BooleanParameter(cLook, "SWT_bGTKTableBug", true, "ConfigView.section.style.verticaloffset");
        }
        if (Constants.isOSX) {
            new BooleanParameter(cLook, "enable_small_osx_fonts", true, "ConfigView.section.style.osx_small_fonts");
        }
        new BooleanParameter(cLook, "GUI_SWT_bAlternateTablePainting", "ConfigView.section.style.alternateTablePainting");
        new BooleanParameter(cLook, "config.style.useSIUnits", false, "ConfigView.section.style.useSIUnits");
        new BooleanParameter(cLook, "config.style.useUnitsRateBits", false, "ConfigView.section.style.useUnitsRateBits");
        new BooleanParameter(cLook, "config.style.doNotUseGB", false, "ConfigView.section.style.doNotUseGB");
        new BooleanParameter(cLook, "config.style.dataStatsOnly", false, "ConfigView.section.style.dataStatsOnly");
        new BooleanParameter(cLook, "config.style.separateProtDataStats", false, "ConfigView.section.style.separateProtDataStats");
        Composite cArea = new Composite(cLook, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData());
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.guiUpdate");
        int[] values = new int[]{100, 250, 500, 1000, 2000, 5000, 10000, 15000};
        String[] labels = new String[]{"100 ms", "250 ms", "500 ms", "1 s", "2 s", "5 s", "10 s", "15 s"};
        new IntListParameter(cArea, "GUI Refresh", 1000, labels, values);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.graphicsUpdate");
        GridData gridData = new GridData();
        gridData.widthHint = 15;
        IntParameter graphicUpdate = new IntParameter(cArea, "Graphics Update", 1, -1, false, false);
        graphicUpdate.setLayoutData(gridData);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.reOrderDelay");
        gridData = new GridData();
        gridData.widthHint = 15;
        IntParameter reorderDelay = new IntParameter(cArea, "ReOrder Delay");
        reorderDelay.setLayoutData(gridData);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.defaultSortOrder");
        int[] sortOrderValues = new int[]{0, 1, 2};
        String[] sortOrderLabels = new String[]{MessageText.getString("ConfigView.section.style.defaultSortOrder.asc"), MessageText.getString("ConfigView.section.style.defaultSortOrder.desc"), MessageText.getString("ConfigView.section.style.defaultSortOrder.flip")};
        new IntListParameter(cArea, "config.style.table.defaultSortOrder", sortOrderLabels, sortOrderValues);
        BooleanParameter disable_sliding = new BooleanParameter(cArea, "GUI_SWT_DisableAlertSliding", "ConfigView.section.style.disableAlertSliding");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        disable_sliding.setLayoutData(gridData);
        BooleanParameter show_alert_timestamps = new BooleanParameter(cArea, "Show Timestamp For Alerts", false, "ConfigView.label.popup.timestamp");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        show_alert_timestamps.setLayoutData(gridData);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.popup.autohide");
        IntParameter auto_hide_alert = new IntParameter(cArea, "Message Popup Autoclose in Seconds", 0, 86400, true, false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 30;
        auto_hide_alert.setLayoutData(gridData);
        new BooleanParameter(cLook, "NameColumn.showProgramIcon", "ConfigView.section.style.showProgramIcon");
        return cLook;
    }
}

