/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.Constants;

public class ImageRepository {
    private static boolean NO_IMAGES = false;
    private static Display display;
    private static final HashMap imagesToPath;
    private static final HashMap images;
    private static final HashMap registry;
    private static final String[] noCacheExtList;
    private static final boolean doNotUseAWTIcon;
    static org.eclipse.swt.graphics.Image onlyOneImage;

    public static void loadImagesForSplashWindow(Display display) {
        ImageRepository.display = display;
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/a16.png", "azureus");
        ImageRepository.addPath("org/gudy/azureus2/ui/splash/azureus.jpg", "azureus_splash");
    }

    public static void loadImages(Display display) {
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/a32.png", "azureus32");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/a64.png", "azureus64");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/a128.png", "azureus128");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/Azureus_big.png", "tray");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/dragger.gif", "dragger");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/folder.gif", "folder");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/ipfilter.png", "ipfilter");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/start.gif", "start");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/stop.gif", "stop");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/bar.gif", "downloadBar");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/delete.gif", "delete");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/lock.gif", "lock");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/host.gif", "host");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/publish.gif", "publish");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/run.gif", "run");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/details.gif", "details");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/up.gif", "up");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/down.gif", "down");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/top.gif", "top");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/bottom.gif", "bottom");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/recheck.gif", "recheck");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/export.gif", "export");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/move.gif", "move");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/add_tracker.gif", "add_tracker");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/edit_trackers.gif", "edit_trackers");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/columns.gif", "columns");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/speed.gif", "speed");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/openFolder16x12.gif", "openFolderButton");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/forcestart.gif", "forcestart");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/greenled.gif", "greenled");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/redled.gif", "redled");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/yellowled.gif", "yellowled");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/grayled.gif", "grayled");
        imagesToPath.put("donation", "org/gudy/azureus2/ui/icons/donation.jpg");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/popup.png", "popup");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/error.gif", "error");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/info.gif", "info");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/warning.gif", "warning");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/subitem.gif", "subitem");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/open.gif", "cb_open");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/open_no_default.gif", "cb_open_no_default");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/open_folder.gif", "cb_open_folder");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/open_url.gif", "cb_open_url");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/new.gif", "cb_new");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/up.gif", "cb_up");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/down.gif", "cb_down");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/top.gif", "cb_top");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/bottom.gif", "cb_bottom");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/run.gif", "cb_run");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/start.gif", "cb_start");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/stop.gif", "cb_stop");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/remove.gif", "cb_remove");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/host.gif", "cb_host");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/publish.gif", "cb_publish");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/sendto.png", "cb_send");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/ok.gif", "st_ok");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/ko.gif", "st_ko");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/stopped.gif", "st_stopped");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/error.gif", "st_error");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/no_tracker.gif", "st_no_tracker");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/no_remote.gif", "st_no_remote");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/ok_shared.gif", "st_ok_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/ko_shared.gif", "st_ko_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/error_shared.gif", "st_error_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/stopped_shared.gif", "st_stopped_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/no_tracker_shared.gif", "st_no_tracker_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/no_remote_shared.gif", "st_no_remote_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/explain.gif", "st_explain");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/shared.gif", "st_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/statusbar/status_warning.gif", "sb_warning");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/smallx.png", "smallx");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/smallx-gray.png", "smallx-gray");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/sendto-small.png", "sendto-small");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/working.gif", "working");
    }

    private static void addPath(String path, String id) {
        imagesToPath.put(id, path);
    }

    private static org.eclipse.swt.graphics.Image loadImage(Display display, String res, String name) {
        return ImageRepository.loadImage(display, res, name, 255);
    }

    private static org.eclipse.swt.graphics.Image loadImage(Display display, String res, String name, int alpha) {
        return ImageRepository.loadImage(ImageRepository.class.getClassLoader(), display, res, name, alpha);
    }

    private static org.eclipse.swt.graphics.Image loadImage(ClassLoader loader, Display display, String res, String name, int alpha) {
        if (NO_IMAGES) {
            if (onlyOneImage == null) {
                onlyOneImage = new org.eclipse.swt.graphics.Image((Device)display, 1, 1);
            }
            return onlyOneImage;
        }
        imagesToPath.put(name, res);
        org.eclipse.swt.graphics.Image im = ImageRepository.getImage(name, false);
        if (null == im) {
            InputStream is = loader.getResourceAsStream(res);
            if (null != is) {
                try {
                    if (alpha == 255) {
                        im = new org.eclipse.swt.graphics.Image((Device)display, is);
                    } else {
                        ImageData icone = new ImageData(is);
                        icone.alpha = alpha;
                        im = new org.eclipse.swt.graphics.Image((Device)display, icone);
                    }
                    images.put(name, im);
                }
                catch (SWTException e) {
                    return null;
                }
            } else {
                System.out.println("ImageRepository:loadImage:: Resource not found: " + res);
                im = new org.eclipse.swt.graphics.Image((Device)display, 1, 1);
                images.put(name, im);
            }
        }
        return im;
    }

    public static void unLoadImages() {
        for (org.eclipse.swt.graphics.Image im : images.values()) {
            im.dispose();
        }
        for (org.eclipse.swt.graphics.Image im : registry.values()) {
            if (im == null) continue;
            im.dispose();
        }
    }

    public static org.eclipse.swt.graphics.Image getImage(String name) {
        if (NO_IMAGES) {
            if (onlyOneImage == null) {
                onlyOneImage = new org.eclipse.swt.graphics.Image((Device)display, 1, 1);
            }
            return onlyOneImage;
        }
        return ImageRepository.getImage(name, true);
    }

    public static InputStream getImageAsStream(String name) {
        String path = (String)imagesToPath.get(name);
        if (path == null) {
            System.out.println("ImageRepository: Unknown image name '" + name + "'");
            return null;
        }
        return ImageRepository.class.getClassLoader().getResourceAsStream(path);
    }

    private static org.eclipse.swt.graphics.Image getImage(String name, boolean allowLoading) {
        String path;
        org.eclipse.swt.graphics.Image result = (org.eclipse.swt.graphics.Image)images.get(name);
        if (allowLoading && result == null && (path = (String)imagesToPath.get(name)) != null) {
            return ImageRepository.loadImage(display, path, name);
        }
        return result;
    }

    public static org.eclipse.swt.graphics.Image getIconFromProgram(Program program) {
        org.eclipse.swt.graphics.Image image = null;
        try {
            ImageData imageData;
            image = (org.eclipse.swt.graphics.Image)images.get(program);
            if (image == null && program != null && (imageData = program.getImageData()) != null) {
                image = new org.eclipse.swt.graphics.Image(null, imageData);
                images.put(program, image);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (image == null) {
            image = ImageRepository.getImage("folder", true);
        }
        return image;
    }

    public static org.eclipse.swt.graphics.Image getFolderImage() {
        return ImageRepository.getImage("folder", true);
    }

    public static org.eclipse.swt.graphics.Image getPathIcon(String path) {
        if (path == null) {
            return null;
        }
        try {
            Object sfInstance;
            Method method;
            String key;
            File file = new File(path);
            if (file.isDirectory()) {
                if (doNotUseAWTIcon) {
                    return ImageRepository.getFolderImage();
                }
                key = file.getPath();
            } else {
                int lookIndex = file.getName().lastIndexOf(".");
                if (lookIndex == -1) {
                    if (doNotUseAWTIcon) {
                        return ImageRepository.getFolderImage();
                    }
                    key = "?!blank";
                } else {
                    String ext;
                    key = ext = file.getName().substring(lookIndex);
                    if (doNotUseAWTIcon) {
                        return ImageRepository.getIconFromProgram(Program.findProgram((String)ext));
                    }
                    for (int i = 0; i < noCacheExtList.length; ++i) {
                        if (!noCacheExtList[i].equalsIgnoreCase(ext)) continue;
                        key = file.getPath();
                        break;
                    }
                }
            }
            org.eclipse.swt.graphics.Image image = (org.eclipse.swt.graphics.Image)registry.get(key);
            if (image != null) {
                return image;
            }
            Image awtImage = null;
            Class<?> sfClass = Class.forName("sun.awt.shell.ShellFolder");
            if (sfClass != null && file != null && (method = sfClass.getMethod("getShellFolder", File.class)) != null && (sfInstance = method.invoke(null, file)) != null && (method = sfClass.getMethod("getIcon", Boolean.TYPE)) != null) {
                awtImage = (Image)method.invoke(sfInstance, new Boolean(false));
            }
            if (awtImage != null) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)awtImage), "png", outStream);
                ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                image = new org.eclipse.swt.graphics.Image(null, (InputStream)inStream);
                if (Constants.isWindows) {
                    org.eclipse.swt.graphics.Image dstImage = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), image.getBounds().width, image.getBounds().height);
                    GC gc = new GC((Drawable)dstImage);
                    gc.drawImage(image, 0, 0);
                    gc.dispose();
                    image.dispose();
                    image = dstImage;
                }
                registry.put(key, image);
                return image;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int fileSepIndex = path.lastIndexOf(File.separator);
        if (fileSepIndex == path.length() - 1) {
            return ImageRepository.getFolderImage();
        }
        int extIndex = fileSepIndex == -1 ? path.indexOf(46) : path.substring(fileSepIndex).indexOf(46);
        if (extIndex == -1) {
            return ImageRepository.getFolderImage();
        }
        return ImageRepository.getIconFromProgram(Program.findProgram((String)path.substring(extIndex)));
    }

    public static org.eclipse.swt.graphics.Image getImageWithSize(String name, Point canvasSize) {
        String key = new StringBuffer().append(name).append('.').append(canvasSize.x).append('.').append(canvasSize.y).toString();
        org.eclipse.swt.graphics.Image newImage = (org.eclipse.swt.graphics.Image)images.get(key);
        if (newImage == null) {
            org.eclipse.swt.graphics.Image oldImage = ImageRepository.getImage(name);
            if (oldImage == null) {
                return null;
            }
            newImage = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), canvasSize.x, canvasSize.y);
            GC gc = new GC((Drawable)newImage);
            int x = Math.max(0, (canvasSize.x - oldImage.getBounds().width) / 2);
            int y = Math.max(0, (canvasSize.y - oldImage.getBounds().height) / 2);
            gc.drawImage(oldImage, x, y);
            gc.dispose();
            images.put(key, newImage);
        }
        return newImage;
    }

    public static void unloadImage(String name) {
        org.eclipse.swt.graphics.Image img = (org.eclipse.swt.graphics.Image)images.get(name);
        if (img != null) {
            images.remove(name);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    public static void unloadPathIcon(String path) {
        String key = ImageRepository.getKey(path);
        org.eclipse.swt.graphics.Image img = (org.eclipse.swt.graphics.Image)registry.get(key);
        if (img != null) {
            registry.remove(key);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    private static String getKey(String path) {
        String key;
        File file = new File(path);
        if (file.isDirectory()) {
            key = file.getPath();
        } else {
            int lookIndex = file.getName().lastIndexOf(".");
            if (lookIndex == -1) {
                key = "?!blank";
            } else {
                String ext;
                key = ext = file.getName().substring(lookIndex);
                for (int i = 0; i < noCacheExtList.length; ++i) {
                    if (!noCacheExtList[i].equalsIgnoreCase(ext)) continue;
                    key = file.getPath();
                }
            }
        }
        return key;
    }

    static {
        noCacheExtList = new String[]{".exe"};
        doNotUseAWTIcon = Constants.isOSX;
        images = new HashMap(150);
        imagesToPath = new HashMap(150);
        registry = new HashMap();
        onlyOneImage = null;
    }
}

