/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UnresolvableHostManager;

public class IPAddressRangeManager {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected ArrayList entries = new ArrayList();
    protected long total_span;
    protected boolean rebuild_required;
    protected long last_rebuild_time;
    protected IpRange[] mergedRanges = new IpRange[0];
    protected AEMonitor this_mon = new AEMonitor("IPAddressRangeManager");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRange(IpRange range) {
        try {
            this.this_mon.enter();
            this.entries.add(range);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(IpRange range) {
        try {
            this.this_mon.enter();
            this.entries.remove(range);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object isInRange(String ip) {
        try {
            Object res;
            this.this_mon.enter();
            long address_long = this.addressToInt(ip);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            Object object = res = this.isInRange(address_long);
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object isInRange(InetAddress ip) {
        try {
            Object res;
            this.this_mon.enter();
            long address_long = this.addressToInt(ip);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            Object object = res = this.isInRange(address_long);
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInRange(IpRange range, String address) {
        try {
            this.this_mon.enter();
            long address_long = PRHelpers.addressToInt(address);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            boolean bl = address_long >= range.getStartIpLong() && address_long <= range.getStartIpLong();
            return bl;
        }
        catch (UnknownHostException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object isInRange(long address_long) {
        try {
            IpRange e;
            this.this_mon.enter();
            this.checkRebuild();
            if (this.mergedRanges.length == 0) {
                Object var3_2 = null;
                return var3_2;
            }
            int bottom = 0;
            int top = this.mergedRanges.length - 1;
            int current = -1;
            while (top >= 0 && bottom < this.mergedRanges.length && bottom <= top) {
                current = (bottom + top) / 2;
                e = this.mergedRanges[current];
                long this_start = e.getStartIpLong();
                long this_end = e.getMergedEndLong();
                if (address_long == this_start) break;
                if (address_long > this_start) {
                    if (address_long <= this_end) break;
                    bottom = current + 1;
                    continue;
                }
                if (address_long == this_end || address_long >= this_start) break;
                top = current - 1;
            }
            if (top >= 0 && bottom < this.mergedRanges.length && bottom <= top) {
                e = this.mergedRanges[current];
                if (address_long <= e.getEndIpLong()) {
                    IpRange this_start = e;
                    return this_start;
                }
                IpRange[] merged = e.getMergedEntries();
                if (merged == null) {
                    Debug.out("IPAddressRangeManager: inconsistent merged details - no entries");
                    Object var8_12 = null;
                    return var8_12;
                }
                for (int i = 0; i < merged.length; ++i) {
                    IpRange me = merged[i];
                    if (me.getStartIpLong() > address_long || me.getEndIpLong() < address_long) continue;
                    IpRange ipRange = me;
                    return ipRange;
                }
                Debug.out("IPAddressRangeManager: inconsistent merged details - entry not found");
            }
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int addressToInt(String address) {
        try {
            return PRHelpers.addressToInt(address);
        }
        catch (UnknownHostException e) {
            return UnresolvableHostManager.getPseudoAddress(address);
        }
    }

    protected int addressToInt(InetAddress address) {
        return PRHelpers.addressToInt(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRebuild() {
        try {
            long now;
            long secs_since_last_build;
            this.this_mon.enter();
            if (this.rebuild_required && (secs_since_last_build = ((now = SystemTime.getCurrentTime()) - this.last_rebuild_time) / 1000L) > (long)(this.entries.size() / 2000)) {
                this.last_rebuild_time = now;
                this.rebuild_required = false;
                this.rebuild();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void rebuild() {
        int i;
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries starts"));
        }
        IpRange[] ents = new IpRange[this.entries.size()];
        this.entries.toArray(ents);
        for (int i2 = 0; i2 < ents.length; ++i2) {
            ents[i2].resetMergeInfo();
        }
        Arrays.sort(ents, new Comparator(){

            public int compare(Object o1, Object o2) {
                IpRange e1 = (IpRange)o1;
                IpRange e2 = (IpRange)o2;
                long diff = e1.getStartIpLong() - e2.getStartIpLong();
                if (diff == 0L) {
                    diff = e2.getEndIpLong() - e1.getEndIpLong();
                }
                return IPAddressRangeManager.this.signum(diff);
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        ArrayList<IpRange> me = new ArrayList<IpRange>(ents.length);
        block1: for (i = 0; i < ents.length; ++i) {
            IpRange entry = ents[i];
            if (entry.getMerged()) continue;
            me.add(entry);
            int pos = i + 1;
            while (pos < ents.length) {
                IpRange e2;
                long end_pos = entry.getMergedEndLong();
                if ((e2 = ents[pos++]).getMerged()) continue;
                if (end_pos < e2.getStartIpLong()) continue block1;
                e2.setMerged();
                if (e2.getEndIpLong() <= end_pos) continue;
                entry.setMergedEnd(e2.getEndIpLong());
                entry.addMergedEntry(e2);
            }
        }
        this.mergedRanges = new IpRange[me.size()];
        me.toArray(this.mergedRanges);
        this.total_span = 0L;
        for (i = 0; i < this.mergedRanges.length; ++i) {
            IpRange e = this.mergedRanges[i];
            long span = e.getMergedEndLong() - e.getStartIpLong() + 1L;
            this.total_span += span;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries ends"));
        }
    }

    protected int signum(long diff) {
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    protected long getTotalSpan() {
        this.checkRebuild();
        return this.total_span;
    }

    public static void main(String[] args) {
        Object[] testBlockIPs2;
        IPAddressRangeManager manager = new IPAddressRangeManager();
        Object[] testBlockIPs1 = new Object[]{new String[]{"1", "3.1.1.1", "3.1.1.2"}, new String[]{"2", "3.1.1.1", "3.1.1.3"}, new String[]{"3", "1.1.1.1", "2.2.2.2", "2"}, new String[]{"4", "0.1.1.1", "2.2.2.2", "3"}, new String[]{"5", "1.1.1.1", "1.2.2.2"}, new String[]{"6", "7.7.7.7", "7.7.8.7"}, new String[]{"7", "8.8.8.8", "8.8.8.8"}, new String[]{"9", "5.5.5.5", "6.6.6.9"}, new String[]{"10", "6.6.6.6", "7.7.0.0"}, new String[]{"11", "254.6.6.6", "254.7.0.0"}};
        Object[] testBlockIPs = testBlockIPs2 = new Object[]{new String[]{"1", "0.0.0.1", "60.0.0.0"}, new String[]{"2", "60.0.0.2", "119.255.255.255"}, new String[]{"2a", "60.0.0.2", "119.255.255.255"}, new String[]{"3", "120.0.0.1", "180.0.0.0"}, new String[]{"4", "180.0.0.0", "255.255.255.255"}};
        for (int i = 0; i < testBlockIPs.length; ++i) {
            String[] ip = (String[])testBlockIPs[i];
            if (ip == null) continue;
            manager.addRange(new IpRangeImpl(ip[0], ip[1], ip[2], true));
        }
        System.out.println("inRange -> " + manager.isInRange("254.6.6.8"));
        String[] testIPs = new String[]{"60.0.0.0", "60.0.0.1", "60.0.0.2", "60.0.0.3", "119.255.255.254", "119.255.255.255", "120.0.0.0", "120.0.0.1", "120.0.0.2", "179.255.255.255", "180.0.0.0", "180.0.0.1"};
        for (int i = 0; i < testIPs.length; ++i) {
            String string = testIPs[i];
            System.out.println(string + " InRange? " + manager.isInRange(string));
        }
        System.out.println("Total span = " + manager.getTotalSpan());
    }

    public ArrayList getEntries() {
        return this.entries;
    }
}

