/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed;

import com.aelitis.azureus.plugins.extseed.ExternalSeedPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderFactory;
import com.aelitis.azureus.plugins.extseed.impl.getright.ExternalSeedReaderFactoryGetRight;
import com.aelitis.azureus.plugins.extseed.impl.webseed.ExternalSeedReaderFactoryWebSeed;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class ExternalSeedPlugin
implements Plugin,
DownloadManagerListener {
    private static ExternalSeedReaderFactory[] factories = new ExternalSeedReaderFactory[]{new ExternalSeedReaderFactoryGetRight(), new ExternalSeedReaderFactoryWebSeed()};
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private Random random = new Random();
    private Map download_map = new HashMap();
    private Monitor download_mon;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "External Seed");
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel("External Seeds");
        final BasicPluginViewModel view_model = this.plugin_interface.getUIManager().createBasicPluginViewModel("Plugin.extseed.name");
        view_model.getActivity().setVisible(false);
        view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                view_model.getLogArea().appendText(content + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    view_model.getLogArea().appendText(str + "\n");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                view_model.getLogArea().appendText(sw.toString() + "\n");
            }
        });
        this.download_mon = this.plugin_interface.getUtilities().getMonitor();
        this.plugin_interface.getDownloadManager().addListener(this);
        this.plugin_interface.getUtilities().createTimer("ExternalPeerScheduler", true).addPeriodicEvent(15000L, new UTTimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(UTTimerEvent event2) {
                try {
                    ExternalSeedPlugin.this.download_mon.enter();
                    Iterator it = ExternalSeedPlugin.this.download_map.values().iterator();
                    while (it.hasNext()) {
                        List peers = ExternalSeedPlugin.this.randomiseList((List)it.next());
                        for (int i = 0; i < peers.size() && !((ExternalSeedPeer)peers.get(i)).checkConnection(); ++i) {
                        }
                    }
                }
                finally {
                    ExternalSeedPlugin.this.download_mon.exit();
                }
            }
        });
    }

    public void downloadAdded(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        ArrayList<ExternalSeedPeer> peers = new ArrayList<ExternalSeedPeer>();
        for (int i = 0; i < factories.length; ++i) {
            ExternalSeedReader[] x = factories[i].getSeedReaders(this, download);
            for (int j = 0; j < x.length; ++j) {
                ExternalSeedReader reader = x[j];
                ExternalSeedPeer peer = new ExternalSeedPeer(this, reader);
                peers.add(peer);
            }
        }
        this.addPeers(download, peers);
    }

    public void addSeed(Download download, Map config) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        ArrayList<ExternalSeedPeer> peers = new ArrayList<ExternalSeedPeer>();
        for (int i = 0; i < factories.length; ++i) {
            ExternalSeedReader[] x = factories[i].getSeedReaders(this, download, config);
            for (int j = 0; j < x.length; ++j) {
                ExternalSeedReader reader = x[j];
                ExternalSeedPeer peer = new ExternalSeedPeer(this, reader);
                peers.add(peer);
            }
        }
        this.addPeers(download, peers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeers(Download download, final List peers) {
        if (peers.size() > 0) {
            boolean add_listener = false;
            try {
                this.download_mon.enter();
                ArrayList<ExternalSeedPeer> existing_peers = (ArrayList<ExternalSeedPeer>)this.download_map.get(download);
                if (existing_peers == null) {
                    add_listener = true;
                    existing_peers = new ArrayList<ExternalSeedPeer>();
                    this.download_map.put(download, existing_peers);
                }
                for (int i = 0; i < peers.size(); ++i) {
                    ExternalSeedPeer peer = (ExternalSeedPeer)peers.get(i);
                    boolean skip = false;
                    for (int j = 0; j < existing_peers.size(); ++j) {
                        ExternalSeedPeer existing_peer = (ExternalSeedPeer)existing_peers.get(j);
                        if (!existing_peer.sameAs(peer)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    existing_peers.add(peer);
                }
            }
            finally {
                this.download_mon.exit();
            }
            if (add_listener) {
                download.addPeerListener(new DownloadPeerListener(){

                    public void peerManagerAdded(Download download, PeerManager peer_manager) {
                        for (int i = 0; i < peers.size(); ++i) {
                            ExternalSeedPeer peer = (ExternalSeedPeer)peers.get(i);
                            peer.setManager(peer_manager);
                        }
                    }

                    public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                        for (int i = 0; i < peers.size(); ++i) {
                            ExternalSeedPeer peer = (ExternalSeedPeer)peers.get(i);
                            peer.setManager(null);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRemoved(Download download) {
        try {
            this.download_mon.enter();
            this.download_map.remove(download);
        }
        finally {
            this.download_mon.exit();
        }
    }

    public void log(String str) {
        this.log.log(str);
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected List randomiseList(List l) {
        if (l.size() < 2) {
            return l;
        }
        ArrayList new_list = new ArrayList();
        for (int i = 0; i < l.size(); ++i) {
            new_list.add(this.random.nextInt(new_list.size() + 1), l.get(i));
        }
        return new_list;
    }
}

