/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;

public class DownloadingUnchoker
implements Unchoker {
    protected ArrayList chokes = new ArrayList();
    protected ArrayList unchokes = new ArrayList();

    public DownloadingUnchoker() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, logging, "using downloading unchoker"));
        }
    }

    public ArrayList getImmediateUnchokes(int max_to_unchoke, ArrayList all_peers) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, logging, "using downloading unchoker"));
        }
        ArrayList<PEPeerTransport> to_unchoke = new ArrayList<PEPeerTransport>();
        int num_unchoked = 0;
        for (int i = 0; i < all_peers.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)all_peers.get(i);
            if (peer.isChokedByMe()) continue;
            ++num_unchoked;
        }
        int needed = max_to_unchoke - num_unchoked;
        if (needed > 0) {
            PEPeerTransport peer;
            for (int i = 0; i < needed && (peer = UnchokerUtil.getNextOptimisticPeer(all_peers, true, true)) != null; ++i) {
                to_unchoke.add(peer);
                peer.setOptimisticUnchoke(true);
            }
        }
        return to_unchoke;
    }

    public void calculateUnchokes(int max_to_unchoke, ArrayList all_peers, boolean force_refresh) {
        PEPeerTransport peer;
        PEPeerTransport peer2;
        int i;
        PEPeerTransport peer3;
        int i2;
        int max_optimistic = (max_to_unchoke - 1) / 10 + 1;
        ArrayList<PEPeerTransport> optimistic_unchokes = new ArrayList<PEPeerTransport>();
        ArrayList<PEPeerTransport> best_peers = new ArrayList<PEPeerTransport>();
        long[] bests = new long[max_to_unchoke];
        for (i2 = 0; i2 < all_peers.size(); ++i2) {
            peer3 = (PEPeerTransport)all_peers.get(i2);
            if (peer3.isChokedByMe()) continue;
            if (UnchokerUtil.isUnchokable(peer3, true)) {
                this.unchokes.add(peer3);
                if (!peer3.isOptimisticUnchoke()) continue;
                optimistic_unchokes.add(peer3);
                continue;
            }
            this.chokes.add(peer3);
        }
        if (!force_refresh) {
            for (i2 = 0; i2 < optimistic_unchokes.size(); ++i2) {
                peer3 = (PEPeerTransport)optimistic_unchokes.get(i2);
                if (i2 < max_optimistic) {
                    best_peers.add(peer3);
                    continue;
                }
                peer3.setOptimisticUnchoke(false);
            }
        }
        int start_pos = best_peers.size();
        for (i = 0; i < all_peers.size(); ++i) {
            long rate;
            peer2 = (PEPeerTransport)all_peers.get(i);
            if (!peer2.isInteresting() || !UnchokerUtil.isUnchokable(peer2, false) || best_peers.contains(peer2) || (rate = peer2.getStats().getSmoothDataReceiveRate()) <= 256L) continue;
            UnchokerUtil.updateLargestValueFirstSort(rate, bests, peer2, best_peers, start_pos);
        }
        if (best_peers.size() < max_to_unchoke) {
            start_pos = best_peers.size();
            for (i = 0; i < all_peers.size(); ++i) {
                long uploaded_ratio;
                peer2 = (PEPeerTransport)all_peers.get(i);
                if (!peer2.isInteresting() || !UnchokerUtil.isUnchokable(peer2, false) || best_peers.contains(peer2) || (uploaded_ratio = peer2.getStats().getTotalDataBytesSent() / (peer2.getStats().getTotalDataBytesReceived() + 16383L)) >= 3L) continue;
                UnchokerUtil.updateLargestValueFirstSort(peer2.getStats().getTotalDataBytesReceived(), bests, peer2, best_peers, start_pos);
            }
        }
        if (force_refresh) {
            while (best_peers.size() > max_to_unchoke - max_optimistic) {
                best_peers.remove(best_peers.size() - 1);
            }
        }
        while (best_peers.size() < max_to_unchoke && (peer = UnchokerUtil.getNextOptimisticPeer(all_peers, true, true)) != null) {
            if (!best_peers.contains(peer)) {
                best_peers.add(peer);
                peer.setOptimisticUnchoke(true);
                continue;
            }
            peer.sendUnChoke();
        }
        Iterator it = this.unchokes.iterator();
        while (it.hasNext()) {
            peer2 = (PEPeerTransport)it.next();
            if (best_peers.contains(peer2)) continue;
            if (best_peers.size() < max_to_unchoke) {
                best_peers.add(peer2);
                continue;
            }
            this.chokes.add(peer2);
            it.remove();
        }
        for (int i3 = 0; i3 < best_peers.size(); ++i3) {
            peer2 = (PEPeerTransport)best_peers.get(i3);
            if (this.unchokes.contains(peer2)) continue;
            this.unchokes.add(peer2);
        }
    }

    public ArrayList getChokes() {
        ArrayList to_choke = this.chokes;
        this.chokes = new ArrayList();
        return to_choke;
    }

    public ArrayList getUnchokes() {
        ArrayList to_unchoke = this.unchokes;
        this.unchokes = new ArrayList();
        return to_unchoke;
    }
}

