/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.piecepicker.impl;

import com.aelitis.azureus.core.peermanager.piecepicker.EndGameModeChunk;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePiecerPriorityShaper;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class PiecePickerImpl
implements PiecePicker {
    private static final LogIDs LOGID = LogIDs.PIECES;
    private static final long TIME_MIN_AVAILABILITY = 974L;
    private static final long TIME_MIN_PRIORITIES = 999L;
    private static final long TIME_AVAIL_REBUILD = 299976L;
    private static final int PRIORITY_W_FIRSTLAST = 1300;
    private static final long FIRST_PIECE_MIN_NB = 4L;
    private static final int PRIORITY_W_FILE = 1000;
    private static final int PRIORITY_W_COMPLETION = 2000;
    private static final int PRIORITY_W_AGE = 900;
    private static final int PRIORITY_DW_AGE = 60000;
    private static final int PRIORITY_DW_STALE = 120000;
    private static final int PRIORITY_W_PIECE_DONE = 900;
    private static final int PRIORITY_W_SAME_PIECE = 700;
    private static final int PRIORITY_OVERRIDES_RAREST = 9000;
    private static final int PRIORITY_REALTIME_MIN = 90000;
    private static final int REQUESTS_MIN = 2;
    private static final int REQUESTS_MAX = 256;
    private static final int SLOPE_REQUESTS = 4096;
    private static final long END_GAME_MODE_SIZE_TRIGGER = 0x1400000L;
    private static final long END_GAME_MODE_TIMEOUT = 76800L;
    protected static volatile boolean firstPiecePriority = COConfigurationManager.getBooleanParameter("Prioritize First Piece", false);
    protected static volatile boolean completionPriority = COConfigurationManager.getBooleanParameter("Prioritize Most Completed Files", false);
    protected static volatile long paramPriorityChange = Long.MIN_VALUE;
    private static final int NO_REQUEST_BACKOFF_MAX_MILLIS = 5000;
    private static final int NO_REQUEST_BACKOFF_MAX_LOOPS = 50;
    private final DiskManager diskManager;
    private final PEPeerControl peerControl;
    private final DiskManagerListenerImpl diskManagerListener;
    protected final Map peerListeners;
    private final PEPeerManagerListener peerManagerListener;
    protected final int nbPieces;
    protected final DiskManagerPiece[] dmPieces;
    protected final PEPiece[] pePieces;
    protected final AEMonitor availabilityMon = new AEMonitor("PiecePicker:avail");
    private final AEMonitor endGameModeChunks_mon = new AEMonitor("PiecePicker:EGM");
    protected volatile int nbPiecesDone;
    protected volatile int[] availabilityAsynch;
    protected volatile long availabilityDrift;
    private long timeAvailRebuild = 299976L;
    protected volatile int[] availability;
    private long time_last_avail;
    protected volatile long availabilityChange;
    private volatile long availabilityComputeChange;
    private long time_last_rebuild;
    private float globalAvail;
    private float globalAvgAvail;
    private int nbRarestActive;
    private int globalMin;
    private volatile int globalMinOthers;
    protected volatile long filePriorityChange;
    private volatile long priorityParamChange;
    private volatile long priorityFileChange;
    private volatile long priorityAvailChange;
    private long timeLastPriorities;
    private int[] startPriorities;
    protected volatile boolean hasNeededUndonePiece;
    protected volatile long neededUndonePieceChange;
    private volatile boolean endGameMode;
    private volatile boolean endGameModeAbandoned;
    private volatile long timeEndGameModeEntered;
    private List endGameModeChunks;
    private long lastShaperRecalcTime;
    private CopyOnWriteList priority_shapers = new CopyOnWriteList();
    private int[] priority_shaper_priorities;
    private int allocate_request_loop_count;

    public PiecePickerImpl(PEPeerControl pc) {
        this.peerControl = pc;
        this.diskManager = this.peerControl.getDiskManager();
        this.dmPieces = this.diskManager.getPieces();
        this.nbPieces = this.diskManager.getNbPieces();
        this.nbPiecesDone = 0;
        this.pePieces = pc.getPieces();
        this.availability = new int[this.nbPieces];
        this.hasNeededUndonePiece = false;
        this.neededUndonePieceChange = Long.MIN_VALUE;
        this.time_last_avail = Long.MIN_VALUE;
        this.availabilityChange = -9223372036854775807L;
        this.availabilityComputeChange = Long.MIN_VALUE;
        this.availabilityDrift = this.nbPieces;
        for (int i = 0; i < this.nbPieces; ++i) {
            if (this.dmPieces[i].isDone()) {
                int n = i;
                this.availability[n] = this.availability[n] + 1;
                ++this.nbPiecesDone;
                continue;
            }
            this.hasNeededUndonePiece |= this.dmPieces[i].calcNeeded();
        }
        if (this.hasNeededUndonePiece) {
            ++this.neededUndonePieceChange;
        }
        this.updateAvailability();
        this.peerListeners = new HashMap();
        this.peerManagerListener = new PEPeerManagerListenerImpl();
        this.peerControl.addListener(this.peerManagerListener);
        this.filePriorityChange = Long.MIN_VALUE;
        this.priorityParamChange = Long.MIN_VALUE;
        this.priorityFileChange = Long.MIN_VALUE;
        this.priorityAvailChange = Long.MIN_VALUE;
        this.timeLastPriorities = Long.MIN_VALUE;
        this.endGameMode = false;
        this.endGameModeAbandoned = false;
        this.timeEndGameModeEntered = 0L;
        this.diskManagerListener = new DiskManagerListenerImpl();
        this.diskManager.addListener(this.diskManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addHavePiece(PEPeer peer, int pieceNumber) {
        try {
            this.availabilityMon.enter();
            if (this.availabilityAsynch == null) {
                this.availabilityAsynch = (int[])this.availability.clone();
            }
            int n = pieceNumber;
            this.availabilityAsynch[n] = this.availabilityAsynch[n] + 1;
            ++this.availabilityChange;
        }
        finally {
            this.availabilityMon.exit();
        }
        if (peer != null && this.dmPieces[pieceNumber].isDownloadable()) {
            peer.setConsecutiveNoRequestCount(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAvailability() {
        int i;
        long now = SystemTime.getCurrentTime();
        if (now >= this.time_last_avail && now < this.time_last_avail + 974L) {
            return;
        }
        if (this.availabilityDrift > 0L || now < this.time_last_rebuild || now - this.time_last_rebuild > this.timeAvailRebuild) {
            try {
                this.availabilityMon.enter();
                this.time_last_rebuild = now;
                int[] new_availability = this.recomputeAvailability();
                if (Constants.isCVSVersion()) {
                    int[] old_availability = this.availabilityAsynch == null ? this.availability : this.availabilityAsynch;
                    int errors = 0;
                    for (int i2 = 0; i2 < new_availability.length; ++i2) {
                        if (new_availability[i2] == old_availability[i2]) continue;
                        ++errors;
                    }
                    if (errors > 0 && errors != this.nbPieces) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.peerControl, LOGID, 3, "updateAvailability(): availability rebuild errors =" + errors + " timeAvailRebuild =" + this.timeAvailRebuild));
                        }
                        this.timeAvailRebuild -= (long)errors;
                    } else {
                        ++this.timeAvailRebuild;
                    }
                }
                this.availabilityAsynch = new_availability;
                this.availabilityDrift = 0L;
                ++this.availabilityChange;
            }
            finally {
                this.availabilityMon.exit();
            }
        } else if (this.availabilityComputeChange >= this.availabilityChange) {
            return;
        }
        try {
            this.availabilityMon.enter();
            this.time_last_avail = now;
            this.availabilityComputeChange = this.availabilityChange;
            if (this.availabilityAsynch != null) {
                this.availability = this.availabilityAsynch;
                this.availabilityAsynch = null;
            }
        }
        finally {
            this.availabilityMon.exit();
        }
        int allMin = Integer.MAX_VALUE;
        int rarestMin = Integer.MAX_VALUE;
        for (i = 0; i < this.nbPieces; ++i) {
            int avail = this.availability[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            PEPiece pePiece = this.pePieces[i];
            if (avail > 0 && avail < rarestMin && dmPiece.isDownloadable() && (pePiece == null || pePiece.isRequestable())) {
                rarestMin = avail;
            }
            if (avail >= allMin) continue;
            allMin = avail;
        }
        this.globalMin = allMin;
        this.globalMinOthers = rarestMin;
        int total = 0;
        int rarestActive = 0;
        long totalAvail = 0L;
        for (i = 0; i < this.nbPieces; ++i) {
            int avail = this.availability[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            PEPiece pePiece = this.pePieces[i];
            if (avail <= 0) continue;
            if (avail > allMin) {
                ++total;
            }
            if (avail <= rarestMin && dmPiece.isDownloadable() && pePiece != null && !pePiece.isRequested()) {
                ++rarestActive;
            }
            totalAvail += (long)avail;
        }
        this.globalAvail = (float)total / (float)this.nbPieces + (float)allMin;
        this.nbRarestActive = rarestActive;
        this.globalAvgAvail = (float)totalAvail / (float)this.nbPieces / (float)(1 + this.peerControl.getNbSeeds() + this.peerControl.getNbPeers());
    }

    private final int[] recomputeAvailability() {
        int j;
        if (this.availabilityDrift > 0L && this.availabilityDrift != (long)this.nbPieces && Logger.isEnabled()) {
            Logger.log(new LogEvent((Object)this.diskManager.getTorrent(), LOGID, 0, "Recomputing availabiliy. Drift=" + this.availabilityDrift + ":" + this.peerControl.getDisplayName()));
        }
        List peers = this.peerControl.getPeers();
        int[] newAvailability = new int[this.nbPieces];
        for (j = 0; j < this.nbPieces; ++j) {
            newAvailability[j] = this.dmPieces[j].isDone() ? 1 : 0;
        }
        int peersSize = peers.size();
        for (int i = 0; i < peersSize; ++i) {
            BitFlags peerHavePieces;
            PEPeerTransport peer = (PEPeerTransport)peers.get(i);
            if (peer == null || peer.getPeerState() != 30 || (peerHavePieces = peer.getAvailable()) == null || peerHavePieces.nbSet <= 0) continue;
            for (j = peerHavePieces.start; j <= peerHavePieces.end; ++j) {
                if (!peerHavePieces.flags[j]) continue;
                int n = j;
                newAvailability[n] = newAvailability[n] + 1;
            }
        }
        return newAvailability;
    }

    public final int[] getAvailability() {
        return this.availability;
    }

    public final int getAvailability(int pieceNumber) {
        return this.availability[pieceNumber];
    }

    public final float getMinAvailability() {
        return this.globalAvail;
    }

    public final float getAvgAvail() {
        return this.globalAvgAvail;
    }

    protected final void checkDownloadablePiece() {
        for (int i = 0; i < this.nbPieces; ++i) {
            if (!this.dmPieces[i].isInteresting()) continue;
            if (!this.hasNeededUndonePiece) {
                this.hasNeededUndonePiece = true;
                ++this.neededUndonePieceChange;
            }
            return;
        }
        if (this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = false;
            ++this.neededUndonePieceChange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void allocateRequests() {
        if (!this.hasNeededUndonePiece) {
            return;
        }
        ++this.allocate_request_loop_count;
        List peers = this.peerControl.getPeers();
        int peersSize = peers.size();
        long[] upRates = new long[peersSize];
        ArrayList bestUploaders = new ArrayList();
        for (int i = 0; i < peersSize; ++i) {
            int no_req_count;
            PEPeerTransport peer = (PEPeerTransport)peers.get(i);
            if (!peer.isDownloadPossible() || (no_req_count = peer.getConsecutiveNoRequestCount()) != 0 && this.allocate_request_loop_count % (no_req_count + 1) != 0) continue;
            long upRate = peer.getStats().getSmoothDataReceiveRate();
            UnchokerUtil.updateLargestValueFirstSort(upRate, upRates, peer, bestUploaders, 0);
        }
        int uploadersSize = bestUploaders.size();
        if (uploadersSize == 0) {
            return;
        }
        this.checkEndGameMode();
        boolean done_priorities = false;
        for (int i = 0; i < uploadersSize; ++i) {
            int maxRequests;
            PEPeerTransport pt = (PEPeerTransport)bestUploaders.get(i);
            if (!pt.isDownloadPossible()) continue;
            int peer_request_num = pt.getMaxNbRequests();
            if (peer_request_num != -1) {
                maxRequests = peer_request_num;
            } else if (!pt.isSnubbed()) {
                if (!this.endGameMode) {
                    maxRequests = 2 + (int)(pt.getStats().getDataReceiveRate() / 4096L);
                    if (maxRequests > 256 || maxRequests < 0) {
                        maxRequests = 256;
                    }
                } else {
                    maxRequests = 2;
                }
            } else {
                maxRequests = 1;
            }
            if (pt.getNbRequests() > maxRequests * 3 / 5) continue;
            if (!done_priorities) {
                done_priorities = true;
                this.computeBasePriorities();
            }
            int total_allocated = 0;
            try {
                boolean peer_managing_requests = pt.requestAllocationStarts(this.startPriorities);
                while (pt.isDownloadPossible() && pt.getNbRequests() < maxRequests) {
                    int allocated = peer_managing_requests || !this.endGameMode ? this.findPieceToDownload(pt, maxRequests, (int)(upRates[i] / 1024L)) : this.findPieceInEndGameMode(pt, maxRequests);
                    if (allocated == 0) {
                        break;
                    }
                    total_allocated += allocated;
                }
            }
            finally {
                pt.requestAllocationComplete();
            }
            if (total_allocated == 0) {
                int no_req_count = pt.getConsecutiveNoRequestCount();
                if (no_req_count >= 50) continue;
                pt.setConsecutiveNoRequestCount(no_req_count + 2);
                continue;
            }
            pt.setConsecutiveNoRequestCount(0);
        }
    }

    private final void computeBasePriorities() {
        long now = SystemTime.getCurrentTime();
        boolean force = false;
        if (now < this.lastShaperRecalcTime || now - this.lastShaperRecalcTime > 1000L) {
            this.lastShaperRecalcTime = now;
            force = this.computeShapePriorities();
        }
        if (!force && this.startPriorities != null && (now > this.timeLastPriorities && now < this.time_last_avail + 999L || this.priorityParamChange >= paramPriorityChange && this.priorityFileChange >= this.filePriorityChange && this.priorityAvailChange >= this.availabilityChange)) {
            return;
        }
        this.timeLastPriorities = now;
        this.priorityParamChange = paramPriorityChange;
        this.priorityFileChange = this.filePriorityChange;
        this.priorityAvailChange = this.availabilityChange;
        boolean foundPieceToDownload = false;
        int[] newPriorities = new int[this.nbPieces];
        boolean firstPiecePriorityL = firstPiecePriority;
        boolean completionPriorityL = completionPriority;
        try {
            boolean rarestOverride = this.isRarestOverride();
            int nbConnects = this.peerControl.getNbPeers() + this.peerControl.getNbSeeds();
            for (int i = 0; i < this.nbPieces; ++i) {
                DiskManagerPiece dmPiece = this.dmPieces[i];
                if (dmPiece.isDone()) continue;
                int priority = Integer.MIN_VALUE;
                int startPriority = Integer.MIN_VALUE;
                DMPieceList pieceList = this.diskManager.getPieceList(dmPiece.getPieceNumber());
                int pieceListSize = pieceList.size();
                for (int j = 0; j < pieceListSize; ++j) {
                    DiskManagerFileInfoImpl fileInfo2 = pieceList.get(j).getFile();
                    long downloaded = fileInfo2.getDownloaded();
                    long length = fileInfo2.getLength();
                    if (length <= 0L || downloaded >= length || fileInfo2.isSkipped()) continue;
                    priority = 0;
                    if (firstPiecePriorityL && (long)fileInfo2.getNbPieces() > 4L && (i == fileInfo2.getFirstPieceNumber() || i == fileInfo2.getLastPieceNumber())) {
                        priority += 1300;
                    }
                    if (fileInfo2.isPriority()) {
                        long percent;
                        priority += 1000;
                        if (completionPriorityL && (percent = 1000L * downloaded / length) >= 900L) {
                            priority = (int)((long)priority + 2000L * downloaded / this.diskManager.getTotalLength());
                        }
                    }
                    if (priority <= startPriority) continue;
                    startPriority = priority;
                }
                if (startPriority >= 0) {
                    dmPiece.setNeeded();
                    foundPieceToDownload = true;
                    int avail = this.availability[i];
                    if (avail > 0 && nbConnects > avail) {
                        startPriority += nbConnects - avail;
                        if (!rarestOverride && avail <= this.globalMinOthers) {
                            startPriority += nbConnects / avail;
                        }
                    }
                    if (this.priority_shaper_priorities != null) {
                        startPriority += this.priority_shaper_priorities[i];
                    }
                } else {
                    dmPiece.clearNeeded();
                }
                newPriorities[i] = startPriority;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (foundPieceToDownload != this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = foundPieceToDownload;
            ++this.neededUndonePieceChange;
        }
        this.startPriorities = newPriorities;
    }

    private final boolean isRarestOverride() {
        boolean rarestOverride;
        int nbSeeds = this.peerControl.getNbSeeds();
        int nbPeers = this.peerControl.getNbPeers();
        int nbMost = nbPeers > nbSeeds ? nbPeers : nbSeeds;
        int nbActive = this.peerControl.getNbActivePieces();
        boolean bl = rarestOverride = this.nbPiecesDone < 4 || this.endGameMode || this.globalMinOthers > 1 && (this.nbRarestActive >= nbMost || nbActive >= nbMost);
        if (!rarestOverride && this.nbRarestActive > 1 && this.globalMinOthers > 1) {
            rarestOverride = this.globalMinOthers > this.globalMin || this.globalMinOthers >= 2 * nbSeeds && 2 * this.globalMinOthers >= nbPeers;
        }
        return rarestOverride;
    }

    protected final int findPieceToDownload(PEPeerTransport pt, int nbWanted, int smoothPeerSpeedKBSec) {
        int[] blocksFound;
        int pieceNumber = this.getRequestCandidate(pt, smoothPeerSpeedKBSec);
        if (pieceNumber < 0) {
            return 0;
        }
        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1000;
        PEPiece pePiece = this.pePieces[pieceNumber];
        if (pePiece == null) {
            int[] peer_priority_offsets = pt.getPriorityOffsets();
            int this_offset = peer_priority_offsets == null ? 0 : peer_priority_offsets[pieceNumber];
            pePiece = new PEPieceImpl(pt.getManager(), this.dmPieces[pieceNumber], peerSpeed >> 1);
            this.peerControl.addPiece(pePiece, pieceNumber);
            if (this.startPriorities != null) {
                pePiece.setResumePriority(this.startPriorities[pieceNumber] + this_offset);
            } else {
                pePiece.setResumePriority(this_offset);
            }
            if (this.availability[pieceNumber] <= this.globalMinOthers) {
                ++this.nbRarestActive;
            }
        }
        if (pePiece.getResumePriority() >= 90000) {
            int thisBlock;
            blocksFound = pePiece.getAndMarkRealTimeBlocks(pt, nbWanted, smoothPeerSpeedKBSec, pt.getNbRequests());
            int requested = 0;
            for (int i = 0; i < blocksFound.length && (thisBlock = blocksFound[i]) != -1; ++i) {
                if (!pt.request(pieceNumber, thisBlock * 16384, pePiece.getBlockSize(thisBlock))) continue;
                ++requested;
                pt.setLastPiece(pieceNumber);
                pePiece.setLastRequestedPeerSpeed(peerSpeed);
            }
            return requested;
        }
        blocksFound = pePiece.getAndMarkBlocks(pt, nbWanted);
        int blockNumber = blocksFound[0];
        int nbBlocks = blocksFound[1];
        if (nbBlocks <= 0) {
            return 0;
        }
        int requested = 0;
        for (int i = 0; i < nbBlocks; ++i) {
            int thisBlock = blockNumber + i;
            if (!pt.request(pieceNumber, thisBlock * 16384, pePiece.getBlockSize(thisBlock))) continue;
            ++requested;
            pt.setLastPiece(pieceNumber);
            pePiece.setLastRequestedPeerSpeed(peerSpeed);
        }
        return requested;
    }

    private final int getRequestCandidate(PEPeerTransport pt, int smoothPeerSpeedKBSec) {
        if (pt == null || pt.getPeerState() != 30) {
            return -1;
        }
        BitFlags peerHavePieces = pt.getAvailable();
        if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
            return -1;
        }
        int reservedPieceNumber = pt.getReservedPieceNumber();
        if (reservedPieceNumber >= 0) {
            String peerReserved;
            PEPiece pePiece = this.pePieces[reservedPieceNumber];
            if (pePiece != null && (peerReserved = pePiece.getReservedBy()) != null && peerReserved.equals(pt.getIp()) && peerHavePieces.flags[reservedPieceNumber] && pePiece.isRequestable()) {
                return reservedPieceNumber;
            }
            pt.setReservedPieceNumber(-1);
            if (pePiece != null && (peerReserved = pePiece.getReservedBy()) != null && peerReserved.equals(pt.getIp())) {
                pePiece.setReservedBy(null);
            }
            reservedPieceNumber = -1;
        }
        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1000;
        int lastPiece = pt.getLastPiece();
        boolean globalRarestOverride = this.isRarestOverride();
        int nbSnubbed = this.peerControl.getNbPeersSnubbed();
        long resumeMinAvail = Long.MAX_VALUE;
        int resumeMaxPriority = Integer.MIN_VALUE;
        boolean resumeIsRarest = false;
        BitFlags startCandidates = null;
        int startMaxPriority = Integer.MIN_VALUE;
        int startMinAvail = Integer.MAX_VALUE;
        boolean startIsRarest = false;
        boolean startIsRealtime = false;
        int avail = 0;
        int startI = peerHavePieces.start;
        int endI = peerHavePieces.end;
        int[] peerPriorities = pt.getPriorityOffsets();
        long now = SystemTime.getCurrentTime();
        for (int i = startI; i <= endI; ++i) {
            if (!peerHavePieces.flags[i]) continue;
            int priority = this.startPriorities[i];
            if (peerPriorities != null && priority >= 0) {
                priority += peerPriorities[i];
            }
            DiskManagerPiece dmPiece = this.dmPieces[i];
            if (priority < 0 || !dmPiece.isDownloadable()) continue;
            PEPiece pePiece = this.pePieces[i];
            if (priority >= 90000 && (pePiece == null || pePiece.hasRealTimeBlock(pt, smoothPeerSpeedKBSec))) {
                if (!startIsRealtime) {
                    startIsRealtime = true;
                    startMaxPriority = priority;
                    if (startCandidates == null) {
                        startCandidates = new BitFlags(this.nbPieces);
                    }
                    startCandidates.setOnly(i);
                } else if (priority == startMaxPriority) {
                    startCandidates.setEnd(i);
                } else if (priority > startMaxPriority) {
                    startMaxPriority = priority;
                    startCandidates.setOnly(i);
                }
                if (pePiece == null) continue;
                if (pePiece.getNbUnrequested() <= 0) {
                    pePiece.setRequested();
                }
                pePiece.setResumePriority(priority);
                continue;
            }
            if (pePiece != null && !pePiece.isRequestable() || startIsRealtime) continue;
            boolean pieceRarestOverride = priority >= 9000 ? true : globalRarestOverride;
            avail = this.availability[i];
            if (avail == 0) {
                this.availability[i] = 1;
                avail = 1;
            }
            if (pePiece != null) {
                int freeReqs = pePiece.getNbUnrequested();
                if (freeReqs <= 0) {
                    pePiece.setRequested();
                    continue;
                }
                String peerReserved = pePiece.getReservedBy();
                if (peerReserved != null) {
                    if (!peerReserved.equals(pt.getIp())) continue;
                    pt.setReservedPieceNumber(i);
                    return i;
                }
                int pieceSpeed = pePiece.getSpeed();
                long timeSinceLastActivity = pePiece.getTimeSinceLastActivity();
                if (avail > 1 && (freeReqs < 3 || pieceSpeed - 1 >= freeReqs * peerSpeed) && (timeSinceLastActivity < 600000L && avail > nbSnubbed && pt.isSnubbed() || peerSpeed < pieceSpeed && i != lastPiece) || (long)avail > resumeMinAvail) continue;
                priority += pieceSpeed;
                priority += i == lastPiece ? 700 : 0;
                priority = (int)((long)priority + timeSinceLastActivity / 120000L);
                long pieceAge = now - pePiece.getCreationTime();
                if (pieceAge > 0L) {
                    priority = (int)((long)priority + 900L * pieceAge / (long)(60000 * dmPiece.getNbBlocks()));
                }
                pePiece.setResumePriority(priority += 900 * dmPiece.getNbWritten() / dmPiece.getNbBlocks());
                if (((long)avail >= resumeMinAvail || pieceRarestOverride && priority < resumeMaxPriority) && (priority <= resumeMaxPriority || resumeIsRarest && !pieceRarestOverride) || !pePiece.hasUnrequestedBlock()) continue;
                reservedPieceNumber = i;
                resumeMinAvail = avail;
                resumeMaxPriority = priority;
                resumeIsRarest = avail <= this.globalMinOthers;
                continue;
            }
            if (avail <= this.globalMinOthers && !pieceRarestOverride) {
                if (!startIsRarest) {
                    if (startCandidates == null) {
                        startCandidates = new BitFlags(this.nbPieces);
                    }
                    startMaxPriority = priority;
                    startMinAvail = avail;
                    startIsRarest = avail <= this.globalMinOthers;
                    startCandidates.setOnly(i);
                    continue;
                }
                if (priority > startMaxPriority) {
                    if (startCandidates == null) {
                        startCandidates = new BitFlags(this.nbPieces);
                    }
                    startMaxPriority = priority;
                    startCandidates.setOnly(i);
                    continue;
                }
                if (priority != startMaxPriority) continue;
                startCandidates.setEnd(i);
                continue;
            }
            if (startIsRarest && !pieceRarestOverride) continue;
            if (priority > startMaxPriority) {
                if (startCandidates == null) {
                    startCandidates = new BitFlags(this.nbPieces);
                }
                startMaxPriority = priority;
                startMinAvail = avail;
                startIsRarest = avail <= this.globalMinOthers;
                startCandidates.setOnly(i);
                continue;
            }
            if (priority != startMaxPriority) continue;
            if (avail < startMinAvail) {
                startMinAvail = avail;
                startIsRarest = avail <= this.globalMinOthers;
                startCandidates.setOnly(i);
                continue;
            }
            if (avail != startMinAvail) continue;
            startCandidates.setEnd(i);
        }
        if (reservedPieceNumber >= 0 && (resumeIsRarest || !startIsRarest || globalRarestOverride || startCandidates == null || startCandidates.nbSet <= 0)) {
            return reservedPieceNumber;
        }
        if (reservedPieceNumber >= 0 && this.globalMinOthers > 0 && this.peerControl.getNbActivePieces() > 32) {
            boolean resumeIsBetter;
            boolean bl = resumeIsBetter = (long)resumeMaxPriority / resumeMinAvail > (long)(startMaxPriority / this.globalMinOthers);
            if (Constants.isCVSVersion() && Logger.isEnabled()) {
                Logger.log(new LogEvent(new Object[]{pt, this.peerControl}, LOGID, "Start/resume choice; piece #:" + reservedPieceNumber + " resumeIsBetter:" + resumeIsBetter + " globalMinOthers=" + this.globalMinOthers + " startMaxPriority=" + startMaxPriority + " startMinAvail=" + startMinAvail + " resumeMaxPriority=" + resumeMaxPriority + " resumeMinAvail=" + resumeMinAvail + " : " + pt));
            }
            if (resumeIsBetter) {
                return reservedPieceNumber;
            }
        }
        return this.getPieceToStart(startCandidates);
    }

    protected final int getPieceToStart(BitFlags startCandidates) {
        if (startCandidates == null || startCandidates.nbSet <= 0) {
            return -1;
        }
        if (startCandidates.nbSet == 1) {
            return startCandidates.start;
        }
        int direction = RandomUtils.generateRandomPlusMinus1();
        int startI = direction == 1 ? startCandidates.start : startCandidates.end;
        int targetNb = RandomUtils.generateRandomIntUpto(startCandidates.nbSet);
        int foundNb = -1;
        for (int i = startI; i <= startCandidates.end && i >= startCandidates.start; i += direction) {
            if (!startCandidates.flags[i] || ++foundNb < targetNb) continue;
            return i;
        }
        return -1;
    }

    public final boolean hasDownloadablePiece() {
        return this.hasNeededUndonePiece;
    }

    public final long getNeededUndonePieceChange() {
        return this.neededUndonePieceChange;
    }

    private final void checkEndGameMode() {
        if (this.peerControl.getNbSeeds() + this.peerControl.getNbPeers() < 3) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (this.endGameMode || this.endGameModeAbandoned) {
            if (!this.endGameModeAbandoned && now - this.timeEndGameModeEntered > 76800L) {
                this.endGameModeAbandoned = true;
                this.clearEndGameChunks();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Abandoning end-game mode: " + this.peerControl.getDisplayName()));
                }
            }
            return;
        }
        int active_pieces = 0;
        for (int i = 0; i < this.nbPieces; ++i) {
            PEPiece pePiece;
            DiskManagerPiece dmPiece = this.dmPieces[i];
            if (!dmPiece.isDownloadable() || (pePiece = this.pePieces[i]) != null && pePiece.isDownloaded()) continue;
            if (pePiece != null && pePiece.isRequested() && dmPiece.isNeeded()) {
                ++active_pieces;
                continue;
            }
            return;
        }
        if ((long)(active_pieces * this.diskManager.getPieceLength()) <= 0x1400000L) {
            this.timeEndGameModeEntered = now;
            this.endGameMode = true;
            this.computeEndGameModeChunks();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Entering end-game mode: " + this.peerControl.getDisplayName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void computeEndGameModeChunks() {
        this.endGameModeChunks = new ArrayList();
        try {
            this.endGameModeChunks_mon.enter();
            for (int i = 0; i < this.nbPieces; ++i) {
                int j;
                PEPiece pePiece;
                DiskManagerPiece dmPiece = this.dmPieces[i];
                if (!dmPiece.isInteresting() || (pePiece = this.pePieces[i]) == null) continue;
                boolean[] written = dmPiece.getWritten();
                if (written == null) {
                    if (dmPiece.isDone()) continue;
                    for (j = 0; j < pePiece.getNbBlocks(); ++j) {
                        this.endGameModeChunks.add(new EndGameModeChunk(pePiece, j));
                    }
                    continue;
                }
                for (j = 0; j < written.length; ++j) {
                    if (written[j]) continue;
                    this.endGameModeChunks.add(new EndGameModeChunk(pePiece, j));
                }
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    public final boolean isInEndGameMode() {
        return this.endGameMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEndGameChunks(PEPiece pePiece) {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            int nbChunks = pePiece.getNbBlocks();
            for (int i = 0; i < nbChunks; ++i) {
                this.endGameModeChunks.add(new EndGameModeChunk(pePiece, i));
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEndGameBlocks(PEPiece pePiece) {
        if (!this.endGameMode || pePiece == null) {
            return;
        }
        DiskManagerPiece dmPiece = pePiece.getDMPiece();
        int nbChunks = pePiece.getNbBlocks();
        try {
            this.endGameModeChunks_mon.enter();
            for (int i = 0; i < nbChunks; ++i) {
                if (pePiece.isDownloaded(i) || dmPiece.isWritten(i)) continue;
                this.endGameModeChunks.add(new EndGameModeChunk(pePiece, i));
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int findPieceInEndGameMode(PEPeerTransport pt, int wants) {
        if (pt == null || wants <= 0 || pt.getPeerState() != 30) {
            return 0;
        }
        try {
            this.endGameModeChunks_mon.enter();
            int nbChunks = this.endGameModeChunks.size();
            if (nbChunks > 0) {
                int random = RandomUtils.generateRandomIntUpto(nbChunks);
                EndGameModeChunk chunk = (EndGameModeChunk)this.endGameModeChunks.get(random);
                int pieceNumber = chunk.getPieceNumber();
                if (this.dmPieces[pieceNumber].isWritten(chunk.getBlockNumber())) {
                    this.endGameModeChunks.remove(chunk);
                    int n = 0;
                    return n;
                }
                PEPiece pePiece = this.pePieces[pieceNumber];
                if (pt.isPieceAvailable(pieceNumber) && pePiece != null && (!pt.isSnubbed() || this.availability[pieceNumber] <= this.peerControl.getNbPeersSnubbed()) && pt.request(pieceNumber, chunk.getOffset(), chunk.getLength())) {
                    pePiece.setRequested(pt, chunk.getBlockNumber());
                    pt.setLastPiece(pieceNumber);
                    int n = 1;
                    return n;
                }
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFromEndGameModeChunks(int pieceNumber, int offset) {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            Iterator iter = this.endGameModeChunks.iterator();
            while (iter.hasNext()) {
                EndGameModeChunk chunk = (EndGameModeChunk)iter.next();
                if (!chunk.equals(pieceNumber, offset)) continue;
                iter.remove();
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearEndGameChunks() {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            this.endGameModeChunks.clear();
            this.endGameMode = false;
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    private boolean computeShapePriorities() {
        List list = this.priority_shapers.getList();
        if (list.size() == 0) {
            this.priority_shaper_priorities = null;
        } else {
            this.priority_shaper_priorities = new int[this.nbPieces];
            for (int i = 0; i < list.size(); ++i) {
                PiecePiecerPriorityShaper shaper = (PiecePiecerPriorityShaper)list.get(i);
                int[] offsets = shaper.updatePriorityOffsets(this);
                for (int j = 0; j < offsets.length; ++j) {
                    int n = j;
                    this.priority_shaper_priorities[n] = this.priority_shaper_priorities[n] + offsets[j];
                }
            }
        }
        return true;
    }

    public void addPriorityShaper(PiecePiecerPriorityShaper shaper) {
        this.priority_shapers.add(shaper);
    }

    public void removePriorityShaper(PiecePiecerPriorityShaper shaper) {
        this.priority_shapers.remove(shaper);
    }

    public String getPieceString(int piece_number) {
        return "pri=" + (this.startPriorities == null ? 0 : this.startPriorities[piece_number]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("Piece Picker");
        try {
            writer.indent();
            writer.println("globalAvail: " + this.globalAvail);
            writer.println("globalAvgAvail: " + this.globalAvgAvail);
            writer.println("nbRarestActive: " + this.nbRarestActive);
            writer.println("globalMin: " + this.globalMin);
            writer.println("globalMinOthers: " + this.globalMinOthers);
            writer.println("hasNeededUndonePiece: " + this.hasNeededUndonePiece);
            writer.println("endGameMode: " + this.endGameMode);
            writer.println("endGameModeAbandoned: " + this.endGameModeAbandoned);
            writer.println("endGameModeChunks: " + this.endGameModeChunks);
        }
        finally {
            writer.exdent();
        }
    }

    static {
        class ParameterListenerImpl
        implements ParameterListener {
            ParameterListenerImpl() {
            }

            public final void parameterChanged(String parameterName) {
                if (parameterName.equals("Prioritize Most Completed Files")) {
                    completionPriority = COConfigurationManager.getBooleanParameter(parameterName, false);
                    ++paramPriorityChange;
                } else if (parameterName.equals("Prioritize First Piece")) {
                    firstPiecePriority = COConfigurationManager.getBooleanParameter(parameterName, false);
                    ++paramPriorityChange;
                }
            }
        }
        ParameterListenerImpl parameterListener = new ParameterListenerImpl();
        COConfigurationManager.addParameterListener("Prioritize Most Completed Files", parameterListener);
        COConfigurationManager.addAndFireParameterListener("Prioritize First Piece", parameterListener);
    }

    private class DiskManagerListenerImpl
    implements DiskManagerListener {
        private DiskManagerListenerImpl() {
        }

        public final void stateChanged(int oldState, int newState) {
        }

        public final void filePriorityChanged(DiskManagerFileInfo file) {
            int endI;
            int startI;
            ++PiecePickerImpl.this.filePriorityChange;
            boolean foundPieceToDownload = false;
            if (PiecePickerImpl.this.hasNeededUndonePiece) {
                startI = 0;
                endI = PiecePickerImpl.this.nbPieces;
            } else {
                startI = file.getFirstPieceNumber();
                endI = file.getLastPieceNumber() + 1;
            }
            for (int i = startI; i < endI; ++i) {
                DiskManagerPiece dmPiece = PiecePickerImpl.this.dmPieces[i];
                if (dmPiece.isDone()) continue;
                foundPieceToDownload |= dmPiece.calcNeeded();
            }
            if (foundPieceToDownload ^ PiecePickerImpl.this.hasNeededUndonePiece) {
                PiecePickerImpl.this.hasNeededUndonePiece = foundPieceToDownload;
                ++PiecePickerImpl.this.neededUndonePieceChange;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pieceDoneChanged(DiskManagerPiece dmPiece) {
            int pieceNumber = dmPiece.getPieceNumber();
            if (dmPiece.isDone()) {
                PiecePickerImpl.this.addHavePiece(null, pieceNumber);
                ++PiecePickerImpl.this.nbPiecesDone;
                if (PiecePickerImpl.this.nbPiecesDone >= PiecePickerImpl.this.nbPieces) {
                    PiecePickerImpl.this.checkDownloadablePiece();
                }
            } else {
                try {
                    PiecePickerImpl.this.availabilityMon.enter();
                    if (PiecePickerImpl.this.availabilityAsynch == null) {
                        PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                    }
                    if (PiecePickerImpl.this.availabilityAsynch[pieceNumber] > 0) {
                        int n = pieceNumber;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                    } else {
                        ++PiecePickerImpl.this.availabilityDrift;
                    }
                    ++PiecePickerImpl.this.availabilityChange;
                }
                finally {
                    PiecePickerImpl.this.availabilityMon.exit();
                }
                --PiecePickerImpl.this.nbPiecesDone;
                if (dmPiece.calcNeeded() && !PiecePickerImpl.this.hasNeededUndonePiece) {
                    PiecePickerImpl.this.hasNeededUndonePiece = true;
                    ++PiecePickerImpl.this.neededUndonePieceChange;
                }
            }
        }

        public final void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
        }
    }

    private class PEPeerListenerImpl
    implements PEPeerListener {
        private PEPeerListenerImpl() {
        }

        public final void stateChanged(PEPeer peer, int newState) {
        }

        public final void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                for (int i = peerHavePieces.start; i <= peerHavePieces.end; ++i) {
                    if (!peerHavePieces.flags[i]) continue;
                    int n = i;
                    PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] + 1;
                }
                ++PiecePickerImpl.this.availabilityChange;
            }
            finally {
                PiecePickerImpl.this.availabilityMon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                for (int i = peerHavePieces.start; i <= peerHavePieces.end; ++i) {
                    if (!peerHavePieces.flags[i]) continue;
                    if (PiecePickerImpl.this.availabilityAsynch[i] > (PiecePickerImpl.this.dmPieces[i].isDone() ? 1 : 0)) {
                        int n = i;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                        continue;
                    }
                    ++PiecePickerImpl.this.availabilityDrift;
                }
                ++PiecePickerImpl.this.availabilityChange;
            }
            finally {
                PiecePickerImpl.this.availabilityMon.exit();
            }
        }
    }

    private class PEPeerManagerListenerImpl
    implements PEPeerManagerListener {
        private PEPeerManagerListenerImpl() {
        }

        public final void peerAdded(PEPeerManager manager, PEPeer peer) {
            PEPeerListenerImpl peerListener = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.get(peer);
            if (peerListener == null) {
                peerListener = new PEPeerListenerImpl();
                PiecePickerImpl.this.peerListeners.put(peer, peerListener);
            }
            peer.addListener(peerListener);
        }

        public final void peerRemoved(PEPeerManager manager, PEPeer peer) {
            PEPeerListenerImpl peerListener = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.remove(peer);
            peer.removeListener(peerListener);
        }
    }
}

