/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.SinglePeerUploader;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class WriteController {
    private volatile ArrayList normal_priority_entities = new ArrayList();
    private volatile ArrayList high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("WriteController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private static final int IDLE_SLEEP_TIME = 50;
    private EventWaiter write_waiter = new EventWaiter();

    public WriteController() {
        AEThread write_processor_thread = new AEThread("WriteController:WriteProcessor"){

            public void runSupport() {
                WriteController.this.writeProcessorLoop();
            }
        };
        write_processor_thread.setDaemon(true);
        write_processor_thread.setPriority(9);
        write_processor_thread.start();
    }

    private void writeProcessorLoop() {
        boolean check_high_first = true;
        while (true) {
            try {
                while (true) {
                    if (check_high_first) {
                        check_high_first = false;
                        if (this.doHighPriorityWrite() || this.doNormalPriorityWrite()) continue;
                        this.write_waiter.waitForEvent(50L);
                        continue;
                    }
                    check_high_first = true;
                    if (this.doNormalPriorityWrite() || this.doHighPriorityWrite()) continue;
                    this.write_waiter.waitForEvent(50L);
                }
            }
            catch (Throwable t) {
                Debug.out("writeProcessorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private boolean doNormalPriorityWrite() {
        RateControlledEntity ready_entity = this.getNextReadyNormalPriorityEntity();
        return ready_entity != null && ready_entity.doProcessing(this.write_waiter);
    }

    private boolean doHighPriorityWrite() {
        RateControlledEntity ready_entity = this.getNextReadyHighPriorityEntity();
        return ready_entity != null && ready_entity.doProcessing(this.write_waiter);
    }

    private RateControlledEntity getNextReadyNormalPriorityEntity() {
        ArrayList ref = this.normal_priority_entities;
        ArrayList<SinglePeerUploader> writable = new ArrayList<SinglePeerUploader>();
        double totalWritableWeight = 1.0E-4;
        for (RateControlledEntity rce : ref) {
            if (!rce.canProcess(this.write_waiter)) continue;
            SinglePeerUploader spu = (SinglePeerUploader)rce;
            writable.add(spu);
            totalWritableWeight += spu.getWeight();
        }
        double random = Math.random();
        double where = 0.0;
        SinglePeerUploader toReturn = null;
        for (SinglePeerUploader spu : writable) {
            if (where / totalWritableWeight <= random) {
                toReturn = spu;
            }
            where += spu.getWeight();
        }
        return toReturn;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledEntity entity = (RateControlledEntity)ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canProcess(this.write_waiter)) continue;
            return entity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
        }
        finally {
            this.entities_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList high_new = new ArrayList(this.high_priority_entities);
                high_new.remove(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList norm_new = new ArrayList(this.normal_priority_entities);
                norm_new.remove(entity);
                this.normal_priority_entities = norm_new;
            }
        }
        finally {
            this.entities_mon.exit();
        }
    }
}

