/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.HIThemeTrackDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.ProgressTrackInfo;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ProgressBarDrawData
extends RangeDrawData {
    public ProgressBarDrawData() {
        this.state = new int[1];
    }

    HIThemeTrackDrawInfo getInfo() {
        int state = this.state[0];
        HIThemeTrackDrawInfo info = new HIThemeTrackDrawInfo();
        info.min = this.minimum;
        info.max = this.maximum;
        info.value = this.selection;
        info.kind = (short)3;
        info.attributes = (short)4;
        if ((this.style & 0x100) != 0) {
            info.attributes = (short)(info.attributes | 1);
        }
        info.enableState = (byte)3;
        if ((state & 0x10) != 0) {
            info.enableState = 0;
        }
        if ((state & 0x20) != 0) {
            info.enableState = 1;
        }
        info.progress = new ProgressTrackInfo();
        return info;
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        HIThemeTrackDrawInfo info = this.getInfo();
        info.bounds_x = bounds.x;
        info.bounds_y = bounds.y;
        info.bounds_width = bounds.width;
        info.bounds_height = bounds.height;
        info.progress = new ProgressTrackInfo();
        OS.HIThemeDrawTrack(info, null, gc.handle, 0);
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }
}

