/****************************************************************************
** $Id:  fgui/glapparea.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/
#include "glapparea.h"
#include <qimage.h>
#include <qtimer.h>
#include <math.h>


GLAppArea::GLAppArea( QWidget* parent,QStringList* strlista)
    : QGLWidget( parent)
{

	ShowNormals=0;
	NS=0.5;
	ViewPortScale=1;
	Texture[0]=0;
	TextureAnt=0;
	EnableSelWin=0;
	setMouseTracking (TRUE);
	setAutoBufferSwap (TRUE);
	strlist=strlista;
	zNear=-1000.0;
	zFar=1000.0;
	RenderMode=1;
	RenderModeAnt=1;
	BackColor[0]=0.0;BackColor[1]=0.0;BackColor[2]=0.0;

	

	
}


GLAppArea::~GLAppArea()
{

}


void GLAppArea::DeleteAllTextures(){
	int i;
	for(i=1;i<100;i++){
		deleteTexture(Texture[i]);
		Texture[i]=0;
	}

}

void GLAppArea::LoadAllTextures(){
	int i;
	i=1;

	for(QStringList::Iterator it=strlist->begin();it!=strlist->end();++it){
		Load1Texture(*it,&Texture[i]);i++;
	
	}
}

void GLAppArea::Load1Texture(QString file,GLuint *tex)
{
     // Set up the textures

	QImage tex1,buf,bufm;
	QString ofile(file);
	if (!buf.load(file)) {	// Load first image from file
		emit SendText(tr("Could not read image file, using single color instead."));
		QImage dummy( 64, 64, QImage::Format_RGB32 );
		dummy.fill( 0x00ff00);
		buf = dummy.copy(0,0,64,64);
	}

	ofile.insert(file.lastIndexOf('.'),"_alpha");
	if (!bufm.load(ofile)) {	// Load first Alpha image from file
		QImage dummym(buf.width(),buf.height(),QImage::Format_RGB32);
		dummym.fill( 0xffffff);
		bufm = dummym.copy();
	}


	unsigned char *Data=new unsigned char[buf.width()*buf.height()*4];
	unsigned char *DataPtr;
	unsigned char *Datafin;
	
	int x,y;
	Datafin=DataPtr=Data;
	if(buf.width()==bufm.width()&&buf.height()==bufm.height()){
			for(y=buf.height()-1;y>=0;y--)
			for(x=0;x<buf.width();x++){
				*DataPtr++=qRed(buf.pixel(x,y));
				*DataPtr++=qGreen(buf.pixel(x,y));
				*DataPtr++=qBlue(buf.pixel(x,y));
				*DataPtr++=qRed(bufm.pixel(x,y));
			}
	}else{
			for(y=buf.height()-1;y>=0;y--)
			for(x=0;x<buf.width();x++){
				*DataPtr++=qRed(buf.pixel(x,y));
				*DataPtr++=qGreen(buf.pixel(x,y));
				*DataPtr++=qBlue(buf.pixel(x,y));
				*DataPtr++=0xff;
			}
	}


		glGenTextures(1, tex);
		// Create Linear Filtered Texture GetWidth  GetHeight
		glBindTexture(GL_TEXTURE_2D, *tex);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexImage2D( GL_TEXTURE_2D, 0, 4, buf.width(), buf.height(), 0,GL_RGBA, GL_UNSIGNED_BYTE,Datafin);

}
void GLAppArea::setDataL(QVector<d3line> *Info,QVector<d3triangle> *Infotri,QVector<tselect> *Info2,QVector<d3line> *Info3,QVector<d3triangle> *InfoSTV,int *mousei){
	DataLV=Info;
	DataTV=Infotri;
	DataSV=Info2;
	DataSLV=Info3;
	DataSTV=InfoSTV;
	MouseMode=mousei;
	
}

void GLAppArea::paintGL()
{
	d3line *DLV=DataLV->data();
	d3triangle *DTV=DataTV->data();
	d3line *DSLV=DataSLV->data();
	d3triangle *DSTV=DataSTV->data();
	tselect *DSV=DataSV->data();
	float m[16];

						/*glDisable(GL_BLEND);
						glDepthMask(GL_TRUE);*/

	int i,j,RPass=0;
	int RFlag=0;
	double var[5];
	GLint viewp[4];
	if(RenderMode!=RenderModeAnt){
		if(RenderMode){
			glPolygonMode(GL_FRONT, GL_FILL);glPolygonMode(GL_BACK,GL_LINE);glDisable(GL_POLYGON_OFFSET_LINE);
		}else{
			glPolygonMode(GL_FRONT,GL_LINE);glPolygonMode(GL_BACK,GL_LINE);glDisable(GL_POLYGON_OFFSET_LINE);
		}
	RenderModeAnt=RenderMode;
	}
	glGetIntegerv(GL_VIEWPORT,viewp);
	
	
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glEnable(GL_LIGHTING);
	
	for(;RPass<1;RPass++){
	
	if(RenderMode==2){
		if(RFlag){
			glEnable(GL_POLYGON_OFFSET_LINE);
			glPolygonMode(GL_FRONT, GL_LINE);glPolygonMode(GL_BACK,GL_LINE);glColorMask(1,1,1,1);
		}else{
			glPolygonMode(GL_FRONT, GL_FILL);glPolygonMode(GL_BACK,GL_FILL);glColorMask(0,0,0,0);
			RFlag++;RPass=-1;
		}
	}
	
	if(View[0]&2){
	glBegin(GL_TRIANGLES);
		for(i=0;i<DataTV->size();i++){
			if(DTV[i].texture!=TextureAnt){
				TextureAnt=DTV[i].texture;
				glEnd();glBindTexture(GL_TEXTURE_2D,Texture[DTV[i].texture]);glBegin(GL_TRIANGLES);
			}
			
			glColor3fv(DTV[i].c1);glNormal3fv(DTV[i].n1);glTexCoord2fv(DTV[i].t1);
			glVertex3fv(DTV[i].v1);
			glColor3fv(DTV[i].c2);glNormal3fv(DTV[i].n2);glTexCoord2fv(DTV[i].t2);
			glVertex3fv(DTV[i].v2);
			glColor3fv(DTV[i].c3);glNormal3fv(DTV[i].n3);glTexCoord2fv(DTV[i].t3);
			glVertex3fv(DTV[i].v3);
		}
		
		if(*GripEditMode==4){/*STRETCH*/
			for(i=0;i<DataSV->size();i++){
				if(DSV[i].type==2){
					if(DTV[DSV[i].index].texture!=TextureAnt){
						TextureAnt=DTV[DSV[i].index].texture;
						glEnd();glBindTexture(GL_TEXTURE_2D,Texture[TextureAnt]);glBegin(GL_TRIANGLES);
					}
				glColor3fv(DTV[DSV[i].index].c1);glNormal3fv(DTV[DSV[i].index].n1);glTexCoord2fv(DTV[DSV[i].index].t1);
					if((DTV[DSV[i].index].v1[0]==GriPoint->v[0])&&(DTV[DSV[i].index].v1[1]==GriPoint->v[1])&&(DTV[DSV[i].index].v1[2]==GriPoint->v[2])){
						glVertex3fv(currentpoint->v);
					}else{
						glVertex3fv(DTV[DSV[i].index].v1);
					}
				glColor3fv(DTV[DSV[i].index].c2);glNormal3fv(DTV[DSV[i].index].n2);glTexCoord2fv(DTV[DSV[i].index].t2);
					if((DTV[DSV[i].index].v2[0]==GriPoint->v[0])&&(DTV[DSV[i].index].v2[1]==GriPoint->v[1])&&(DTV[DSV[i].index].v2[2]==GriPoint->v[2])){
						glVertex3fv(currentpoint->v);
					}else{
						glVertex3fv(DTV[DSV[i].index].v2);
					}
				glColor3fv(DTV[DSV[i].index].c3);glNormal3fv(DTV[DSV[i].index].n3);glTexCoord2fv(DTV[DSV[i].index].t3);
					if((DTV[DSV[i].index].v3[0]==GriPoint->v[0])&&(DTV[DSV[i].index].v3[1]==GriPoint->v[1])&&(DTV[DSV[i].index].v3[2]==GriPoint->v[2])){
						glVertex3fv(currentpoint->v);
					}else{
						glVertex3fv(DTV[DSV[i].index].v3);
					}
				}
			}
		}
		if(*GripEditMode==5){/*ROTATE*/
			var[0]=(currentpoint->v[0]-GriPoint->v[0]);var[1]=(currentpoint->v[1]-GriPoint->v[1]);
			var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
			if(var[2]){
			for(i=0;i<DataSTV->size();i++){
				
				if(DSTV[i].texture!=TextureAnt){
					TextureAnt=DSTV[i].texture;
					glEnd();glBindTexture(GL_TEXTURE_2D,Texture[TextureAnt]);glBegin(GL_TRIANGLES);
				}
				glColor3fv(DSTV[i].c1);glNormal3fv(DSTV[i].n1);glTexCoord2fv(DSTV[i].t1);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v1[0]*var[0]-DSTV[i].v1[1]*var[1])/var[2],GriPoint->v[1]+(DSTV[i].v1[1]*var[0]+DSTV[i].v1[0]*var[1])/var[2],DSTV[i].v1[2]);
				
				glColor3fv(DSTV[i].c2);glNormal3fv(DSTV[i].n2);glTexCoord2fv(DSTV[i].t2);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v2[0]*var[0]-DSTV[i].v2[1]*var[1])/var[2],GriPoint->v[1]+(DSTV[i].v2[1]*var[0]+DSTV[i].v2[0]*var[1])/var[2],DSTV[i].v2[2]);
				
				glColor3fv(DSTV[i].c3);glNormal3fv(DSTV[i].n3);glTexCoord2fv(DSTV[i].t3);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v3[0]*var[0]-DSTV[i].v3[1]*var[1])/var[2],GriPoint->v[1]+(DSTV[i].v3[1]*var[0]+DSTV[i].v3[0]*var[1])/var[2],DSTV[i].v3[2]);
			
			}
			}
		}
		if(*GripEditMode==3){/*MOVE*/
			for(i=0;i<DataSTV->size();i++){
				if(DSTV[i].texture!=TextureAnt){
					TextureAnt=DSTV[i].texture;
					glEnd();glBindTexture(GL_TEXTURE_2D,Texture[TextureAnt]);glBegin(GL_TRIANGLES);
				}
				glColor3fv(DSTV[i].c1);glNormal3fv(DSTV[i].n1);glTexCoord2fv(DSTV[i].t1);
				glVertex3f(DSTV[i].v1[0]+currentpoint->v[0],DSTV[i].v1[1]+currentpoint->v[1],DSTV[i].v1[2]+currentpoint->v[2]);
				
				glColor3fv(DSTV[i].c2);glNormal3fv(DSTV[i].n2);glTexCoord2fv(DSTV[i].t2);
				glVertex3f(DSTV[i].v2[0]+currentpoint->v[0],DSTV[i].v2[1]+currentpoint->v[1],DSTV[i].v2[2]+currentpoint->v[2]);
				
				glColor3fv(DSTV[i].c3);glNormal3fv(DSTV[i].n3);glTexCoord2fv(DSTV[i].t3);
				glVertex3f(DSTV[i].v3[0]+currentpoint->v[0],DSTV[i].v3[1]+currentpoint->v[1],DSTV[i].v3[2]+currentpoint->v[2]);
			}
		}
		if(*GripEditMode==2){/*SCALE*/
			var[0]=(currentpoint->v[0]-GriPoint->v[0]);var[1]=(currentpoint->v[1]-GriPoint->v[1]);
			var[2]=sqrt(var[0]*var[0]+var[1]*var[1])/cscalarf[0];
			if(cscalari[0]==1){
			for(i=0;i<DataSTV->size();i++){
				if(DSTV[i].texture!=TextureAnt){
					TextureAnt=DSTV[i].texture;
					glEnd();glBindTexture(GL_TEXTURE_2D,Texture[TextureAnt]);glBegin(GL_TRIANGLES);
				}
				glColor3fv(DSTV[i].c1);glNormal3fv(DSTV[i].n1);glTexCoord2fv(DSTV[i].t1);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v1[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSTV[i].v1[1]-GriPoint->v[1]),GriPoint->v[2]+(DSTV[i].v1[2]-GriPoint->v[2]));
				
				glColor3fv(DSTV[i].c2);glNormal3fv(DSTV[i].n2);glTexCoord2fv(DSTV[i].t2);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v2[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSTV[i].v2[1]-GriPoint->v[1]),GriPoint->v[2]+(DSTV[i].v2[2]-GriPoint->v[2]));
				
				glColor3fv(DSTV[i].c3);glNormal3fv(DSTV[i].n3);glTexCoord2fv(DSTV[i].t3);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v3[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSTV[i].v3[1]-GriPoint->v[1]),GriPoint->v[2]+(DSTV[i].v3[2]-GriPoint->v[2]));
			}
			}
			if(cscalari[0]==2){
			for(i=0;i<DataSTV->size();i++){
				if(DSTV[i].texture!=TextureAnt){
					TextureAnt=DSTV[i].texture;
					glEnd();glBindTexture(GL_TEXTURE_2D,Texture[TextureAnt]);glBegin(GL_TRIANGLES);
				}
				glColor3fv(DSTV[i].c1);glNormal3fv(DSTV[i].n1);glTexCoord2fv(DSTV[i].t1);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v1[0]-GriPoint->v[0]),GriPoint->v[1]+(DSTV[i].v1[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSTV[i].v1[2]-GriPoint->v[2]));
				
				glColor3fv(DSTV[i].c2);glNormal3fv(DSTV[i].n2);glTexCoord2fv(DSTV[i].t2);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v2[0]-GriPoint->v[0]),GriPoint->v[1]+(DSTV[i].v2[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSTV[i].v2[2]-GriPoint->v[2]));
				
				glColor3fv(DSTV[i].c3);glNormal3fv(DSTV[i].n3);glTexCoord2fv(DSTV[i].t3);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v3[0]-GriPoint->v[0]),GriPoint->v[1]+(DSTV[i].v3[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSTV[i].v3[2]-GriPoint->v[2]));
			}
			}
			if(cscalari[0]==4){
			for(i=0;i<DataSTV->size();i++){
				if(DSTV[i].texture!=TextureAnt){
					TextureAnt=DSTV[i].texture;
					glEnd();glBindTexture(GL_TEXTURE_2D,Texture[TextureAnt]);glBegin(GL_TRIANGLES);
				}
				glColor3fv(DSTV[i].c1);glNormal3fv(DSTV[i].n1);glTexCoord2fv(DSTV[i].t1);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v1[0]-GriPoint->v[0]),GriPoint->v[1]+(DSTV[i].v1[1]-GriPoint->v[1]),GriPoint->v[2]+(DSTV[i].v1[2]-GriPoint->v[2])*var[2]);
				
				glColor3fv(DSTV[i].c2);glNormal3fv(DSTV[i].n2);glTexCoord2fv(DSTV[i].t2);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v2[0]-GriPoint->v[0]),GriPoint->v[1]+(DSTV[i].v2[1]-GriPoint->v[1]),GriPoint->v[2]+(DSTV[i].v2[2]-GriPoint->v[2])*var[2]);
				
				glColor3fv(DSTV[i].c3);glNormal3fv(DSTV[i].n3);glTexCoord2fv(DSTV[i].t3);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v3[0]-GriPoint->v[0]),GriPoint->v[1]+(DSTV[i].v3[1]-GriPoint->v[1]),GriPoint->v[2]+(DSTV[i].v3[2]-GriPoint->v[2])*var[2]);
			}
			}
			if(cscalari[0]==7){
			for(i=0;i<DataSTV->size();i++){
				if(DSTV[i].texture!=TextureAnt){
					TextureAnt=DSTV[i].texture;
					glEnd();glBindTexture(GL_TEXTURE_2D,Texture[TextureAnt]);glBegin(GL_TRIANGLES);
				}
				glColor3fv(DSTV[i].c1);glNormal3fv(DSTV[i].n1);glTexCoord2fv(DSTV[i].t1);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v1[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSTV[i].v1[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSTV[i].v1[2]-GriPoint->v[2])*var[2]);
				
				glColor3fv(DSTV[i].c2);glNormal3fv(DSTV[i].n2);glTexCoord2fv(DSTV[i].t2);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v2[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSTV[i].v2[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSTV[i].v2[2]-GriPoint->v[2])*var[2]);
				
				glColor3fv(DSTV[i].c3);glNormal3fv(DSTV[i].n3);glTexCoord2fv(DSTV[i].t3);
				glVertex3f(GriPoint->v[0]+(DSTV[i].v3[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSTV[i].v3[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSTV[i].v3[2]-GriPoint->v[2])*var[2]);
			}
			}
		}
		if(*GripEditMode==1){/*MIRROR*/
			var[0]=(currentpoint->v[0]-GriPoint->v[0]);var[1]=(currentpoint->v[1]-GriPoint->v[1]);var[2]=0;
			var[3]=var[0]*var[0]+var[1]*var[1];
			if(var[3]){
			for(i=0;i<DataSTV->size();i++){
				if(DSTV[i].texture!=TextureAnt){
					TextureAnt=DSTV[i].texture;
					glEnd();glBindTexture(GL_TEXTURE_2D,Texture[TextureAnt]);glBegin(GL_TRIANGLES);
				}
				glColor3fv(DSTV[i].c1);glNormal3fv(DSTV[i].n1);glTexCoord2fv(DSTV[i].t1);
				var[4]=(DSTV[i].v1[0]*var[0]+DSTV[i].v1[1]*var[1]+DSTV[i].v1[2]*var[2])/var[3];
				glVertex3f(GriPoint->v[0]+(2.0*var[4]*var[0])-DSTV[i].v1[0],GriPoint->v[1]+(2.0*var[4]*var[1])-DSTV[i].v1[1],GriPoint->v[2]+DSTV[i].v1[2]);
				
				glColor3fv(DSTV[i].c2);glNormal3fv(DSTV[i].n2);glTexCoord2fv(DSTV[i].t2);
				var[4]=(DSTV[i].v2[0]*var[0]+DSTV[i].v2[1]*var[1]+DSTV[i].v2[2]*var[2])/var[3];
				glVertex3f(GriPoint->v[0]+(2.0*var[4]*var[0])-DSTV[i].v2[0],GriPoint->v[1]+(2.0*var[4]*var[1])-DSTV[i].v2[1],GriPoint->v[2]+DSTV[i].v2[2]);
				
				glColor3fv(DSTV[i].c3);glNormal3fv(DSTV[i].n3);glTexCoord2fv(DSTV[i].t3);
				var[4]=(DSTV[i].v3[0]*var[0]+DSTV[i].v3[1]*var[1]+DSTV[i].v3[2]*var[2])/var[3];
				glVertex3f(GriPoint->v[0]+(2.0*var[4]*var[0])-DSTV[i].v3[0],GriPoint->v[1]+(2.0*var[4]*var[1])-DSTV[i].v3[1],GriPoint->v[2]+DSTV[i].v3[2]);
			}
			}
		}
	glEnd();
	}/*View[0]&2*/
	}
	
	glBindTexture(GL_TEXTURE_2D,0);TextureAnt=0;
	glDisable(GL_LIGHTING);
	glBegin(GL_LINES);
	if(View[0]&1){
		for(i=0;i<DataLV->size();i++){
			glColor3fv(DLV[i].c1);glVertex3fv(DLV[i].v1);
			glColor3fv(DLV[i].c2);glVertex3fv(DLV[i].v2);

		}
		
		if(*GripEditMode==3){/*MOVE*/
			for(i=0;i<DataSLV->size();i++){
				glColor3fv(DSLV[i].c1);glVertex3f(DSLV[i].v1[0]+currentpoint->v[0],DSLV[i].v1[1]+currentpoint->v[1],DSLV[i].v1[2]+currentpoint->v[2]);
				glColor3fv(DSLV[i].c2);glVertex3f(DSLV[i].v2[0]+currentpoint->v[0],DSLV[i].v2[1]+currentpoint->v[1],DSLV[i].v2[2]+currentpoint->v[2]);
			}
		}
		
		if(*GripEditMode==2){/*SCALE*/
			var[0]=(currentpoint->v[0]-GriPoint->v[0]);var[1]=(currentpoint->v[1]-GriPoint->v[1]);
			var[2]=sqrt(var[0]*var[0]+var[1]*var[1])/cscalarf[0];
			if(cscalari[0]==1){
			for(i=0;i<DataSLV->size();i++){
				glColor3fv(DSLV[i].c1);glVertex3f(GriPoint->v[0]+(DSLV[i].v1[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSLV[i].v1[1]-GriPoint->v[1]),GriPoint->v[2]+(DSLV[i].v1[2]-GriPoint->v[2]));
				glColor3fv(DSLV[i].c2);glVertex3f(GriPoint->v[0]+(DSLV[i].v2[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSLV[i].v2[1]-GriPoint->v[1]),GriPoint->v[2]+(DSLV[i].v2[2]-GriPoint->v[2]));
			}
			}
			if(cscalari[0]==2){
			for(i=0;i<DataSLV->size();i++){
				glColor3fv(DSLV[i].c1);glVertex3f(GriPoint->v[0]+(DSLV[i].v1[0]-GriPoint->v[0]),GriPoint->v[1]+(DSLV[i].v1[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSLV[i].v1[2]-GriPoint->v[2]));
				glColor3fv(DSLV[i].c2);glVertex3f(GriPoint->v[0]+(DSLV[i].v2[0]-GriPoint->v[0]),GriPoint->v[1]+(DSLV[i].v2[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSLV[i].v2[2]-GriPoint->v[2]));
			}
			}
			if(cscalari[0]==4){
			for(i=0;i<DataSLV->size();i++){
				glColor3fv(DSLV[i].c1);glVertex3f(GriPoint->v[0]+(DSLV[i].v1[0]-GriPoint->v[0]),GriPoint->v[1]+(DSLV[i].v1[1]-GriPoint->v[1]),GriPoint->v[2]+(DSLV[i].v1[2]-GriPoint->v[2])*var[2]);
				glColor3fv(DSLV[i].c2);glVertex3f(GriPoint->v[0]+(DSLV[i].v2[0]-GriPoint->v[0]),GriPoint->v[1]+(DSLV[i].v2[1]-GriPoint->v[1]),GriPoint->v[2]+(DSLV[i].v2[2]-GriPoint->v[2])*var[2]);
			}
			}
			if(cscalari[0]==7){
			for(i=0;i<DataSLV->size();i++){
				glColor3fv(DSLV[i].c1);glVertex3f(GriPoint->v[0]+(DSLV[i].v1[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSLV[i].v1[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSLV[i].v1[2]-GriPoint->v[2])*var[2]);
				glColor3fv(DSLV[i].c2);glVertex3f(GriPoint->v[0]+(DSLV[i].v2[0]-GriPoint->v[0])*var[2],GriPoint->v[1]+(DSLV[i].v2[1]-GriPoint->v[1])*var[2],GriPoint->v[2]+(DSLV[i].v2[2]-GriPoint->v[2])*var[2]);
			}
			}
		}
		
		if(*GripEditMode==1){/*MIRROR*/
			var[0]=(currentpoint->v[0]-GriPoint->v[0]);var[1]=(currentpoint->v[1]-GriPoint->v[1]);var[2]=0;
			var[3]=var[0]*var[0]+var[1]*var[1];
			if(var[3]){
				for(i=0;i<DataSLV->size();i++){
					var[4]=(DSLV[i].v1[0]*var[0]+DSLV[i].v1[1]*var[1]+DSLV[i].v1[2]*var[2])/var[3];
					glColor3fv(DSLV[i].c1);glVertex3f(GriPoint->v[0]+(2.0*var[4]*var[0])-DSLV[i].v1[0],GriPoint->v[1]+(2.0*var[4]*var[1])-DSLV[i].v1[1],GriPoint->v[2]+DSLV[i].v1[2]);
					var[4]=(DSLV[i].v2[0]*var[0]+DSLV[i].v2[1]*var[1]+DSLV[i].v2[2]*var[2])/var[3];
					glColor3fv(DSLV[i].c2);glVertex3f(GriPoint->v[0]+(2.0*var[4]*var[0])-DSLV[i].v2[0],GriPoint->v[1]+(2.0*var[4]*var[1])-DSLV[i].v2[1],GriPoint->v[2]+DSLV[i].v2[2]);
				}
			}
		}
		
		if(*GripEditMode==4){/*STRETCH*/
			for(i=0;i<DataSV->size();i++){
				if(DSV[i].type==1){
					glColor3fv(DLV[DSV[i].index].c1);
					if((DLV[DSV[i].index].v1[0]==GriPoint->v[0])&&(DLV[DSV[i].index].v1[1]==GriPoint->v[1])&&(DLV[DSV[i].index].v1[2]==GriPoint->v[2])){
						glVertex3fv(currentpoint->v);
					}else{
						glVertex3fv(DLV[DSV[i].index].v1);
					}
					glColor3fv(DLV[DSV[i].index].c2);
					if((DLV[DSV[i].index].v2[0]==GriPoint->v[0])&&(DLV[DSV[i].index].v2[1]==GriPoint->v[1])&&(DLV[DSV[i].index].v2[2]==GriPoint->v[2])){
						glVertex3fv(currentpoint->v);
					}else{
						glVertex3fv(DLV[DSV[i].index].v2);
					}
				}
			}
		}
		if(*GripEditMode==5){/*ROTATE*/
			var[0]=(currentpoint->v[0]-GriPoint->v[0]);var[1]=(currentpoint->v[1]-GriPoint->v[1]);
			var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
			if(var[2]){
				for(i=0;i<DataSLV->size();i++){
					glColor3fv(DSLV[i].c1);
					glVertex3f(GriPoint->v[0]+(DSLV[i].v1[0]*var[0]-DSLV[i].v1[1]*var[1])/var[2],
					GriPoint->v[1]+(DSLV[i].v1[1]*var[0]+DSLV[i].v1[0]*var[1])/var[2],
					DSLV[i].v1[2]);
					glColor3fv(DSLV[i].c2);
					glVertex3f(GriPoint->v[0]+(DSLV[i].v2[0]*var[0]-DSLV[i].v2[1]*var[1])/var[2],
					GriPoint->v[1]+(DSLV[i].v2[1]*var[0]+DSLV[i].v2[0]*var[1])/var[2],
					DSLV[i].v2[2]);
				}
			}
		}
	}/*View[0]&1*/
		if(rtlines->find){
			glColor3fv(rtcolor);glVertex3fv(rtlines->v);
			glColor3fv(currentcolor);glVertex3fv(currentpoint->v);
		}
		if(rtlines[1].find){
			glColor3fv(rtcolor);glVertex3fv(rtlines[0].v);
			glColor3fv(rtcolor1);glVertex3fv(rtlines[1].v);
		}
		
		glColor3f(1,1,1);
		if(ShowNormals){
			for(i=0;i<DataTV->size();i++){
			glVertex3fv(DTV[i].v1);
			glVertex3f(DTV[i].v1[0]+DTV[i].n1[0]*NS,DTV[i].v1[1]+DTV[i].n1[1]*NS,DTV[i].v1[2]+DTV[i].n1[2]*NS);
			glVertex3fv(DTV[i].v2);
			glVertex3f(DTV[i].v2[0]+DTV[i].n2[0]*NS,DTV[i].v2[1]+DTV[i].n2[1]*NS,DTV[i].v2[2]+DTV[i].n2[2]*NS);
			glVertex3fv(DTV[i].v3);
			glVertex3f(DTV[i].v3[0]+DTV[i].n3[0]*NS,DTV[i].v3[1]+DTV[i].n3[1]*NS,DTV[i].v3[2]+DTV[i].n3[2]*NS);
			}
		
		}
		
		
		
	glEnd();
	
	
	glColor3f(0,0,1);
	glBegin(GL_POINTS);
		for(i=0;i<DataSV->size();i++){
			if(DSV[i].type==1){
				j=DSV[i].index;
				glVertex3fv(DLV[j].v1);glVertex3fv(DLV[j].v2);
				glVertex3f((DLV[j].v1[0]+DLV[j].v2[0])/2.0,(DLV[j].v1[1]+DLV[j].v2[1])/2.0,(DLV[j].v1[2]+DLV[j].v2[2])/2.0);
			}
			if(DSV[i].type==2){
				j=DSV[i].index;
				glVertex3fv(DTV[j].v1);glVertex3fv(DTV[j].v2);glVertex3fv(DTV[j].v3);
				glVertex3f((DTV[j].v1[0]+DTV[j].v2[0])/2.0,(DTV[j].v1[1]+DTV[j].v2[1])/2.0,(DTV[j].v1[2]+DTV[j].v2[2])/2.0);
				glVertex3f((DTV[j].v2[0]+DTV[j].v3[0])/2.0,(DTV[j].v2[1]+DTV[j].v3[1])/2.0,(DTV[j].v2[2]+DTV[j].v3[2])/2.0);
				glVertex3f((DTV[j].v1[0]+DTV[j].v3[0])/2.0,(DTV[j].v1[1]+DTV[j].v3[1])/2.0,(DTV[j].v1[2]+DTV[j].v3[2])/2.0);
			}
		}
	if(GripEditMode[0]>0){
		glColor3f(1,0,0);
		glVertex3fv(GriPoint->v);
	}
	
	if(SnapMode[0]&&SnaPoint->find){
		glColor3f(1,1,0);
		glVertex3fv(SnaPoint->v);
	}
	glEnd();
	
	if(EnableSelWin){
		glColor3f(1,1,1);
		glDepthFunc(GL_ALWAYS);
		glEnable(GL_LINE_STIPPLE);
		glMatrixMode(GL_PROJECTION);glPushMatrix();glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);glPushMatrix();glLoadIdentity();
		glBegin(GL_LINE_STRIP);
			glVertex3f(2.0*selectionRect.topLeft().x()/viewp[2]-1.0,1-2.0*selectionRect.topLeft().y()/viewp[3],0);
			glVertex3f(2.0*selectionRect.topLeft().x()/viewp[2]-1.0,1-2.0*selectionRect.bottomRight().y()/viewp[3],0);
			glVertex3f(2.0*selectionRect.bottomRight().x()/viewp[2]-1.0,1-2.0*selectionRect.bottomRight().y()/viewp[3],0);
			glVertex3f(2.0*selectionRect.bottomRight().x()/viewp[2]-1.0,1-2.0*selectionRect.topLeft().y()/viewp[3],0);
			glVertex3f(2.0*selectionRect.topLeft().x()/viewp[2]-1.0,1-2.0*selectionRect.topLeft().y()/viewp[3],0);
	
		glEnd();
		glPopMatrix();glMatrixMode(GL_PROJECTION);glPopMatrix();glMatrixMode(GL_MODELVIEW);
		glDisable(GL_LINE_STIPPLE);
		glDepthFunc(GL_LEQUAL);
	}
	
	if(*ucsicon){
		glViewport(0,0,viewp[2]/5,viewp[3]/5);
		glClear(GL_DEPTH_BUFFER_BIT);
	        glMatrixMode(GL_PROJECTION);glPushMatrix();glLoadIdentity();
        	glOrtho(-(GLfloat)(viewp[2])/(GLfloat)(viewp[3]),(GLfloat)(viewp[2])/(GLfloat)(viewp[3]),-1.0,1.0,-2.0,2.0);
		glMatrixMode(GL_MODELVIEW);glPushMatrix();
		glGetFloatv(GL_MODELVIEW_MATRIX,m);
		glLineWidth(3.0);
		m[12]=0.0;m[13]=0.0;m[14]=0.0;
		glLoadMatrixf(m);
		glBegin(GL_LINES);
				glColor3f(1.0,0.0,0.0);glVertex3f(0.0,0.0,0.0);glVertex3f(1.0,0.0,0.0);
				glColor3f(0.0,1.0,0.0);glVertex3f(0.0,0.0,0.0);glVertex3f(0.0,1.0,0.0);
				glColor3f(0.0,0.0,1.0);glVertex3f(0.0,0.0,0.0);glVertex3f(0.0,0.0,1.0);
		glEnd();
		glLineWidth(1.0);
		glViewport(0,0,viewp[2],viewp[3]);
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);glPopMatrix();
	        glMatrixMode(GL_MODELVIEW);
	}
	

}



void GLAppArea::initializeGL()
{
	int i;
	i=1;

	for(QStringList::Iterator it=strlist->begin();it!=strlist->end();++it){
		Load1Texture(*it,&Texture[i]);i++;
	}
	

	/*Load1Texture("c:\\crate.bmp",&Texture[0]);*/
	GLfloat LightAmbient[]={0.0,0.0,0.0,0.0};
	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	glClearDepth(1.0f);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glPointSize(6);/*9*/
	glDisable(GL_LINE_STIPPLE);
	glLineStipple(1,0xf0f0);
	glLineWidth(1.0);
	/*glEnable(GL_POLYGON_OFFSET_LINE);*/
	glPolygonOffset(0.0,-15.0);
	/*cuad=gluNewQuadric();
	gluQuadricNormals(cuad, GLU_SMOOTH);
	gluQuadricTexture(cuad, GL_TRUE);*/
        glPolygonMode(GL_FRONT, GL_FILL);
        glPolygonMode(GL_BACK,GL_LINE);
        glBlendFunc(GL_SRC_ALPHA,GL_DST_ALPHA);//GL_SRC_COLOR,GL_DST_COLOR);
        //glPolygonMode(GL_FRONT_AND_BACK,GL_LINE); //GL_FRONT_AND_BACK//GL_FILL//GL_LINE//GL_POINT
	glLightfv(GL_LIGHT0, GL_AMBIENT, LightAmbient);
        /*glLightfv(GL_LIGHT0, GL_DIFFUSE, LightDiffuse);
        glLightfv(GL_LIGHT0, GL_POSITION,LightPosition);*/
        glColorMaterial(GL_FRONT_AND_BACK,GL_AMBIENT_AND_DIFFUSE);
        glBindTexture(GL_TEXTURE_2D, Texture[0]);
        //glEnable(GL_CULL_FACE);
	//glEnable(GL_TEXTURE_GEN_S);
	//glEnable(GL_TEXTURE_GEN_T);
        glEnable(GL_AUTO_NORMAL);
        glEnable(GL_COLOR_MATERIAL);
        glEnable(GL_LIGHT0);
        /*glDisable(GL_LIGHTING);*/
	glEnable(GL_LIGHTING);
        glEnable(GL_DEPTH_TEST);
        glEnable(GL_TEXTURE_2D);
	glMatrixMode(GL_PROJECTION);glLoadIdentity();

	glEnable(GL_ALPHA_TEST);glAlphaFunc(GL_GEQUAL,0.5);
}

void GLAppArea::resizeGL( int width, int height )
{
	if (!height)
        height=1;
	glViewport(0,0,width,height);
        glMatrixMode(GL_PROJECTION);glLoadIdentity();
        glOrtho(-(GLfloat)width*ViewPortScale/(GLfloat)height,(GLfloat)width*ViewPortScale/(GLfloat)height,-ViewPortScale,ViewPortScale,zNear,zFar);
        /*gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,1.0f,1000.0f);*/
        glMatrixMode(GL_MODELVIEW);
	/*glLoadIdentity();glTranslatef(0.0,0.0,-50.0);*/
}

void GLAppArea::PublicUpdate()
{
	GLint viewp[4];
	makeCurrent();
	glGetIntegerv(GL_VIEWPORT,viewp);
        glMatrixMode(GL_PROJECTION);glLoadIdentity();
        glOrtho(-(GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3],(GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3],-ViewPortScale,ViewPortScale,zNear,zFar);
        /*gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,1.0f,1000.0f);*/
        glMatrixMode(GL_MODELVIEW);
	/*glLoadIdentity();glTranslatef(0.0,0.0,-50.0);*/
	updateGL();
}

void GLAppArea::mousePressEvent ( QMouseEvent * e )
{
	
	makeCurrent ();
	tselect *DSV=DataSV->data();
	double dm[16],dm2[16],dm3[16];
	GLdouble winX,winY,winZ;
	GLint viewp[4];
	int i,j,find=1;
	int id;
	tselect objtemp;
	dataformat pickpoint;
	pickpoint.format=0;
	pickpoint.v[0]=pickpoint.v[1]=pickpoint.v[2]=0;

	switch(MouseMode[0]){
		case MOUSEMODE_PICKPOINT:
		if(e->button()==Qt::LeftButton){
			if(SnapMode[0]&&SnaPoint->find){
			pickpoint.v[0]=SnaPoint->v[0];pickpoint.v[1]=SnaPoint->v[1];pickpoint.v[2]=SnaPoint->v[2];
			}else{
				if(currentpoint->find){
					pickpoint.v[0]=currentpoint->v[0];pickpoint.v[1]=currentpoint->v[1];pickpoint.v[2]=currentpoint->v[2];
				}else{
					glGetDoublev(GL_MODELVIEW_MATRIX,dm);glGetDoublev(GL_PROJECTION_MATRIX,dm2);
					glGetIntegerv(GL_VIEWPORT,viewp);MatrixMultd(dm2,dm,dm3);
					winX=((2.0*e->x())/(float)viewp[2]-1-dm3[12]);winY=((2.0*(viewp[3]-e->y()))/(float)viewp[3]-1-dm3[13]);winZ=dm3[0]*dm3[5]-dm3[1]*dm3[4];
					
						winZ=dm3[0]*dm3[5]-dm3[1]*dm3[4];				
						if(winZ!=0){pickpoint.v[0]=(winX*dm3[5]-dm3[4]*winY)/winZ;
						pickpoint.v[1]=(dm3[0]*winY-winX*dm3[1])/winZ;pickpoint.v[2]=0;
						if(*GripEditMode==4){/*STRETCH MODE*/
							pickpoint.v[2]=GriPoint->v[2];
						}
						}
					
					
	
				}
			}
			SnaPoint->find=0;
			emit setCmdData(pickpoint);
		}
		if(e->button()==Qt::RightButton){
			emit processcmd("MouseRButton");
		}
		emit UpdateAll();
		makeCurrent();
		break;
		case MOUSEMODE_SELECT:
		if(e->button()==Qt::LeftButton){
			GriPoint[0].find=currentpoint->find;
			if(currentpoint->find){
				GriPoint->v[0]=currentpoint->v[0];GriPoint->v[1]=currentpoint->v[1];GriPoint->v[2]=currentpoint->v[2];
				QMenu *menu = new QMenu(this);
				QMenu *MPoint = new QMenu;
				QAction *MHActions;
				QAction *Act1,*Act2,*Act3,*Act4,*Act5,*Act6;
				QAction *PActColor,*PActTex,*PActNor;
				Act1=new QAction(tr("Move"),this);Act1->setData(3);Act2=new QAction(tr("Scale"),this);Act2->setData(2);
				Act3=new QAction(tr("Stretch"),this);Act3->setData(4);Act4=new QAction(tr("Rotate"),this);Act4->setData(5);
				Act5=new QAction(tr("Mirror"),this);Act5->setData(1);Act6=new QAction(tr("Exit"),this);Act6->setData(0);
				PActTex=new QAction(tr("Texture"),this);PActTex->setData(10);
				PActColor=new QAction(tr("Color"),this);PActColor->setData(11);
				PActNor=new QAction(tr("Normal"),this);PActNor->setData(12);
				
				menu->addAction(Act1);menu->addAction(Act2);menu->addAction(Act3);menu->addAction(Act4);
				menu->addAction(Act5);menu->addSeparator();
				MPoint=menu->addMenu(tr("&Point"));
					MPoint->addAction(PActTex);
					MPoint->addAction(PActColor);
					MPoint->addAction(PActNor);
				menu->addAction(Act6);
				menu->setMouseTracking( TRUE );
				MHActions=menu->exec(e->globalPos());
				if(MHActions){
					*GripEditMode = MHActions->data().toInt();
					if(*GripEditMode==0)emit processcmd(tr("**Cancel**"));if(*GripEditMode==5)emit processcmd("griprotate");if(*GripEditMode==4)emit processcmd("gripstretch");if(*GripEditMode==2)emit processcmd("gripscale");if(*GripEditMode==3)emit processcmd("gripmove");if(*GripEditMode==1)emit processcmd("gripmirror");
					if(*GripEditMode==10){*GripEditMode=0;emit processcmd("grippointtexture");}
					if(*GripEditMode==11){*GripEditMode=0;emit processcmd("grippointcolor");}
					if(*GripEditMode==12){*GripEditMode=0;emit processcmd("grippointnormal");}
				}else{
					emit processcmd(tr("**Cancel**"));
				}
				delete menu;
				
			
			}else{
				objtemp=search(e->x(),e->y(),7,7);
				if(objtemp.type>0){
					for(i=0;i<DataSV->size();i++){
						if(DSV[i].index==objtemp.index&&DSV[i].type==objtemp.type){
							find=0;j=DataSV->size()-1;
							DSV[i].index=DSV[j].index;
							DSV[i].type=DSV[j].type;
							DataSV->resize(j);
						}
					}
					if(find){
						DataSV->resize(DataSV->size()+1);DSV=DataSV->data();DSV[DataSV->size()-1]=objtemp;emit SendText(QString(tr("Selected 1,type=%1,index=%2")).arg(objtemp.type).arg(objtemp.index));
					}
					
				}else{
					
				}
			selectionRect.setTopLeft(e->pos());
			selectionRect.setBottomRight(e->pos());
			EnableSelWin=1;
			}
			
		}
		
			if(e->button()==Qt::RightButton){
				emit processcmd("MouseRButton");
			}
		break;
		
		case MOUSEMODE_ZOOM:
			rotrect.setTopLeft(e->pos());
			rotrect.setBottomRight(e->pos());
			tempdataF[0]=ViewPortScale;
			if(e->button()==Qt::RightButton){
				QMenu *menu = new QMenu(this);
				QAction *MHActions;
				QAction *Act1,*Act2,*Act3,*Act4;
				Act1=new QAction(tr("Zoom"),this);Act1->setData(1);Act2=new QAction(tr("Pan"),this);Act2->setData(2);
				Act3=new QAction(tr("Rotate View"),this);Act3->setData(3);Act4=new QAction(tr("Exit"),this);Act4->setData(0);

				menu->addAction(Act1);menu->addAction(Act2);menu->addAction(Act3);
				menu->addSeparator();menu->addAction(Act4);
				menu->setMouseTracking( TRUE );
				MHActions=menu->exec(e->globalPos());
				if(MHActions){
					id = MHActions->data().toInt();
					if(id==0)emit processcmd(tr("**Cancel**"));if(id==2)emit processcmd(tr("pan"));if(id==1)emit processcmd(tr("zoom"));if(id==3)emit processcmd(tr("rotateview"));
				}else{
					emit processcmd(tr("**Cancel**"));
				}
				delete menu;
			}
		break;
		
		case MOUSEMODE_PAN:
			rotrect.setTopLeft(e->pos());
			rotrect.setBottomRight(e->pos());
			if(e->button()==Qt::RightButton){
				QMenu *menu = new QMenu(this);
				QAction *MHActions;
				QAction *Act1,*Act2,*Act3,*Act4;
				Act1=new QAction(tr("Zoom"),this);Act1->setData(1);Act2=new QAction(tr("Pan"),this);Act2->setData(2);
				Act3=new QAction(tr("Rotate View"),this);Act3->setData(3);Act4=new QAction(tr("Exit"),this);Act4->setData(0);

				menu->addAction(Act1);menu->addAction(Act2);menu->addAction(Act3);
				menu->addSeparator();menu->addAction(Act4);
				menu->setMouseTracking( TRUE );
				MHActions=menu->exec(e->globalPos());
				if(MHActions){
					id = MHActions->data().toInt();
					if(id==0)emit processcmd(tr("**Cancel**"));if(id==2)emit processcmd(tr("pan"));if(id==1)emit processcmd(tr("zoom"));if(id==3)emit processcmd(tr("rotateview"));
				}else{
					emit processcmd(tr("**Cancel**"));
				}
				delete menu;
			}
		break;
		case MOUSEMODE_ROTATE:
			if(e->button()==Qt::LeftButton){
				rotrect.setTopLeft(e->pos());
				rotrect.setBottomRight(e->pos());
			}
			if(e->button()==Qt::RightButton){
				QMenu *menu = new QMenu(this);
				QAction *MHActions;
				QAction *Act1,*Act2,*Act3,*Act4;
				Act1=new QAction(tr("Zoom"),this);Act1->setData(1);Act2=new QAction(tr("Pan"),this);Act2->setData(2);
				Act3=new QAction(tr("Rotate View"),this);Act3->setData(3);Act4=new QAction(tr("Exit"),this);Act4->setData(0);

				menu->addAction(Act1);menu->addAction(Act2);menu->addAction(Act3);
				menu->addSeparator();menu->addAction(Act4);
				menu->setMouseTracking( TRUE );
				MHActions=menu->exec(e->globalPos());
				if(MHActions){
				id = MHActions->data().toInt();
				if(id==0)emit processcmd(tr("**Cancel**"));if(id==2)emit processcmd(tr("pan"));if(id==1)emit processcmd(tr("zoom"));if(id==3)emit processcmd(tr("rotateview"));
				}else{
					emit processcmd(tr("**Cancel**"));
				}
				delete menu;
			}
		break;
	}

	
}


void GLAppArea::mouseMoveEvent ( QMouseEvent * e )
{
	double dm[16],dm2[16],dm3[16];
	float m[16],tempf;
	GLint viewp[4];
	GLdouble winX,winY,winZ;
	tselect objtemp;
	makeCurrent ();
	
	switch(MouseMode[0]){
		case MOUSEMODE_PICKPOINT:
			if(SnapMode[0]){
				objtemp=search(e->x(),e->y(),10,10);
				searchSnap(objtemp,e->x(),e->y());
			}
			emit UpdateAll();
			makeCurrent();
			/*updateGL();*/
		
		case MOUSEMODE_SELECT:
			glGetDoublev(GL_MODELVIEW_MATRIX,dm);glGetDoublev(GL_PROJECTION_MATRIX,dm2);glGetIntegerv(GL_VIEWPORT,viewp);MatrixMultd(dm2,dm,dm3);
			if(e->buttons()==Qt::LeftButton){
				selectionRect.setBottomRight(e->pos());
				if(selectionRect.bottomRight().x()<0){selectionRect.setRight(0);}
				if(selectionRect.bottomRight().y()<0){selectionRect.setBottom(1);}
				if(selectionRect.bottomRight().x()>viewp[2]){selectionRect.setRight(viewp[2]-1);}
				if(selectionRect.bottomRight().y()>viewp[3]){selectionRect.setBottom(viewp[3]);}
				
			}else{
			
			currentpoint[0]=searchP(e->x(), e->y(),4,4);
			if(currentpoint->find){
				/*gluProject(currentpoint->v[0],currentpoint->v[1],currentpoint->v[2],dm,dm2,viewp, &winX,&winY,&winZ );*/
				winX=viewp[0]+viewp[2]*((dm3[0]*currentpoint->v[0]+dm3[4]*currentpoint->v[1]+dm3[8]*currentpoint->v[2]+dm3[12])+1)/2.0;
				winY=viewp[1]+viewp[3]*((dm3[1]*currentpoint->v[0]+dm3[5]*currentpoint->v[1]+dm3[9]*currentpoint->v[2]+dm3[13])+1)/2.0;
				cursor().setPos(mapToGlobal(QPoint((int)winX+1,  viewp[3]-(int)winY-1 )));
				emit message(QString("X%1,Y%2,Z%3").arg(currentpoint->v[0]).arg(currentpoint->v[1]).arg(currentpoint->v[2]),20000);

			}else{
				/*/StatusBar Message///////////////////////////////////////////////////////////////////*/
				winX=((2.0*e->x())/(float)viewp[2]-1-dm3[12]);winY=((2.0*(viewp[3]-e->y()))/(float)viewp[3]-1-dm3[13]);
				
					winZ=dm3[0]*dm3[5]-dm3[1]*dm3[4];				
					if(winZ!=0){currentpoint->v[0]=(winX*dm3[5]-dm3[4]*winY)/winZ;
					currentpoint->v[1]=(dm3[0]*winY-winX*dm3[1])/winZ;currentpoint->v[2]=0;
					if(*GripEditMode==4){/*STRETCH MODE*/
							currentpoint->v[2]=GriPoint->v[2];
					}
					}
					emit message(QString("X%1,Y%2,Z%3").arg(currentpoint->v[0]).arg(currentpoint->v[1]).arg(currentpoint->v[2]),20000);
				
				/*////////////////////////////////////////////////////////////////////*/
			}
			}
			updateGL();

		break;
		case MOUSEMODE_ZOOM:
		if(e->buttons()==Qt::LeftButton){
			if(rotrect.height()){
				ViewPortScale=(-rotrect.y()+e->y())*tempdataF[0]/300.0+tempdataF[0];
				if(ViewPortScale<0){ViewPortScale*=-1;}
        			glMatrixMode(GL_PROJECTION);glLoadIdentity();
				glGetIntegerv(GL_VIEWPORT,viewp);
        			glOrtho(-(GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3],(GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3],-ViewPortScale,ViewPortScale,zNear,zFar);
        			/*gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,1.0f,1000.0f);*/
	        		glMatrixMode(GL_MODELVIEW);
			}
			updateGL();
		}
		
		break;
		
		case MOUSEMODE_PAN:
			if(e->buttons()==Qt::LeftButton){
				glGetFloatv(GL_MODELVIEW_MATRIX,m);glGetIntegerv(GL_VIEWPORT,viewp);
				tempf=((float)2.0*(rotrect.y()-e->y())/(float)viewp[3])*ViewPortScale;glTranslatef(tempf*m[1],tempf*m[5],tempf*m[9]);
				tempf=((float)2.0*(e->x()-rotrect.x())/viewp[2])*((GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3]);glTranslatef(tempf*m[0],tempf*m[4],tempf*m[8]);
				glGetFloatv(GL_MODELVIEW_MATRIX,m);
				m[14]=0.0;
				glLoadMatrixf(m);
				rotrect.setTopLeft(e->pos());
				
			}
			updateGL();
		break;
		
		case MOUSEMODE_ROTATE:
			if(e->buttons()==Qt::LeftButton){
				rotrect.setBottomRight(e->pos());
				glGetFloatv(GL_MODELVIEW_MATRIX,m);
				glLoadIdentity();
				glRotatef((float)rotrect.width()-1,0,1,0);glGetDoublev(GL_MODELVIEW_MATRIX,dm);
				glRotatef((float)rotrect.height()-1,dm[0],dm[4],dm[8]);
				glMultMatrixf(m);
				
				/*
				rotrect.setBottomRight(e->pos());
				glGetFloatv(GL_MODELVIEW_MATRIX,m);
				glRotatef((float)rotrect.width()-1,m[1],m[5],m[9]);
				glRotatef((float)rotrect.height()-1,m[0],m[4],m[8]);
				rotrect.setTopLeft(e->pos());
				*/
				rotrect.setTopLeft(e->pos());
			}
			updateGL();
		break;
	}


	
}



void GLAppArea::mouseReleaseEvent ( QMouseEvent *)
{
	if(EnableSelWin){
		EnableSelWin=0;
		selectionRect=selectionRect.normalized();
		if(selectionRect.height()>7||selectionRect.width()>7){
			searchWindow();
		}
		emit UpdateAll();
		
		
	}else{
		updateGL();
	}
}


tselect GLAppArea::search (int x, int y,int deltx,int delty){

	d3line *DLV=DataLV->data();
	d3triangle *DTV=DataTV->data();

	GLint viewp[4];
	int i,j,area;
	float min=1.0;
	float pixels[1024];

	tselect sel;
	sel.type=0;
	if(DataLV->size()||DataTV->size()){
		glMatrixMode(GL_PROJECTION);glPushMatrix();glLoadIdentity();
		
		glGetIntegerv(GL_VIEWPORT,viewp);gluPickMatrix(x,viewp[3]-y,deltx,delty,viewp);
		glOrtho(-(GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3],(GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3],-ViewPortScale,ViewPortScale,zNear,zFar);
		glViewport(0,0,deltx, delty);area=deltx*delty;
		glMatrixMode(GL_MODELVIEW);
			glColorMask(0,0,0,0);glClear(GL_DEPTH_BUFFER_BIT);
			if(View[0]&1){
				for(i=0;i<DataLV->size();i++){
					glBegin(GL_LINES);glVertex3fv(DLV[i].v1);glVertex3fv(DLV[i].v2);glEnd();
					glReadPixels(0,0, deltx, delty,GL_DEPTH_COMPONENT, GL_FLOAT, pixels);
					for(j=0;j<area;j++){
						if(min>pixels[j]){
							min=pixels[j];sel.type=CADTYPE_LINE;sel.index=i;
						}
					}
				}
			}
			if(View[0]&2){
				for(i=0;i<DataTV->size();i++){
					glBegin(GL_TRIANGLES);glVertex3fv(DTV[i].v1);glVertex3fv(DTV[i].v2);glVertex3fv(DTV[i].v3);glEnd();
					glReadPixels(0,0, deltx, delty,GL_DEPTH_COMPONENT, GL_FLOAT, pixels);
					for(j=0;j<area;j++){
						if(min>pixels[j]){
							min=pixels[j];sel.type=CADTYPE_TRIANGLE;sel.index=i;
						}
					}
				}
			}
			glColorMask(1,1,1,1);
		glViewport(0,0,viewp[2], viewp[3]);
		glMatrixMode(GL_PROJECTION);glPopMatrix();glMatrixMode(GL_MODELVIEW);
		
		return sel;
	}
	return sel;
}


foundP GLAppArea::searchP (int x, int y,int deltx,int delty){

	static double dm[16],dm2[16],dm3[16];
	GLint viewp[4];
	foundP result;
	double min=1;
	int i,indx;
	GLdouble winX,winY,winZ;
	d3line *DLV=DataLV->data();
	d3triangle *DTV=DataTV->data();
	tselect *DSV=DataSV->data();

	result.find=0;
	
	glGetDoublev(GL_MODELVIEW_MATRIX,dm);glGetDoublev(GL_PROJECTION_MATRIX,dm2);glGetIntegerv(GL_VIEWPORT,viewp);MatrixMultd(dm2,dm,dm3);
	for(i=0;i<DataSV->size();i++){
		indx=DSV[i].index;
		if(View[0]&1){
		if(DSV[i].type==CADTYPE_LINE){
			winX=viewp[0]+viewp[2]*((dm3[0]*DLV[indx].v1[0]+dm3[4]*DLV[indx].v1[1]+dm3[8]*DLV[indx].v1[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DLV[indx].v1[0]+dm3[5]*DLV[indx].v1[1]+dm3[9]*DLV[indx].v1[2]+dm3[13])+1)/2.0;
			winZ=((dm3[2]*DLV[indx].v1[0]+dm3[6]*DLV[indx].v1[1]+dm3[10]*DLV[indx].v1[2]+dm3[14])+1)/2.0;
			
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=DLV[indx].v1[0];result.v[1]=DLV[indx].v1[1];result.v[2]=DLV[indx].v1[2];
				result.find=1;
			}
			winX=viewp[0]+viewp[2]*((dm3[0]*DLV[indx].v2[0]+dm3[4]*DLV[indx].v2[1]+dm3[8]*DLV[indx].v2[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DLV[indx].v2[0]+dm3[5]*DLV[indx].v2[1]+dm3[9]*DLV[indx].v2[2]+dm3[13])+1)/2.0;
			winZ=((dm3[2]*DLV[indx].v2[0]+dm3[6]*DLV[indx].v2[1]+dm3[10]*DLV[indx].v2[2]+dm3[14])+1)/2.0;
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=DLV[indx].v2[0];result.v[1]=DLV[indx].v2[1];result.v[2]=DLV[indx].v2[2];
				result.find=1;
			}
			winX=viewp[0]+viewp[2]*((dm3[0]*((DLV[indx].v1[0]+DLV[indx].v2[0])/2.0)+dm3[4]*((DLV[indx].v1[1]+DLV[indx].v2[1])/2.0)+dm3[8]*((DLV[indx].v1[2]+DLV[indx].v2[2])/2.0)+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*((DLV[indx].v1[0]+DLV[indx].v2[0])/2.0)+dm3[5]*((DLV[indx].v1[1]+DLV[indx].v2[1])/2.0)+dm3[9]*((DLV[indx].v1[2]+DLV[indx].v2[2])/2.0)+dm3[13])+1)/2.0;
			winZ=((dm3[2]*((DLV[indx].v1[0]+DLV[indx].v2[0])/2.0)+dm3[6]*((DLV[indx].v1[1]+DLV[indx].v2[1])/2.0)+dm3[10]*((DLV[indx].v1[2]+DLV[indx].v2[2])/2.0)+dm3[14])+1)/2.0;
			
			
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=(DLV[indx].v1[0]+DLV[indx].v2[0])/2.0;result.v[1]=(DLV[indx].v1[1]+DLV[indx].v2[1])/2.0;result.v[2]=(DLV[indx].v1[2]+DLV[indx].v2[2])/2.0;
				result.find=1;
			}
		}
		}
		if(View[0]&2){
		if(DSV[i].type==CADTYPE_TRIANGLE){
			winX=viewp[0]+viewp[2]*((dm3[0]*DTV[indx].v1[0]+dm3[4]*DTV[indx].v1[1]+dm3[8]*DTV[indx].v1[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DTV[indx].v1[0]+dm3[5]*DTV[indx].v1[1]+dm3[9]*DTV[indx].v1[2]+dm3[13])+1)/2.0;
			winZ=((dm3[2]*DTV[indx].v1[0]+dm3[6]*DTV[indx].v1[1]+dm3[10]*DTV[indx].v1[2]+dm3[14])+1)/2.0;
			
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=DTV[indx].v1[0];result.v[1]=DTV[indx].v1[1];result.v[2]=DTV[indx].v1[2];
				result.find=1;
			}
			winX=viewp[0]+viewp[2]*((dm3[0]*DTV[indx].v2[0]+dm3[4]*DTV[indx].v2[1]+dm3[8]*DTV[indx].v2[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DTV[indx].v2[0]+dm3[5]*DTV[indx].v2[1]+dm3[9]*DTV[indx].v2[2]+dm3[13])+1)/2.0;
			winZ=((dm3[2]*DTV[indx].v2[0]+dm3[6]*DTV[indx].v2[1]+dm3[10]*DTV[indx].v2[2]+dm3[14])+1)/2.0;
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=DTV[indx].v2[0];result.v[1]=DTV[indx].v2[1];result.v[2]=DTV[indx].v2[2];
				result.find=1;
			}
			winX=viewp[0]+viewp[2]*((dm3[0]*DTV[indx].v3[0]+dm3[4]*DTV[indx].v3[1]+dm3[8]*DTV[indx].v3[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DTV[indx].v3[0]+dm3[5]*DTV[indx].v3[1]+dm3[9]*DTV[indx].v3[2]+dm3[13])+1)/2.0;
			winZ=((dm3[2]*DTV[indx].v3[0]+dm3[6]*DTV[indx].v3[1]+dm3[10]*DTV[indx].v3[2]+dm3[14])+1)/2.0;
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=DTV[indx].v3[0];result.v[1]=DTV[indx].v3[1];result.v[2]=DTV[indx].v3[2];
				result.find=1;
			}
			winX=viewp[0]+viewp[2]*((dm3[0]*((DTV[indx].v1[0]+DTV[indx].v2[0])/2.0)+dm3[4]*((DTV[indx].v1[1]+DTV[indx].v2[1])/2.0)+dm3[8]*((DTV[indx].v1[2]+DTV[indx].v2[2])/2.0)+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*((DTV[indx].v1[0]+DTV[indx].v2[0])/2.0)+dm3[5]*((DTV[indx].v1[1]+DTV[indx].v2[1])/2.0)+dm3[9]*((DTV[indx].v1[2]+DTV[indx].v2[2])/2.0)+dm3[13])+1)/2.0;
			winZ=((dm3[2]*((DTV[indx].v1[0]+DTV[indx].v2[0])/2.0)+dm3[6]*((DTV[indx].v1[1]+DTV[indx].v2[1])/2.0)+dm3[10]*((DTV[indx].v1[2]+DTV[indx].v2[2])/2.0)+dm3[14])+1)/2.0;
			
			
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=(DTV[indx].v1[0]+DTV[indx].v2[0])/2.0;result.v[1]=(DTV[indx].v1[1]+DTV[indx].v2[1])/2.0;result.v[2]=(DTV[indx].v1[2]+DTV[indx].v2[2])/2.0;
				result.find=1;
			}
			winX=viewp[0]+viewp[2]*((dm3[0]*((DTV[indx].v1[0]+DTV[indx].v3[0])/2.0)+dm3[4]*((DTV[indx].v1[1]+DTV[indx].v3[1])/2.0)+dm3[8]*((DTV[indx].v1[2]+DTV[indx].v3[2])/2.0)+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*((DTV[indx].v1[0]+DTV[indx].v3[0])/2.0)+dm3[5]*((DTV[indx].v1[1]+DTV[indx].v3[1])/2.0)+dm3[9]*((DTV[indx].v1[2]+DTV[indx].v3[2])/2.0)+dm3[13])+1)/2.0;
			winZ=((dm3[2]*((DTV[indx].v1[0]+DTV[indx].v3[0])/2.0)+dm3[6]*((DTV[indx].v1[1]+DTV[indx].v3[1])/2.0)+dm3[10]*((DTV[indx].v1[2]+DTV[indx].v3[2])/2.0)+dm3[14])+1)/2.0;
			
			
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=(DTV[indx].v1[0]+DTV[indx].v3[0])/2.0;result.v[1]=(DTV[indx].v1[1]+DTV[indx].v3[1])/2.0;result.v[2]=(DTV[indx].v1[2]+DTV[indx].v3[2])/2.0;
				result.find=1;
			}
			winX=viewp[0]+viewp[2]*((dm3[0]*((DTV[indx].v2[0]+DTV[indx].v3[0])/2.0)+dm3[4]*((DTV[indx].v2[1]+DTV[indx].v3[1])/2.0)+dm3[8]*((DTV[indx].v2[2]+DTV[indx].v3[2])/2.0)+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*((DTV[indx].v2[0]+DTV[indx].v3[0])/2.0)+dm3[5]*((DTV[indx].v2[1]+DTV[indx].v3[1])/2.0)+dm3[9]*((DTV[indx].v2[2]+DTV[indx].v3[2])/2.0)+dm3[13])+1)/2.0;
			winZ=((dm3[2]*((DTV[indx].v2[0]+DTV[indx].v3[0])/2.0)+dm3[6]*((DTV[indx].v2[1]+DTV[indx].v3[1])/2.0)+dm3[10]*((DTV[indx].v2[2]+DTV[indx].v3[2])/2.0)+dm3[14])+1)/2.0;
			
			
			if((x-deltx)<winX&&(x+deltx)>winX&&(y-delty)<(viewp[3]-winY)&&(y+delty)>(viewp[3]-winY)&&min>winZ){
				min=winZ;
				result.v[0]=(DTV[indx].v2[0]+DTV[indx].v3[0])/2.0;result.v[1]=(DTV[indx].v2[1]+DTV[indx].v3[1])/2.0;result.v[2]=(DTV[indx].v2[2]+DTV[indx].v3[2])/2.0;
				result.find=1;
			}
		}
		}
		
	}

	return result;
}
void GLAppArea::searchWindow(){

	static double dm[16],dm2[16],dm3[16];
	GLint viewp[4];
	int i,indx,find,cl=0,ct=0;
	GLdouble winX,winY;
	d3line *DLV=DataLV->data();
	d3triangle *DTV=DataTV->data();
	tselect *DSV=DataSV->data();

	selectionRect=selectionRect.normalized();
	glGetDoublev(GL_MODELVIEW_MATRIX,dm);glGetDoublev(GL_PROJECTION_MATRIX,dm2);glGetIntegerv(GL_VIEWPORT,viewp);MatrixMultd(dm2,dm,dm3);
	if(View[0]&1){
	for(indx=0;indx<DataLV->size();indx++){
		find=1;
		winX=viewp[0]+viewp[2]*((dm3[0]*DLV[indx].v1[0]+dm3[4]*DLV[indx].v1[1]+dm3[8]*DLV[indx].v1[2]+dm3[12])+1)/2.0;
		winY=viewp[1]+viewp[3]*((dm3[1]*DLV[indx].v1[0]+dm3[5]*DLV[indx].v1[1]+dm3[9]*DLV[indx].v1[2]+dm3[13])+1)/2.0;
		
		if(selectionRect.left()<winX&&selectionRect.right()>winX&&selectionRect.top()<(viewp[3]-winY)&&selectionRect.bottom()>(viewp[3]-winY)){
			winX=viewp[0]+viewp[2]*((dm3[0]*DLV[indx].v2[0]+dm3[4]*DLV[indx].v2[1]+dm3[8]*DLV[indx].v2[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DLV[indx].v2[0]+dm3[5]*DLV[indx].v2[1]+dm3[9]*DLV[indx].v2[2]+dm3[13])+1)/2.0;
			if(selectionRect.left()<winX&&selectionRect.right()>winX&&selectionRect.top()<(viewp[3]-winY)&&selectionRect.bottom()>(viewp[3]-winY)){
				for(i=0;i<DataSV->size();i++){
					if(DSV[i].index==indx&&DSV[i].type==CADTYPE_LINE){
						find=0;
					}
				}
				if(find){cl++;DataSV->resize(DataSV->size()+1);DSV=DataSV->data();DSV[DataSV->size()-1].type=1;DSV[DataSV->size()-1].index=indx;}
			}
		}
	}
	}
	if(View[0]&2){
	for(indx=0;indx<DataTV->size();indx++){
		find=1;
		winX=viewp[0]+viewp[2]*((dm3[0]*DTV[indx].v1[0]+dm3[4]*DTV[indx].v1[1]+dm3[8]*DTV[indx].v1[2]+dm3[12])+1)/2.0;
		winY=viewp[1]+viewp[3]*((dm3[1]*DTV[indx].v1[0]+dm3[5]*DTV[indx].v1[1]+dm3[9]*DTV[indx].v1[2]+dm3[13])+1)/2.0;
		
		if(selectionRect.left()<winX&&selectionRect.right()>winX&&selectionRect.top()<(viewp[3]-winY)&&selectionRect.bottom()>(viewp[3]-winY)){
			winX=viewp[0]+viewp[2]*((dm3[0]*DTV[indx].v2[0]+dm3[4]*DTV[indx].v2[1]+dm3[8]*DTV[indx].v2[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DTV[indx].v2[0]+dm3[5]*DTV[indx].v2[1]+dm3[9]*DTV[indx].v2[2]+dm3[13])+1)/2.0;
			if(selectionRect.left()<winX&&selectionRect.right()>winX&&selectionRect.top()<(viewp[3]-winY)&&selectionRect.bottom()>(viewp[3]-winY)){
				winX=viewp[0]+viewp[2]*((dm3[0]*DTV[indx].v3[0]+dm3[4]*DTV[indx].v3[1]+dm3[8]*DTV[indx].v3[2]+dm3[12])+1)/2.0;
				winY=viewp[1]+viewp[3]*((dm3[1]*DTV[indx].v3[0]+dm3[5]*DTV[indx].v3[1]+dm3[9]*DTV[indx].v3[2]+dm3[13])+1)/2.0;
				if(selectionRect.left()<winX&&selectionRect.right()>winX&&selectionRect.top()<(viewp[3]-winY)&&selectionRect.bottom()>(viewp[3]-winY)){
					for(i=0;i<DataSV->size();i++){
						if(DSV[i].index==indx&&DSV[i].type==CADTYPE_TRIANGLE){
							find=0;
						}
					}
					if(find){ct++;DataSV->resize(DataSV->size()+1);DSV=DataSV->data();DSV[DataSV->size()-1].type=2;DSV[DataSV->size()-1].index=indx;}
				}
			}
		}
	}
	}
	if(cl)
	emit SendText(QString(tr("Selected %1 line(s)")).arg(cl));
	if(ct)
	emit SendText(QString(tr("Selected %1 triangle(s)")).arg(ct));
	
}




void GLAppArea::searchSnap(tselect sel,int inx,int iny){
	SnaPoint->find=0;
	d3line *DLV=DataLV->data();
	d3triangle *DTV=DataTV->data();
	
	if(sel.type==CADTYPE_LINE){
		/*ENDPOINT*/
		if(SnapMode[0]==1){
			static double dm[16],dm2[16],dm3[16];
			GLint viewp[4];
			GLdouble winX,winY,winX2,winY2;
			glGetDoublev(GL_MODELVIEW_MATRIX,dm);glGetDoublev(GL_PROJECTION_MATRIX,dm2);glGetIntegerv(GL_VIEWPORT,viewp);MatrixMultd(dm2,dm,dm3);
			winX=viewp[0]+viewp[2]*((dm3[0]*DLV[sel.index].v1[0]+dm3[4]*DLV[sel.index].v1[1]+dm3[8]*DLV[sel.index].v1[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DLV[sel.index].v1[0]+dm3[5]*DLV[sel.index].v1[1]+dm3[9]*DLV[sel.index].v1[2]+dm3[13])+1)/2.0;
			winX2=viewp[0]+viewp[2]*((dm3[0]*DLV[sel.index].v2[0]+dm3[4]*DLV[sel.index].v2[1]+dm3[8]*DLV[sel.index].v2[2]+dm3[12])+1)/2.0;
			winY2=viewp[1]+viewp[3]*((dm3[1]*DLV[sel.index].v2[0]+dm3[5]*DLV[sel.index].v2[1]+dm3[9]*DLV[sel.index].v2[2]+dm3[13])+1)/2.0;

			winX-=inx;winY-=viewp[3]-iny;winX2-=inx;winY2-=viewp[3]-iny;
			if((winX*winX+winY*winY)>(winX2*winX2+winY2*winY2)){
				SnaPoint->v[0]=DLV[sel.index].v2[0];
				SnaPoint->v[1]=DLV[sel.index].v2[1];
				SnaPoint->v[2]=DLV[sel.index].v2[2];
			}else{
				SnaPoint->v[0]=DLV[sel.index].v1[0];
				SnaPoint->v[1]=DLV[sel.index].v1[1];
				SnaPoint->v[2]=DLV[sel.index].v1[2];
			}
			
			
		}
	
		/*MIDPOINT*/
		if(SnapMode[0]==2){
			SnaPoint->v[0]=(DLV[sel.index].v1[0]+DLV[sel.index].v2[0])/2.0;
			SnaPoint->v[1]=(DLV[sel.index].v1[1]+DLV[sel.index].v2[1])/2.0;
			SnaPoint->v[2]=(DLV[sel.index].v1[2]+DLV[sel.index].v2[2])/2.0;
		}
		SnaPoint->find=1;
	}
	if(sel.type==CADTYPE_TRIANGLE){
		/*ENDPOINT*/
		if(SnapMode[0]==1){
			static double dm[16],dm2[16],dm3[16];
			GLint viewp[4];
			GLdouble winX,winY,winX2,winY2,winX3,winY3;
			glGetDoublev(GL_MODELVIEW_MATRIX,dm);glGetDoublev(GL_PROJECTION_MATRIX,dm2);glGetIntegerv(GL_VIEWPORT,viewp);MatrixMultd(dm2,dm,dm3);
			winX=viewp[0]+viewp[2]*((dm3[0]*DTV[sel.index].v1[0]+dm3[4]*DTV[sel.index].v1[1]+dm3[8]*DTV[sel.index].v1[2]+dm3[12])+1)/2.0;
			winY=viewp[1]+viewp[3]*((dm3[1]*DTV[sel.index].v1[0]+dm3[5]*DTV[sel.index].v1[1]+dm3[9]*DTV[sel.index].v1[2]+dm3[13])+1)/2.0;
			winX2=viewp[0]+viewp[2]*((dm3[0]*DTV[sel.index].v2[0]+dm3[4]*DTV[sel.index].v2[1]+dm3[8]*DTV[sel.index].v2[2]+dm3[12])+1)/2.0;
			winY2=viewp[1]+viewp[3]*((dm3[1]*DTV[sel.index].v2[0]+dm3[5]*DTV[sel.index].v2[1]+dm3[9]*DTV[sel.index].v2[2]+dm3[13])+1)/2.0;
			winX3=viewp[0]+viewp[2]*((dm3[0]*DTV[sel.index].v3[0]+dm3[4]*DTV[sel.index].v3[1]+dm3[8]*DTV[sel.index].v3[2]+dm3[12])+1)/2.0;
			winY3=viewp[1]+viewp[3]*((dm3[1]*DTV[sel.index].v3[0]+dm3[5]*DTV[sel.index].v3[1]+dm3[9]*DTV[sel.index].v3[2]+dm3[13])+1)/2.0;
			
			winX-=inx;winY-=viewp[3]-iny;winX2-=inx;winY2-=viewp[3]-iny;winX3-=inx;winY3-=viewp[3]-iny;
			if((winX*winX+winY*winY)>(winX2*winX2+winY2*winY2)){
				if((winX3*winX3+winY3*winY3)>(winX2*winX2+winY2*winY2)){
					SnaPoint->v[0]=DTV[sel.index].v2[0];SnaPoint->v[1]=DTV[sel.index].v2[1];SnaPoint->v[2]=DTV[sel.index].v2[2];
				}else{
					SnaPoint->v[0]=DTV[sel.index].v3[0];SnaPoint->v[1]=DTV[sel.index].v3[1];SnaPoint->v[2]=DTV[sel.index].v3[2];
				}
			
			}else{
				if((winX3*winX3+winY3*winY3)>(winX*winX+winY*winY)){
					SnaPoint->v[0]=DTV[sel.index].v1[0];SnaPoint->v[1]=DTV[sel.index].v1[1];SnaPoint->v[2]=DTV[sel.index].v1[2];
				}else{
					SnaPoint->v[0]=DTV[sel.index].v3[0];SnaPoint->v[1]=DTV[sel.index].v3[1];SnaPoint->v[2]=DTV[sel.index].v3[2];
				}
			}
			
		}
	
		/*MIDPOINT*/
		if(SnapMode[0]==2){
			static double dm[16],dm2[16],dm3[16];
			GLint viewp[4];
			GLdouble winX,winY,winX2,winY2,winX3,winY3;
			glGetDoublev(GL_MODELVIEW_MATRIX,dm);glGetDoublev(GL_PROJECTION_MATRIX,dm2);glGetIntegerv(GL_VIEWPORT,viewp);MatrixMultd(dm2,dm,dm3);
			winX=viewp[0]+viewp[2]*((dm3[0]*((DTV[sel.index].v1[0]+DTV[sel.index].v2[0])/2.0)+dm3[4]*((DTV[sel.index].v1[1]+DTV[sel.index].v2[1])/2.0)+dm3[8]*((DTV[sel.index].v1[2]+DTV[sel.index].v2[2])/2.0)+dm3[12])+1)/2.0;
			
			winY=viewp[1]+viewp[3]*((dm3[1]*((DTV[sel.index].v1[0]+DTV[sel.index].v2[0])/2.0)+dm3[5]*((DTV[sel.index].v1[1]+DTV[sel.index].v2[1])/2.0)+dm3[9]*((DTV[sel.index].v1[2]+DTV[sel.index].v2[2])/2.0)+dm3[13])+1)/2.0;
			
			
			winX2=viewp[0]+viewp[2]*((dm3[0]*((DTV[sel.index].v1[0]+DTV[sel.index].v3[0])/2.0)+dm3[4]*((DTV[sel.index].v1[1]+DTV[sel.index].v3[1])/2.0)+dm3[8]*((DTV[sel.index].v1[2]+DTV[sel.index].v3[2])/2.0)+dm3[12])+1)/2.0;
			winY2=viewp[1]+viewp[3]*((dm3[1]*((DTV[sel.index].v1[0]+DTV[sel.index].v3[0])/2.0)+dm3[5]*((DTV[sel.index].v1[1]+DTV[sel.index].v3[1])/2.0)+dm3[9]*((DTV[sel.index].v1[2]+DTV[sel.index].v3[2])/2.0)+dm3[13])+1)/2.0;
			
			winX3=viewp[0]+viewp[2]*((dm3[0]*((DTV[sel.index].v2[0]+DTV[sel.index].v3[0])/2.0)+dm3[4]*((DTV[sel.index].v2[1]+DTV[sel.index].v3[1])/2.0)+dm3[8]*((DTV[sel.index].v2[2]+DTV[sel.index].v3[2])/2.0)+dm3[12])+1)/2.0;
			winY3=viewp[1]+viewp[3]*((dm3[1]*((DTV[sel.index].v2[0]+DTV[sel.index].v3[0])/2.0)+dm3[5]*((DTV[sel.index].v2[1]+DTV[sel.index].v3[1])/2.0)+dm3[9]*((DTV[sel.index].v2[2]+DTV[sel.index].v3[2])/2.0)+dm3[13])+1)/2.0;
			
			winX-=inx;winY-=viewp[3]-iny;winX2-=inx;winY2-=viewp[3]-iny;winX3-=inx;winY3-=viewp[3]-iny;
			if((winX*winX+winY*winY)>(winX2*winX2+winY2*winY2)){
				if((winX3*winX3+winY3*winY3)>(winX2*winX2+winY2*winY2)){
					SnaPoint->v[0]=(DTV[sel.index].v1[0]+DTV[sel.index].v3[0])/2.0;
					SnaPoint->v[1]=(DTV[sel.index].v1[1]+DTV[sel.index].v3[1])/2.0;
					SnaPoint->v[2]=(DTV[sel.index].v1[2]+DTV[sel.index].v3[2])/2.0;
				}else{
					SnaPoint->v[0]=(DTV[sel.index].v2[0]+DTV[sel.index].v3[0])/2.0;
					SnaPoint->v[1]=(DTV[sel.index].v2[1]+DTV[sel.index].v3[1])/2.0;
					SnaPoint->v[2]=(DTV[sel.index].v2[2]+DTV[sel.index].v3[2])/2.0;
				}
			
			}else{
				if((winX3*winX3+winY3*winY3)>(winX*winX+winY*winY)){
					SnaPoint->v[0]=(DTV[sel.index].v1[0]+DTV[sel.index].v2[0])/2.0;
					SnaPoint->v[1]=(DTV[sel.index].v1[1]+DTV[sel.index].v2[1])/2.0;
					SnaPoint->v[2]=(DTV[sel.index].v1[2]+DTV[sel.index].v2[2])/2.0;
				}else{
					SnaPoint->v[0]=(DTV[sel.index].v2[0]+DTV[sel.index].v3[0])/2.0;
					SnaPoint->v[1]=(DTV[sel.index].v2[1]+DTV[sel.index].v3[1])/2.0;
					SnaPoint->v[2]=(DTV[sel.index].v2[2]+DTV[sel.index].v3[2])/2.0;
				}
			}
		}
	
		SnaPoint->find=1;
	}


}
void GLAppArea::UpdateMouseMove(){
	QCursor tempc=cursor();
	QMouseEvent *ev=new QMouseEvent(QEvent::MouseMove,mapFromGlobal(tempc.pos()),Qt::NoButton,Qt::NoButton,Qt::NoModifier );
	mouseMoveEvent (ev );
}

void GLAppArea::ZoomVar(float var){
				GLint viewp[4];
				if(var){ViewPortScale=ViewPortScale/var;}
				if(ViewPortScale<0){ViewPortScale*=-1;}
				makeCurrent ();
        			glMatrixMode(GL_PROJECTION);glLoadIdentity();
				glGetIntegerv(GL_VIEWPORT,viewp);
        			glOrtho(-(GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3],(GLfloat)viewp[2]*ViewPortScale/(GLfloat)viewp[3],-ViewPortScale,ViewPortScale,zNear,zFar);
        			/*gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,1.0f,1000.0f);*/
	        		glMatrixMode(GL_MODELVIEW);
			updateGL();
}




void GLAppArea::ViewMode(int mod){
	GLdouble dm[16];
	
	makeCurrent();
	glLoadIdentity();
	
	switch(mod){
		case 0:
		break;
		
		case 1:
			glRotatef(-90.0,0.0,1.0,0.0);glRotatef(-90.0,1.0,0.0,0.0);
		break;
		
		case 2:
			glRotatef(-90.0,1.0,0.0,0.0);
		break;
		
		case 3:
			glRotatef(45.0,0.0,0.0,1.0);
			glGetDoublev(GL_MODELVIEW_MATRIX,dm);
			glRotatef(-54.73561032,dm[0],dm[4],dm[8]);
		break;


	}
	updateGL();

}


