/****************************************************************************
** $Id:  dialogs/about.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "about.h"

#include <QVariant>
#include <QLabel>
#include <QPushButton>
#include <QLayout>
#include <QPixmap>

/*
 *  Constructs a About as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
About::About( QWidget* parent,Qt::WFlags fl )
    : QDialog( parent,fl )
{
 
    AboutLayout = new QGridLayout( this); 
    textLabel1 = new QLabel;
    OkBtn = new QPushButton;
	QLabel *textname = new QLabel("AutoQ3D Project Team\n2005-2008 AutoQ3D. All rights reserved");
    AboutLayout->addWidget( textLabel1, 0, 0,1,1,Qt::AlignCenter);
    AboutLayout->addWidget( textname, 1, 0,1,1,Qt::AlignCenter);

    

    AboutLayout->addWidget( OkBtn, 2, 1 ,1,1);
    languageChange();
    resize( QSize(240, 126).expandedTo(minimumSizeHint()) );
    connect( OkBtn, SIGNAL( clicked() ), this, SLOT( accept() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
About::~About()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void About::languageChange()
{
    setWindowTitle( tr( "About" ) );
    textLabel1->setText( trUtf8( "<b><font size=""+1"">AutoQ3D Community 1.39</font><br>http://autoq3d.ecuadra.com" ) );
    OkBtn->setText( tr( "OK" ) );
}
 
