/****************************************************************************
** $Id:  cmds/cmdrevolve.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDREVOLVE_H
#define CMDREVOLVE_H
#include "cmds.h"


void cmds::cmdrevolve(){
	int i,j,k,n;
	int isw=0;
	float incf;
	float currangle;
	float angle;
	float segments;
	double var[3];
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	if((SecCmd==tr("**Cancel**"))&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
				SendText(tr("--Revolve--"));instruction=tr("Revolve Angle<360>:");emit instru(instruction);
				tempdataI[0]=0;tempdataF[0]=360.0;tempdataF[1]=8.0;tempdataF[2]=0;tempdataF[3]=1;tempdataF[4]=0;
				rtlines->v[0]=0;GriPoint->v[0]=0;rtlines->v[1]=0;GriPoint->v[1]=0;rtlines->v[2]=0;GriPoint->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				step++;
				return;
		break;
		
		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("")){
				step++;
				if(tempdataI[0]==0){
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<Z>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				}
				if(tempdataI[0]==1){
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<X>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				}
				if(tempdataI[0]==2){
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<Y>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				}
				return;
			}
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==2){
					tempdataF[0]=currentdata.v[0];
				if(tempdataI[0]==0){
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<Z>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				}
				if(tempdataI[0]==1){
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<X>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				}
				if(tempdataI[0]==2){
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<Y>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				}
					step++;
					return;
				}
			}
			
		break;
		case 2:
			if(!SecCmd.compare(tr("a","Angle"))||!SecCmd.compare(tr("A","Angle"))){
				instruction=QString(tr("Revolve Angle<%1>:")).arg(tempdataF[0]);emit instru(instruction);
				step=1;
				return;
			}
			if(!SecCmd.compare(tr("b","Basepoint"))||!SecCmd.compare(tr("B","Basepoint"))){
				SendText(tr("Base point"));emit instru(tr("Revolve (Base point):"));
				rtlines[0].find=0;
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				step=3;
				return;
			}
			
			if(!SecCmd.compare(tr("x","Plane x"))||!SecCmd.compare(tr("X","Plane X"))){
				
				tempdataI[0]=1;
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<X>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				SendText(tr("X","Plane X"));
				return;
			}
			
			if(!SecCmd.compare(tr("y","Plane Y"))||!SecCmd.compare(tr("Y","Plane Y"))){
				
				tempdataI[0]=2;
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<Y>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				SendText(tr("Y"));
				return;
			}
			
			if(!SecCmd.compare(tr("z","Plane Z"))||!SecCmd.compare(tr("Z","Plane Z"))){
				
				tempdataI[0]=0;
				instruction=QString(tr("Revolve Segments [Angle<%1>/BasePoint/X/Y/Z]<Z>:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				SendText(tr("Z","Plane Z"));
				return;
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format<2){
					SendText(tr("--Error--(Only console data)"));
				}
				if(currentdata.format==2){
					tempdataF[1]=currentdata.v[0];
					instruction=QString(tr("Revolve Segments [Angle<%1>]:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
					SecCmd="";
				}
			}
			if(!SecCmd.compare("")){

				segments=tempdataF[1];
				angle=tempdataF[0];
				for(isw=0,n=0;n<DataSV.size();n++,isw++){
					DataSLV.resize(0);
				for(incf=-1.0;incf<=segments+1.0;incf=incf+1.0){
					currangle=angle*incf/segments;
					var[0]=cosf(currangle*M_PI/180.0);var[1]=sinf(currangle*M_PI/180.0);
					var[2]=1;
					if(DataSV[n].type==1&&tempdataI[0]==1){
						j=DataSLV.size();DataSLV.resize(j+1);k=DataSV[n].index;
						tempdataF[0]=DLV[k].v2[0];
						tempdataF[1]=DLV[k].v2[1]-GriPoint->v[1];
						tempdataF[2]=DLV[k].v2[2]-GriPoint->v[2];
						DataSLV[j].v1[0]=tempdataF[0];
						DataSLV[j].v1[1]=GriPoint->v[1]+(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
						DataSLV[j].v1[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
						DataSLV[j].c1[0]=DLV[k].c2[0];DataSLV[j].c1[1]=DLV[k].c2[1];DataSLV[j].c1[2]=DLV[k].c2[2];
						tempdataF[0]=DLV[k].v1[0];
						tempdataF[1]=DLV[k].v1[1]-GriPoint->v[1];
						tempdataF[2]=DLV[k].v1[2]-GriPoint->v[2];
						DataSLV[j].v2[0]=tempdataF[0];
						DataSLV[j].v2[1]=GriPoint->v[1]+(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
						DataSLV[j].v2[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
						DataSLV[j].c2[0]=DLV[k].c1[0];DataSLV[j].c2[1]=DLV[k].c1[1];DataSLV[j].c2[2]=DLV[k].c1[2];
					}
					
					if(DataSV[n].type==1&&tempdataI[0]==2){
						j=DataSLV.size();DataSLV.resize(j+1);k=DataSV[n].index;
						tempdataF[0]=DLV[k].v2[0]-GriPoint->v[0];
						tempdataF[1]=DLV[k].v2[1];
						tempdataF[2]=DLV[k].v2[2]-GriPoint->v[2];
						DataSLV[j].v1[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
						DataSLV[j].v1[1]=tempdataF[1];
						DataSLV[j].v1[2]=GriPoint->v[2]+(tempdataF[2]*var[0]-tempdataF[0]*var[1])/var[2];
						DataSLV[j].c1[0]=DLV[k].c2[0];DataSLV[j].c1[1]=DLV[k].c2[1];DataSLV[j].c1[2]=DLV[k].c2[2];
						tempdataF[0]=DLV[k].v1[0]-GriPoint->v[0];
						tempdataF[1]=DLV[k].v1[1];
						tempdataF[2]=DLV[k].v1[2]-GriPoint->v[2];
						DataSLV[j].v2[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
						DataSLV[j].v2[1]=tempdataF[1];
						DataSLV[j].v2[2]=GriPoint->v[2]+(tempdataF[2]*var[0]-tempdataF[0]*var[1])/var[2];
						DataSLV[j].c2[0]=DLV[k].c1[0];DataSLV[j].c2[1]=DLV[k].c1[1];DataSLV[j].c2[2]=DLV[k].c1[2];
					}
					
					if(DataSV[n].type==1&&tempdataI[0]==0){
						j=DataSLV.size();DataSLV.resize(j+1);k=DataSV[n].index;
						tempdataF[0]=DLV[k].v2[0]-GriPoint->v[0];
						tempdataF[1]=DLV[k].v2[1]-GriPoint->v[1];
						tempdataF[2]=DLV[k].v2[2];
						DataSLV[j].v1[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
						DataSLV[j].v1[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
						DataSLV[j].v1[2]=tempdataF[2];
						DataSLV[j].c1[0]=DLV[k].c2[0];DataSLV[j].c1[1]=DLV[k].c2[1];DataSLV[j].c1[2]=DLV[k].c2[2];
						tempdataF[0]=DLV[k].v1[0]-GriPoint->v[0];
						tempdataF[1]=DLV[k].v1[1]-GriPoint->v[1];
						tempdataF[2]=DLV[k].v1[2];
						DataSLV[j].v2[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
						DataSLV[j].v2[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
						DataSLV[j].v2[2]=tempdataF[2];
						DataSLV[j].c2[0]=DLV[k].c1[0];DataSLV[j].c2[1]=DLV[k].c1[1];DataSLV[j].c2[2]=DLV[k].c1[2];
					}

				}
				
				if(DataSLV.size()<2){
					CmdCancel();
					return;
				}
				
				if(angle==360.0){
					j=DataSLV.size()-2;
					DataSLV[j].v1[0]=DataSLV[1].v1[0];DataSLV[j].v1[1]=DataSLV[1].v1[1];DataSLV[j].v1[2]=DataSLV[1].v1[2];
					DataSLV[j].v2[0]=DataSLV[1].v2[0];DataSLV[j].v2[1]=DataSLV[1].v2[1];DataSLV[j].v2[2]=DataSLV[1].v2[2];
				}
				
				
				for(i=1,incf=0.0;i<DataSLV.size()-2;i++,incf=incf+1.0){
				if(tempdataI[0]!=1&&(DataSLV[i].v1[0]!=DataSLV[i+1].v1[0]&&DataSLV[i].v2[0]!=DataSLV[i+1].v2[0])||(tempdataI[0]==1&&(DataSLV[i].v1[1]!=DataSLV[i+1].v1[1]&&DataSLV[i].v2[1]!=DataSLV[i+1].v2[1]))){
					j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
					DTV[j].v1[0]=DataSLV[i].v1[0];DTV[j].v1[1]=DataSLV[i].v1[1];DTV[j].v1[2]=DataSLV[i].v1[2];
					DTV[j].v2[0]=DataSLV[i].v2[0];DTV[j].v2[1]=DataSLV[i].v2[1];DTV[j].v2[2]=DataSLV[i].v2[2];
					if(isw%2){
						DTV[j].v3[0]=DataSLV[i+1].v2[0];DTV[j].v3[1]=DataSLV[i+1].v2[1];DTV[j].v3[2]=DataSLV[i+1].v2[2];
						DTV[j].t3[1]=0;
					}else{
						DTV[j].v3[0]=DataSLV[i+1].v1[0];DTV[j].v3[1]=DataSLV[i+1].v1[1];DTV[j].v3[2]=DataSLV[i+1].v1[2];
						DTV[j].t3[1]=1;
					}
					DTV[j].c1[0]=DataSLV[i].c1[0];DTV[j].c1[1]=DataSLV[i].c1[1];DTV[j].c1[2]=DataSLV[i].c1[2];
					DTV[j].c2[0]=DataSLV[i].c2[0];DTV[j].c2[1]=DataSLV[i].c2[1];DTV[j].c2[2]=DataSLV[i].c2[2];
					DTV[j].c3[0]=DataSLV[i+1].c2[0];DTV[j].c3[1]=DataSLV[i+1].c2[1];DTV[j].c3[2]=DataSLV[i+1].c2[2];
					DTV[j].texture=0;
					DTV[j].t1[1]=1;DTV[j].t2[1]=0;
					
					DTV[j].t1[0]=incf/segments;
					DTV[j].t2[0]=incf/segments;
					DTV[j].t3[0]=(incf+1.0)/segments;
					

				tempdataF[0]=DataSLV[i].v1[0]-DataSLV[i].v2[0];
				tempdataF[1]=DataSLV[i].v1[1]-DataSLV[i].v2[1];
				tempdataF[2]=DataSLV[i].v1[2]-DataSLV[i].v2[2];
				tempdataF[3]=DataSLV[i-1].v1[0]-DataSLV[i].v2[0];
				tempdataF[4]=DataSLV[i-1].v1[1]-DataSLV[i].v2[1];
				tempdataF[5]=DataSLV[i-1].v1[2]-DataSLV[i].v2[2];
					DTV[j].n1[0]=DTV[j].n2[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n1[1]=DTV[j].n2[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n1[2]=DTV[j].n2[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				tempdataF[0]=DataSLV[i+1].v1[0]-DataSLV[i].v2[0];
				tempdataF[1]=DataSLV[i+1].v1[1]-DataSLV[i].v2[1];
				tempdataF[2]=DataSLV[i+1].v1[2]-DataSLV[i].v2[2];
				tempdataF[3]=DataSLV[i].v1[0]-DataSLV[i].v2[0];
				tempdataF[4]=DataSLV[i].v1[1]-DataSLV[i].v2[1];
				tempdataF[5]=DataSLV[i].v1[2]-DataSLV[i].v2[2];
					DTV[j].n1[0]=DTV[j].n2[0]+=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n1[1]=DTV[j].n2[1]+=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n1[2]=DTV[j].n2[2]+=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				var[0]=sqrt(DTV[j].n1[0]*DTV[j].n1[0]+DTV[j].n1[1]*DTV[j].n1[1]+DTV[j].n1[2]*DTV[j].n1[2]);
					DTV[j].n1[0]/=var[0];DTV[j].n2[0]/=var[0];
					DTV[j].n1[1]/=var[0];DTV[j].n2[1]/=var[0];
					DTV[j].n1[2]/=var[0];DTV[j].n2[2]/=var[0];


				
					j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
					DTV[j].v1[0]=DataSLV[i+1].v2[0];DTV[j].v1[1]=DataSLV[i+1].v2[1];DTV[j].v1[2]=DataSLV[i+1].v2[2];
					DTV[j].v2[0]=DataSLV[i+1].v1[0];DTV[j].v2[1]=DataSLV[i+1].v1[1];DTV[j].v2[2]=DataSLV[i+1].v1[2];
					
					if(isw%2){
						DTV[j].v3[0]=DataSLV[i].v1[0];DTV[j].v3[1]=DataSLV[i].v1[1];DTV[j].v3[2]=DataSLV[i].v1[2];
						DTV[j].t3[1]=1;
					}else{
						DTV[j].v3[0]=DataSLV[i].v2[0];DTV[j].v3[1]=DataSLV[i].v2[1];DTV[j].v3[2]=DataSLV[i].v2[2];
						DTV[j].t3[1]=0;
					}
					isw++;
					DTV[j].c1[0]=DataSLV[i+1].c2[0];DTV[j].c1[1]=DataSLV[i+1].c2[1];DTV[j].c1[2]=DataSLV[i+1].c2[2];
					DTV[j].c2[0]=DataSLV[i+1].c1[0];DTV[j].c2[1]=DataSLV[i+1].c1[1];DTV[j].c2[2]=DataSLV[i+1].c1[2];
					DTV[j].c3[0]=DataSLV[i].c1[0];DTV[j].c3[1]=DataSLV[i].c1[1];DTV[j].c3[2]=DataSLV[i].c1[2];
					DTV[j].texture=0;
					DTV[j].t1[1]=0;DTV[j].t2[1]=1;
					DTV[j].t1[0]=(incf+1.0)/segments;
					DTV[j].t2[0]=(incf+1.0)/segments;
					DTV[j].t3[0]=incf/segments;
				
				tempdataF[0]=DataSLV[i+1].v1[0]-DataSLV[i+1].v2[0];
				tempdataF[1]=DataSLV[i+1].v1[1]-DataSLV[i+1].v2[1];
				tempdataF[2]=DataSLV[i+1].v1[2]-DataSLV[i+1].v2[2];
				tempdataF[3]=DataSLV[i].v1[0]-DataSLV[i+1].v2[0];
				tempdataF[4]=DataSLV[i].v1[1]-DataSLV[i+1].v2[1];
				tempdataF[5]=DataSLV[i].v1[2]-DataSLV[i+1].v2[2];
				
				DTV[j].n2[0]=DTV[j].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
				DTV[j].n2[1]=DTV[j].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
				DTV[j].n2[2]=DTV[j].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				
				tempdataF[0]=DataSLV[i+2].v1[0]-DataSLV[i+1].v2[0];
				tempdataF[1]=DataSLV[i+2].v1[1]-DataSLV[i+1].v2[1];
				tempdataF[2]=DataSLV[i+2].v1[2]-DataSLV[i+1].v2[2];
				tempdataF[3]=DataSLV[i+1].v1[0]-DataSLV[i+1].v2[0];
				tempdataF[4]=DataSLV[i+1].v1[1]-DataSLV[i+1].v2[1];
				tempdataF[5]=DataSLV[i+1].v1[2]-DataSLV[i+1].v2[2];
				DTV[j].n2[0]=DTV[j].n1[0]+=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
				DTV[j].n2[1]=DTV[j].n1[1]+=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
				DTV[j].n2[2]=DTV[j].n1[2]+=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				var[0]=sqrt(DTV[j].n1[0]*DTV[j].n1[0]+DTV[j].n1[1]*DTV[j].n1[1]+DTV[j].n1[2]*DTV[j].n1[2]);
				DTV[j].n2[0]/=var[0];DTV[j].n1[0]/=var[0];
				DTV[j].n2[1]/=var[0];DTV[j].n1[1]/=var[0];
				DTV[j].n2[2]/=var[0];DTV[j].n1[2]/=var[0];
				
				DTV[j-1].n3[0]=DTV[j].n2[0];DTV[j-1].n3[1]=DTV[j].n2[1];DTV[j-1].n3[2]=DTV[j].n2[2];
				DTV[j].n3[0]=DTV[j-1].n2[0];DTV[j].n3[1]=DTV[j-1].n2[1];DTV[j].n3[2]=DTV[j-1].n2[2];
				
		
				
			}
			if((tempdataI[0]!=1&&(DataSLV[i].v1[0]==DataSLV[i+1].v1[0]))||tempdataI[0]==1&&(DataSLV[i].v1[1]==DataSLV[i+1].v1[1])){
			
					j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
					DTV[j].v1[0]=DataSLV[i].v1[0];DTV[j].v1[1]=DataSLV[i].v1[1];DTV[j].v1[2]=DataSLV[i].v1[2];
					DTV[j].v2[0]=DataSLV[i].v2[0];DTV[j].v2[1]=DataSLV[i].v2[1];DTV[j].v2[2]=DataSLV[i].v2[2];
					DTV[j].v3[0]=DataSLV[i+1].v2[0];DTV[j].v3[1]=DataSLV[i+1].v2[1];DTV[j].v3[2]=DataSLV[i+1].v2[2];
					
					DTV[j].c1[0]=DataSLV[i].c1[0];DTV[j].c1[1]=DataSLV[i].c1[1];DTV[j].c1[2]=DataSLV[i].c1[2];
					DTV[j].c2[0]=DataSLV[i].c2[0];DTV[j].c2[1]=DataSLV[i].c2[1];DTV[j].c2[2]=DataSLV[i].c2[2];
					DTV[j].c3[0]=DataSLV[i+1].c2[0];DTV[j].c3[1]=DataSLV[i+1].c2[1];DTV[j].c3[2]=DataSLV[i+1].c2[2];
					
					DTV[j].texture=0;
					DTV[j].t1[0]=0.5;DTV[j].t1[1]=1.0;
					DTV[j].t2[1]=0.0;DTV[j].t3[1]=0.0;
					DTV[j].t2[0]=1.0-(incf+1.0)/segments;
					DTV[j].t3[0]=1.0-incf/segments;
					
					tempdataF[0]=DataSLV[i-1].v2[0]-DataSLV[i].v1[0];
					tempdataF[1]=DataSLV[i-1].v2[1]-DataSLV[i].v1[1];
					tempdataF[2]=DataSLV[i-1].v2[2]-DataSLV[i].v1[2];
					tempdataF[3]=DataSLV[i].v2[0]-DataSLV[i].v1[0];
					tempdataF[4]=DataSLV[i].v2[1]-DataSLV[i].v1[1];
					tempdataF[5]=DataSLV[i].v2[2]-DataSLV[i].v1[2];
					DTV[j].n2[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n2[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n2[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
					tempdataF[0]=DataSLV[i].v2[0]-DataSLV[i].v1[0];
					tempdataF[1]=DataSLV[i].v2[1]-DataSLV[i].v1[1];
					tempdataF[2]=DataSLV[i].v2[2]-DataSLV[i].v1[2];
					tempdataF[3]=DataSLV[i+1].v2[0]-DataSLV[i].v1[0];
					tempdataF[4]=DataSLV[i+1].v2[1]-DataSLV[i].v1[1];
					tempdataF[5]=DataSLV[i+1].v2[2]-DataSLV[i].v1[2];
					DTV[j].n2[0]+=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n2[1]+=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n2[2]+=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
					
				var[0]=sqrt(DTV[j].n2[0]*DTV[j].n2[0]+DTV[j].n2[1]*DTV[j].n2[1]+DTV[j].n2[2]*DTV[j].n2[2]);
					DTV[j].n2[0]/=var[0];DTV[j].n2[1]/=var[0];DTV[j].n2[2]/=var[0];
					if(tempdataI[0]==1){
						DTV[j].n1[0]=1.0;DTV[j].n1[1]=0.0;DTV[j].n1[2]=0.0;
					}
					if(tempdataI[0]==2){
						DTV[j].n1[0]=0.0;DTV[j].n1[1]=1.0;DTV[j].n1[2]=0.0;
					}
					if(tempdataI[0]==0){
						DTV[j].n1[0]=0.0;DTV[j].n1[1]=0.0;DTV[j].n1[2]=1.0;
					}
					tempdataF[0]=DataSLV[i].v2[0]-DataSLV[i].v1[0];
					tempdataF[1]=DataSLV[i].v2[1]-DataSLV[i].v1[1];
					tempdataF[2]=DataSLV[i].v2[2]-DataSLV[i].v1[2];
					tempdataF[3]=DataSLV[i+1].v2[0]-DataSLV[i].v1[0];
					tempdataF[4]=DataSLV[i+1].v2[1]-DataSLV[i].v1[1];
					tempdataF[5]=DataSLV[i+1].v2[2]-DataSLV[i].v1[2];
					DTV[j].n3[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n3[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n3[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
					
					tempdataF[0]=DataSLV[i+1].v2[0]-DataSLV[i].v1[0];
					tempdataF[1]=DataSLV[i+1].v2[1]-DataSLV[i].v1[1];
					tempdataF[2]=DataSLV[i+1].v2[2]-DataSLV[i].v1[2];
					tempdataF[3]=DataSLV[i+2].v2[0]-DataSLV[i].v1[0];
					tempdataF[4]=DataSLV[i+2].v2[1]-DataSLV[i].v1[1];
					tempdataF[5]=DataSLV[i+2].v2[2]-DataSLV[i].v1[2];
					DTV[j].n3[0]+=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n3[1]+=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n3[2]+=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
					
					
				var[0]=sqrt(DTV[j].n3[0]*DTV[j].n3[0]+DTV[j].n3[1]*DTV[j].n3[1]+DTV[j].n3[2]*DTV[j].n3[2]);
					DTV[j].n3[0]/=var[0];DTV[j].n3[1]/=var[0];DTV[j].n3[2]/=var[0];
					
			
			}
			
			if((tempdataI[0]!=1&&(DataSLV[i].v2[0]==DataSLV[i+1].v2[0]))||tempdataI[0]==1&&(DataSLV[i].v2[1]==DataSLV[i+1].v2[1])){
					j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
					DTV[j].v1[0]=DataSLV[i].v2[0];DTV[j].v1[1]=DataSLV[i].v2[1];DTV[j].v1[2]=DataSLV[i].v2[2];
					DTV[j].v2[0]=DataSLV[i+1].v1[0];DTV[j].v2[1]=DataSLV[i+1].v1[1];DTV[j].v2[2]=DataSLV[i+1].v1[2];
					DTV[j].v3[0]=DataSLV[i].v1[0];DTV[j].v3[1]=DataSLV[i].v1[1];DTV[j].v3[2]=DataSLV[i].v1[2];
					DTV[j].c1[0]=DataSLV[i].c2[0];DTV[j].c1[1]=DataSLV[i].c2[1];DTV[j].c1[2]=DataSLV[i].c2[2];
					DTV[j].c2[0]=DataSLV[i+1].c1[0];DTV[j].c2[1]=DataSLV[i+1].c1[1];DTV[j].c2[2]=DataSLV[i+1].c1[2];
					DTV[j].c3[0]=DataSLV[i].c1[0];DTV[j].c3[1]=DataSLV[i].c1[1];DTV[j].c3[2]=DataSLV[i].c1[2];
					
					DTV[j].texture=0;
					DTV[j].t1[0]=0.5;DTV[j].t1[1]=1.0;
					DTV[j].t2[1]=0.0;DTV[j].t3[1]=0.0;
					DTV[j].t2[0]=incf/segments;
					DTV[j].t3[0]=(incf+1.0)/segments;
					
					tempdataF[0]=DataSLV[i].v1[0]-DataSLV[i].v2[0];
					tempdataF[1]=DataSLV[i].v1[1]-DataSLV[i].v2[1];
					tempdataF[2]=DataSLV[i].v1[2]-DataSLV[i].v2[2];
					tempdataF[3]=DataSLV[i-1].v1[0]-DataSLV[i].v2[0];
					tempdataF[4]=DataSLV[i-1].v1[1]-DataSLV[i].v2[1];
					tempdataF[5]=DataSLV[i-1].v1[2]-DataSLV[i].v2[2];
					DTV[j].n3[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n3[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n3[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
					
					tempdataF[0]=DataSLV[i+1].v1[0]-DataSLV[i].v2[0];
					tempdataF[1]=DataSLV[i+1].v1[1]-DataSLV[i].v2[1];
					tempdataF[2]=DataSLV[i+1].v1[2]-DataSLV[i].v2[2];
					tempdataF[3]=DataSLV[i].v1[0]-DataSLV[i].v2[0];
					tempdataF[4]=DataSLV[i].v1[1]-DataSLV[i].v2[1];
					tempdataF[5]=DataSLV[i].v1[2]-DataSLV[i].v2[2];
					DTV[j].n3[0]+=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n3[1]+=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n3[2]+=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				var[0]=sqrt(DTV[j].n3[0]*DTV[j].n3[0]+DTV[j].n3[1]*DTV[j].n3[1]+DTV[j].n3[2]*DTV[j].n3[2]);
					DTV[j].n3[0]/=var[0];DTV[j].n3[1]/=var[0];DTV[j].n3[2]/=var[0];
					if(tempdataI[0]==1){
						DTV[j].n1[0]=-1.0;DTV[j].n1[1]=0.0;DTV[j].n1[2]=0.0;
					}
					if(tempdataI[0]==2){
						DTV[j].n1[0]=0.0;DTV[j].n1[1]=-1.0;DTV[j].n1[2]=0.0;
					}
					if(tempdataI[0]==0){
						DTV[j].n1[0]=0.0;DTV[j].n1[1]=0.0;DTV[j].n1[2]=-1.0;
					}
					
					tempdataF[0]=DataSLV[i+1].v1[0]-DataSLV[i].v2[0];
					tempdataF[1]=DataSLV[i+1].v1[1]-DataSLV[i].v2[1];
					tempdataF[2]=DataSLV[i+1].v1[2]-DataSLV[i].v2[2];
					tempdataF[3]=DataSLV[i].v1[0]-DataSLV[i].v2[0];
					tempdataF[4]=DataSLV[i].v1[1]-DataSLV[i].v2[1];
					tempdataF[5]=DataSLV[i].v1[2]-DataSLV[i].v2[2];
					DTV[j].n2[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n2[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n2[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
					tempdataF[0]=DataSLV[i+2].v1[0]-DataSLV[i].v2[0];
					tempdataF[1]=DataSLV[i+2].v1[1]-DataSLV[i].v2[1];
					tempdataF[2]=DataSLV[i+2].v1[2]-DataSLV[i].v2[2];
					tempdataF[3]=DataSLV[i+1].v1[0]-DataSLV[i].v2[0];
					tempdataF[4]=DataSLV[i+1].v1[1]-DataSLV[i].v2[1];
					tempdataF[5]=DataSLV[i+1].v1[2]-DataSLV[i].v2[2];
					DTV[j].n2[0]+=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
					DTV[j].n2[1]+=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
					DTV[j].n2[2]+=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				var[0]=sqrt(DTV[j].n2[0]*DTV[j].n2[0]+DTV[j].n2[1]*DTV[j].n2[1]+DTV[j].n2[2]*DTV[j].n2[2]);
					DTV[j].n2[0]/=var[0];DTV[j].n2[1]/=var[0];DTV[j].n2[2]/=var[0];
			
			}
			
			}
				
		}	
			SecCmd="";step=1;
			cmdquickerase();
			CmdCancel();
			return;
			
			}
			
		break;
		case 3: /*SET BASE POINT STATE*/
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
					GriPoint->v[0]=currentdata.v[0];GriPoint->v[1]=currentdata.v[1];GriPoint->v[2]=currentdata.v[2];
				}
				if(currentdata.format==1){
					GriPoint->v[0]+=currentdata.v[0];GriPoint->v[1]+=currentdata.v[1];GriPoint->v[2]+=currentdata.v[2];
				}
				var[0]=1;var[1]=0;var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				if(var[2]){
				
				rtlines->v[0]=GriPoint->v[0];rtlines->v[1]=GriPoint->v[1];rtlines->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];rtlines[0].find=1;
				}
			emit instru(instruction);
			step=2;
			emit SetMouseMode(MOUSEMODE_SELECT);
			return;
			}
		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif


