/****************************************************************************
** $Id:  cmds/cmdgriponlystretch.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDGRIPONLYSTRETCH_H
#define CMDGRIPONLYSTRETCH_H
#include "cmds.h"


void cmds::cmdgriponlystretch(){
	int i,j;
	double var[2];
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	if((SecCmd==tr("**Cancel**")||SecCmd=="")&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
				SendText(tr("--Grip-Stretch--"));instruction=tr("Stretch [Copy]:");emit instru(instruction);
				tempdataI[0]=0;
				step++;
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				return;
		break;
		
		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare(tr("c"))||!SecCmd.compare(tr("C"))){
				tempdataI[0]=1;
				SendText(tr("copy"));
				return;
			}
			

			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				GriPoint[0].find=0;
				
				
				if(tempdataI[0]){/*//////Copy?(y/n)/////*/
					if(currentdata.format==0){/*Global*/
						for(i=0;i<DataSV.size();i++){
							if(DataSV[i].type==1){
								j=DataLV->size();DataLV->resize(j+1);DLV=DataLV->data();
								if((DLV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v1[2]==GriPoint->v[2])){
									DLV[j].v1[0]=currentdata.v[0];
									DLV[j].v1[1]=currentdata.v[1];
									DLV[j].v1[2]=currentdata.v[2];
								}else{
									DLV[j].v1[0]=DLV[DataSV[i].index].v1[0];
									DLV[j].v1[1]=DLV[DataSV[i].index].v1[1];
									DLV[j].v1[2]=DLV[DataSV[i].index].v1[2];
								}
								if((DLV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v2[2]==GriPoint->v[2])){
									DLV[j].v2[0]=currentdata.v[0];
									DLV[j].v2[1]=currentdata.v[1];
									DLV[j].v2[2]=currentdata.v[2];
								}else{
									DLV[j].v2[0]=DLV[DataSV[i].index].v2[0];
									DLV[j].v2[1]=DLV[DataSV[i].index].v2[1];
									DLV[j].v2[2]=DLV[DataSV[i].index].v2[2];
								}
								DLV[j].c1[0]=DLV[DataSV[i].index].c1[0];DLV[j].c1[1]=DLV[DataSV[i].index].c1[1];
								DLV[j].c1[2]=DLV[DataSV[i].index].c1[2];DLV[j].c2[0]=DLV[DataSV[i].index].c2[0];
								DLV[j].c2[1]=DLV[DataSV[i].index].c2[1];DLV[j].c2[2]=DLV[DataSV[i].index].c2[2];
							}
							if(DataSV[i].type==2){
								j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
								if((DTV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v1[2]==GriPoint->v[2])){
									DTV[j].v1[0]=currentdata.v[0];
									DTV[j].v1[1]=currentdata.v[1];
									DTV[j].v1[2]=currentdata.v[2];
								}else{
									DTV[j].v1[0]=DTV[DataSV[i].index].v1[0];
									DTV[j].v1[1]=DTV[DataSV[i].index].v1[1];
									DTV[j].v1[2]=DTV[DataSV[i].index].v1[2];
								}
								if((DTV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v2[2]==GriPoint->v[2])){
									DTV[j].v2[0]=currentdata.v[0];
									DTV[j].v2[1]=currentdata.v[1];
									DTV[j].v2[2]=currentdata.v[2];
								}else{
									DTV[j].v2[0]=DTV[DataSV[i].index].v2[0];
									DTV[j].v2[1]=DTV[DataSV[i].index].v2[1];
									DTV[j].v2[2]=DTV[DataSV[i].index].v2[2];
								}
								if((DTV[DataSV[i].index].v3[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v3[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v3[2]==GriPoint->v[2])){
									DTV[j].v3[0]=currentdata.v[0];
									DTV[j].v3[1]=currentdata.v[1];
									DTV[j].v3[2]=currentdata.v[2];
								}else{
									DTV[j].v3[0]=DTV[DataSV[i].index].v3[0];
									DTV[j].v3[1]=DTV[DataSV[i].index].v3[1];
									DTV[j].v3[2]=DTV[DataSV[i].index].v3[2];
								}
								tempdataF[0]=DTV[j].v2[0]-DTV[j].v1[0];
								tempdataF[1]=DTV[j].v2[1]-DTV[j].v1[1];
								tempdataF[2]=DTV[j].v2[2]-DTV[j].v1[2];
								tempdataF[3]=DTV[j].v3[0]-DTV[j].v1[0];
								tempdataF[4]=DTV[j].v3[1]-DTV[j].v1[1];
								tempdataF[5]=DTV[j].v3[2]-DTV[j].v1[2];

								var[0]=sqrt(tempdataF[0]*tempdataF[0]+tempdataF[1]*tempdataF[1]+tempdataF[2]*tempdataF[2]);
								var[1]=sqrt(tempdataF[3]*tempdataF[3]+tempdataF[4]*tempdataF[4]+tempdataF[5]*tempdataF[5])*var[0];

						DTV[j].n3[0]=DTV[j].n2[0]=DTV[j].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4])/var[1];
						DTV[j].n3[1]=DTV[j].n2[1]=DTV[j].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5])/var[1];
						DTV[j].n3[2]=DTV[j].n2[2]=DTV[j].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3])/var[1];
								
							DTV[j].texture=DTV[DataSV[i].index].texture;
							DTV[j].t1[0]=DTV[DataSV[i].index].t1[0];DTV[j].t1[1]=DTV[DataSV[i].index].t1[1];
							DTV[j].t2[0]=DTV[DataSV[i].index].t2[0];DTV[j].t2[1]=DTV[DataSV[i].index].t2[1];
							DTV[j].t3[0]=DTV[DataSV[i].index].t3[0];DTV[j].t3[1]=DTV[DataSV[i].index].t3[1];
							
								DTV[j].c1[0]=DTV[DataSV[i].index].c1[0];DTV[j].c1[1]=DTV[DataSV[i].index].c1[1];
								DTV[j].c1[2]=DTV[DataSV[i].index].c1[2];DTV[j].c2[0]=DTV[DataSV[i].index].c2[0];
								DTV[j].c2[1]=DTV[DataSV[i].index].c2[1];DTV[j].c2[2]=DTV[DataSV[i].index].c2[2];
								DTV[j].c3[0]=DTV[DataSV[i].index].c3[0];DTV[j].c3[1]=DTV[DataSV[i].index].c3[1];
								DTV[j].c3[2]=DTV[DataSV[i].index].c3[2];
							}
						}
					}
					
					if(currentdata.format==1){/*Relativa ("@")*/
						for(i=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							j=DataLV->size();DataLV->resize(j+1);DLV=DataLV->data();
							if((DLV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v1[2]==GriPoint->v[2])){
								DLV[j].v1[0]=GriPoint->v[0]+currentdata.v[0];DLV[j].v1[1]=GriPoint->v[1]+currentdata.v[1];
								DLV[j].v1[2]=GriPoint->v[2]+currentdata.v[2];
							}else{
								DLV[j].v1[0]=DLV[DataSV[i].index].v1[0];DLV[j].v1[1]=DLV[DataSV[i].index].v1[1];
								DLV[j].v1[2]=DLV[DataSV[i].index].v1[2];
							}
							if((DLV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v2[2]==GriPoint->v[2])){
								DLV[j].v2[0]=GriPoint->v[0]+currentdata.v[0];DLV[j].v2[1]=GriPoint->v[1]+currentdata.v[1];
								DLV[j].v2[2]=GriPoint->v[2]+currentdata.v[2];
							}else{
								DLV[j].v2[0]=DLV[DataSV[i].index].v2[0];DLV[j].v2[1]=DLV[DataSV[i].index].v2[1];
								DLV[j].v2[2]=DLV[DataSV[i].index].v2[2];
							}
							DLV[j].c1[0]=DLV[DataSV[i].index].c1[0];DLV[j].c1[1]=DLV[DataSV[i].index].c1[1];
							DLV[j].c1[2]=DLV[DataSV[i].index].c1[2];DLV[j].c2[0]=DLV[DataSV[i].index].c2[0];
							DLV[j].c2[1]=DLV[DataSV[i].index].c2[1];DLV[j].c2[2]=DLV[DataSV[i].index].c2[2];
							
						}
						if(DataSV[i].type==2){
								j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
								if((DTV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v1[2]==GriPoint->v[2])){
									DTV[j].v1[0]=GriPoint->v[0]+currentdata.v[0];
									DTV[j].v1[1]=GriPoint->v[1]+currentdata.v[1];
									DTV[j].v1[2]=GriPoint->v[2]+currentdata.v[2];
								}else{
									DTV[j].v1[0]=DTV[DataSV[i].index].v1[0];
									DTV[j].v1[1]=DTV[DataSV[i].index].v1[1];
									DTV[j].v1[2]=DTV[DataSV[i].index].v1[2];
								}
								if((DTV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v2[2]==GriPoint->v[2])){
									DTV[j].v2[0]=GriPoint->v[0]+currentdata.v[0];
									DTV[j].v2[1]=GriPoint->v[1]+currentdata.v[1];
									DTV[j].v2[2]=GriPoint->v[2]+currentdata.v[2];
								}else{
									DTV[j].v2[0]=DTV[DataSV[i].index].v2[0];
									DTV[j].v2[1]=DTV[DataSV[i].index].v2[1];
									DTV[j].v2[2]=DTV[DataSV[i].index].v2[2];
								}
								if((DTV[DataSV[i].index].v3[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v3[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v3[2]==GriPoint->v[2])){
									DTV[j].v3[0]=GriPoint->v[0]+currentdata.v[0];
									DTV[j].v3[1]=GriPoint->v[1]+currentdata.v[1];
									DTV[j].v3[2]=GriPoint->v[2]+currentdata.v[2];
								}else{
									DTV[j].v3[0]=DTV[DataSV[i].index].v3[0];
									DTV[j].v3[1]=DTV[DataSV[i].index].v3[1];
									DTV[j].v3[2]=DTV[DataSV[i].index].v3[2];
								}
								tempdataF[0]=DTV[j].v2[0]-DTV[j].v1[0];
								tempdataF[1]=DTV[j].v2[1]-DTV[j].v1[1];
								tempdataF[2]=DTV[j].v2[2]-DTV[j].v1[2];
								tempdataF[3]=DTV[j].v3[0]-DTV[j].v1[0];
								tempdataF[4]=DTV[j].v3[1]-DTV[j].v1[1];
								tempdataF[5]=DTV[j].v3[2]-DTV[j].v1[2];


						DTV[j].n3[0]=DTV[j].n2[0]=DTV[j].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
						DTV[j].n3[1]=DTV[j].n2[1]=DTV[j].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
						DTV[j].n3[2]=DTV[j].n2[2]=DTV[j].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
						var[0]=sqrt(DTV[j].n1[0]*DTV[j].n1[0]+DTV[j].n1[1]*DTV[j].n1[1]+DTV[j].n1[2]*DTV[j].n1[2]);
						DTV[j].n3[0]/=var[0];DTV[j].n2[0]/=var[0];DTV[j].n1[0]/=var[0];
						DTV[j].n3[1]/=var[0];DTV[j].n2[1]/=var[0];DTV[j].n1[1]/=var[0];
						DTV[j].n3[2]/=var[0];DTV[j].n2[2]/=var[0];DTV[j].n1[2]/=var[0];
									
							DTV[j].texture=DTV[DataSV[i].index].texture;
							DTV[j].t1[0]=DTV[DataSV[i].index].t1[0];DTV[j].t1[1]=DTV[DataSV[i].index].t1[1];
							DTV[j].t2[0]=DTV[DataSV[i].index].t2[0];DTV[j].t2[1]=DTV[DataSV[i].index].t2[1];
							DTV[j].t3[0]=DTV[DataSV[i].index].t3[0];DTV[j].t3[1]=DTV[DataSV[i].index].t3[1];
								DTV[j].c1[0]=DTV[DataSV[i].index].c1[0];DTV[j].c1[1]=DTV[DataSV[i].index].c1[1];
								DTV[j].c1[2]=DTV[DataSV[i].index].c1[2];DTV[j].c2[0]=DTV[DataSV[i].index].c2[0];
								DTV[j].c2[1]=DTV[DataSV[i].index].c2[1];DTV[j].c2[2]=DTV[DataSV[i].index].c2[2];
								DTV[j].c3[0]=DTV[DataSV[i].index].c3[0];DTV[j].c3[1]=DTV[DataSV[i].index].c3[1];
								DTV[j].c3[2]=DTV[DataSV[i].index].c3[2];
						}
						}
					}
	
					
				}else{
					if(currentdata.format==0){/*Global*/
						for(i=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							if((DLV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v1[2]==GriPoint->v[2])){
								DLV[DataSV[i].index].v1[0]=currentdata.v[0];DLV[DataSV[i].index].v1[1]=currentdata.v[1];
								DLV[DataSV[i].index].v1[2]=currentdata.v[2];
							}
							if((DLV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v2[2]==GriPoint->v[2])){
								DLV[DataSV[i].index].v2[0]=currentdata.v[0];DLV[DataSV[i].index].v2[1]=currentdata.v[1];
								DLV[DataSV[i].index].v2[2]=currentdata.v[2];
							}
						}
						if(DataSV[i].type==2){
							if((DTV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v1[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].v1[0]=currentdata.v[0];DTV[DataSV[i].index].v1[1]=currentdata.v[1];
								DTV[DataSV[i].index].v1[2]=currentdata.v[2];
							}
							if((DTV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v2[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].v2[0]=currentdata.v[0];DTV[DataSV[i].index].v2[1]=currentdata.v[1];
								DTV[DataSV[i].index].v2[2]=currentdata.v[2];
							}
							if((DTV[DataSV[i].index].v3[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v3[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v3[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].v3[0]=currentdata.v[0];DTV[DataSV[i].index].v3[1]=currentdata.v[1];
								DTV[DataSV[i].index].v3[2]=currentdata.v[2];
							}
							
								tempdataF[0]=DTV[DataSV[i].index].v2[0]-DTV[DataSV[i].index].v1[0];
								tempdataF[1]=DTV[DataSV[i].index].v2[1]-DTV[DataSV[i].index].v1[1];
								tempdataF[2]=DTV[DataSV[i].index].v2[2]-DTV[DataSV[i].index].v1[2];
								tempdataF[3]=DTV[DataSV[i].index].v3[0]-DTV[DataSV[i].index].v1[0];
								tempdataF[4]=DTV[DataSV[i].index].v3[1]-DTV[DataSV[i].index].v1[1];
								tempdataF[5]=DTV[DataSV[i].index].v3[2]-DTV[DataSV[i].index].v1[2];

	DTV[DataSV[i].index].n3[0]=DTV[DataSV[i].index].n2[0]=DTV[DataSV[i].index].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
	DTV[DataSV[i].index].n3[1]=DTV[DataSV[i].index].n2[1]=DTV[DataSV[i].index].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
	DTV[DataSV[i].index].n3[2]=DTV[DataSV[i].index].n2[2]=DTV[DataSV[i].index].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
	var[0]=sqrt(DTV[DataSV[i].index].n1[0]*DTV[DataSV[i].index].n1[0]+DTV[DataSV[i].index].n1[1]*DTV[DataSV[i].index].n1[1]+DTV[DataSV[i].index].n1[2]*DTV[DataSV[i].index].n1[2]);
	DTV[DataSV[i].index].n3[0]/=var[0];DTV[DataSV[i].index].n2[0]/=var[0];DTV[DataSV[i].index].n1[0]/=var[0];
	DTV[DataSV[i].index].n3[1]/=var[0];DTV[DataSV[i].index].n2[1]/=var[0];DTV[DataSV[i].index].n1[1]/=var[0];
	DTV[DataSV[i].index].n3[2]/=var[0];DTV[DataSV[i].index].n2[2]/=var[0];DTV[DataSV[i].index].n1[2]/=var[0];
						
						}
						}
					}
					
					if(currentdata.format==1){/*Relativa ("@")*/
						for(i=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							if((DLV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v1[2]==GriPoint->v[2])){
								DLV[DataSV[i].index].v1[0]=GriPoint->v[0]+currentdata.v[0];DLV[DataSV[i].index].v1[1]=GriPoint->v[1]+currentdata.v[1];
								DLV[DataSV[i].index].v1[2]=GriPoint->v[2]+currentdata.v[2];
							}
							if((DLV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v2[2]==GriPoint->v[2])){
								DLV[DataSV[i].index].v2[0]=GriPoint->v[0]+currentdata.v[0];DLV[DataSV[i].index].v2[1]=GriPoint->v[1]+currentdata.v[1];
								DLV[DataSV[i].index].v2[2]=GriPoint->v[2]+currentdata.v[2];
							}
						}
						if(DataSV[i].type==2){
							if((DTV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v1[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].v1[0]=GriPoint->v[0]+currentdata.v[0];DTV[DataSV[i].index].v1[1]=GriPoint->v[1]+currentdata.v[1];
								DTV[DataSV[i].index].v1[2]=GriPoint->v[2]+currentdata.v[2];
							}
							if((DTV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v2[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].v2[0]=GriPoint->v[0]+currentdata.v[0];DTV[DataSV[i].index].v2[1]=GriPoint->v[1]+currentdata.v[1];
								DTV[DataSV[i].index].v2[2]=GriPoint->v[2]+currentdata.v[2];
							}
							if((DTV[DataSV[i].index].v3[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v3[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v3[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].v3[0]=GriPoint->v[0]+currentdata.v[0];DTV[DataSV[i].index].v3[1]=GriPoint->v[1]+currentdata.v[1];
								DTV[DataSV[i].index].v3[2]=GriPoint->v[2]+currentdata.v[2];
							}
								tempdataF[0]=DTV[DataSV[i].index].v2[0]-DTV[DataSV[i].index].v1[0];
								tempdataF[1]=DTV[DataSV[i].index].v2[1]-DTV[DataSV[i].index].v1[1];
								tempdataF[2]=DTV[DataSV[i].index].v2[2]-DTV[DataSV[i].index].v1[2];
								tempdataF[3]=DTV[DataSV[i].index].v3[0]-DTV[DataSV[i].index].v1[0];
								tempdataF[4]=DTV[DataSV[i].index].v3[1]-DTV[DataSV[i].index].v1[1];
								tempdataF[5]=DTV[DataSV[i].index].v3[2]-DTV[DataSV[i].index].v1[2];

								var[0]=sqrt(tempdataF[0]*tempdataF[0]+tempdataF[1]*tempdataF[1]+tempdataF[2]*tempdataF[2]);
								var[1]=sqrt(tempdataF[3]*tempdataF[3]+tempdataF[4]*tempdataF[4]+tempdataF[5]*tempdataF[5])*var[0];

	DTV[DataSV[i].index].n3[0]=DTV[DataSV[i].index].n2[0]=DTV[DataSV[i].index].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4])/var[1];
	DTV[DataSV[i].index].n3[1]=DTV[DataSV[i].index].n2[1]=DTV[DataSV[i].index].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5])/var[1];
	DTV[DataSV[i].index].n3[2]=DTV[DataSV[i].index].n2[2]=DTV[DataSV[i].index].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3])/var[1];
						
						}
						}
					}
				CmdCancel();
				}
			
			
			/*DataSV.resize(0);*/
			
			return;
			}
			
		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
