/****************************************************************************
** $Id:  cmds/cmdarray.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/


#ifndef CMDARRAY_H
#define CMDARRAY_H
#include "cmds.h"


void cmds::cmdarray(){
	int i,j,k;
	float incf;
	float currangle;
	float angle;
	float segments;
	float vec[3];
	float incvec[3];
	double var[3];
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	vec[0]=0;vec[1]=0;vec[2]=0;
	incvec[0]=0;incvec[1]=0;incvec[2]=0;
	if((SecCmd==tr("**Cancel**"))&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		case 0:
				SendText(tr("--Array--"));
				instruction=tr("Array [Rectangular/Polar]<Polar>:");emit instru(instruction);
				step++;
				return;
		break;
		
		case 1:
			if(!SecCmd.compare(tr("r","Rectangular"))||!SecCmd.compare(tr("R","Rectangular"))){
				*GripEditMode=3;
				GriPoint->v[0]=0;GriPoint->v[1]=0;GriPoint->v[2]=0;
				for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;k=DataSV[i].index;
						DataSLV[j].v1[0]=DLV[k].v1[0];
						DataSLV[j].v2[0]=DLV[k].v2[0];
						DataSLV[j].v1[1]=DLV[k].v1[1];
						DataSLV[j].v2[1]=DLV[k].v2[1];
						DataSLV[j].v1[2]=DLV[k].v1[2];
						DataSLV[j].v2[2]=DLV[k].v2[2];
						DataSLV[j].c1[0]=DLV[k].c1[0];
						DataSLV[j].c2[0]=DLV[k].c2[0];
						DataSLV[j].c1[1]=DLV[k].c1[1];
						DataSLV[j].c2[1]=DLV[k].c2[1];
						DataSLV[j].c1[2]=DLV[k].c1[2];
						DataSLV[j].c2[2]=DLV[k].c2[2];
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[0]=DTV[k].v1[0];
						DataSTV[j].v2[0]=DTV[k].v2[0];
						DataSTV[j].v3[0]=DTV[k].v3[0];
						DataSTV[j].v1[1]=DTV[k].v1[1];
						DataSTV[j].v2[1]=DTV[k].v2[1];
						DataSTV[j].v3[1]=DTV[k].v3[1];
						DataSTV[j].v1[2]=DTV[k].v1[2];
						DataSTV[j].v2[2]=DTV[k].v2[2];
						DataSTV[j].v3[2]=DTV[k].v3[2];
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c3[0]=DTV[k].c3[0];
						DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c3[1]=DTV[k].c3[1];
						DataSTV[j].c1[2]=DTV[k].c1[2];DataSTV[j].c2[2]=DTV[k].c2[2];DataSTV[j].c3[2]=DTV[k].c3[2];
						DataSTV[j].n1[0]=DTV[k].n1[0];DataSTV[j].n2[0]=DTV[k].n2[0];DataSTV[j].n3[0]=DTV[k].n3[0];
						DataSTV[j].n1[1]=DTV[k].n1[1];DataSTV[j].n2[1]=DTV[k].n2[1];DataSTV[j].n3[1]=DTV[k].n3[1];
						DataSTV[j].n1[2]=DTV[k].n1[2];DataSTV[j].n2[2]=DTV[k].n2[2];DataSTV[j].n3[2]=DTV[k].n3[2];
					}
				}
				step=5;
				instruction=QString(tr("Array Rectangular [Base point/Items<%1>]:")).arg(Array_NItems);emit instru(instruction);
				SetMouseMode(MOUSEMODE_PICKPOINT);
				return;

			}
			if(!SecCmd.compare(tr("p","Polar"))||!SecCmd.compare(tr("P","Polar"))){
				instruction=tr("Array Angle<360>:");emit instru(instruction);
				tempdataI[0]=0;tempdataF[0]=360.0;tempdataF[1]=8.0;tempdataF[2]=0;tempdataF[3]=1;tempdataF[4]=0;tempdataI[1]=2;
				rtlines->v[0]=0;GriPoint->v[0]=0;rtlines->v[1]=0;GriPoint->v[1]=0;rtlines->v[2]=0;GriPoint->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				step++;
				return;
			}
		break;
		
		case 2:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("")){
				step++;
				instruction=QString(tr("Array Segments [Angle<%1>/BasePoint]:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				return;
			}
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==2){
					tempdataF[0]=currentdata.v[0];
				instruction=QString(tr("Array Segments [Angle<%1>/BasePoint]:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
					step++;
					return;
				}
			}
			
		break;
		case 3:
			if(!SecCmd.compare(tr("a"))||!SecCmd.compare(tr("A"))){
				instruction=QString(tr("Array Angle<%1>:")).arg(tempdataF[0]);emit instru(instruction);
				step=2;
				return;
			}
			if(!SecCmd.compare(tr("b"))||!SecCmd.compare(tr("B"))){
				SendText(tr("Base point"));emit instru(tr("Array (Base point):"));
				rtlines[0].find=0;
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				step=4;
				return;
			}
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==2){
					tempdataF[1]=currentdata.v[0];
					instruction=QString(tr("Array Segments [Angle<%1>]:<%2>")).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
					SecCmd="";
				}
			}
			if(!SecCmd.compare("")){

				segments=tempdataF[1];
				angle=tempdataF[0];
				
				for(incf=1.0;incf<segments;incf=incf+1.0){
					currangle=angle*incf/segments;
					var[0]=cosf(currangle*M_PI/180.0);var[1]=sinf(currangle*M_PI/180.0);
					var[2]=1;

				if(var[2]){
				
					for(i=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							j=DataLV->size();DataLV->resize(j+1);DLV=DataLV->data();k=DataSV[i].index;
							tempdataF[0]=DLV[k].v1[0]-GriPoint->v[0];
							tempdataF[1]=DLV[k].v1[1]-GriPoint->v[1];
							tempdataF[2]=DLV[k].v1[2]-GriPoint->v[2];
							DLV[j].v1[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DLV[j].v1[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DLV[j].v1[2]=tempdataF[2];
							DLV[j].c1[0]=DLV[k].c1[0];DLV[j].c1[1]=DLV[k].c1[1];DLV[j].c1[2]=DLV[k].c1[2];

							tempdataF[0]=DLV[k].v2[0]-GriPoint->v[0];
							tempdataF[1]=DLV[k].v2[1]-GriPoint->v[1];
							tempdataF[2]=DLV[k].v2[2]-GriPoint->v[2];
							DLV[j].v2[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DLV[j].v2[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DLV[j].v2[2]=tempdataF[2];
							DLV[j].c2[0]=DLV[k].c2[0];DLV[j].c2[1]=DLV[k].c2[1];DLV[j].c2[2]=DLV[k].c2[2];
						}
						
						if(DataSV[i].type==2){
							j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();k=DataSV[i].index;
							tempdataF[0]=DTV[k].v1[0]-GriPoint->v[0];
							tempdataF[1]=DTV[k].v1[1]-GriPoint->v[1];
							tempdataF[2]=DTV[k].v1[2]-GriPoint->v[2];
							DTV[j].v1[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[j].v1[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[j].v1[2]=tempdataF[2];
							tempdataF[0]=DTV[k].v2[0]-GriPoint->v[0];
							tempdataF[1]=DTV[k].v2[1]-GriPoint->v[1];
							tempdataF[2]=DTV[k].v2[2]-GriPoint->v[2];
							DTV[j].v2[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[j].v2[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[j].v2[2]=tempdataF[2];
							tempdataF[0]=DTV[k].v3[0]-GriPoint->v[0];
							tempdataF[1]=DTV[k].v3[1]-GriPoint->v[1];
							tempdataF[2]=DTV[k].v3[2]-GriPoint->v[2];
							DTV[j].v3[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[j].v3[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[j].v3[2]=tempdataF[2];
							tempdataF[0]=DTV[k].n1[0];tempdataF[1]=DTV[k].n1[1];tempdataF[2]=DTV[k].n1[2];
							DTV[j].n1[0]=(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[j].n1[1]=(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[j].n1[2]=tempdataF[2];
							tempdataF[0]=DTV[k].n2[0];tempdataF[1]=DTV[k].n2[1];tempdataF[2]=DTV[k].n2[2];
							DTV[j].n2[0]=(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[j].n2[1]=(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[j].n2[2]=tempdataF[2];
							tempdataF[0]=DTV[k].n3[0];tempdataF[1]=DTV[k].n3[1];tempdataF[2]=DTV[k].n3[2];
							DTV[j].n3[0]=(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[j].n3[1]=(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[j].n3[2]=tempdataF[2];
							DTV[j].texture=DTV[k].texture;
							DTV[j].t1[0]=DTV[k].t1[0];DTV[j].t1[1]=DTV[k].t1[1];
							DTV[j].t2[0]=DTV[k].t2[0];DTV[j].t2[1]=DTV[k].t2[1];
							DTV[j].t3[0]=DTV[k].t3[0];DTV[j].t3[1]=DTV[k].t3[1];
							DTV[j].c1[0]=DTV[k].c1[0];DTV[j].c1[1]=DTV[k].c1[1];DTV[j].c1[2]=DTV[k].c1[2];
							DTV[j].c2[0]=DTV[k].c2[0];DTV[j].c2[1]=DTV[k].c2[1];DTV[j].c2[2]=DTV[k].c2[2];
							DTV[j].c3[0]=DTV[k].c3[0];DTV[j].c3[1]=DTV[k].c3[1];DTV[j].c3[2]=DTV[k].c3[2];
						
						}

					}

				}
			}
			CmdCancel();
			return;
			
			}
			
		break;
		case 4: /*SET BASE POINT STATE*/
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
					GriPoint->v[0]=currentdata.v[0];GriPoint->v[1]=currentdata.v[1];GriPoint->v[2]=currentdata.v[2];
				}
				if(currentdata.format==1){
					GriPoint->v[0]+=currentdata.v[0];GriPoint->v[1]+=currentdata.v[1];GriPoint->v[2]+=currentdata.v[2];
				}
				var[0]=1;var[1]=0;var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				if(var[2]){
				
				rtlines->v[0]=GriPoint->v[0];rtlines->v[1]=GriPoint->v[1];rtlines->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];rtlines[0].find=1;
				}
			emit instru(instruction);
			step=3;
			emit SetMouseMode(MOUSEMODE_SELECT);
			return;
			}
		break;
		case 5:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			if(!SecCmd.compare(tr("i","item"))||!SecCmd.compare(tr("I","Item"))){
				SendText(tr("Items"));emit instru(tr("Num. of Items:"));
				step=6;
				return;
			}
			if(!SecCmd.compare(tr("b"))||!SecCmd.compare(tr("B"))){
				SendText(tr("Base point"));emit instru(tr("Array Rectangular (set base point):"));
				DataSLV.resize(0);DataSTV.resize(0);
				step=7;
				return;
			}
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}

				if(currentdata.format==0){
					vec[0]=currentdata.v[0];vec[1]=currentdata.v[1];vec[2]=currentdata.v[2];
					incvec[0]=currentdata.v[0]-GriPoint->v[0];incvec[1]=currentdata.v[1]-GriPoint->v[1];incvec[2]=currentdata.v[2]-GriPoint->v[2];
				}
				if(currentdata.format==1){
					vec[0]=currentdata.v[0]+GriPoint->v[0];vec[1]=currentdata.v[1]+GriPoint->v[1];
					vec[2]=currentdata.v[2]+GriPoint->v[2];
					incvec[0]=currentdata.v[0];incvec[1]=currentdata.v[1];incvec[2]=currentdata.v[2];
				}

				for(k=0;k<Array_NItems;k++){
						for(i=0;i<DataSLV.size();i++){
							j=DataLV->size();DataLV->resize(j+1);DLV=DataLV->data();
							DLV[j].c1[0]=DataSLV[i].c1[0];
							DLV[j].c1[1]=DataSLV[i].c1[1];
							DLV[j].c1[2]=DataSLV[i].c1[2];
							DLV[j].c2[0]=DataSLV[i].c2[0];
							DLV[j].c2[1]=DataSLV[i].c2[1];
							DLV[j].c2[2]=DataSLV[i].c2[2];
						}
						
						for(i=0;i<DataSTV.size();i++){
							j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
							DTV[j].texture=DataSTV[i].texture;
							DTV[j].t1[0]=DataSTV[i].t1[0];DTV[j].t1[1]=DataSTV[i].t1[1];
							DTV[j].t2[0]=DataSTV[i].t2[0];DTV[j].t2[1]=DataSTV[i].t2[1];
							DTV[j].t3[0]=DataSTV[i].t3[0];DTV[j].t3[1]=DataSTV[i].t3[1];
							DTV[j].c1[0]=DataSTV[i].c1[0];DTV[j].c1[1]=DataSTV[i].c1[1];DTV[j].c1[2]=DataSTV[i].c1[2];
							DTV[j].c2[0]=DataSTV[i].c2[0];DTV[j].c2[1]=DataSTV[i].c2[1];DTV[j].c2[2]=DataSTV[i].c2[2];
							DTV[j].c3[0]=DataSTV[i].c3[0];DTV[j].c3[1]=DataSTV[i].c3[1];DTV[j].c3[2]=DataSTV[i].c3[2];
							DTV[j].n1[0]=DataSTV[i].n1[0];DTV[j].n1[1]=DataSTV[i].n1[1];DTV[j].n1[2]=DataSTV[i].n1[2];
							DTV[j].n2[0]=DataSTV[i].n2[0];DTV[j].n2[1]=DataSTV[i].n2[1];DTV[j].n2[2]=DataSTV[i].n2[2];
							DTV[j].n3[0]=DataSTV[i].n3[0];DTV[j].n3[1]=DataSTV[i].n3[1];DTV[j].n3[2]=DataSTV[i].n3[2];
						}


						for(i=0,j=DataLV->size()-DataSLV.size();i<DataSLV.size();i++,j++){
							DLV[j].v1[0]=vec[0]+DataSLV[i].v1[0];
							DLV[j].v1[1]=vec[1]+DataSLV[i].v1[1];
							DLV[j].v1[2]=vec[2]+DataSLV[i].v1[2];
							DLV[j].v2[0]=vec[0]+DataSLV[i].v2[0];
							DLV[j].v2[1]=vec[1]+DataSLV[i].v2[1];
							DLV[j].v2[2]=vec[2]+DataSLV[i].v2[2];
							
						}
						
						for(i=0,j=DataTV->size()-DataSTV.size();i<DataSTV.size();i++,j++){
							DTV[j].v1[0]=vec[0]+DataSTV[i].v1[0];
							DTV[j].v1[1]=vec[1]+DataSTV[i].v1[1];
							DTV[j].v1[2]=vec[2]+DataSTV[i].v1[2];
							DTV[j].v2[0]=vec[0]+DataSTV[i].v2[0];
							DTV[j].v2[1]=vec[1]+DataSTV[i].v2[1];
							DTV[j].v2[2]=vec[2]+DataSTV[i].v2[2];
							DTV[j].v3[0]=vec[0]+DataSTV[i].v3[0];
							DTV[j].v3[1]=vec[1]+DataSTV[i].v3[1];
							DTV[j].v3[2]=vec[2]+DataSTV[i].v3[2];
						}
						vec[0]+=incvec[0];vec[1]+=incvec[1];vec[2]+=incvec[2];
				}
			DataSV.resize(0);
			CmdCancel();
			return;
		}
		break;
		case 6:
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==2){
					if((int)currentdata.v[0]>=0){
						Array_NItems=(int)currentdata.v[0];
						instruction=QString(tr("Array Rectangular [Base point/Items<%1>]:")).arg(Array_NItems);emit instru(instruction);
						step=5;
					}
				}
		                return;
			}
		break;
		case 7:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
					GriPoint->v[0]=currentdata.v[0];GriPoint->v[1]=currentdata.v[1];GriPoint->v[2]=currentdata.v[2];
				}
				if(currentdata.format==1){
					GriPoint->v[0]+=currentdata.v[0];GriPoint->v[1]+=currentdata.v[1];GriPoint->v[2]+=currentdata.v[2];
				}
				
				for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;k=DataSV[i].index;
						DataSLV[j].v1[0]=DLV[k].v1[0]-GriPoint->v[0];
						DataSLV[j].v2[0]=DLV[k].v2[0]-GriPoint->v[0];
						DataSLV[j].v1[1]=DLV[k].v1[1]-GriPoint->v[1];
						DataSLV[j].v2[1]=DLV[k].v2[1]-GriPoint->v[1];
						DataSLV[j].v1[2]=DLV[k].v1[2]-GriPoint->v[2];
						DataSLV[j].v2[2]=DLV[k].v2[2]-GriPoint->v[2];
						DataSLV[j].c1[0]=DLV[k].c1[0];
						DataSLV[j].c2[0]=DLV[k].c2[0];
						DataSLV[j].c1[1]=DLV[k].c1[1];
						DataSLV[j].c2[1]=DLV[k].c2[1];
						DataSLV[j].c1[2]=DLV[k].c1[2];
						DataSLV[j].c2[2]=DLV[k].c2[2];
						
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[0]=DTV[k].v1[0]-GriPoint->v[0];
						DataSTV[j].v2[0]=DTV[k].v2[0]-GriPoint->v[0];
						DataSTV[j].v3[0]=DTV[k].v3[0]-GriPoint->v[0];
						
						DataSTV[j].v1[1]=DTV[k].v1[1]-GriPoint->v[1];
						DataSTV[j].v2[1]=DTV[k].v2[1]-GriPoint->v[1];
						DataSTV[j].v3[1]=DTV[k].v3[1]-GriPoint->v[1];
						
						DataSTV[j].v1[2]=DTV[k].v1[2]-GriPoint->v[2];
						DataSTV[j].v2[2]=DTV[k].v2[2]-GriPoint->v[2];
						DataSTV[j].v3[2]=DTV[k].v3[2]-GriPoint->v[2];
						
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c3[0]=DTV[k].c3[0];
						DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c3[1]=DTV[k].c3[1];
						DataSTV[j].c1[2]=DTV[k].c1[2];DataSTV[j].c2[2]=DTV[k].c2[2];DataSTV[j].c3[2]=DTV[k].c3[2];
						/*normals*/
						DataSTV[j].n1[0]=DTV[k].n1[0];DataSTV[j].n2[0]=DTV[k].n2[0];DataSTV[j].n3[0]=DTV[k].n3[0];
						DataSTV[j].n1[1]=DTV[k].n1[1];DataSTV[j].n2[1]=DTV[k].n2[1];DataSTV[j].n3[1]=DTV[k].n3[1];
						DataSTV[j].n1[2]=DTV[k].n1[2];DataSTV[j].n2[2]=DTV[k].n2[2];DataSTV[j].n3[2]=DTV[k].n3[2];
					}
				}
				
				
			emit instru(instruction);
			step=5;
			return;
			}
			

		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif


