#!/usr/bin/perl
# renames files to numbers
# (c) John Hanna 2003 under the terms of the GPL
# v2.0

use strict;
use warnings;

use vars qw{
  $MaxBytes $MaxFiles $base $c $d $fn $fn0 $ltime $maillogExt $modversion
  $notspamlog $spamlog $version %Config
};

$version    = '2.0';
$modversion = '';        #appended in version display.

if ( !defined( $ARGV[0] ) || !( $ARGV[0] =~ /-[r]/ ) ) {
    print "This program renames files to numbers

Usage:
 perl move2num.pl -r              actually rename the files
";
    exit;
}

open( F, "<assp.cfg" );
local $/;
(%Config) = split( /:=|\n/, <F> );
close F;
$spamlog    = $Config{spamlog}    && "$Config{base}/$Config{spamlog}"    || 'spam';
$notspamlog = $Config{notspamlog} && "$Config{base}/$Config{notspamlog}" || 'notspam';
$MaxFiles = $Config{MaxFiles} || 14003;
$MaxBytes = $Config{MaxBytes} || 6000;
$maillogExt = $Config{maillogExt};
$base       = $Config{base};

$ltime = localtime(time);
open( R, ">>$base/move2numlog.txt" );
printlog("$ltime: move2num $version$modversion started\n");

# we'll move files whose numbers are > $MaxFiles or files without numbered names to
# numbered names < $MaxFiles -- if there are more files than $MaxFiles we'll randomly overwrite
# some.

$c = 1;
for $fn ( glob("$spamlog/*$maillogExt") ) {
    next      if -d $fn;
    next      if $fn =~ /\/(\d+)$maillogExt$/i && $1 < $MaxFiles;
    print "." if $c++ % 100 == 0;
    $fn0 = substr( $fn, 0, $MaxBytes );
    while ( $c < $MaxFiles && -s "$spamlog/$c$maillogExt" ) { $c++ }
    $d = $c < $MaxFiles ? $c : int( rand() * $MaxFiles );
    $fn =~ s#/[^/]*$#/$d$maillogExt#;
    unlink($fn);
    rename( $fn0, $fn );
}
$c = 1;
for $fn ( glob("$notspamlog/*$maillogExt") ) {
    next      if -d $fn;
    next      if $fn =~ /\/(\d+)$maillogExt$/i && $1 < $MaxFiles;
    print "." if $c++ % 100 == 0;
    $fn0 = substr( $fn, 0, $MaxBytes );
    while ( $c < $MaxFiles && -s "$notspamlog/$c$maillogExt" ) { $c++ }
    $d = $c < $MaxFiles ? $c : int( rand() * $MaxFiles );
    $fn =~ s#/[^/]*$#/$d$maillogExt#;
    unlink($fn);
    rename( $fn0, $fn );
}

$ltime = localtime(time);
printlog("$ltime: move2num ended\n");
close R;

sub printlog {
    my ( $text, $format ) = @_;
    print "$text"   if !$format;
    print R "$text" if !$format;
    printf "$text", $format if $format;
    printf R "$text", $format if $format;
}

