<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

	/**
	 * implements the main view of the validate trackback plugin
	 */
	class AdminValidateTrackbackPluginSettingsView extends AdminPluginTemplatedView
	{

		function AdminValidateTrackbackPluginSettingsView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "validatetrackback", "pluginsettings" );
		}
		
		function render()
		{
			// load some configuration settings
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_validatetrackback_enabled" );

			$checkTrackbackUrls = $blogSettings->getValue( "plugin_validatetrackback_trackback_enabled" );
			$useDnsChecks = $blogSettings->getValue( "plugin_validatetrackback_dns_enabled" );
            $useLinkChecks = $blogSettings->getValue( "plugin_validatetrackback_linkchecking_enabled" );
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );		

			$this->setValue( "trackbackUrlCheckingEnabled", $checkTrackbackUrls );		
			$this->setValue( "dnsCheckingEnabled", $useDnsChecks );		
			$this->setValue( "linkCheckingEnabled", $useLinkChecks );		
			
			parent::render();
		}
	}
?>