<?php

	lt_include( PLOG_CLASS_PATH."class/security/pipelinefilter.class.php" );

	class ValidateTrackbackDNSAntiSpamFilter 
	{
        

        // The following function comese from John Sinteur
        /*
        Plugin Name: Block-lists anti-spam measures
        Version: 1.5.1
        Plugin URI: http://weblog.sinteur.com/index.php?p=8106
        Description: check if a comment poster is on an open proxy list, and check if the content contains known spammer domains
        Author: John Sinteur, with a big thank you to io_error!
        Author URI: http://weblog.sinteur.com/
        */

        function checkClientIP( $spammer_ip )
        {
            $rev = array_reverse(explode('.', $spammer_ip));
        
            $lookup = implode('.', $rev) . '.' . 'l1.spews.dnsbl.sorbs.net.';
        
            if ($lookup != gethostbyname($lookup)) {
                return false;
            }
            $lookup = implode('.', $rev) . '.' . 'sbl-xbl.spamhaus.org.';
            if ($lookup != gethostbyname($lookup)) {
                return false;
            }
            $lookup = implode('.', $rev) . '.' . 'list.dsbl.org.';
            if ($lookup != gethostbyname($lookup)) {
                return false;
            }
            $lookup = implode('.', $rev) . '.' . 'opm.blitzed.org.';
            if ($lookup != gethostbyname($lookup)) {
                return false;
            }
        
            return true ;
        }
        
        
        // for a full explanation, see http://www.surbl.org 
        // summary: blocks trackback if it contains an url that's on a known spammers list.
        function checkTrackbackURL ( $trackback_url )
        {
            $pieces = explode('/',$trackback_url);
            for( $cnt=0; $cnt < count($pieces); $cnt++ ) {
                $short_url = $pieces[$cnt];
        
                if ($short_url != 'http')
                {
                    $short_url = str_replace("www.", "", "$short_url");
                    if (strlen($short_url) > 3)
                    {
                        $domain_to_test = $short_url . ".multi.surbl.org.";
                        if( gethostbyname($domain_to_test) != $domain_to_test ) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }        
    }
?>
