<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/validatetrackback/class/view/adminvalidatetrackbackpluginsettingsview.class.php" ); 

    class AdminValidateTrackbackPluginUpdateSettingsAction extends AdminAction 
	{
	
		var $_pluginEnabled;

		var $_validateTrackbacksUrls;
		var $_dnsAntiSpam;


    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function AdminValidateTrackbackPluginUpdateSettingsAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );
        }
		
		function validate()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );			
        
            $this->_validateTrackbacksUrls = $this->_request->getValue( "trackbackUrlCheckingEnabled" );
            $this->_validateTrackbacksUrls = ($this->_validateTrackbacksUrls != "" );			
        
            $this->_dnsAntiSpam            = $this->_request->getValue( "dnsCheckingEnabled" );
            $this->_dnsAntiSpam            = ($this->_dnsAntiSpam != "" );			

            $this->_checkForLinks          = $this->_request->getValue( "linkCheckingEnabled" );
            $this->_checkForLinks          = ($this->_checkForLinks != "" );			
			
			return true;
		}
		
        /**
         * Carries out the specified action
         */
        function perform()
        {
            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_validatetrackback_enabled", $this->_pluginEnabled );

            $blogSettings->setValue( "plugin_validatetrackback_trackback_enabled", $this->_validateTrackbacksUrls );
            $blogSettings->setValue( "plugin_validatetrackback_dns_enabled", $this->_dnsAntiSpam );
            $blogSettings->setValue( "plugin_validatetrackback_linkchecking_enabled", $this->_checkForLinks );


            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new AdminValidateTrackbackPluginSettingsView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;                       
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new AdminValidateTrackbackPluginSettingsView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("validatetrackback_settings_saved_ok"));			
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());					
            
            return true;		
        }
    }
?>
